/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This is GNU GO, a Go program. Contact gnugo@gnu.org, or see   *
 * http://www.gnu.org/software/gnugo/ for more information.      *
 *                                                               *
 * Copyright 1999 and 2000 by the Free Software Foundation.      *
 *                                                               *
 * This program is free software; you can redistribute it and/or *
 * modify it under the terms of the GNU General Public License   *
 * as published by the Free Software Foundation - version 2.     *
 *                                                               *
 * This program is distributed in the hope that it will be       *
 * useful, but WITHOUT ANY WARRANTY; without even the implied    *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR       *
 * PURPOSE.  See the GNU General Public License in file COPYING  *
 * for more details.                                             *
 *                                                               *
 * You should have received a copy of the GNU General Public     *
 * License along with this program; if not, write to the Free    *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,       *
 * Boston, MA 02111, USA                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef CURSES

#include <unistd.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifdef __MINGW32__
#include <windows.h>
#include <winsock.h>
#include <io.h>
#endif

#ifdef HAVE_VISUAL_C
#include <winsock.h>
#include <io.h>
#endif

#include "gnugo.h"
#include "sgftree.h"
#include "interface.h"
#include "random.h"

#include "display.h"
#include "gui.h"



Tab tabs[] = {
  {"Worms"},
  {"Dragons"},
  {" Eyes "},
  {" Help "},
  {""},
};


Gameinfo  gameinfo;
SGFNode  *sgf_root;

void choose_worms_tab(void);
void choose_dragons_tab(void);
void choose_eyes_tab(void);
void choose_help_tab(void);

void show_current_info(void);


int
main(int argc, char *argv[])
{
  int  ch;
  char *until = NULL;
  int  next;
  char *infilename;

  /* Examine options. */
  if (argc == 1 || argc > 3 ) {
    fprintf(stderr, "Usage: %s infile [movenum]\n", argv[0]);
    exit(1);
  }

  /* Try to open the infile. */
  infilename = argv[1];
  if ((sgf_root = readsgffile(infilename)) == NULL) {
    fprintf(stderr, "Cannot open or parse '%s'\n", infilename);
    exit(1);
  }

  if (argc == 3) {
    until = argv[2];
  }

  /* FIXME PRE3.0: Want to do this somewhere more structured. */
  nominal_depth               = DEPTH;
  nominal_backfill_depth      = BACKFILL_DEPTH;
  nominal_backfill2_depth     = BACKFILL2_DEPTH;
  nominal_fourlib_depth       = FOURLIB_DEPTH;
  nominal_ko_depth            = KO_DEPTH;
  nominal_branch_depth        = BRANCH_DEPTH;
  nominal_owl_distrust_depth  = OWL_DISTRUST_DEPTH;
  nominal_owl_branch_depth    = OWL_BRANCH_DEPTH;
  nominal_owl_reading_depth   = OWL_READING_DEPTH;
  nominal_owl_node_limit      = OWL_NODE_LIMIT;
  nominal_aa_depth            = AA_DEPTH;
  debug = 0;
  level = 10;
  noinhibit = 0;
  life  = 0;
  life_eyesize = LIFE_EYESIZE;
  fusekidb = 1;
  josekidb = 1;
  
  gameinfo_clear(&gameinfo, 19);
  next = play_sgf_tree(sgf_root, &gameinfo, until);


  /* Check if there is enough screen space. */
  if (!display_init(MINWIDTH, MINHEIGHT, gameinfo.position.boardsize))
    exit(1);

  /* Initialize the GNU Go engine. */
  gg_srand(time(0));
  init_gnugo(8);
  reset_engine();
  life = 1;

  display_message("Hit 'h' for help!");

  tab_window_draw(tabs);

  display_board_position(&gameinfo.position);
  gnugo_examine_position(&gameinfo.position, next, EXAMINE_ALL);

  choose_worms_tab();

  while (1) {
    ch = display_input();
    if (ch == -1) {
#ifdef HAVE_USLEEP
      usleep(100000);
#else
      struct timeval timeout;
      timeout.tv_sec = 0;
      timeout.tv_usec = 100000;
      select(0, NULL, NULL, NULL, &timeout);
#endif
      continue;
    }

    if (ch ==  'q' || ch ==  'Q')
      break;

    switch (ch) {
    case 'w': /* Worms */
    case 'W':
      choose_worms_tab();
      show_current_info();
      break;

    case 'd': /* Dragons */
    case 'D':
      choose_dragons_tab();
      show_current_info();
      break;

    case 'e': /* Eyes */
    case 'E':
      choose_eyes_tab();
      show_current_info();
      break;

    case 2: /* CTRL-B */
#ifdef HAVE_CURSES_ARROWS
    case KEY_LEFT:
#endif
      display_board_move_left();
      show_current_info();
      break;

    case 6: /* CTRL-F */
#ifdef HAVE_CURSES_ARROWS
    case KEY_RIGHT:
#endif
      display_board_move_right();
      show_current_info();
      break;

    case 16: /* CTRL-P */
#ifdef HAVE_CURSES_ARROWS
    case KEY_UP:
#endif
      display_board_move_up();
      show_current_info();
      break;

    case 14: /* CTRL-N */
#ifdef HAVE_CURSES_ARROWS
    case KEY_DOWN:
#endif
      display_board_move_down();
      show_current_info();
      break;


    case 'l': /* Refresh screen */
    case 'L':
      display_refresh();
      break;

    case '?': /* Help */
    case 'h':
    case 'H':
      choose_help_tab();
      display_help();
      break;

    default:
      display_message("Unkown character (%d) received", ch);
    }
  }

  display_cleanup();

  exit(0);
}


void
choose_worms_tab()
{
  tab_window_choose(tabs, 0);
  prepare_worms_tab();
  display_worm(&gameinfo.position, display_cur_row(), display_cur_col());

  display_board_cursor();
}


void
choose_dragons_tab()
{
  tab_window_choose(tabs, 1);
  prepare_dragons_tab();

  display_board_cursor();
}


void
choose_eyes_tab()
{
  tab_window_choose(tabs, 2);
  prepare_eyes_tab();

  display_board_cursor();
}


void
choose_help_tab()
{
  tab_window_choose(tabs, 3);
  prepare_help_tab();

  display_board_cursor();
}


void
show_current_info()
{
  switch (display_cur_tabchoice()) {
  case 0: 
    display_worm(&gameinfo.position, display_cur_row(), display_cur_col());
    break;
  case 1: 
    display_dragon(&gameinfo.position, display_cur_row(), display_cur_col());
    break;
  case 2: 
    display_eye(white_eye, display_cur_row(), display_cur_col());
  default:
    break;
  }

  display_board_cursor();
}

#else /* !CURSES */

#define UNUSED(x) x=x;

int
main(int argc, char *argv[])
{
  UNUSED(argc);
  UNUSED(argv);
  fprintf(stderr, "This program requires curses. Rebuild with curses and/or check that\nconfigure did find curses successfully.\n");
  return 1;
}

#endif /* CURSES */

/*
 * Local Variables:
 * tab-width: 8
 * c-basic-offset: 2
 * End:
 */
