/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This is GNU GO, a Go program. Contact gnugo@gnu.org, or see   *
 * http://www.gnu.org/software/gnugo/ for more information.      *
 *                                                               *
 * Copyright 1999 and 2000 by the Free Software Foundation.      *
 *                                                               *
 * This program is free software; you can redistribute it and/or *
 * modify it under the terms of the GNU General Public License   *
 * as published by the Free Software Foundation - version 2.     *
 *                                                               *
 * This program is distributed in the hope that it will be       *
 * useful, but WITHOUT ANY WARRANTY; without even the implied    *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR       *
 * PURPOSE.  See the GNU General Public License in file COPYING  *
 * for more details.                                             *
 *                                                               *
 * You should have received a copy of the GNU General Public     *
 * License along with this program; if not, write to the Free    *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,       *
 * Boston, MA 02111, USA                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef CURSES

#include "display.h"
#include "gui.h"
#include "liberty.h"


void
prepare_worms_tab()
{
  wmove(info_window, 2, 2);
  gg_wprintw(info_window, "Worm at       origin: ");

  wmove(info_window, 4, 2);
  gg_wprintw(info_window, "color:          ");
  wmove(info_window, 5, 2);
  gg_wprintw(info_window, "size:           ");
  wmove(info_window, 6, 2);
  gg_wprintw(info_window, "effective size: ");

  wmove(info_window, 8, 2);
  gg_wprintw(info_window, "liberties:      ");
  wmove(info_window, 9, 2);
  gg_wprintw(info_window, "liberties2:     ");
  wmove(info_window, 10, 2);
  gg_wprintw(info_window, "liberties3:     ");
  wmove(info_window, 11, 2);
  gg_wprintw(info_window, "liberties4:     ");


  wmove(info_window, 4, 42);
  gg_wprintw(info_window, "attack:          ");
  wmove(info_window, 5, 42);
  gg_wprintw(info_window, "defense:         ");
  wmove(info_window, 6, 42);
  gg_wprintw(info_window, "lunch: ");

  wmove(info_window, 8, 42);
  gg_wprintw(info_window, "cutstone:        ");
  wmove(info_window, 9, 42);
  gg_wprintw(info_window, "cutstone2:       ");
  wmove(info_window, 10, 42);
  gg_wprintw(info_window, "genus:           ");

  wrefresh(info_window);
}


void
display_worm(Position *pos, int i, int j)
{
  wmove(info_window, 2, 10);
  gg_wprintw(info_window, "%s ", location_to_string(i, j));

  wmove(info_window, 2, 24);
  gg_wprintw(info_window, "%s ", 
	  location_to_string(worm[i][j].origini,
			     worm[i][j].originj));

  wmove(info_window, 4, 18);
  gg_wprintw(info_window, "%s", color_to_string(pos->board[i][j]));
  wmove(info_window, 5, 18);
  gg_wprintw(info_window, "%d   ", worm[i][j].size);
  wmove(info_window, 6, 18);
  gg_wprintw(info_window, "%5f  ", worm[i][j].effective_size);

  wmove(info_window, 8, 18);
  gg_wprintw(info_window, "%d  ", worm[i][j].liberties);
  wmove(info_window, 9, 18);
  gg_wprintw(info_window, "%d  ", worm[i][j].liberties2);
  wmove(info_window, 10, 18);
  gg_wprintw(info_window, "%d  ", worm[i][j].liberties3);
  wmove(info_window, 11, 18);
  gg_wprintw(info_window, "%d  ", worm[i][j].liberties4);

  wmove(info_window, 4, 58);
  if (worm[i][j].attacki == -1)
    gg_wprintw(info_window, "---          ");
  else
    gg_wprintw(info_window, "%3s [code %d]", 
	    location_to_string(worm[i][j].attacki,
			       worm[i][j].attackj),
	    worm[i][j].attack_code);
  

  wmove(info_window, 5, 58);
  if (worm[i][j].defendi == -1)
    gg_wprintw(info_window, "---          ");
  else
    gg_wprintw(info_window, "%3s [code %d]", 
	    location_to_string(worm[i][j].defendi,
			       worm[i][j].defendj),
	    worm[i][j].defend_code);

  wmove(info_window, 6, 58);
  if (worm[i][j].lunchi == -1)
    gg_wprintw(info_window, "---");
  else
    gg_wprintw(info_window, "%3s", 
	    location_to_string(worm[i][j].lunchi,
			       worm[i][j].lunchj));

  wmove(info_window, 8, 58);
  gg_wprintw(info_window, "%d", worm[i][j].cutstone);
  wmove(info_window, 9, 58);
  gg_wprintw(info_window, "%d", worm[i][j].cutstone2);
  wmove(info_window, 10, 58);
  gg_wprintw(info_window, "%d", worm[i][j].genus);

  wrefresh(info_window);
}


/* ---------------------------------------------------------------- */


void
prepare_dragons_tab()
{
  wmove(info_window, 2, 2);
  gg_wprintw(info_window, "Dragon at     origin: ");

  wmove(info_window, 4, 2);
  gg_wprintw(info_window, "color:          ");
  wmove(info_window, 5, 2);
  gg_wprintw(info_window, "size:           ");
  wmove(info_window, 6, 2);
  gg_wprintw(info_window, "effective size: ");

  wmove(info_window, 8, 2);
  gg_wprintw(info_window, "half eyes:      ");
  wmove(info_window, 9, 2);
  gg_wprintw(info_window, "genus:          ");
  wmove(info_window, 10, 2);
  gg_wprintw(info_window, "escape_route    ");

  wmove(info_window, 4, 42);
  gg_wprintw(info_window, "owl_status:    ");
  wmove(info_window, 5, 42);
  gg_wprintw(info_window, "owl_attack:    ");
  wmove(info_window, 6, 42);
  gg_wprintw(info_window, "owl_defend:    ");
  wmove(info_window, 7, 42);
  gg_wprintw(info_window, "lunch: ");

  wmove(info_window, 9, 42);
  gg_wprintw(info_window, "status:          ");
  wmove(info_window, 10, 42);
  gg_wprintw(info_window, "matcher_status:  ");
  wmove(info_window, 11, 42);
  gg_wprintw(info_window, "safety:          ");
  wmove(info_window, 12, 42);
  gg_wprintw(info_window, "semeai:          ");

  wrefresh(info_window);
}


void
display_dragon(Position *pos, int i, int j)
{
  wmove(info_window, 2, 12);
  gg_wprintw(info_window, "%s ", location_to_string(i, j));

  wmove(info_window, 2, 24);
  gg_wprintw(info_window, "%s ", 
	  location_to_string(dragon[i][j].origini,
			     dragon[i][j].originj));

  wmove(info_window, 4, 18);
  gg_wprintw(info_window, "%s       ", color_to_string(pos->board[i][j]));
  wmove(info_window, 5, 18);
  gg_wprintw(info_window, "%d   ", dragon[i][j].size);
  wmove(info_window, 6, 18);
  gg_wprintw(info_window, "%5f  ", dragon[i][j].effective_size);

  wmove(info_window, 8, 18);
  gg_wprintw(info_window, "%d  ", dragon[i][j].heyes);
  /* FIXME PRE3.0: halfeye coordinate */
  wmove(info_window, 9, 18);
  gg_wprintw(info_window, "%d  ", dragon[i][j].genus);
  wmove(info_window, 10, 18);
  gg_wprintw(info_window, "%d  ", dragon[i][j].escape_route);

  wmove(info_window, 4, 58);
  gg_wprintw(info_window, "%s     ", status_to_string(dragon[i][j].owl_status));

  wmove(info_window, 5, 58);
  if (dragon[i][j].owl_attacki == -1)
    gg_wprintw(info_window, "---          ");
  else
    gg_wprintw(info_window, "%3s", 
	    location_to_string(dragon[i][j].owl_attacki,
			       dragon[i][j].owl_attackj));

  wmove(info_window, 6, 58);
  if (dragon[i][j].owl_defendi == -1)
    gg_wprintw(info_window, "---          ");
  else
    gg_wprintw(info_window, "%3s", 
	    location_to_string(dragon[i][j].owl_defendi,
			       dragon[i][j].owl_defendj));
  
  wmove(info_window, 7, 58);
  if (dragon[i][j].lunchi == -1)
    gg_wprintw(info_window, "---");
  else
    gg_wprintw(info_window, "%3s", 
	    location_to_string(dragon[i][j].lunchi,
			       dragon[i][j].lunchj));

  wmove(info_window, 9, 58);
  gg_wprintw(info_window, "%s     ", status_to_string(dragon[i][j].status));

  wmove(info_window, 10, 58);
  gg_wprintw(info_window, "%s     ", status_to_string(dragon[i][j].matcher_status));
  wmove(info_window, 11, 58);
  gg_wprintw(info_window, "%s     ", status_to_string(dragon[i][j].old_safety));
  wmove(info_window, 12, 58);
  gg_wprintw(info_window, "%d  ", dragon[i][j].semeai);

  wrefresh(info_window);
}


/* ---------------------------------------------------------------- */


void
prepare_eyes_tab()
{
  wmove(info_window, 2, 2);
  gg_wprintw(info_window, "Eye at        origin: ");

  wmove(info_window, 4, 2);
  gg_wprintw(info_window, "color:          ");
  wmove(info_window, 5, 2);
  gg_wprintw(info_window, "total size:     ");
  wmove(info_window, 6, 2);
  gg_wprintw(info_window, "marginals:      ");
  wmove(info_window, 7, 2);
  gg_wprintw(info_window, "surr. dragon:   ");

  wmove(info_window, 9, 2);
  gg_wprintw(info_window, "----------------------------------------------------------------------------");

  wmove(info_window, 11, 2);
  gg_wprintw(info_window, "type:           ");
  wmove(info_window, 12, 2);
  gg_wprintw(info_window, "marginal:       ");
  wmove(info_window, 13, 2);
  gg_wprintw(info_window, "false margin:   ");

  wmove(info_window, 4, 42);
  gg_wprintw(info_window, "max eyes:        ");
  wmove(info_window, 5, 42);
  gg_wprintw(info_window, "min eyes:        ");
  wmove(info_window, 6, 42);
  gg_wprintw(info_window, "attack point:    ");
  wmove(info_window, 7, 42);
  gg_wprintw(info_window, "defense point:   ");

  wmove(info_window, 11, 42);
  gg_wprintw(info_window, "neighbors:       ");
  wmove(info_window, 12, 42);
  gg_wprintw(info_window, "marg. neighbors: ");
  wmove(info_window, 13, 42);
  gg_wprintw(info_window, "cut:             ");

  wrefresh(info_window);
}


void
display_eye(struct eye_data eyedata[MAX_BOARD][MAX_BOARD], int i, int j)
{
  wmove(info_window, 2, 9);
  gg_wprintw(info_window, "%s ", location_to_string(i, j));

  wmove(info_window, 2, 24);
  if (eyedata[i][j].origini == -1)
    gg_wprintw(info_window, "---");
  else
    gg_wprintw(info_window, "%s ", 
	    location_to_string(eyedata[i][j].origini,
			       eyedata[i][j].originj));

  wmove(info_window, 4, 18);
  gg_wprintw(info_window, "%s       ", color_to_string(eyedata[i][j].color));
  wmove(info_window, 5, 18);
  gg_wprintw(info_window, "%d   ", eyedata[i][j].esize);
  wmove(info_window, 6, 18);
  gg_wprintw(info_window, "%d   ", eyedata[i][j].msize);
  wmove(info_window, 7, 18);
  if (eyedata[i][j].dragoni == -1)
    gg_wprintw(info_window, "---");
  else
    gg_wprintw(info_window, "%s ",
	    location_to_string(eyedata[i][j].dragoni,
			       eyedata[i][j].dragonj));

  wmove(info_window, 11, 18);
  gg_wprintw(info_window, "%d  ", eyedata[i][j].type);
  wmove(info_window, 12, 18);
  gg_wprintw(info_window, "%d  ", eyedata[i][j].marginal);
  wmove(info_window, 13, 18);
  gg_wprintw(info_window, "%d  ", eyedata[i][j].false_margin);

  wmove(info_window, 4, 58);
  gg_wprintw(info_window, "%d ", eyedata[i][j].maxeye);
  wmove(info_window, 5, 58);
  gg_wprintw(info_window, "%d ", eyedata[i][j].mineye);

  wmove(info_window, 6, 58);
  if (eyedata[i][j].attacki == -1)
    gg_wprintw(info_window, "---          ");
  else
    gg_wprintw(info_window, "%3s", 
	    location_to_string(eyedata[i][j].attacki,
			       eyedata[i][j].attackj));

  wmove(info_window, 7, 58);
  if (eyedata[i][j].defendi == -1)
    gg_wprintw(info_window, "---          ");
  else
    gg_wprintw(info_window, "%3s", 
	    location_to_string(eyedata[i][j].defendi,
			       eyedata[i][j].defendj));
  
  wmove(info_window, 11, 58);
  gg_wprintw(info_window, "%d ", eyedata[i][j].neighbors);
  wmove(info_window, 12, 58);
  gg_wprintw(info_window, "%d ", eyedata[i][j].marginal_neighbors);
  wmove(info_window, 13, 58);
  gg_wprintw(info_window, "%d ", eyedata[i][j].cut);

  wrefresh(info_window);
}


/* ---------------------------------------------------------------- */


void
prepare_help_tab()
{
  wmove(info_window, 2, 2);
  gg_wprintw(info_window, "Worms screen   - press 'w'.");
  wmove(info_window, 3, 2);
  gg_wprintw(info_window, "Dragons screen - press 'd'.");
  wmove(info_window, 4, 2);
  gg_wprintw(info_window, "Eyes screen    - press 'e'.");
  wmove(info_window, 5, 2);
  gg_wprintw(info_window, "Help screen    - press 'h'.");

  wmove(info_window, 7, 2);
  gg_wprintw(info_window, "Refresh screen - press 'l'.");
  wmove(info_window, 8, 2);
  gg_wprintw(info_window, "Quit program   - press 'q'.");

  wmove(info_window, 2, 42);
  gg_wprintw(info_window, "Move up    - press '^p'.");
  wmove(info_window, 3, 42);
  gg_wprintw(info_window, "Move down  - press '^n'.");
  wmove(info_window, 4, 42);
  gg_wprintw(info_window, "Move left  - press '^b'.");
  wmove(info_window, 5, 42);
  gg_wprintw(info_window, "Move right - press '^f'.");

  wrefresh(info_window);
}

#endif /* CURSES */

/*
 * Local Variables:
 * tab-width: 8
 * c-basic-offset: 2
 * End:
 */
