/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This is GNU GO, a Go program. Contact gnugo@gnu.org, or see   *
 * http://www.gnu.org/software/gnugo/ for more information.      *
 *                                                               *
 * Copyright 1999 by the Free Software Foundation.               *
 *                                                               *
 * This program is free software; you can redistribute it and/or *
 * modify it under the terms of the GNU General Public License   *
 * as published by the Free Software Foundation - version 2.     *
 *                                                               *
 * This program is distributed in the hope that it will be       *
 * useful, but WITHOUT ANY WARRANTY; without even the implied    *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR       *
 * PURPOSE.  See the GNU General Public License in file COPYING  *
 * for more details.                                             *
 *                                                               *
 * You should have received a copy of the GNU General Public     *
 * License along with this program; if not, write to the Free    *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,       *
 * Boston, MA 02111, USA                                         *
 \* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <assert.h>
#include "liberty.h"

/* Incremental string data. */
struct string_data {
  int color;                       /* Color of string, BLACK or WHITE */
  int size;                        /* Number of stones in string. */
  int origini;                     /* Coordinates of "origin", i.e. */
  int originj;                     /* "upper left" stone. */
  int liberties;                   /* Number of liberties. */
  int libi[MAX_LIBERTIES];         /* Coordinates of liberties. */
  int libj[MAX_LIBERTIES];
  int neighbors;                   /* Number of neighbor strings */
  int neighborlist[MAXCHAIN];      /* List of neighbor string numbers. */
  int mark;                        /* General purpose mark. */
};


/* we keep the adress and the old value */
struct change_stack_entry {
  int *address;
  int value;
};

/* we keep the adress and the old value */
struct vertex_stack_entry {
  Intersection *address;
  int value;
};

/* Experimental results show that the average number of change stack
 * entries per move usually is in the 20-30 range and very seldom
 * exceeds 40. But since we have no way to recover from running out of
 * stack space, we allocate with a substantial safety margin.
 */
#define STACK_SIZE 80 * MAXSTACK

extern struct change_stack_entry change_stack[STACK_SIZE];
extern struct vertex_stack_entry vertex_stack[STACK_SIZE];

extern struct change_stack_entry *change_stack_pointer;
extern struct vertex_stack_entry *vertex_stack_pointer;

#define CLEAR_STACKS()\
(change_stack_pointer = change_stack, vertex_stack_pointer = vertex_stack)

/* Begin a record : adress==NULL */
#define BEGIN_CHANGE_RECORD()\
((change_stack_pointer++)->address = NULL,\
 (vertex_stack_pointer++)->address = NULL)

/* Save a value : store the adress and the value in the stack */
#define PUSH_VALUE(v)\
(change_stack_pointer->address = &(v),\
 (change_stack_pointer++)->value = (v))

/* Save a board value : store the adress and the value in the stack */
#define PUSH_VERTEX(v)\
(vertex_stack_pointer->address = &(v),\
 (vertex_stack_pointer++)->value = (v))

#define POP_MOVE()\
  while ((--change_stack_pointer)->address)\
  *(change_stack_pointer->address) =\
  change_stack_pointer->value

#define POP_VERTICES()\
  while ((--vertex_stack_pointer)->address)\
  *(vertex_stack_pointer->address) =\
  vertex_stack_pointer->value


/* Incremental board functions. These should only be visible to board.c */
void incremental_board_init(void);
void incremental_invalidate_strings(void);
int  incremental_is_suicide(int i, int j, int color);
void incremental_play_move(int i, int j, int color);
void incremental_undo_move(void);
int  incremental_countlib(int i, int j);
int  incremental_findlib(int i, int j, int maxlib, int *libi, int *libj);
int  incremental_approxlib(int i, int j, int color, int maxlib,
			   int *libi, int *libj);
int  incremental_sloppy_self_atari(int m, int n, int color);
int  incremental_countstones(int i, int j);
int  incremental_findstones(int m, int n, int maxstones,
			    int *stonei, int *stonej);
void incremental_chainlinks(int i, int j, int *adj, int adji[MAXCHAIN],
			    int adjj[MAXCHAIN], int adjsize[MAXCHAIN],
			    int adjlib[MAXCHAIN]);
void incremental_chainlinks2(int i, int j, int *adj, int adji[MAXCHAIN],
			     int adjj[MAXCHAIN], int lib);
void incremental_find_origin(int i, int j, int *origini, int *originj);
int  incremental_neighbor_of(int ai, int aj, int si, int sj);
int  incremental_is_ko(int i, int j, int color);
void incremental_mark_string(int m, int n, char mx[MAX_BOARD][MAX_BOARD],
			     char mark);


/*
 * Local Variables:
 * tab-width: 8
 * c-basic-offset: 2
 * End:
 */
