/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This is GNU GO, a Go program. Contact gnugo@gnu.org, or see   *
 * http://www.gnu.org/software/gnugo/ for more information.      *
 *                                                               *
 * Copyright 1999 and 2000 by the Free Software Foundation.      *
 *                                                               *
 * This program is free software; you can redistribute it and/or *
 * modify it under the terms of the GNU General Public License   *
 * as published by the Free Software Foundation - version 2.     *
 *                                                               *
 * This program is distributed in the hope that it will be       *
 * useful, but WITHOUT ANY WARRANTY; without even the implied    *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR       *
 * PURPOSE.  See the GNU General Public License in file COPYING  *
 * for more details.                                             *
 *                                                               *
 * You should have received a copy of the GNU General Public     *
 * License along with this program; if not, write to the Free    *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,       *
 * Boston, MA 02111, USA                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#include <stdio.h>

#include "sgftree.h"
#include "liberty.h"

/* 
 * Define all global variables used within the engine.
 */


/* The go board and position. */
Intersection p[MAX_BOARD][MAX_BOARD];
int          ko_i;
int          ko_j;

/* Hashing of positions. */
Hash_data    hashdata;

int hashflags = HASH_DEFAULT;

int potential_moves[MAX_BOARD][MAX_BOARD];

int  black_captured;
int  white_captured;    /* number of black and white stones captured */

/* Used by reading. */
int stackp;             /* stack pointer */
int movenum;            /* movenumber: Used only for debugging */
int position_number;    /* position number */
int depth;              /* deep reading cut off */
int backfill_depth;     /* deep reading cut off */
int backfill2_depth;    /* deep reading cut off */
int superstring_depth;  /* deep reading cut off */
int fourlib_depth;      /* deep reading cut off */
int ko_depth;           /* deep reading cut off */
int branch_depth;       /* deep reading cut off */
int aa_depth;
int owl_distrust_depth;   /* below this owl trusts the optics code */
int owl_branch_depth;     /* below this owl tries only one variation */
int owl_reading_depth;    /* owl does not read below this depth */
int owl_node_limit;       /* maximum number of nodes considered */
int nominal_depth;             /* deep reading cut off, nominal value */
int nominal_backfill_depth;    /* deep reading cut off, nominal value */
int nominal_backfill2_depth;   /* deep reading cut off, nominal value */
int nominal_superstring_depth; /* deep reading cut off, nominal value */
int nominal_fourlib_depth;   /* deep reading cut off, nominal value */
int nominal_ko_depth;        /* deep reading cut off, nominal value */
int nominal_branch_depth;    /* deep reading cut off, nominal value */
int nominal_aa_depth;
int nominal_owl_distrust_depth;  
int nominal_owl_branch_depth;  
int nominal_owl_reading_depth; 
int nominal_owl_node_limit;    

/* Miscellaneous. */
int quiet            = 0;  /* minimal output */
int showstack        = 0;  /* debug stack pointer */
int showstatistics   = 0;  /* print statistics */
int profile_patterns = 0;  /* print statistics of pattern usage */
int allpats          = 0;  /* generate all patterns, even small ones */
int printworms       = 0;  /* print full data on each string */
int printmoyo        = 0;  /* print moyo board each move */
int printboard       = 0;  /* print board each move */
int board_size       = 19; /* board size */
int count_variations = 0;  /* used by decide_string */
int sgf_dump         = 0;  /* used by decide_string */
struct SGFTree_t *sgf_dumptree = NULL;
int loading          = 0;  /* TRUE if last loaded move comes from file */
int life             = 0;  /* use eye reading code */
int life_eyesize     = 0;  /* max eyesize for life code */
int fusekidb         = 1;  /* use fuseki database */
int josekidb         = 1;  /* use fuseki database */
int showtime         = 0;  /* print time to find move */
int level            = 10; /* normally 0, but 1, 2, or 3 to play faster */
int urgent           = 0;  /* urgent move on board */
int kothreat_needed  = 0;  /* need a ko threat */
int noinhibit        = 0;  /* estimate moyos boldly */
int debug            = 0;  /* controls debug output */
int verbose          = 0;  /* trace level */
int analyzerflag     = 0;
char *analyzerfile   = NULL;

/* Various statistics are collected here. */
struct stats_data stats;

struct worm_data      worm[MAX_BOARD][MAX_BOARD];
struct dragon_data    dragon[MAX_BOARD][MAX_BOARD];
int                   number_of_dragons;
struct dragon_data2   *dragon2 = NULL;
struct half_eye_data  half_eye[MAX_BOARD][MAX_BOARD];
struct half_eye_data  owl_half_eye[MAX_BOARD][MAX_BOARD];
struct eye_data       black_eye[MAX_BOARD][MAX_BOARD];
struct eye_data       white_eye[MAX_BOARD][MAX_BOARD];
struct eye_data       owl_black_eye[MAX_BOARD][MAX_BOARD];
struct eye_data       owl_white_eye[MAX_BOARD][MAX_BOARD];
