/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This is GNU GO, a Go program. Contact gnugo@gnu.org, or see   *
 * http://www.gnu.org/software/gnugo/ for more information.      *
 *                                                               *
 * Copyright 1999 and 2000 by the Free Software Foundation.      *
 *                                                               *
 * This program is free software; you can redistribute it and/or *
 * modify it under the terms of the GNU General Public License   *
 * as published by the Free Software Foundation - version 2.     *
 *                                                               *
 * This program is distributed in the hope that it will be       *
 * useful, but WITHOUT ANY WARRANTY; without even the implied    *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR       *
 * PURPOSE.  See the GNU General Public License in file COPYING  *
 * for more details.                                             *
 *                                                               *
 * You should have received a copy of the GNU General Public     *
 * License along with this program; if not, write to the Free    *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,       *
 * Boston, MA 02111, USA                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */





#ifndef _SGFANA_H
#define _SGFANA_H 1


#include "sgftree.h"

/* low level functions */
SGFNode * sgfTerritory(SGFNode *node, int i, int j, int color);
void sgfHelp(void);
void sgfNextString(char *s);
void sgfPrevString(char *s);

/* high level functions */
void sgfMarkWorm(SGFNode *node, int x, int y, const char *mark);
void sgfPrintSingleEyeInfo(SGFNode *node, int i, int j, char *c);
void parse_analyzer_options(char *optionstring);
void sgfAnalyzer(SGFNode *node, int value);
void sgfPrintSingleDragonInfo(SGFNode *node, int i, int j, char *c);
void sgfPrintSingleWormInfo(SGFNode *node, int i, int j, char *c);
void sgfShowTerritory(SGFNode *node,int as_variant);
void sgfCaptureString(SGFNode *node, int i, int j);
void sgfDefendString(SGFNode *node, int i, int j);

/* In moyo.c */
void sgfShowMoyo(SGFNode *node, int mode, int as_variant);
void sgfShowTerri(SGFNode *node, int mode, int as_variant);
void sgfShowArea(SGFNode *node, int mode, int as_variant);



enum{SGF_SHOW_STATUS,  /*show status of worms or dragons*/
     SGF_SHOW_LIBERTIES,
     SGF_SHOW_COLOR,
     SGF_SHOW_VALUE
};


#define    ANALYZE_OVERWRITE    1  /* overwrite already existing sgf info*/
#define    ANALYZE_DRAGONINFO   2
#define    ANALYZE_DRAGONSTATUS 4
#define    ANALYZE_CONSIDERED   8   /* show considered moves */
#define    ANALYZE_WORMS        16
#define    ANALYZE_EYES         32
#define    ANALYZE_WORMINFO     64
#define    ANALYZE_EYEINFO      128
#define    ANALYZE_GAMEINFO     0x100
#define    ANALYZE_MOYOCOLOR    0x200
#define    ANALYZE_RECOMMENDED  0x400
#define    ANALYZE_CAPTURING    0x800
#define    ANALYZE_MOYOVALUE    0x1000
#define    ANALYZE_DEFENSE      0x2000
#define    ANALYZE_TERRICOLOR   0x4000
#define    ANALYZE_TERRIVALUE   0x8000
#define    ANALYZE_TERRITORY    0x10000
#define    ANALYZE_AREACOLOR    0x20000
#define    ANALYZE_AREAVALUE    0x40000

#endif
