#include "lolit_ml.h"

#ifdef USE_GNOME
GnomeUIInfo gamemenu[] = {
  {GNOME_APP_UI_ITEM, N_("Level _1 - Adding"), 0, Level1, 0, 0,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, '1', GDK_CONTROL_MASK, 0},
  {GNOME_APP_UI_ITEM, N_("Level _2 - Subtracting"), 0, Level2, 0, 0,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, '2', GDK_CONTROL_MASK, 0},
  {GNOME_APP_UI_ITEM, N_("Level _3 - Multiplying"), 0, Level3, 0, 0,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, '3', GDK_CONTROL_MASK, 0},
  {GNOME_APP_UI_ITEM, N_("Level _4 - Deviding"), 0, Level4, 0, 0,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, '4', GDK_CONTROL_MASK, 0},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Level _5 - Subtracting II"), 0, Level5, 0, 0,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, '5', GDK_CONTROL_MASK, 0},
  {GNOME_APP_UI_ITEM, N_("Level _6 - Deviding II"), 0, Level6, 0, 0,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, '6', GDK_CONTROL_MASK, 0},
  {GNOME_APP_UI_ITEM, N_("Level _7 - Random"), 0, Level7, 0, 0,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, '7', GDK_CONTROL_MASK, 0},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("_Quit"), 0, Quit, 0, 0,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT, 'Q', GDK_CONTROL_MASK, 0},
  GNOMEUIINFO_END
};

GnomeUIInfo helpmenu[] = {
  {GNOME_APP_UI_ITEM, N_("_About..."), 0, About, 0, 0,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 'A', GDK_CONTROL_MASK, 0},
  GNOMEUIINFO_END
};

GnomeUIInfo menu[] = {
  GNOMEUIINFO_SUBTREE (N_("_Game"), gamemenu),
  GNOMEUIINFO_SUBTREE (N_("_Help"), helpmenu),
  GNOMEUIINFO_END
};
#endif

int main (int argc, char *argv[])
{
  if (argc == 2)
  {
    if (strcmp (argv[1], "--version") == 0)
    {
      printf ("0.0.1\n");
      exit (EXIT_NORMAL);
    }
  }

  if ((getenv ("DISPLAY")) == 0) {
    printf ("[Start the X Window System first]\n");
    exit (EXIT_ERROR);
  }

#ifdef USE_GNOME
  gnome_init ("Math Literature", "0.0.1", argc, argv);
#else
  gtk_init (&argc, &argv);
#endif
  gdk_imlib_init ();
  gtk_widget_push_visual (gdk_imlib_get_visual ());
  gtk_widget_push_colormap (gdk_imlib_get_colormap ());

  srandom ((unsigned)time(&tTm));
  iScore = 0;
  iAll = 0;
  iBusy = 0;

#ifdef USE_GNOME
  gWindow1 = gnome_app_new ("Math Literature", "Math Literature");
#else
  gWindow1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
#endif
  gtk_window_set_position (GTK_WINDOW (gWindow1), GTK_WIN_POS_CENTER);
  gtk_window_set_title (GTK_WINDOW (gWindow1), "lolit - Math Literature");
  gtk_signal_connect (GTK_OBJECT (gWindow1), "delete_event",
    GTK_SIGNAL_FUNC (Quit), NULL);
  gtk_window_set_policy (GTK_WINDOW (gWindow1), 0, 0, 1);
  gtk_container_border_width (GTK_CONTAINER (gWindow1), 0);
  gtk_widget_realize (gWindow1);

  gBox1 = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (gBox1), 0);
#ifdef USE_GNOME
  gnome_app_set_contents (GNOME_APP (gWindow1), gBox1);
#else
  gtk_container_add (GTK_CONTAINER (gWindow1), gBox1);
#endif
  gtk_widget_show (gBox1);

  gTable1 = gtk_table_new (30, 4, FALSE);
  gtk_widget_show (gTable1);
  gtk_box_pack_start (GTK_BOX (gBox1), gTable1, TRUE, TRUE, 0);

#ifdef USE_GNOME
  gnome_app_create_menus (GNOME_APP (gWindow1), menu);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (menu[1].widget));
#else
  GetMenu (gWindow1, &GMMenuBar);
  gtk_table_attach (GTK_TABLE (gTable1), GMMenuBar, 0, 30, 0, 1,
    GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show (GMMenuBar);
#endif

  ImMathL = gdk_imlib_load_image (PKGDATADIR"fonts/mathl.png");
  WMathL = ImMathL->rgb_width;
  HMathL = ImMathL->rgb_height;
  gdk_imlib_render (ImMathL, WMathL, HMathL);
  gMathLPixmap = gdk_imlib_move_image (ImMathL);
  gMathLPixmapWid = gtk_pixmap_new (gMathLPixmap, NULL);
  gtk_table_attach (GTK_TABLE (gTable1), gMathLPixmapWid, 0, 30, 1, 2,
    GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show (gMathLPixmapWid);

  gWindowSep = gtk_hseparator_new ();
  gtk_table_attach (GTK_TABLE (gTable1), gWindowSep, 0, 30, 3, 4,
    GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show (gWindowSep);

  gLabel1 = gtk_label_new ("lolit - Math Literature");
  gtk_table_attach (GTK_TABLE (gTable1), gLabel1, 0, 30, 5, 6,
    GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
  gtk_widget_show (gLabel1);

  for (iButtons = 0; iButtons < 15; iButtons++)
  {
    gButtons[iButtons] = gtk_event_box_new ();
    gtk_widget_set_usize (gButtons[iButtons], 50, 60);
    gtk_table_attach (GTK_TABLE (gTable1), gButtons[iButtons],
      iButtons * 2, (iButtons * 2) + 2, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
    gtk_signal_connect (GTK_OBJECT (gButtons[iButtons]), "button_press_event",
      GTK_SIGNAL_FUNC (ButtonsPress), (gpointer) iButtons);
    gtk_signal_connect (GTK_OBJECT (gButtons[iButtons]), "enter_notify_event",
      GTK_SIGNAL_FUNC (ButtonsYes), (gpointer) iButtons);
    gtk_signal_connect (GTK_OBJECT (gButtons[iButtons]), "leave_notify_event",
      GTK_SIGNAL_FUNC (ButtonsNo), (gpointer) iButtons);
    gtk_widget_show (gButtons[iButtons]);
  }

  for (iButtons = 0; iButtons < 5; iButtons++)
  {
    gSButtons[iButtons] = gtk_event_box_new ();
    gtk_widget_set_usize (gSButtons[iButtons], 25, 30);
    gtk_table_attach (GTK_TABLE (gTable1), gSButtons[iButtons],
      iButtons, iButtons + 1, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
    gtk_widget_show (gSButtons[iButtons]);
  }

  gMinusButton = gtk_event_box_new ();
  gtk_widget_set_usize (gMinusButton, 25, 30);
  gtk_table_attach (GTK_TABLE (gTable1), gMinusButton,
    5, 6, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
  gtk_signal_connect (GTK_OBJECT (gMinusButton), "button_press_event",
    GTK_SIGNAL_FUNC (MinusPress), NULL);
  gtk_signal_connect (GTK_OBJECT (gMinusButton), "enter_notify_event",
    GTK_SIGNAL_FUNC (MinusYes), NULL);
  gtk_signal_connect (GTK_OBJECT (gMinusButton), "leave_notify_event",
    GTK_SIGNAL_FUNC (MinusNo), NULL);
  gtk_widget_show (gMinusButton);

  for (iButtons = 0; iButtons < FONTS2; iButtons++)
  {
    gButtons2[iButtons] = gtk_event_box_new ();
    gtk_widget_set_usize (gButtons2[iButtons], 25, 30);
    gtk_table_attach (GTK_TABLE (gTable1), gButtons2[iButtons],
      iButtons + 6, iButtons + 7, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
    gtk_signal_connect (GTK_OBJECT (gButtons2[iButtons]), "button_press_event",
      GTK_SIGNAL_FUNC (Buttons2Press), (gpointer) iButtons);
    gtk_signal_connect (GTK_OBJECT (gButtons2[iButtons]), "enter_notify_event",
      GTK_SIGNAL_FUNC (Buttons2Yes), (gpointer) iButtons);
    gtk_signal_connect (GTK_OBJECT (gButtons2[iButtons]), "leave_notify_event",
      GTK_SIGNAL_FUNC (Buttons2No), (gpointer) iButtons);
    gtk_widget_show (gButtons2[iButtons]);
  }

  gDotButton = gtk_event_box_new ();
  gtk_widget_set_usize (gDotButton, 25, 30);
  gtk_table_attach (GTK_TABLE (gTable1), gDotButton,
    16, 17, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
  gtk_signal_connect (GTK_OBJECT (gDotButton), "button_press_event",
    GTK_SIGNAL_FUNC (DotPress), NULL);
  gtk_signal_connect (GTK_OBJECT (gDotButton), "enter_notify_event",
    GTK_SIGNAL_FUNC (DotYes), NULL);
  gtk_signal_connect (GTK_OBJECT (gDotButton), "leave_notify_event",
    GTK_SIGNAL_FUNC (DotNo), NULL);
  gtk_widget_show (gDotButton);

  gXButton = gtk_event_box_new ();
  gtk_widget_set_usize (gXButton, 25, 30);
  gtk_table_attach (GTK_TABLE (gTable1), gXButton,
    17, 18, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
  gtk_signal_connect (GTK_OBJECT (gXButton), "button_press_event",
    GTK_SIGNAL_FUNC (XPress), NULL);
  gtk_signal_connect (GTK_OBJECT (gXButton), "enter_notify_event",
    GTK_SIGNAL_FUNC (XYes), NULL);
  gtk_signal_connect (GTK_OBJECT (gXButton), "leave_notify_event",
    GTK_SIGNAL_FUNC (XNo), NULL);
  gtk_widget_show (gXButton);

  gSpaceButton = gtk_event_box_new ();
  gtk_widget_set_usize (gSpaceButton, 25, 30);
  gtk_table_attach (GTK_TABLE (gTable1), gSpaceButton,
    18, 19, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show (gSpaceButton);

  gOKButton = gtk_event_box_new ();
  gtk_widget_set_usize (gOKButton, 50, 30);
  gtk_table_attach (GTK_TABLE (gTable1), gOKButton,
    19, 21, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
  gtk_signal_connect (GTK_OBJECT (gOKButton), "button_press_event",
    GTK_SIGNAL_FUNC (OKPress), NULL);
  gtk_signal_connect (GTK_OBJECT (gOKButton), "enter_notify_event",
    GTK_SIGNAL_FUNC (OKYes), NULL);
  gtk_signal_connect (GTK_OBJECT (gOKButton), "leave_notify_event",
    GTK_SIGNAL_FUNC (OKNo), NULL);
  gtk_widget_show (gOKButton);

  gClearButton = gtk_event_box_new ();
  gtk_widget_set_usize (gClearButton, 75, 30);
  gtk_table_attach (GTK_TABLE (gTable1), gClearButton,
    21, 24, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
  gtk_signal_connect (GTK_OBJECT (gClearButton), "button_press_event",
    GTK_SIGNAL_FUNC (ClearPress), NULL);
  gtk_signal_connect (GTK_OBJECT (gClearButton), "enter_notify_event",
    GTK_SIGNAL_FUNC (ClearYes), NULL);
  gtk_signal_connect (GTK_OBJECT (gClearButton), "leave_notify_event",
    GTK_SIGNAL_FUNC (ClearNo), NULL);
  gtk_widget_show (gClearButton);

  gHelpButton = gtk_event_box_new ();
  gtk_widget_set_usize (gHelpButton, 75, 30);
  gtk_table_attach (GTK_TABLE (gTable1), gHelpButton,
    24, 27, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
  gtk_signal_connect (GTK_OBJECT (gHelpButton), "button_press_event",
    GTK_SIGNAL_FUNC (HelpPress), NULL);
  gtk_signal_connect (GTK_OBJECT (gHelpButton), "enter_notify_event",
    GTK_SIGNAL_FUNC (HelpYes), NULL);
  gtk_signal_connect (GTK_OBJECT (gHelpButton), "leave_notify_event",
    GTK_SIGNAL_FUNC (HelpNo), NULL);
  gtk_widget_show (gHelpButton);

  gHintButton = gtk_event_box_new ();
  gtk_widget_set_usize (gHintButton, 75, 30);
  gtk_table_attach (GTK_TABLE (gTable1), gHintButton,
    27, 30, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
  gtk_signal_connect (GTK_OBJECT (gHintButton), "button_press_event",
    GTK_SIGNAL_FUNC (HintPress), NULL);
  gtk_signal_connect (GTK_OBJECT (gHintButton), "enter_notify_event",
    GTK_SIGNAL_FUNC (HintYes), NULL);
  gtk_signal_connect (GTK_OBJECT (gHintButton), "leave_notify_event",
    GTK_SIGNAL_FUNC (HintNo), NULL);
  gtk_widget_show (gHintButton);

  for (iFonts = 0; iFonts < FONTS; iFonts++)
  {
    switch (iFonts)
    {
      case 0: Im[0] = gdk_imlib_load_image (PKGDATADIR"fonts/0.png"); break;
      case 1: Im[1] = gdk_imlib_load_image (PKGDATADIR"fonts/1.png"); break;
      case 2: Im[2] = gdk_imlib_load_image (PKGDATADIR"fonts/2.png"); break;
      case 3: Im[3] = gdk_imlib_load_image (PKGDATADIR"fonts/3.png"); break;
      case 4: Im[4] = gdk_imlib_load_image (PKGDATADIR"fonts/4.png"); break;
      case 5: Im[5] = gdk_imlib_load_image (PKGDATADIR"fonts/5.png"); break;
      case 6: Im[6] = gdk_imlib_load_image (PKGDATADIR"fonts/6.png"); break;
      case 7: Im[7] = gdk_imlib_load_image (PKGDATADIR"fonts/7.png"); break;
      case 8: Im[8] = gdk_imlib_load_image (PKGDATADIR"fonts/8.png"); break;
      case 9: Im[9] = gdk_imlib_load_image (PKGDATADIR"fonts/9.png"); break;
      case 10:
        Im[10] = gdk_imlib_load_image (PKGDATADIR"fonts/dot.png"); break;
      case 11: Im[11] = gdk_imlib_load_image (PKGDATADIR"fonts/is.png"); break;
      case 12:
        Im[12] = gdk_imlib_load_image (PKGDATADIR"fonts/minus.png"); break;
      case 13:
        Im[13] = gdk_imlib_load_image (PKGDATADIR"fonts/plus.png"); break;
      case 14:
        Im[14] = gdk_imlib_load_image (PKGDATADIR"fonts/slash.png"); break;
      case 15:
        Im[15] = gdk_imlib_load_image (PKGDATADIR"fonts/space.png"); break;
      case 16:
        Im[16] = gdk_imlib_load_image (PKGDATADIR"fonts/star.png"); break;
      case 17: Im[17] = gdk_imlib_load_image (PKGDATADIR"fonts/x.png");
        break;
      case 18: Im[18] = gdk_imlib_load_image (PKGDATADIR"fonts/u_0.png");
        break;
      case 19: Im[19] = gdk_imlib_load_image (PKGDATADIR"fonts/u_1.png"); break;
      case 20: Im[20] = gdk_imlib_load_image (PKGDATADIR"fonts/u_2.png"); break;
      case 21: Im[21] = gdk_imlib_load_image (PKGDATADIR"fonts/u_3.png"); break;
      case 22: Im[22] = gdk_imlib_load_image (PKGDATADIR"fonts/u_4.png"); break;
      case 23: Im[23] = gdk_imlib_load_image (PKGDATADIR"fonts/u_5.png"); break;
      case 24: Im[24] = gdk_imlib_load_image (PKGDATADIR"fonts/u_6.png"); break;
      case 25: Im[25] = gdk_imlib_load_image (PKGDATADIR"fonts/u_7.png"); break;
      case 26: Im[26] = gdk_imlib_load_image (PKGDATADIR"fonts/u_8.png"); break;
      case 27: Im[27] = gdk_imlib_load_image (PKGDATADIR"fonts/u_9.png"); break;
      case 28: Im[28] = gdk_imlib_load_image (PKGDATADIR"fonts/u_clear.png");
        break;
      case 29: Im[29] = gdk_imlib_load_image (PKGDATADIR"fonts/u_dot.png");
        break;
      case 30: Im[30] = gdk_imlib_load_image (PKGDATADIR"fonts/u_help.png");
        break;
      case 31: Im[31] = gdk_imlib_load_image (PKGDATADIR"fonts/u_hint.png");
        break;
      case 32: Im[32] = gdk_imlib_load_image (PKGDATADIR"fonts/u_ok.png");
        break;
      case 33: Im[33] = gdk_imlib_load_image (PKGDATADIR"fonts/u_space.png");
        break;
      case 34: Im[34] = gdk_imlib_load_image (PKGDATADIR"fonts/u_x.png"); break;
      case 35: Im[35] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_0.png");
        break;
      case 36: Im[36] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_1.png");
        break;
      case 37: Im[37] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_2.png");
        break;
      case 38: Im[38] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_3.png");
        break;
      case 39: Im[39] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_4.png");
        break;
      case 40: Im[40] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_5.png");
        break;
      case 41: Im[41] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_6.png");
        break;
      case 42: Im[42] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_7.png");
        break;
      case 43: Im[43] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_8.png");
        break;
      case 44: Im[44] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_9.png");
        break;
      case 45: Im[45] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_clear.png");
        break;
      case 46: Im[46] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_dot.png");
        break;
      case 47: Im[47] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_help.png");
        break;
      case 48: Im[48] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_hint.png");
        break;
      case 49: Im[49] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_ok.png");
        break;
      case 50: Im[50] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_x.png");
        break;
      case 51: Im[51] = gdk_imlib_load_image (PKGDATADIR"fonts/r_0.png"); break;
      case 52: Im[52] = gdk_imlib_load_image (PKGDATADIR"fonts/r_1.png"); break;
      case 53: Im[53] = gdk_imlib_load_image (PKGDATADIR"fonts/r_2.png"); break;
      case 54: Im[54] = gdk_imlib_load_image (PKGDATADIR"fonts/r_3.png"); break;
      case 55: Im[55] = gdk_imlib_load_image (PKGDATADIR"fonts/r_4.png"); break;
      case 56: Im[56] = gdk_imlib_load_image (PKGDATADIR"fonts/r_5.png"); break;
      case 57: Im[57] = gdk_imlib_load_image (PKGDATADIR"fonts/r_6.png"); break;
      case 58: Im[58] = gdk_imlib_load_image (PKGDATADIR"fonts/r_7.png"); break;
      case 59: Im[59] = gdk_imlib_load_image (PKGDATADIR"fonts/r_8.png"); break;
      case 60: Im[60] = gdk_imlib_load_image (PKGDATADIR"fonts/r_9.png"); break;
      case 61: Im[61] = gdk_imlib_load_image (PKGDATADIR"fonts/r_dot.png");
        break;
      case 62: Im[62] = gdk_imlib_load_image (PKGDATADIR"fonts/r_x.png"); break;
      case 63: Im[63] = gdk_imlib_load_image (PKGDATADIR"fonts/h_0.png"); break;
      case 64: Im[64] = gdk_imlib_load_image (PKGDATADIR"fonts/h_1.png"); break;
      case 65: Im[65] = gdk_imlib_load_image (PKGDATADIR"fonts/h_2.png"); break;
      case 66: Im[66] = gdk_imlib_load_image (PKGDATADIR"fonts/h_3.png"); break;
      case 67: Im[67] = gdk_imlib_load_image (PKGDATADIR"fonts/h_4.png"); break;
      case 68: Im[68] = gdk_imlib_load_image (PKGDATADIR"fonts/h_5.png"); break;
      case 69: Im[69] = gdk_imlib_load_image (PKGDATADIR"fonts/h_6.png"); break;
      case 70: Im[70] = gdk_imlib_load_image (PKGDATADIR"fonts/h_7.png"); break;
      case 71: Im[71] = gdk_imlib_load_image (PKGDATADIR"fonts/h_8.png"); break;
      case 72: Im[72] = gdk_imlib_load_image (PKGDATADIR"fonts/h_9.png"); break;
      case 73: Im[73] = gdk_imlib_load_image (PKGDATADIR"fonts/h_dot.png");
        break;
      case 74: Im[74] = gdk_imlib_load_image (PKGDATADIR"fonts/h_x.png");
        break;
      case 75: Im[75] = gdk_imlib_load_image (PKGDATADIR"fonts/r_minus.png");
        break;
      case 76: Im[76] = gdk_imlib_load_image (PKGDATADIR"fonts/u_minus.png");
        break;
      case 77: Im[77] = gdk_imlib_load_image (PKGDATADIR"fonts/uh_minus.png");
        break;
      case 78: Im[78] = gdk_imlib_load_image (PKGDATADIR"fonts/h_minus.png");
        break;
      default:
        Message ("Could not load png!", 3);
    }
    gW[iFonts] = Im[iFonts]->rgb_width;
    gH[iFonts] = Im[iFonts]->rgb_height;
    gdk_imlib_render (Im[iFonts], gW[iFonts], gH[iFonts]);
    gPixmap[iFonts] = gdk_imlib_move_image (Im[iFonts]);
  }

  for (iButtons = 0; iButtons < 15; iButtons++)
  {
    gPixmapWid[iButtons] = gtk_pixmap_new (gPixmap[15], NULL);
    gtk_container_add (GTK_CONTAINER (gButtons[iButtons]),
      gPixmapWid[iButtons]);
    gtk_widget_show (gPixmapWid[iButtons]);
  }

  for (iButtons = 0; iButtons < 5; iButtons++)
  {
    gPixmapWidS[iButtons] = gtk_pixmap_new (gPixmap[33], NULL);
    gtk_container_add (GTK_CONTAINER (gSButtons[iButtons]),
      gPixmapWidS[iButtons]);
    gtk_widget_show (gPixmapWidS[iButtons]);
  }

  gMinusWid = gtk_pixmap_new (gPixmap[76], NULL);
  gtk_container_add (GTK_CONTAINER (gMinusButton),
    gMinusWid);
  gtk_widget_show (gMinusWid);

  for (iButtons = 0; iButtons < FONTS2; iButtons++)
  {
    gPixmapWid2[iButtons] = gtk_pixmap_new (gPixmap[iButtons + 18], NULL);
    gtk_container_add (GTK_CONTAINER (gButtons2[iButtons]),
      gPixmapWid2[iButtons]);
    gtk_widget_show (gPixmapWid2[iButtons]);
  }

  gPixmapWid2[10] = gtk_pixmap_new (gPixmap[29], NULL);
  gtk_container_add (GTK_CONTAINER (gDotButton),
    gPixmapWid2[10]);
  gtk_widget_show (gPixmapWid2[10]);
  gPixmapWid2[11] = gtk_pixmap_new (gPixmap[34], NULL);
  gtk_container_add (GTK_CONTAINER (gXButton),
    gPixmapWid2[11]);
  gtk_widget_show (gPixmapWid2[11]);
  gPixmapWid2[12] = gtk_pixmap_new (gPixmap[33], NULL);
  gtk_container_add (GTK_CONTAINER (gSpaceButton),
    gPixmapWid2[12]);
  gtk_widget_show (gPixmapWid2[12]);
  gPixmapWid2[13] = gtk_pixmap_new (gPixmap[32], NULL);
  gtk_container_add (GTK_CONTAINER (gOKButton),
    gPixmapWid2[13]);
  gtk_widget_show (gPixmapWid2[13]);
  gPixmapWid2[14] = gtk_pixmap_new (gPixmap[28], NULL);
  gtk_container_add (GTK_CONTAINER (gClearButton),
    gPixmapWid2[14]);
  gtk_widget_show (gPixmapWid2[14]);
  gPixmapWid2[15] = gtk_pixmap_new (gPixmap[30], NULL);
  gtk_container_add (GTK_CONTAINER (gHelpButton),
    gPixmapWid2[15]);
  gtk_widget_show (gPixmapWid2[15]);
  gPixmapWid2[16] = gtk_pixmap_new (gPixmap[31], NULL);
  gtk_container_add (GTK_CONTAINER (gHintButton),
    gPixmapWid2[16]);
  gtk_widget_show (gPixmapWid2[16]);

  NewQuestion ();
  gtk_widget_show (gWindow1);
  gtk_main ();
  return 0;
}
