#include "About.h"

#ifndef USE_GNOME
void DestroyAbout (void)
{
  gtk_widget_destroy (gAbout);
  iAbout = 0;
}
#endif

void About (void)
{
  if (iAbout == 0)
  {
#ifdef USE_GNOME
    const gchar *author[] = {
      "Norbert de Jonge <hack@altavista.net>", 0
    };
    gAbout = gnome_about_new ("Math Literature", "0.0.1",
      "Copyright (C) 1999 Norbert de Jonge", author,
      "Math Literature is a part of Logical Literature (lolit) and aims to "
      "teach children aged 2-8 to calculate with positive numbers.", 0);
    gtk_widget_show (gAbout);
#else
    GtkWidget *gAboutLabel;
    GtkWidget *gAboutLabel2;
    GtkWidget *gAboutButton;

    gAbout = gtk_dialog_new ();
    gtk_window_position (GTK_WINDOW (gAbout), GTK_WIN_POS_CENTER);
    gtk_window_set_title (GTK_WINDOW (gAbout), "About");
    gtk_signal_connect (GTK_OBJECT (gAbout), "delete_event",
      GTK_SIGNAL_FUNC (DestroyAbout), NULL);
    gtk_window_set_policy (GTK_WINDOW (gAbout), 0, 0, 1);
    gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (gAbout)->vbox), 10);
    gtk_widget_realize (gAbout);

    gAboutLabel = gtk_label_new ("Math Literature 0.0.1\n\nCopyright (C) 1999 "
      "Norbert de Jonge <hack@altavista.net>");
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (gAbout)->vbox), gAboutLabel, TRUE,
      TRUE, 10);
    gtk_widget_show (gAboutLabel);

    gAboutLabel2 = gtk_label_new ("Math Literature is a part of Logical "
      "Literature (lolit) and aims to\nteach children aged 2-8 to calculate "
      "with positive numbers.\n");
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (gAbout)->vbox), gAboutLabel2,
      TRUE, TRUE, 10);
    gtk_widget_show (gAboutLabel2);

    gAboutButton = gtk_button_new_with_label ("OK");
    gtk_signal_connect (GTK_OBJECT (gAboutButton), "clicked",
      GTK_SIGNAL_FUNC (DestroyAbout), NULL);
    GTK_WIDGET_SET_FLAGS (gAboutButton, GTK_CAN_DEFAULT);
    gtk_window_set_default (GTK_WINDOW (gAbout), gAboutButton);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (gAbout)->action_area),
      gAboutButton, TRUE, TRUE, 10);
    gtk_widget_show (gAboutButton);

    gtk_widget_show (gAbout);
    iAbout = 1;
#endif
  }
}
