/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */


/* theme.h - gnect - a "Four In A Row" game for the GNOME.
 *
 * (c) 2000, 2001 Tim Musson <trmusson@ihug.co.nz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



#ifndef _GNECT_THEME_H_
#define _GNECT_THEME_H_ 1


#define THEME_FILEBUFFER_GROW_SIZE     300

#define MAX_LENGTH_PLAYER_DESCR        22

#define STR_THEME_KEYWORD_TITLE        "Title"
#define STR_THEME_KEYWORD_PLAYER1      "Player1"
#define STR_THEME_KEYWORD_PLAYER2      "Player2"
#define STR_THEME_KEYWORD_TILE_SET     "Tileset"
#define STR_THEME_KEYWORD_BACKGROUND   "Background"
#define STR_THEME_KEYWORD_GRID_RGB     "GridRGB"
#define STR_THEME_KEYWORD_NO_GRID      "NoGrid"
#define STR_THEME_KEYWORD_TOOLTIP      "Tooltip"

#define DEFAULT_GRID_COLOUR            "RGB:00/00/00"
#define USER_THEME_DIR                 "~/.gnect/themes"
#define USER_PIXMAP_DIR                "~/.gnect/pixmaps"


typedef struct ThemeList {
	gchar        *title;
	gchar        *fnameTheme;
	gchar        *fnameTileset;
	gchar        *fnameBackground;
	gchar        *descrPlayer1;
	gchar        *descrPlayer2;
	gchar        *tooltip;
	gchar        *gridRGB;
	gboolean      isUserTheme;
	struct ThemeList *prev;
	struct ThemeList *next;
} *THEMELIST_PTR;



void          theme_init(void);
void          theme_free(THEMELIST_PTR firstTheme);
THEMELIST_PTR theme_pointer_from_filename(const gchar *fnameTheme);


#endif
