/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */


/* sound.c - gnect - a "Four In A Row" game for the GNOME.
 *
 * (c) 2000, 2001 Tim Musson <trmusson@ihug.co.nz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



#include <gnome.h>
#include "main.h"
#include "sound.h"



extern struct Gnect gnect;


void sound_event(gint soundID)
{
	/* If sound isn't toggled off, make a noise according to
	   soundMode and soundID */


	if (gnect.prefs.toggleSound) {

		switch(soundID) {

		case SOUND_ID_WIN :
			if (gnect.prefs.soundMode == SELECT_SOUNDMODE_BEEP) {
				gdk_beep();
			}
			else if (gnect.prefs.soundMode == SELECT_SOUNDMODE_PLAY) {
				gnome_triggers_do(NULL, NULL, PACKAGE, SOUND_STR_WIN, NULL);
			}
			break;

		case SOUND_ID_I_WIN :
			if (gnect.prefs.soundMode == SELECT_SOUNDMODE_BEEP) {
				gdk_beep();
			}
			else if (gnect.prefs.soundMode == SELECT_SOUNDMODE_PLAY) {
				gnome_triggers_do(NULL, NULL, PACKAGE, SOUND_STR_I_WIN, NULL);
			}
			break;

		case SOUND_ID_YOU_WIN :
			if (gnect.prefs.soundMode == SELECT_SOUNDMODE_BEEP) {
				gdk_beep();
			}
			else if (gnect.prefs.soundMode == SELECT_SOUNDMODE_PLAY) {
				gnome_triggers_do(NULL, NULL, PACKAGE, SOUND_STR_YOU_WIN, NULL);
			}
			break;

		case SOUND_ID_DRAWN_GAME :
			if (gnect.prefs.soundMode == SELECT_SOUNDMODE_BEEP) {
				gdk_beep();
			}
			else if (gnect.prefs.soundMode == SELECT_SOUNDMODE_PLAY) {
				gnome_triggers_do(NULL, NULL, PACKAGE, SOUND_STR_DRAWN_GAME, NULL);
			}
			break;

		case SOUND_ID_CANT_MOVE :
			if (gnect.prefs.soundMode == SELECT_SOUNDMODE_BEEP) {
				gdk_beep();
			}
			else if (gnect.prefs.soundMode == SELECT_SOUNDMODE_PLAY) {
				gnome_triggers_do(NULL, NULL, PACKAGE, SOUND_STR_CANT_MOVE, NULL);
			}
			break;

		case SOUND_ID_DROP_COUNTER :
			if (gnect.prefs.soundMode == SELECT_SOUNDMODE_PLAY) {
				gnome_triggers_do(NULL, NULL, PACKAGE, SOUND_STR_DROP_COUNTER, NULL);
			}
			break;
			
		case SOUND_ID_TANTRUM :
			if (gnect.prefs.soundMode == SELECT_SOUNDMODE_PLAY) {
				gnome_triggers_do(NULL, NULL, PACKAGE, SOUND_STR_TANTRUM, NULL);
			}
			break;

		default:
			break;

		}

	}

}
