/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */


/* prefs.h - gnect - a "Four In A Row" game for the GNOME.
 *
 * (c) 2000, 2001 Tim Musson <trmusson@ihug.co.nz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



#ifndef _GNECT_PREFS_H_
#define _GNECT_PREFS_H_ 1


#define DEFAULT_PREFS_PLAYER1                 "0"              /* Human */
#define DEFAULT_PREFS_PLAYER2                 "2"              /* Velena Engine, first level */
#define DEFAULT_PREFS_STARTMODE               "3"              /* Alternate */
#define DEFAULT_PREFS_SOUNDMODE               "1"              /* Beep */
#define DEFAULT_PREFS_KEY_LEFT                "106"            /* j */
#define DEFAULT_PREFS_KEY_RIGHT               "108"            /* l */
#define DEFAULT_PREFS_KEY_DROP                "107"            /* k */
#define DEFAULT_PREFS_THEME                   "default.gnect"  /* If no prefs exist, start with this theme */
#define DEFAULT_PREFS_DO_GRIDS                "true"           /* Draw grids on background images by default */
#define DEFAULT_PREFS_DO_ANIMATE              "true"           /* Use animation by default */
#define DEFAULT_PREFS_DO_WIPES                "true"           /* Do animated wipes by default */
#define DEFAULT_PREFS_DO_LOCK                 "true"           /* Use theme-supplied player descriptions by default */
#define DEFAULT_PREFS_ANIM_DELAY              "1"              /* Normal speed (no prefs options for this) */
#define DEFAULT_PREFS_TOGGLE_TOOLBAR          "true"          /* true = enabled */
#define DEFAULT_PREFS_TOGGLE_SOUND            "true"           /* true = enabled */

#define SELECT_PLAYER_HUMAN                   0
#define SELECT_PLAYER_GNECT                   1
#define SELECT_PLAYER_VELENA_WEAK             2
#define SELECT_PLAYER_VELENA_MEDIUM           3
#define SELECT_PLAYER_VELENA_STRONG           4

#define SELECT_STARTMODE_PLAYER_ONE           0
#define SELECT_STARTMODE_PLAYER_TWO           1
#define SELECT_STARTMODE_RANDOM               2
#define SELECT_STARTMODE_ALTERNATE            3

#define SELECT_SOUNDMODE_NONE                 0
#define SELECT_SOUNDMODE_BEEP                 1
#define SELECT_SOUNDMODE_PLAY                 2


typedef struct Prefs {
	gint           player1;
	gint           player2;
	gint           startMode;
	gint           soundMode;
	gint           keyLeft;
	gint           keyRight;
	gint           keyDrop;
	gchar         *fnameTheme;
	gchar         *descrPlayer1;
	gchar         *descrPlayer2;
	THEMELIST_PTR  theme;
	gboolean       doGrids;
	gboolean       doAnimate;
	gboolean       doWipes;
	gint           animDelay;
	gboolean       toggleToolbar;
	gboolean       toggleSound;
} *PREFERENCES_PTR;



void prefs_init(void);
void prefs_free(void);
void prefs_check(void);
void prefs_set_player_descriptions(void);
void cb_prefs(const GtkWidget *widget, const gpointer *data);

#endif
