/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */


/* main.h - gnect - a "Four In A Row" game for the GNOME.
 *
 * (c) 2000, 2001 Tim Musson <trmusson@ihug.co.nz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include "config.h"
#include "theme.h"
#include "gfx.h"
#include "gui.h"
#include "prefs.h"
#include "connect4.h"


#ifndef _GNECT_MAIN_H_
#define _GNECT_MAIN_H_ 1


/* Include --debugging option? Might as well */
#define GNECT_DEBUGGING

/* Want those tooltips on the player selection options
   in prefs? comment = no / uncomment = yes */
#define ANNOYING_TOOLTIPS

/* Should the grid drawn over the background image
   include the cursor row? comment = no / uncomment = yes */
#define GRID_FULL_HEIGHT


#define PLAYER_ONE                            0
#define PLAYER_TWO                            1
#define DRAWN_GAME                            2

#define GNECT_REFRESH_DISPLAY_FALSE           FALSE
#define GNECT_REFRESH_DISPLAY_TRUE            TRUE

#define GNECT_RESET_FIRST_GAME                0
#define GNECT_RESET_AND_WAIT                  1
#define GNECT_RESET_AND_START                 2

#define GAME_N_ROWS                           7 /* do not change - won't work with Velena Engine */
#define GAME_N_COLS                           7 /* ditto */
#define GAME_LINE_LENGTH                      4 /* ditto */
#define CURSOR_START_COL                      (GAME_N_COLS / 2)
#define MAX_LEN_VELENGSTR                     (GAME_N_COLS * GAME_N_ROWS + 4)

#define GNECT_ICON_FILENAME                   "gnect-icon.png"
#define GNECT_ICON_WIDTH                      48
#define GNECT_ICON_HEIGHT                     48

#define UNDO_IS_WIPE                          TRUE
#define UNDO_IS_NORMAL                        FALSE


typedef struct Gnect {
#ifdef GNECT_DEBUGGING
	gint            debugging;
#endif
	gboolean        over;
	gint            cursorCol;
	gint            currentPlayer;
	gint            whoStarts;
	gint            winner;
	gint            score[3];
	gchar           velengStr[MAX_LEN_VELENGSTR];
	struct board   *velengBoard;
	gint            board[GAME_N_ROWS][GAME_N_COLS];
	struct Gui      gui;
	struct Gfx      gfx;
	struct Prefs    prefs;
	THEMELIST_PTR   themes;
} *GNECT_PTR;



/* VELENA ENGINE */

/* playgame.c */
short          playgame(char *input_str, struct board *board);

/* connect4.c */
struct board  *veleng_init(void);
void           veleng_free(struct board *board);


#endif
