/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */


/* gui.h - gnect - a "Four In A Row" game for the GNOME.
 *
 * (c) 2000, 2001 Tim Musson <trmusson@ihug.co.nz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



#ifndef _GNECT_GUI_H_
#define _GNECT_GUI_H_ 1


#define GNECT_ID_MENU_ITEM_TOGGLE_TOOLBAR     2 /* toolbar toggle is 2nd item in settings menu */
#define GNECT_ID_MENU_ITEM_TOGGLE_SOUND       3
#define GNECT_ID_MENU_ITEM_TOGGLE_GRID        4

#define GNECT_STATUS_MSG_FLASH                0
#define GNECT_STATUS_MSG_SET                  1
#define GNECT_STATUS_MSG_CLEAR                3



typedef struct Gui {
	GtkWidget      *app;
 	GtkWidget      *appbar;
 	GnomeDockItem  *toolbarGDI;
	GtkWidget      *contentbox;
 	GtkWidget      *drawArea;
 	GtkWidget      *aboutDialog;
 	GtkWidget      *prefsDialog;
 	GtkWidget      *scoreDialog;
} *GUI_PTR;



void      gui_set_tooltip(GtkWidget *widget, const gchar *tipStr);
void      gui_status_message(const gchar *message, gint mode);
void      gui_create_app_window(void);
void      gui_open(void);


#endif
