/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */


/* gnect.h - gnect - a "Four In A Row" game for the GNOME.
 *
 * (c) 2000, 2001 Tim Musson <trmusson@ihug.co.nz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



#ifndef _GNECT_H_
#define _GNECT_H_ 1


void      gnect_randomize(void);
gint      gnect_random_number(gint top);
void      gnect_cleanup(void);
void      gnect_error(const gchar *message);
gint      gnect_mouse_x_to_col(gint x);
gboolean  gnect_is_full_board(void);
gboolean  gnect_is_full_column(gint col);
gint      gnect_top_used_row(gint col);
gboolean  gnect_player_is_human(gint player);
gboolean  gnect_player_is_gnect(gint player);
gboolean  gnect_player_is_veleng(gint player);
gboolean  gnect_is_computers_move(void);
gint      gnect_n_players(void);
gchar     gnect_get_veleng_level(gint player);
void      gnect_switch_players(void);
gboolean  gnect_undo_move(gboolean isWipe);
void      gnect_reset(gint resetMode);
void      gnect_reset_game(gint resetMode);
void      gnect_reset_display(void);
void      gnect_reset_board(gboolean refreshDisplay);
void      gnect_reset_scores(gboolean refreshDisplay);
gint      gnect_check_computer_move(gpointer data); /* (DN, 2001.01.18) */
void      gnect_process_move(gint col);
gboolean  gnect_makes_line(gint counter, gint row, gint col, gint len);
gboolean  gnect_makes_line_diagonal2(gint counter, gint row, gint col, gint len);
gboolean  gnect_makes_line_diagonal1(gint counter, gint row, gint col, gint len);
gboolean  gnect_makes_line_vertical(gint counter, gint col, gint len);
gboolean  gnect_makes_line_horizontal(gint counter, gint row, gint len);
void      gnect_tantrum(void);


#endif
