/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */


/* gfx.h - gnect - a "Four In A Row" game for the GNOME.
 *
 * (c) 2000, 2001 Tim Musson <trmusson@ihug.co.nz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



#ifndef _GNECT_GFX_H_
#define _GNECT_GFX_H_ 1


#define TILE_PLAYER_ONE                       0
#define TILE_PLAYER_TWO                       1
#define TILE_CLEAR                            2
#define TILE_CLEAR_CURSOR                     3
#define TILE_PLAYER_ONE_CURSOR                4
#define TILE_PLAYER_TWO_CURSOR                5
#define N_TILES_IN_SET                        6

#define N_WINNING_LINE_FLASHES                4

#define GNECT_FRAMERATE                       (CLOCKS_PER_SEC / 60)



typedef struct Gfx {
	GdkPixmap      *tilesPixmap;
	GdkPixmap      *tilesMask;
	GdkPixmap      *backgroundPixmap;
	GdkPixmap      *playerPixmap1;
	GdkPixmap      *playerPixmap2;
	GdkPixmap      *bufferPixmap;
	gint            tileWidth;
	gint            tileHeight;
	gint            tileOffset[N_TILES_IN_SET];
} *GFX_PTR;



gboolean  gfx_load_pixmaps(THEMELIST_PTR theme);
void      gfx_free_pixmaps(void);
void      gfx_redraw_area(const GdkRectangle *area);
void      gfx_draw_tile(gint row, gint col, gint tileSelector, gboolean refreshDisplay);
void      gfx_draw_all_tiles(gboolean refreshDisplay);
gint      gfx_drop_counter(gint col);
void      gfx_suck_counter(gint col);
void      gfx_move_cursor(gint col);
void      gfx_flash_winning_lines(gint row, gint col, gint nFlashes);
void      gfx_wipe_board(void);


#endif
