/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */


/****************************************************************************
 *                                                                          *
 *                      Velena Source Code V1.0                             *
 *                   Written by Giuliano Bertoletti                         *
 *       Based on the knowledged approach of Louis Victor Allis             *
 *   Copyright (C) 1996-97 by Giuliano Bertoletti & GBE 32241 Software PR   *
 *                                                                          *
 ****************************************************************************

 Portable engine version.
 read the README file for further informations.

 ============================================================================

 The author, Giuliano Bertoletti, has kindly granted permission to distribute
 this software under the terms of the GNU General Public License. (Please see
 the COPYING file for details). Note that these files have been hacked a bit
 for inclusion with gnect. The original Velena Engine source can be found
 here:

 http://www.ce.unipr.it/~gbe/velena.html


 T.R. Musson, 2001.01.08

 ===========================================================================*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>

#include <gnome.h>

#include "connect4.h"
#include "pnsearch.h"
#include "proto.h"


void gnect_error(const gchar *message);


extern struct board *brd;
extern int doVelengLogfile;


void fatal_error(char *erstring)
{
	FILE *h1 = NULL;
	short x;


	if (doVelengLogfile) {
		h1 = fopen(LOGFILE, "a+");
		if (h1 != NULL) {
			fprintf(h1, _("\n*** Fatal Error *** : %s\n"), erstring);
		}
	}

	if (brd && brd->filled > 0) {
		for(x = 0; x < brd->filled; x++) {
			putc(brd->moves[x]+0x31, h1);
		}
		if (h1 != NULL) {
			fprintf(h1, "\n\n");
		}
	}

	if (h1 != NULL) {
		fclose(h1);
	}

	g_print(_("\ngnect: Fatal Error: %s\n"), erstring);

	gnect_error(NULL);

}
