/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */


/* dialog.c - gnect - a "Four In A Row" game for the GNOME.
 *
 * (c) 2000, 2001 Tim Musson <trmusson@ihug.co.nz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



#include <gnome.h>
#include "main.h"
#include "gnect.h"
#include "dialog.h"
#include "file.h"


extern struct Gnect gnect;


static GtkWidget *labelDescrOne;
static GtkWidget *labelScoreOne;
static GtkWidget *labelDescrTwo;
static GtkWidget *labelScoreTwo;
static GtkWidget *labelDescrDrawn;
static GtkWidget *labelScoreDrawn;
static gchar      scoreStr[LEN_SCORESTR];




void cb_dialog_about(const GtkWidget *widget, const gpointer *data)
{
	/* Build and display the "About" dialogue */


	const gchar *authors[] = {"Tim Musson  <trmusson@ihug.co.nz>                  ",
							  "David Neary <dneary@eircom.net>",
							  NULL};


	/* don't bother if it's already open */
	if (gnect.gui.aboutDialog != NULL) {
		return;
	}

	gnect.gui.aboutDialog = gnome_about_new(PACKAGE, VERSION,
										   "(c) 2001, The Authors", authors,
										   _("\"Four In A Row\" for GNOME, with a computer player driven by Giuliano Bertoletti's Velena Engine. This software is released under the GNU General Public License with Giuliano's consent.\n \nBug Reports:\n    <trmusson@ihug.co.nz>\n \nInformation:\n    Gnect: http://homepages.ihug.co.nz/~trmusson/gnect.html\n    Velena: http://www.ce.unipr.it/~gbe/velena.html\n \nSincere thanks to Giuliano Bertoletti.\n"),
										   NULL);

	gnome_dialog_set_parent(GNOME_DIALOG(gnect.gui.aboutDialog), GTK_WINDOW(gnect.gui.app));
	gtk_signal_connect(GTK_OBJECT(gnect.gui.aboutDialog), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &gnect.gui.aboutDialog);

	gtk_widget_show(gnect.gui.aboutDialog);
}



static void dialog_score_set_descriptions(void)
{
	/* Set player description labels in score dialogue */


	GtkWidget *labelTempDescrOne = NULL;
	GtkWidget *labelTempDescrTwo = NULL;
	gchar     *descrMe           = NULL;
	gchar     *descrYou          = NULL;


	if (gnect_n_players() == 1) { /* in human vs computer games... */

		/* "Me" vs "You" */

		descrMe = g_strdup(_("Me"));
		descrYou = g_strdup(_("You"));

		if (!gnect_player_is_human(gnect.prefs.player1)) {
			labelTempDescrOne = labelDescrOne;
			labelTempDescrTwo = labelDescrTwo;
		}
		else {
			labelTempDescrOne = labelDescrTwo;
			labelTempDescrTwo = labelDescrOne;
		}
		gtk_label_set_text(GTK_LABEL(labelTempDescrOne), descrMe);
		gtk_label_set_text(GTK_LABEL(labelTempDescrTwo), descrYou);

		g_free(descrMe);
		g_free(descrYou);

	}
	else { /* in human vs human and computer vs computer games... */

		/* tile description vs tile description */

		labelTempDescrOne = labelDescrOne;
		labelTempDescrTwo = labelDescrTwo;

		gtk_label_set_text(GTK_LABEL(labelTempDescrOne), gnect.prefs.descrPlayer1);
		gtk_label_set_text(GTK_LABEL(labelTempDescrTwo), gnect.prefs.descrPlayer2);

	}
}



void dialog_score_update(void)
{
	/* If the scores dialogue is open, update the scores it's showing */


	if (gnect.gui.scoreDialog) {

		dialog_score_set_descriptions();
		g_snprintf(scoreStr, LEN_SCORESTR, " %d", gnect.score[PLAYER_ONE]);
		gtk_label_set_text(GTK_LABEL(labelScoreOne), scoreStr);
		g_snprintf(scoreStr, LEN_SCORESTR, " %d", gnect.score[PLAYER_TWO]);
		gtk_label_set_text(GTK_LABEL(labelScoreTwo), scoreStr);
		g_snprintf(scoreStr, LEN_SCORESTR, " %d", gnect.score[DRAWN_GAME]);
		gtk_label_set_text(GTK_LABEL(labelScoreDrawn), scoreStr);

	}
}



static void cb_dialog_score_close(const GtkWidget *widget, const gpointer *data)
{
	/* Close score dialogue */


	gtk_widget_destroy(gnect.gui.scoreDialog);
	gnect.gui.scoreDialog = 0;
}



void cb_dialog_score(const GtkWidget *widget, const gpointer *data)
{
	/* Build and display the score dialogue */


	GtkWidget *table    = NULL;
	GtkWidget *logo     = NULL;
	gchar     *filename = NULL;
	gboolean   verify;


	/* don't bother if it's already open */
	if (gnect.gui.scoreDialog) {
		return;
	}

	gnect.gui.scoreDialog = gnome_dialog_new(_("Scores"), GNOME_STOCK_BUTTON_OK, NULL);
	gnome_dialog_set_parent(GNOME_DIALOG(gnect.gui.scoreDialog), GTK_WINDOW(gnect.gui.app));
	gtk_signal_connect(GTK_OBJECT(gnect.gui.scoreDialog), "delete_event", GTK_SIGNAL_FUNC(cb_dialog_score_close), NULL);


	/* tabled layout */
	table = gtk_table_new(3, 2, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table), 10);
	gtk_widget_show(table);


	/* logo image (or just a label if image not found) */
	filename = filename_gnect_base_pixmap(GNECT_ICON_FILENAME, &verify);
	if (verify) {
		logo = gnome_pixmap_new_from_file_at_size(filename, GNECT_ICON_WIDTH, GNECT_ICON_HEIGHT);
	}
	else {
		logo = gtk_label_new(_("SCORE BOX"));
	}
	if (filename) {
		g_free(filename);
	}
	gtk_widget_show(logo);
	gtk_table_attach_defaults(GTK_TABLE(table), logo, 0, 2, 0, 1);


	/* player one */
	labelDescrOne = gtk_label_new(NULL);
	gtk_widget_show(labelDescrOne);
	gtk_table_attach_defaults(GTK_TABLE(table), labelDescrOne, 0, 1, 1, 2);

	g_snprintf(scoreStr, LEN_SCORESTR, " %d", gnect.score[PLAYER_ONE]);
	labelScoreOne = gtk_label_new(scoreStr);
	gtk_widget_show(labelScoreOne);
	gtk_table_attach_defaults(GTK_TABLE(table), labelScoreOne, 1, 2, 1, 2);


	/* player two */
	labelDescrTwo = gtk_label_new(NULL);
	gtk_widget_show(labelDescrTwo);
	gtk_table_attach_defaults(GTK_TABLE(table), labelDescrTwo, 0, 1, 2, 3);

	g_snprintf(scoreStr, LEN_SCORESTR, " %d", gnect.score[PLAYER_TWO]);
	labelScoreTwo = gtk_label_new(scoreStr);
	gtk_widget_show(labelScoreTwo);
	gtk_table_attach_defaults(GTK_TABLE(table), labelScoreTwo, 1, 2, 2, 3);


	/* drawn games */
	labelDescrDrawn = gtk_label_new(_("Drawn"));
	gtk_widget_show(labelDescrDrawn);
	gtk_table_attach_defaults(GTK_TABLE(table), labelDescrDrawn, 0, 1, 3, 4);

	g_snprintf(scoreStr, LEN_SCORESTR, " %d", gnect.score[DRAWN_GAME]);
	labelScoreDrawn = gtk_label_new(scoreStr);
	gtk_widget_show(labelScoreDrawn);
	gtk_table_attach_defaults(GTK_TABLE(table), labelScoreDrawn, 1, 2, 3, 4);


	/* set label text for player names according to tile description */
	dialog_score_set_descriptions();


	/* add it all to the dialog */
	gtk_box_pack_start_defaults(GTK_BOX(GNOME_DIALOG(gnect.gui.scoreDialog)->vbox), table);

	gnome_dialog_button_connect(GNOME_DIALOG(gnect.gui.scoreDialog), 0, GTK_SIGNAL_FUNC(cb_dialog_score_close), NULL);


	/* open dialogue */
	gtk_widget_show(gnect.gui.scoreDialog);

}
