# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import random, sys, time
import configureoutput

# some ugly workaround until pygtk get fixed...
if filter(lambda a: a in sys.argv, ['-h', '--help']):
    print """
GNU Solfege %s
Type "man solfege" for more details.
Options:
  --external-midiplayer
  --sequencer-device
  --num-synth
  --sound-using-drvmidi
  --sound-using-timidity 
  --no-sound             Do not play any sounds. Useful when porting.
  --verbose-sound-init   display more info about the sound setup
  -v, --version
  -w, --warranty         show warranty and copyright
  -h, --help             Display this message
  --gtk-help             Display the usual gtk/gnome commandline options.
    """ % configureoutput.VERSION_STRING
    sys.exit()

if filter(lambda a: a in sys.argv, ['-v', '--version']):
    print """GNU Solfege %s
This is free software. It is covered by the GNU General Public License,
and you are welcome to change it and/or distribute copies of it under
certain conditions. Invoke as `solfege --warranty` for more information.

Copyright (c) 2000-2001 by Tom Cato Amundsen <tca@gnu.org>
    """ % configureoutput.VERSION_STRING
    sys.exit()

if filter(lambda a: a in sys.argv, ['-w', '--warranty']):
    print """GNU Solfege %s
Copyright (c) 2000-2001 by Tom Cato Amundsen <tca@gnu.org>

    This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License version 2
as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

    You should have received a copy (refer to the file COPYING) of the
GNU General Public License along with this program; if not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
USA.
""" % configureoutput.VERSION_STRING
    sys.exit()


if '--gtk-help' in sys.argv:
    del sys.argv[sys.argv.index('--gtk-help')]
    sys.argv.append('--help')

# we don't want all the noise gnome and esd is making
sys.argv.append('--disable-sound')
import gtk, gnome
gtk.rc_parse("solfege.gtkrc")

class SplashWin(gtk.GtkWindow):
    def __init__(self):
        gtk.GtkWindow.__init__(self, gtk.WINDOW_POPUP)
        self.set_position(gtk.WIN_POS_CENTER)
        self.set_policy(gtk.FALSE, gtk.FALSE, gtk.FALSE)
        self.set_name("SplashWindow")
        frame = gtk.GtkFrame()
        frame.set_shadow_type(gtk.SHADOW_OUT)
        self.add(frame)
        vbox = gtk.GtkVBox()
        vbox.set_border_width(20)
        frame.add(vbox)
        l = gtk.GtkLabel("Starting GNU Solfege %s" % configureoutput.VERSION_STRING)
        l.set_name("Heading1")
        vbox.pack_start(l)
        l = gtk.GtkLabel("http://www.solfege.org")
        vbox.pack_start(l)
        self.show_all()

if not filter(lambda a: a in sys.argv, ['--no-splash', '--help', '--usage', '-?']):
    splash_win = SplashWin()
    time.sleep(0.1)
    gtk.gdk_flush()
    while gtk.events_pending():
        gtk.mainiteration(0)
else:
    splash_win = None
    if '--no-splash' in sys.argv:
        del sys.argv[sys.argv.index('--no-splash')]

import os, types, shutil
from i18n import _
import gu
import soundcard
import cfg
import tracebackwindow


def check_statistics():
    if cfg.get_string("app/version") < "0.7.21":
        print "Deleting all your statistics because of compatibility issues."
        if os.path.exists(os.path.expanduser("~/.solfege/")):
            shutil.rmtree(os.path.expanduser("~/.solfege/"))
    elif cfg.get_string("app/version") < "0.7.33":
        print "Deleting the identify-scale statistics because there was one"
        print "of the keys to the statistics code was changed. Such nasty"
        print "changes will not happen in the stable 1.0.x series."
        if os.path.exists(os.path.expanduser("~/.solfege0.7/identify-scale")):
            shutil.rmtree(os.path.expanduser("~/.solfege0.7/identify-scale/"))

def check_rcfile():
    if cfg.get_string("app/version") < "0.7.27":
        if configureoutput.WITH_GNOME:
                fn = "~/.gnome/%s" % cfg.app_id
        else:
            if sys.platform == "win32":
                fn = "~/solfegerc%s.%s"
            else:
                fn = "~/.solfegerc%s.%s"
            fn = fn % (configureoutput.MAJOR_VERSION, configureoutput.MINOR_VERSION)
        if os.path.isfile("debian-solfege.py.in"):
            # we are running the program from the source dir without installing
            shutil.copyfile("default.config", os.path.expanduser(fn))
            print "\nSorry, but you have to start Solfege one more time."
            print "I just installed a new", fn
            sys.exit(-1)
        else:
            print "Ok, you have upgraded, so I will replace your %s file." % fn
            print "Don't vorry, it's no big loss."
            cfg.clean_file()
            cfg.sync()
            if cfg.get_string("app/version") != configureoutput.VERSION_STRING:
                # we get here if the user installed with a sysconfdir that
                # gnome do not know, eg, not in /etc/gnome/config
                assert configureoutput.WITH_GNOME
                shutil.copyfile("default.config",
                                os.path.expanduser("~/.gnome/%s" % cfg.app_id))
                print "You have to start Solfege once more."
                sys.exit(-1)

    cfg.set_string('app/version', configureoutput.VERSION_STRING)

def setup_sound():
    # We do this because:
    #  if the config say we should use /dev/music, and the user
    #  give command line option --no-sound, this should not be
    #  remembered the next run.
    for a in "type", "device_file", "synth_number", "commandline", "card_info":
        cfg.set_string("_tmp/%s" % a,
            cfg.get_string("sound/%s" % a))

    x = 0
    while 1:
        arg = sys.argv[x]
        if arg[:len('--external-midiplayer=')] == '--external-midiplayer=':
            cfg.set_string("sound/type", "external-midiplayer")
            cfg.set_string("sound/commandline",
                                arg[len('--external-midiplayer='):])
            del sys.argv[x]
        elif arg[:len('--sequencer-device=')] == '--sequencer-device=':
            cfg.set_string("sound/type", "sequencer-device")
            cfg.set_string("sound/device_file",
                                arg[len('--sequencer-device='):])
            del sys.argv[x]
        elif arg == '--no-sound':
            cfg.set_string("sound/type", "fake-synth")
            del sys.argv[x]
        elif arg[:len('--synth-num=')] == '--synth-num=':
            cfg.set_int("sound/synth_number", int(arg[len('--synth-num=')]))
            del sys.argv[x]
        elif arg == '--sound-using-timidity':
            cfg.set_string("sound/type", "external-midiplayer")
            cfg.set_string("sound/commandline", "timidity -idqq %s")
            del sys.argv[x]
        elif arg == '--sound-using-drvmidi':
            cfg.set_string("sound/type", "external-midiplayer")
            cfg.set_string("sound/commandline", "drvmidi -i d %s")
            del sys.argv[x]
        else:
            x = x + 1
        if x == len(sys.argv):
            break

    if cfg.get_string("sound/type") == "external-midiplayer":
        soundcard.initialise(cfg.get_string("sound/commandline"),
                             verbose_init='--verbose-sound-init' in sys.argv)
    elif cfg.get_string("sound/type") == "sequencer-device":
            if not configureoutput.HAVE_LINUX_AWE_VOICE_H and \
               cfg.get_string("sound/card_info") == "awe":
                       cfg.set_string("sound/card_info", "");
            soundcard.initialise(cfg.get_string("sound/device_file"),
                                 cfg.get_int("sound/synth_number"),
                                 cfg.get_string("sound/card_info"),
                                 verbose_init='--verbose-sound-init' in sys.argv)
    elif cfg.get_string("sound/type") == "fake-synth":
        soundcard.initialise_using_fake_synth('--verbose-sound-init' in sys.argv)
    if '--verbose-sound-init' in sys.argv:
        del sys.argv[sys.argv.index('--verbose-sound-init')]

if not '--help' in sys.argv:
    check_statistics()
    check_rcfile()
    setup_sound()

import gnome.ui
import app

gnome.app_version = configureoutput.VERSION_STRING
gnome.app_id = 'solfege0.7'

# redirect error messages to a window that will popup if
# something bad happens.

w = tracebackwindow.TracebackWindow()
sys.stderr = w

the_app = app.SolfegeApp()

if configureoutput.WITH_GNOME:
    the_app.handle_href('welcome.html')
else:
    the_app.handle_href('nognomewelcome.html')

if splash_win:
    splash_win.destroy()
the_app.run()
