# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk, gnome
import gu, const, soundcard, mpd, abstract, random
import lessonfile, statistics, string
from i18n import _
import widgets

class Teacher(abstract.LessonbasedTeacher):
    def __init__(self, exname, app):
        abstract.LessonbasedTeacher.__init__(self, exname, app, const.USE_SING_CHORD)
        self.lessonfileclass = lessonfile.SingChordLessonfile
        self.parse_lessonfile()
    def new_question(self):
        self.q_status = const.NEW_QUESTION
        self.m_P.select_random_question()
    def play_answer(self):
        self.play_question()
    def play_440hz(self):
        soundcard.play_note(self.get_int('config/preferred_instrument'),
                       4, 0, mpd.notename_to_int("a'"),
                       self.get_int('config/preferred_instrument_velocity'))
    def play_answer_arpeggio(self):
        if self.q_status == const.NO_QUESTION:
            return
        m = soundcard.Track()
        m.set_bpm(self.get_int('config/default_bpm'))
        m.set_patch(0, self.get_int('config/preferred_instrument'))
        vel = self.get_int('config/preferred_instrument_velocity')
        for x in [0, 1]:
            v = self.m_P.get_satb_vector()[x]
            s = string.split(string.strip(v), " ")
            for n in s:
                if self.get_string('user/sex') == 'female':
                    m.note(4, 0, mpd.notename_to_int(n), vel)
                else:
                    m.note(4, 0, mpd.notename_to_int(n)-12, vel)
        for x in [2, 3]:
            v = self.m_P.get_satb_vector()[x]
            s = string.split(string.strip(v), " ")
            for n in s:
                if self.get_string('user/sex') == 'male':
                    m.note(4, 0, mpd.notename_to_int(n), vel)
                else:
                    m.note(4, 0, mpd.notename_to_int(n)+12, vel)
        soundcard.synth.play_track(m)


class Gui(abstract.LessonbasedGui):
    def __init__(self, teacher, window):
        abstract.LessonbasedGui.__init__(self, teacher, window)
        self.m_key_bindings = {'new_ak': self.new_question,
                               '440hz_ak': self.m_t.play_440hz,
                               'play_answer_ak': self.m_t.play_answer_arpeggio}
        ################
        # practise_box #
        ################
        self.g_music_displayer = mpd.MusicDisplayer()
        self.g_music_displayer.set_usize(-1, 170)
        self.practise_box.pack_start(self.g_music_displayer)
        
        self.g_new = gu.bButton(self.action_area, _("New"), self.new_question)
        gu.bButton(self.action_area, _("440hz"), lambda f, s=self: s.m_t.play_440hz())
        self.g_play_answer = gu.bButton(self.action_area, _("Play answer"), lambda f, s=self: s.m_t.play_answer_arpeggio())
        self.practise_box.show_all()
        ##############
        # config_box #
        ##############
        self.g_lessonfile_selector = widgets.SelectLessonfileWidget(
             self.m_t, self.g_win, self.update_gui_after_lessonfile_change)
        self.g_lessonfile_selector.show()
        self.config_box.pack_start(self.g_lessonfile_selector)
        self.update_gui_after_lessonfile_change()
    def new_question(self, widget=None):
        self.m_t.new_question()
        fontsize = self.get_int('config/feta_font_size=20')
        self.g_music_displayer.display(self.m_t.m_P.get_music(), fontsize)
        self.g_play_answer.set_sensitive(gtk.TRUE)
        self.m_t.play_440hz()
    def on_end_practise(self):
        self.g_play_answer.set_sensitive(gtk.FALSE)
        self.g_music_displayer.clear(2)
        self.m_t.end_practise()
    def update_gui_after_lessonfile_change(self):
        self.g_music_displayer.clear(2)
        if self.m_t.m_P:
            self.g_new.set_sensitive(gtk.TRUE)
        else:
            self.g_new.set_sensitive(gtk.FALSE)
        self.g_play_answer.set_sensitive(gtk.FALSE)
        self.g_win.set_title("Solfege - " + self.get_pretty_name())

