# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from i18n import _
import GDK

SHORT_WAIT = 700
NORMAL_WAIT = 2000

USE_CHORD = 'chord'
USE_HARMONY = 'harmony'
USE_ID_BY_NAME = 'id-by-name'
USE_DICTATION = 'dictation'
USE_SING_CHORD = 'sing-chord'


# WARNING: changing the definition of the following variables will
# break links in the documentation and the exercises will not even find
# their doco. So when adding exercises, think very carefully to get a name
# we can stick with.
CHORD              = 'chord'
HARMONIC_INTERVALL = 'harmonic-intervall'
MELODIC_INTERVALL  = 'melodic-intervall'
SING_INTERVALL     = 'sing-intervall'
IDENTIFY_SCALE     = 'identify-scale'
DICTATION          = 'dictation'
IDENTIFY_BPM       = 'identify-bpm'
ID_BY_NAME         = 'id-by-name'
HARMONIC_PROGRESSION_DICTATION = 'harmonic-progression-dictation'
TWELVE_TONE        = 'twelve-tone'
SING_CHORD         = 'sing-chord'
ID_TONE            = 'id-tone'
COMPARE_INTERVALLS = 'compare-intervalls'
INTERVALL          = 'intervalls'
POLYRHYTHM         = 'polyrhythm'
RHYTHM             = 'rhythm'

exercises = [CHORD,
             HARMONIC_INTERVALL,
             MELODIC_INTERVALL,
             SING_INTERVALL,
             IDENTIFY_SCALE,
             ID_BY_NAME,
             DICTATION,
             TWELVE_TONE,
             ID_TONE,
             COMPARE_INTERVALLS,
             SING_CHORD,
             RHYTHM]

exercisedata = {
   # id: prettyname, menulabel, pixmap
	CHORD: (_("Chords"),  _("_Chords"), 'chord24.xpm', GDK.F2, 0),
	HARMONIC_INTERVALL: (_("Harmonic intervalls"), 
              _("_Harmonic intervalls"), "harmonicintervall24.xpm", GDK.F3, 0),
	MELODIC_INTERVALL: (_("Melodic intervalls"), 
              _("_Melodic intervalls"), "melodicintervall24.xpm", GDK.F4, 0),
	SING_INTERVALL: (_("Sing intervall"), _("_Sing intervall"),
                         "singintervall24.xpm", GDK.F5, 0),
	IDENTIFY_SCALE: (_("Identify scale"), _("_Identify scale"),
                         "identifyscale24.xpm", GDK.F6, 0),
	ID_BY_NAME: (_("Identify by name"), _("Identify by _name"),
                     "idbyname24.xpm", GDK.F7, 0),
	DICTATION: (_("Dictation"), _("_Dictation"), "dictation24.xpm",
                    GDK.F8, 0),
	HARMONIC_PROGRESSION_DICTATION: (_("Harmonic progression"),
     _("Harmonic _progression dictation"), "harmonicprogression24.xpm",
            GDK.F9, 0),
	TWELVE_TONE: (_("Sing twelvetone"), _("Sing _twelvetone"), 
                "twelvetone24.xpm", GDK.F10, 0),
	ID_TONE: (_("Identify tone"), _("Id_entify tone"), 'idtone24.xpm',
                  GDK.F2, GDK.CONTROL_MASK),
	COMPARE_INTERVALLS: (_("Compare intervalls"),
              _("C_ompare intervalls"), 'compareintervalls24.xpm',
              GDK.F3, GDK.CONTROL_MASK),
	SING_CHORD: (_("Sing chord"), _("Sin_g chord"), 'singchord24.xpm',
              GDK.F4, GDK.CONTROL_MASK),
        RHYTHM: (_("Rhythm"), _("Rh_ythm"), 'rhythm24.xpm', 
              GDK.F5, GDK.CONTROL_MASK),
        POLYRHYTHM: ("Polyrhythmic", "_Polyrhythmic", "",
                     GDK.F6, GDK.CONTROL_MASK),
        IDENTIFY_BPM: ("Bpm", "Bpm", "", None, None),
        INTERVALL: ("Intervall", "Intervall", "", None, None),
}


NO_QUESTION = 0
NEW_QUESTION = 1
WRONG_GUESS = 2
SOLVED = 3

int_intervall = [_("unison"), _("minor second"), _("major second"),
                 _("minor third"), _("major third"), _("fourth"),
                 _("diminished fifth"), _("perfect fifth"),
                 _("minor sixth"), _("major sixth"),
                 _("minor seventh"), _("major seventh"),
                 _("perfect octave"),
                 _("minor ninth"), _("major ninth"),
                 _("minor decim"), _("major decim")]

from i18n import _i
short_intervall_name = [_i("u"), _i("m2"), _i("M2"), _i("m3"), _i("M3"), _i("4"),
                        _i("d5"), _i("5"), _i("m6"), _i("M6"), _i("m7"),
                        _i("M7"), _i("8"), _i("m9"), _i("M9"), _i("m10"),
                        _i("M10")]
del _i

