# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from i18n import _

import harmonicintervall, melodicintervall, singintervall
import identifyscale, bpm, idbyname, harmonicprogressiondictation
import twelvetone, singchord, idtone, compareintervalls, intervall
import chord, dictation, polyrhythm, rhythm

import mainwin
import gtk

import utils
import const
import soundcard, mpd
import lessonfile
import os
import gnome
import cfg

class SolfegeApp(cfg.ConfigUtils):
    def __init__(self):
        cfg.ConfigUtils.__init__(self, 'solfege-app')
        self.mainwin = mainwin.MainWin(self)
        self.mainwin.show()
        self.mainwin.post_constructor()
        self.g_musicviewer_window = None
        self.g_about_window = None
        self.m_teachers = {}
        self.lessonfile_manager = lessonfile.LessonFileManager()
        if not soundcard.synth:
            self.mainwin.display_sound_config_error_message()
    def play_happy_sound(self):
        mpd.play_music(r"\staff\relative c'{c16 e g a}", 180, 8)
    def play_sad_sound(self):
        mpd.play_music(r"\staff\relative c'{<c,,8 cis>", 180, 58)
    def close_musicviewer(self, widget=None):
        self.g_musicviewer_window.destroy()
        self.g_musicviewer_window = None
    def display_in_musicviewer(self, music):
        if not self.g_musicviewer_window:
            self.g_musicviewer_window = mainwin.MusicViewerWindow(self)
            self.g_musicviewer_window.show()
        self.g_musicviewer_window.display_music(music)
    def please_help_me(self):
        if self.mainwin.m_viewer != 'docviewer':
            self.handle_href('%s-help.html' % self.mainwin.m_viewer)
    def handle_href(self, href):
        protocol, action, fn, lessoncollection, lessonfile, config = \
           utils.parse_url(href)
        ed = {const.HARMONIC_INTERVALL: harmonicintervall.Teacher,
              const.MELODIC_INTERVALL: melodicintervall.Teacher,
              const.SING_INTERVALL: singintervall.Teacher,
              const.IDENTIFY_SCALE: identifyscale.Teacher,
              const.IDENTIFY_BPM: bpm.Teacher,
              const.ID_BY_NAME: idbyname.Teacher,
              const.HARMONIC_PROGRESSION_DICTATION: 
                           harmonicprogressiondictation.Teacher,
              const.TWELVE_TONE: twelvetone.Teacher,
              const.SING_CHORD: singchord.Teacher,
              const.ID_TONE: idtone.Teacher,
              const.COMPARE_INTERVALLS: compareintervalls.Teacher,
              const.INTERVALL: intervall.Teacher,
              const.CHORD: chord.Teacher,
              const.DICTATION: dictation.Teacher,
              const.POLYRHYTHM: polyrhythm.Teacher,
              const.RHYTHM: rhythm.Teacher}
        if protocol == None:
            self.mainwin.display_docfile(fn)
        elif protocol == 'solfege':
            if action == 'all-lessonfiles':
                self.mainwin.display_html(self.lessonfile_manager.m_htmldoc)
                #ugh
                self.mainwin.m_history.add('solfege:all-lessonfiles')
            else:
                if not self.m_teachers.has_key(fn):
                    self.m_teachers[fn] = ed[fn](fn, self)
                    # if we don't have a teacher, then the Gui has not been
                    # initialized either
                    self.mainwin.initialise_exercise(self.m_teachers[fn])
                    self.m_teachers[fn].g_view = self.mainwin.box_dict[fn]
                self.m_teachers[fn].configure_exercise(lessoncollection, lessonfile, config)
                self.mainwin.activate_exercise(href)
        elif protocol == 'http':
            os.system(self.get_string("config/web_browser") % href)
        elif protocol == 'mailto':
            os.system(self.get_string("config/mua") % href)
        else:
            print "unknown link type", protocol
    def run(self):
        gtk.mainloop()
    def hide_about_window(self, widget):
        self.g_about_window.destroy()
        self.g_about_window = None
    def show_about_window(self, widget):
        if not self.g_about_window:
            from configureoutput import VERSION_STRING
            self.g_about_window = gnome.ui.GnomeAbout(
                    'GNU Solfege', VERSION_STRING,
                    'Copyright (C) 2000-2001 Tom Cato Amundsen',
                    ['Tom Cato Amundsen',
                     'Oliver Vollmer %s' % _("(toolbar icons)")],
                    #['see AUTHORS file or online documentation for details'],
                    _("GPL'ed eartraining.") + "\n"
                    + _("New version available at http://www.solfege.org"))
            self.g_about_window.connect('destroy', self.hide_about_window)
            self.g_about_window.show()
    def quit_program(self):
        if self.get_string('_tmp/type') != None:
            for a in ("type", "device_file", "synth_number",
                      "commandline", "card_info"):
                self.set_string("sound/%s" % a,
                    self.get_string("_tmp/%s" % a))
            cfg.clean_section("_tmp")
            cfg.sync()
            for k in self.m_teachers.keys():
                if self.m_teachers[k].m_statistics is not None:
                    self.m_teachers[k].m_statistics.save_data()
        if soundcard.synth:
            soundcard.synth.close()
        gtk.mainquit()
    def quit_program_NOW(self):
        """Exit really fast when we are in trouble"""
        if soundcard.synth:
            soundcard.synth.close()
        gtk.mainquit()


