m4_dnl   This documentation is free software; you can redistribute
m4_dnl   it and/or modify it under the terms of the GNU General Public
m4_dnl   License as published by the Free Software Foundation; either
m4_dnl   version 2 of the License, or (at your option) any later version.

m4_include(definitions.m4) m4warning()
<html>
<body>
body_start()

<h1>Music format</h1>

<p>The music parser understand a language inspired by mudela (MUsic DEfinition
LAnguage), as used by <a href="http://www.lilypond.org">GNU 
Lilypond</a>. An example will tell more than I can explain:
<p>
<table width="100%" bgcolor="#c7e8ff"><tr><td>
<pre>\staff{
c, g cisis' &lt; e' g' cis''&gt; cis'' 
}</pre>
</p>
</td></tr></table>

<img src="../png/simple.png">

<p>Apostroph (') and comma (,) is used to tell what octave the note
   is in. Notenames are: c d e f g a b, with endings like this to get
   accidentals: <code>ceses ces cis cisis eses es eis eisis</code>. Rests are
   entered with an <code>r</code>.  Notes to be stacked as a chord is inside
   'less than' and 'greater than' chars: <code>&lt;c e g&gt;</code> </p>

<h2><code>\relative</code></h2>
<p>A very useful <code>\relative</code> mode, like what you find in Lilypond,
   saves you from typing lots of commas and apostrophes. The parser will look
   at what octave the previous tone is, and place the note in the octave that
   make the intervall smallest possible.  See the next two examples:

<pre>
\staff\relative c'{
\key d; \time 3/4;
d a a | a2 fis8 a | d4 b b | b2
}
</pre>
<img src="../png/fist.png">

<p><pre>
\staff\relative c'{
c e g c e g c e g
}
</pre></p>
<img src="../png/ceg-relative.png">

<h2>Clefs</h2>
<p>You can set the clef with the <code>\clef clefname;</code> command.
The default clef is <code>violin</code> clef. The following clefs
are supported:
<ul>
<li><code>subbass</code>
<li><code>bass</code>
<li><code>baritone</code>
<li><code>varbaritone</code>
<li><code>tenor</code>
<li><code>alto</code>
<li><code>mezzosoprano</code>
<li><code>soprano</code>
<li><code>violin</code>(also called <code>treble</code>)
<li><code>french</code>
</ul>

<img src="../png/clef.png">

<h2><code>\addvoice</code></h2>
<p>Use <code>\addvoice</code> do enter polyphonic music:</p>
<p><pre>
\staff\relative c'{
\stemup c d e f | g2 g
}
\addvoice\relative c'{
\stemdown c4  b c2 e2 e
}
</pre></p>
<img src="../png/addvoice.png">

<a name="ties"><h2>Ties</h2></a>
Tie notes together using the tilde <code>~</code>  character.
An example:
<pre>
\staff\relative c''{
g ~ [g8 e] f4~ &lt;g f c&gt; ~ &lt;g e c&gt;
} 
</pre>

<img src="../png/tie.png">

standard_ending()
</body>
</html>
