m4_dnl   This documentation is free software; you can redistribute
m4_dnl   it and/or modify it under the terms of the GNU General Public
m4_dnl   License as published by the Free Software Foundation; either
m4_dnl   version 2 of the License, or (at your option) any later version.

m4_include(definitions.m4) m4warning()
<html>
<body>
body_start()

<h1>Lesson files</h1>

<p>If you want to write lesson files, my advise is to look at
   some of the files in <code>lesson-files/</code> and use this
   document and <a href="music-format.html">music format</a>
   spec for reference.

<h2>Lesson file contents</h2>
A lesson file contains of a header block and one or more
question blocks:
<pre>
header {
  ASSIGNMENT
  ASSIGNMENT
  ...
}
question {
  ASSIGNMENT
  ...
}
</pre>

<h3>Header block</h3>

The header block can be placed anywhere in the file, but by
convention it should be the first block in the file.

<p>Definitions to put in the header block:

<dl>
 <dt><var>title = STRING</var></dt>
 <dd>Short oneline description</dd>
 
 <dt><var>description = STRING</var></dt>
 <dd>Long description that can contain html tags.</dd>
 
 <dt><code><var>content</var> = LIST</code></dt>
 <dd>Possible values: <var>chord</var>, <var>dictation</var>,
      <var>id-by-name</var>, <var>harmony</var> and <var>sing-chord</var>
    <br>Some lessonfiles can be useful for more than one exercise.
    For example a file with chords can also be used by the id-by-name
    exercise, and should have: <code>content = chord, id-by-name</code>
 <dt><code><var>musicformat</var> = FORMAT</code></dt>
 <dd>
   <dl>
     <dt><var>normal</var>
     <dd>The default value</dd>

     <dt><var>chord</var></dt>
     <dd>any music "MUSIC CODE" will be interpreted as:
        <pre>
          \staff{ &lt; MUSIC CODE &gt; }</pre>
        or <pre>
          \staff\transpose NOTENAME{ &lt; MUSIC CODE &gt; }</pre>
        <code>musicformat = chord</code> is necessary if lesson files
        written for the chord exercise should be used by for example the
        id-by-name exercise.</dd>
     <dt><var>satb</var></dt>
     <dd>the music <code>"c | bes g | e | G C"</code>
       will be interpreted as:
       <pre>
       \staff{ \stemUp &lt;c&gt; }
       \addvoice{ \stemDown &lt;bes g&gt; }
       \staff{\clef bass; \stemUp &lt;e&gt;}
       \addvoice{ \stemDown &lt;G C&gt;}
       </pre>
       This is used by the <a href="solfege:practise/sing-chord">
               sing-chord</a> exercise.
       </dd>
   </dl>    
 </dd>
 <dt><code><var>random_transpose</var> = yes | no</code></dt>
 <dd>(Default: no) In some exercises the program can transpose the
     music to create variation. The variable is ignored in exercises
     that does not support transposing.</dd>
 <dt><code><var>labelformat</var> = normal | progression</code></dt>
 <dd>(Default: normal)</dd>
</dl>


<h4>For "Id by name" exercise only</h4>
<dl>
<dt><code><var>filldir</var> = horiz | vertic</code></dt>
<dt><code><var>fillnum</var> = INTEGER</code></dt>
<dd>These two variables control how the buttons are layed out.
    <code>filldir</code> tell the direction the buttons are filled,
    and <code>fillnum</code> tell how many buttons there are in
    each row or column.</dd>
</dl>

<h3>Question block</h3>
<dl>
<dt><code>name = "some short name"</code></dt>
<dd>Questions written for <i>id-by-name</i> and <i>chord</i> exercise
    need a name.

<dt><code>music = "\staff{c'2 g' e4 e c1}"</code></dt>
<dd>
The music in the question. Note that there is a shortcut. Instead of:
<pre>question {
   tempo = 160/4
   name = "Lisa gikk til skolen"
   music = "\staff\relative c'{c d e f g2 g2}"  
}
</pre>
you can write:
<pre>
question {
   tempo = 160/4
   name = "Lisa gikk til skolen"
   "\staff\relative c'{c d e f g2 g2}"  
}
</pre>
</dd>
<dt><code>tempo</code> = 130/4</dt>
<dd>beats per minute / notelen per beat</dd>
</dl>

<h4>Chord questions only</h4>
<p>In lesson files that is written to work with <code>chord</code> exercise,
two more variables can used:

<dl>
<dt><code>inversion</code></dt>
<dd>0 = root position, 1 = first inversion etc</dd>

<dt><code>toptone</code></dt>
<dd>1, 3, 5, 7</dd>
</dl>
</p>

<h4>Dictation exercise</h4>
<p>By default, the dictation exercise will show the first column of
   music, and then the user should write the rest. But if the first
   column is not good enough, if there for example are only rests on
   the first beat, these two variables can tell the program how much
   music to display:
<dl>
<dt><code>clue_end = nn/dd</code></dt>
<dd><code>clue_end=1/4</code> will display all music in the first
    quarter note.</dd>
<dt><code>clue_music = MUSIC</code></dt>
<dd>Write the exact music you want to display. If for example you
    want to display the whoe bar in the upper staff, and only one 
    note in the lower staff.</dd>
</dl>
(Use only one if these variables in one question. Using both are undefined.)
</p>

<h4>Sing chord exercise</h4>
Questions for this exercise need to have the <code>key</code>
variable set if the key signature is anything else than
<i>c</i> major (or <i>a</i> minor). Example:
<pre>
question { "c''|e'|g|c" }
question { "a'|e'|c'|a" }
question { key="d \major" "a'|fis'|d'|d"}
question { key="f \minor" "as'|f'|c'|f"}
</pre>
<h3>Global variables</h3>
Global variables can save you a few key strokes.

<pre>
s = "\score\relative c'{ %s  }

question {
  # instead of music = "\score\relative c'{ c d e f g2 g2 } :
  music = s % "c d e f g2 g"
}
</pre>

The global variable <var>tempo</var> will be the default tempo
for the questions following the definition. If not set, the
default value is 120 beats per minute. That equals the definition

<pre>
tempo = 60/4
</pre>

<h2>Comments</h2>
<p>Everything after # on a line is ignored</p>


<h2>Grammar</h2>

<p><small>Disclaimer: I don't know any of the standard ways of 
describing grammar, like BNF. So this is just an attemt to describe 
the file format to get people started writing lesson files.
</small></p>

<p>Lessonfiles consists of assignment statements and blocks
containing assignment statements.</p>

<h3>Functions</h3>
One builtin function, <tt><b>_</b></tt> , taking a string as its only
argument, is used to get strings translated. It is not possible
to define other functions. Example:
<pre>
description = _("This is a short description")
</pre>

<h3>Types</h3>
<dl>
<dt><code>string</code></dt>
<dd>is quoted using the <code>"</code> character, like this: "this is a string". 
    The string can contain line breaks, so this is valid:
<pre>
description = "&lt;h1&gt;Long desription&lt;/h1&gt;
               This lessonfile need very much descriptions.
               bla bla bla"
</pre>

<p> If the string need to contain the <code>"</code> character, you have
    to use tripple quotes:
<pre>
description = """Try &lt;a href="solfege:practise/melodic-intervall"&gt;this
&lt;/a&gt; for a simpler intervall exercise."""
</pre>

<dt><code>integer</code></dt>
<dd>is an integer is an integer...</dd>
<dt><code>tempotype</code> (in lack of a better name)</dt>
<dd>is entered as <code>bpm/beatlen</code>. An example:
<pre>
tempo = 120/4
</pre>
will set the tempo to 120 beats per minute, each beat being a quarter note.
</dd>
</dl>

<h3>Operators</h3>
The operators can only be used on strings
<dl>
<dt><code>+</code></dt>
<dd>is used for joining strings</dd>
<dt><code>%</code></dt>
<dd>is similar to what you find in python, but it is very limited. It
    only know about <code>%s</code>. Examples:
<pre>"\staff\relative c'{%s}" % "c d e"</pre>
 evaluates to
<pre>"\staff\relative c'{c d e}"</pre>
</dd>
</dl>

<h3>Reserved words</h3>
To be put on the right side of assignments. The current parse does
not complain if you redefines the identifiers, so <b>don't do that!</b>

<dl>
<dt><code>chord, dictation, id-by-name, sing-chord</code></dt>
<dd>Possible values for <var>content</var></dd>

<dt><code>horiz, vertic</code></dt>
<dd>Table filling in id-by-name exercise</dd>

<dt><code>normal, progression</code></dt>
<dd><var>Labelformat</var> values

<dt><code>yes, no</code><dt>
</ul>

<h3>Identifiers</h3>
Identifiers match the regular expression "[a-zA-Z]+[\w_-]*".

<h3>Block</h3>
There are two block types, <code>header</code> and <code>question</code>
<pre>
blocktype {
  CONTENTS
}
</pre>

standard_ending()
</body></html>
