m4_dnl   This documentation is free software; you can redistribute
m4_dnl   it and/or modify it under the terms of the GNU General Public
m4_dnl   License as published by the Free Software Foundation; either
m4_dnl   version 2 of the License, or (at your option) any later version.

m4_include(definitions.m4) m4warning()
<html>
<body>
body_start()
<h1>Help files</h1>

<p>Solfege is using the GtkXmHTML widget to display help, so the file
   format is plain html, more specific HTML 3.2.
</p>
<p>In addition to links to other help files, you can have links to
exercises, and the link can contain data that configure the exercise. 
</p>

<p>One of the main ideas of the integrated help system is that you can write
texts about music theory and ear training, and have links in the text that
start an exercise, configured to do whatever the author wants.  </p>

<h2>Syntax</h2>
<p>
<code>protocol:action/exercise/lessoncollection/lessonfile?configuration</code>
<p>
<dl>
<dt><code>protocol</code></dt>
<dd>Optional, if omitted, the links if to a html file.
    One possible value: <code>solfege</code>.</dd>

<dt><code>action</code></dt>
<dd>Optional, possible values: <code>practise</code>, <code>config</code>
    or <code>statistics</code>. If omitted, you will view the same part
    of the exercise you used last time. If the exercise has not been
    used in this session, you will see the practise page.

<dt><code>exercise</code></dt>
<dd><code>chord, harmonic-intervall, melodic-intervall, sing-intervall,
    identify-scale, dictation, id-by-name,
    twelve-tone, sing-chord, id-tone, compare-intervalls</code></dd>

<dt><code>lessoncollection</code></dt>
<dd>Use the value <code>solfege</code> for files distributed
with Solfege. Use <code>user</code> for your own files stored in
  <code>~/lessonfiles</code></dd>

<dt><code>lessonfile</code></dt>
<dd>File name.</dd>

<dt><code>configuration</code></dt>
<dd>Optional. Semicolon-separated list of assignments. Example:
 <code>highest_instrumnt=80; intervalls=[1, 2, 3, 4]</dd>
</dl>

<h2>Configuring exercises</h2>
If you want to configure the exercise, add data for that after a
question mark.

<p>
I am implementing configuration of exercises right now, so all exercises
are not finished. Some examples (please view the source to see how it is
done):

<p>Harmonic intervall:
<a href="solfege:practise/harmonic-intervall?intervalls=[3, 4];
nevertwice=1;lowest_tone=cis';
highest_tone=dis';
override_default_instrument=1">link</a>
<a href="solfege:/harmonic-intervall?intervalls=[3, 4];
nevertwice=0;lowest_tone=fis;highest_tone=gis;override_default_instrument=0">link</a>
 <a href="solfege:config/harmonic-intervall">View config page</a>
<p>Melodic intervall and scales:
<a href="solfege:/melodic-intervall?ask_for_intervalls_0=[3, 4, -3, -4]; nevertwice=1">link</a>
<a href="solfege:/identify-scale?scales=['Dorian', 'Aeolian', 'Harmonic minor']">link</a>

<p>Compare intervall:
<a href="solfege:/compare-intervalls?
first_intervall_up=[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16];
first_intervall_down=[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16];
last_intervall_up=[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16];
last_intervall_down=[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16];
first_intervall_type='up/down';last_intervall_type='up/down'">link</a>

<a href="solfege:/compare-intervalls?highest_instrument=30;
lowest_instrument=31;highest_instrument_velocity=100;
lowest_instrument_velocity=101">compare, set instr</a>

<a href="solfege:/compare-intervalls?highest_instrument=1;
lowest_instrument=1;highest_instrument_velocity=99;
lowest_instrument_velocity=99">compare, set instr</a>

<p>
<a href="solfege:/chord?lowest_instrument=2;middle_instrument=3;highest_instrument=4">link</a>
<a href="solfege:/chord?lowest_instrument=5;middle_instrument=6;highest_instrument=7">link</a>

<a href="solfege:/harmonic-intervall?override_default_instrument=1">override</a>

<h3>Listing of variables</h3>

<h4>Chord</h4>
<p><table border=1>
<tr>
<td>highest_instrument<br>middle_instrument<br>lowest_instrument</td>
<td>integer 0-127</td>
</tr>

<tr>
<td>highest_instrument_velocity<br>
middle_instrument_velocity<br>
lowest_instrument_velocity</td>
<td>integer 0-127</td>
</tr>

<tr><td>override_default_instrument</td><td>boolean</td></tr>
</table>

<h4>Harmonic intervall</h4>
<table border=1>

<tr><td>highest_instrument<br>lowest_instrument</td><td>integer 0-127</td></tr>

<tr>
<td>highest_instrument_velocity<br>
lowest_instrument_velocity</td>
<td>integer 0-127</td>
</tr>

<tr><td>override_default_instrument</td><td>boolean</td></tr>

<tr><td>intervalls</td><td>list of integers, [1, 2, ... 15, 16]</td></tr>

<tr><td>highest_tone<br>lowest_tone</td>
<td>Notename like, <code>c</code>, <code>fis,</code>,  or <code>d''</code></td>
</tr>
<tr><td>new_question_automatically</td><td>boolean</td></tr>
<tr><td>seconds_before_new_question</td><td>float</td></tr>
</table>

<h3>Melodic intervall, sing intervall</h3>
<table border=1>
<tr><td>number_of_intervalls</td><td>integer</td></tr>
<tr><td>ask_for_intervalls_nn, where nn is 0 or greater</td><td>list of integers: [-16, -15 ... 15, 16]</td></tr>
</table>

<h3>Identify scale</h3>
<table border=1>
<tr><td>scales</td>
<td>list of scale types: ['ionian', 'dorian', 'phrygian', 'lydian',
'mixolydian', 'aeolian', 'lokrisk', 'harmonic_minor', 'melodic_minor']</td></tr>
</table>

<h3>Id by name, dictation, harmonic progression dictation</h3>
Only specifying lesson file. 

<h3>Id tone</h3>
<p>
<table border=1>
<tr><td>c_weight<br>cis_weight<br>etc..</td>
<td>0..1000</td>
</tr>
<tr><td>one_chance_only</td><td>boolean</td></tr>
<tr><td>warning_sound</td><td>boolean</td></tr>
<tr><td>repeat_question</td><td>boolean</td></tr>
</table>
standard_ending()
</body>
</html>

