/** EMULib Emulation Library *********************************/
/**                                                         **/
/**                        LibUnix.h                        **/
/**                                                         **/
/** This file contains definitions and declarations for     **/
/** some commonly used Unix/X11 routines.                   **/
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1996-1998                 **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/
/**     changes to this file.                               **/
/*************************************************************/
#ifndef LIBUNIX_H
#define LIBUNIX_H
#ifdef UNIX

#include <X11/Xlib.h>

#ifdef MITSHM
#include <X11/extensions/XShm.h>
#endif

#ifdef BPP32
typedef unsigned int pixel;
#else
#ifdef BPP16
typedef unsigned short pixel;
#else
#ifdef BPP8
typedef unsigned char pixel;
#endif
#endif
#endif

/** InitLibUnix() ********************************************/
/** This function is called to obtain the display and other **/
/** values at startup. It returns 0 on failure.             **/
/*************************************************************/
int InitLibUnix(Display *AppDisplay);

/** X11Window() **********************************************/
/** Open a window of a given size with a given title.       **/
/*************************************************************/
Window X11Window(char *Title,int W,int H);

/** Bitmap Images ********************************************/
#define USE_SHM   0x0001            /* Use MITSHM extension  */

typedef struct
{
  char *Data;
  int W,H,D,Attrs;
  XImage *XImg;
#ifdef MITSHM
  XShmSegmentInfo SHMInfo;
  int NeedRMID;
#endif
} Image;

void X11PutImage(Window Wnd,Image *Img,int DX,int DY,int SX,int SY,int W,int H);
int  X11NewImage(Image *Img,int W,int H,int Attrs);
void X11FreeImage(Image *Img);
/*************************************************************/

/*** Color Allocation ****************************************/
#define MAXALLOC  4096

unsigned int X11GetColor(unsigned char R,unsigned char G,unsigned char B);
    /* Allocate a new color. Returns 0 (black color) on      */
    /* failure.                                              */
void X11FlushColors(int N);
    /* Free all colors except for the N allocated last.      */
/*************************************************************/

/** Timers ***************************************************/
#define MAXTIMERFREQ 100 /* Maximal frequency for AddTimer() */

int TimerSignal(int Freq,void (*Handler)(int));
    /* Establishes a signal handler called with given        */
    /* frequency (Hz). Returns 0 if failed.                  */
int AddTimer(int Freq,void (*Handler)(void));
    /* Establishes a periodically called routine at a given  */
    /* frequency (1..MAXTIMERFREQ Hz). Returns 0 if failed.  */
void DelTimer(void (*Handler)(void));
    /* Removes timers established with AddTimer().           */
/*************************************************************/

#endif /* UNIX */
#endif /* LIBUNIX_H */
