// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"


void ARGB8888toRGB565(uchar *d, uchar *s) {
	d[1] = (s[2] & 0xF8) | (s[1] >> 5);
	d[0] = ((s[1] << 3) & 0xE0) | (s[0] >> 3);
}

void RGBA8888toARGB888(uchar *d, uchar *s) {
	d[3] = s[0];
	d[2] = s[3];
	d[1] = s[2];
	d[0] = s[1];
}

void ARGB8888toRGB888(uchar *d, uchar *s) {
	d[2] = s[2];
	d[1] = s[1];
	d[0] = s[0];
}

void ARGB8888toARGB8888(uchar *d, uchar *s) {
	d[3] = s[3];
	d[2] = s[2];
	d[1] = s[1];
	d[0] = s[0];
}

void ARGB8888toARGB1555(uchar *d, uchar *s) {
	d[1] = (s[3] & 0x10) | ((s[2] >> 1) & 0x7C) | (s[1] >> 6);
	d[0] = ((s[1] << 2) & 0xE0) | (s[0] >> 3);
}

void ARGB8888toARGB4444(uchar *d, uchar *s) {
	d[1] = (s[3] & 0xF0) | (s[2] >> 4);
	d[0] = (s[1] & 0xF0) | (s[0] >> 4);
}

void ARGB8888toRGB332(uchar *d, uchar *s) {
	d[0] = (s[2] & 0xE0) | ((s[1] >> 3) & 0x1C) | (s[0] >> 6);
}

void ARGB8888toARGB8332(uchar *d, uchar *s) {
	d[1] = s[3];
	d[0] = (s[2] & 0xE0) | ((s[1] >> 3) & 0x1C) | (s[0] >> 6);
}

void ARGB1555toRGB565(uchar *d, uchar *s) {
	d[1] = s[1] >> 1;
	d[0] = (s[1] << 7) | ((s[0] >> 1) & 0x60) | (s[0] & 0x1F);
}


void RGB555toRGB565(uchar *d, uchar *s) {
	d[1] = (s[1] << 1) | (s[0] >> 7);
	d[0] = ((s[0] << 1) & 0xC0) | (s[0] & 0x1F);
}

void RGB565toRGB565(uchar *d, uchar *s) {
	d[1] = s[1];
	d[0] = s[0];
}

void ARGB4444toARGB4444(uchar *d, uchar *s) {
	d[1] = s[1];
	d[0] = s[0];
}

void ARGB1555toARGB1555(uchar *d, uchar *s) {
	d[1] = s[1];
	d[0] = s[0];
}

void RGB565toRGB555(uchar *d, uchar *s) {
	d[1] = s[1] >> 1;
	d[0] = (s[1] << 7) | ((s[0] >> 1) & 0x60) | (s[0] & 0x1F);
}

void RGB565toARGB1555(uchar *d, uchar *s) {
	d[1] = s[1] >> 1;
	d[0] = (s[1] << 7) | ((s[0] >> 1) & 0x60) | (s[0] & 0x1F);
}

void AL44toARGB4444(uchar *d, uchar *s) {
	d[1] = (s[1] & 0xF0) | (s[0] & 0x0F);
	d[0] = ((s[0] & 0x0F) << 4) | (s[0] & 0x0F);
}

void AL88toARGB8888(uchar *d, uchar *s) {
	d[3] = s[1];
	d[2] = s[0];
	d[1] = s[0];
	d[0] = s[0];
}

void RGB332toRGB565(uchar *d, uchar *s) {
	d[1] = (s[0] & 0xE0) | ((s[0] >> 2) & 0x07);
	d[0] = ((s[0] << 3) & 0x18);
}

void YIQ422toRGB565(uchar *d, uchar *s) {
//	((short *)d)[0] = yiq_lut[s[0]];
	d[1] = 1;
	d[0] = 1;
}


void P8toRGB565(uchar *d, uchar *s) {
	d[1] = (Voodoo.palette[s[0]].peRed & 0xF8) | (Voodoo.palette[s[0]].peGreen >> 5);
	d[0] = (Voodoo.palette[s[0]].peGreen << 5) | (Voodoo.palette[s[0]].peBlue >> 3);
}

void P8toRGB888(uchar *d, uchar *s) {
	d[2] = Voodoo.palette[s[0]].peRed;
	d[1] = Voodoo.palette[s[0]].peGreen;
	d[0] = Voodoo.palette[s[0]].peBlue;
}

void AP88toARGB8888(uchar *d, uchar *s) {
	d[3] = s[1];
	d[2] = Voodoo.palette[s[0]].peRed;
	d[1] = Voodoo.palette[s[0]].peGreen;
	d[0] = Voodoo.palette[s[0]].peBlue;
}

void AP88toARGB4444(uchar *d, uchar *s) {
	d[1] = (s[1] & 0xF0) | (Voodoo.palette[s[0]].peRed >> 4);
	d[0] = (Voodoo.palette[s[0]].peGreen & 0xF0) | (Voodoo.palette[s[0]].peBlue >> 4);
}

void A8toARGB4444(uchar *d, uchar *s) {
	d[1] = s[0] & 0xF0;
	d[0] = 0;
}

void L8toRGB565(uchar *d, uchar *s) {
	d[1] = (s[0] & 0xF8) | (s[0] >> 5);
	d[0] = (s[0] << 5) | (s[0] >> 3);
}

void AL88toARGB4444(uchar *d, uchar *s) {
	d[1] = (s[1] & 0xF0) | (s[0] >> 4);
	d[0] = (s[0] << 4) | (s[0] >> 4);
}

void ARGB8332toARGB4444(uchar *d, uchar *s) {
	d[1] = (s[1] & 0xF0) | ((s[0] & 0xE0) >> 4);
	d[0] = ((s[0] & 0x1C) << 3) | ((s[0] & 0x03) << 2);
}


void RGB565_4to1(void *d, void *s0, void *s1, void *s2, void *s3) {
	uint16 _d, _s0, _s1, _s2, _s3;

	_s0 = *(uint16 *)s0;
	_s1 = *(uint16 *)s1;
	_s2 = *(uint16 *)s2;
	_s3 = *(uint16 *)s3;

	_d = (((_s0 & 0xF800) + (_s1 & 0xF800) + (_s2 & 0xF800) + (_s3 & 0xF800)) >> 2) & 0xF800;
	_d |= (((_s0 & 0x07E0) + (_s1 & 0x07E0) + (_s2 & 0x07E0) + (_s3 & 0x07E0)) >> 2) & 0x07E0;
	_d |= (((_s0 & 0x001F) + (_s1 & 0x001F) + (_s2 & 0x001F) + (_s3 & 0x001F)) >> 2);

	*(uint16 *)d = _d;
}

void ARGB4444_4to1(void *d, void *s0, void *s1, void *s2, void *s3) {
	uint16 _d, _s0, _s1, _s2, _s3;

	_s0 = *(uint16 *)s0;
	_s1 = *(uint16 *)s1;
	_s2 = *(uint16 *)s2;
	_s3 = *(uint16 *)s3;

	_d  = (((_s0 & 0xF000) + (_s1 & 0xF000) + (_s2 & 0xF000) + (_s3 & 0xF000)) >> 2) & 0xF000;
	_d |= (((_s0 & 0x0F00) + (_s1 & 0x0F00) + (_s2 & 0x0F00) + (_s3 & 0x0F00)) >> 2) & 0x0F00;
	_d |= (((_s0 & 0x00F0) + (_s1 & 0x00F0) + (_s2 & 0x00F0) + (_s3 & 0x00F0)) >> 2) & 0x00F0;
	_d |= (((_s0 & 0x000F) + (_s1 & 0x000F) + (_s2 & 0x000F) + (_s3 & 0x000F)) >> 2);

	*(uint16 *)d = _d;
}

void ARGB1555_4to1(void *d, void *s0, void *s1, void *s2, void *s3) {
	uint16 _d, _s0, _s1, _s2, _s3;

	_s0 = *(uint16 *)s0;
	_s1 = *(uint16 *)s1;
	_s2 = *(uint16 *)s2;
	_s3 = *(uint16 *)s3;

	_d  = (((_s0 & 0x8000) + (_s1 & 0x8000) + (_s2 & 0x8000) + (_s3 & 0x8000)) >> 2) & 0x8000;
	_d |= (((_s0 & 0x7C00) + (_s1 & 0x7C00) + (_s2 & 0x7C00) + (_s3 & 0x7C00)) >> 2) & 0x7C00;
	_d |= (((_s0 & 0x03E0) + (_s1 & 0x03E0) + (_s2 & 0x03E0) + (_s3 & 0x03E0)) >> 2) & 0x03E0;
	_d |= (((_s0 & 0x001F) + (_s1 & 0x001F) + (_s2 & 0x001F) + (_s3 & 0x001F)) >> 2);

	*(uint16 *)d = _d;
}