// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"


void inittexturetables();


// Go through the 4 given D3D modes, trying each in sequence 
// until one that fits the capabilities is found.
#define fill_lut(table, caps, caps_lut, glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4) \
	if (caps & caps_lut[d3dmode1]) { \
		table[glidemode] = d3dmode1; \
	} else if (caps & caps_lut[d3dmode2]) { \
		log("Mode " #d3dmode1 " not supported in " #table "--reverting to mode " #d3dmode2); \
		table[glidemode] = d3dmode2; \
	} else if (caps & caps_lut[d3dmode3]) { \
		log("Mode " #d3dmode1 " not supported in " #table "--reverting to mode " #d3dmode3); \
		table[glidemode] = d3dmode3; \
	} else if (caps & caps_lut[d3dmode4]) { \
		log("Mode " #d3dmode1 " not supported in " #table "--reverting to mode " #d3dmode4); \
		table[glidemode] = d3dmode4; \
	} else { \
		log("No alternative blend modes found for mode " #d3dmode1 " in " #table ".  Please contact the author."); \
		table[glidemode] = 0; \
	}


// The next 3 #define's call fill_lut() with appropriate parameters

#define fill_src_blend_lut(glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4) \
	fill_lut(src_blend_lut, DX.D3DHD.dpcTriCaps.dwSrcBlendCaps, blend_caps_lut, glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4)

#define fill_dst_blend_lut(glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4) \
	fill_lut(dst_blend_lut, DX.D3DHD.dpcTriCaps.dwDestBlendCaps, blend_caps_lut, glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4)

#define fill_atest_lut(glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4) \
	fill_lut(atest_lut, DX.D3DHD.dpcTriCaps.dwAlphaCmpCaps, atest_caps_lut, glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4)



XGLLINK void XGLCALL grGlideInit() {
	log("Called grGlideInit");

	loadsettings();

	Voodoo.tmumem = Settings.tmumem;


	Voodoo.colorkeyon = 0;
	Voodoo.palhash = -1;

	_texlist = new TexList();
	_exebuffer = new ExeBuffer();

}

XGLLINK void XGLCALL grGlideGetVersion(char *ver) {
	log("Called grGlideGetVersion");

//	strcpy(ver, "Scott Cutler's Glide to Direct3D Wrapper v" XGLVER);
	strcpy(ver, "2.60.00.0408");
}



XGLLINK void XGLCALL grGlideShutdown() {
	log("Called grGlideShutdown");

	grSstWinClose();
}


XGLLINK void XGLCALL grGlideGetState(void *state) {
	vlog("Called grGlideGetState");

}

XGLLINK void XGLCALL grGlideSetState(void *state) {
	vlog("Called grGlideSetState");

}



void table_init() {

	cc_lut_init();



	// Init texture scaling vars for different aspect ratios
	smul = new float[XGLASPECT_MAX];
	tmul = new float[XGLASPECT_MAX];

	smul[XGLASPECT_8x1] = 1.0f / 256.0f;
	smul[XGLASPECT_4x1] = 1.0f / 256.0f;
	smul[XGLASPECT_2x1] = 1.0f / 256.0f;
	smul[XGLASPECT_1x1] = 1.0f / 256.0f;
	smul[XGLASPECT_1x2] = 1.0f / 128.0f;
	smul[XGLASPECT_1x4] = 1.0f / 64.0f;
	smul[XGLASPECT_1x8] = 1.0f / 32.0f;
	tmul[XGLASPECT_8x1] = 1.0f / 32.0f;
	tmul[XGLASPECT_4x1] = 1.0f / 64.0f;
	tmul[XGLASPECT_2x1] = 1.0f / 128.0f;
	tmul[XGLASPECT_1x1] = 1.0f / 256.0f;
	tmul[XGLASPECT_1x2] = 1.0f / 256.0f;
	tmul[XGLASPECT_1x4] = 1.0f / 256.0f;
	tmul[XGLASPECT_1x8] = 1.0f / 256.0f;



	src_blend_lut = new uint32[16];
	blend_caps_lut = new uint32[16];
	dst_blend_lut = new uint32[16];


	blend_caps_lut[0] =							0;
	blend_caps_lut[D3DBLEND_ZERO] =				D3DPBLENDCAPS_ZERO;
	blend_caps_lut[D3DBLEND_ONE] =				D3DPBLENDCAPS_ONE;
	blend_caps_lut[D3DBLEND_SRCCOLOR] =			D3DPBLENDCAPS_SRCCOLOR;
	blend_caps_lut[D3DBLEND_INVSRCCOLOR] =		D3DPBLENDCAPS_INVSRCCOLOR;
	blend_caps_lut[D3DBLEND_SRCALPHA] =			D3DPBLENDCAPS_SRCALPHA;
	blend_caps_lut[D3DBLEND_INVSRCALPHA] =		D3DPBLENDCAPS_INVSRCALPHA;
	blend_caps_lut[D3DBLEND_DESTALPHA] =		D3DPBLENDCAPS_DESTALPHA;
	blend_caps_lut[D3DBLEND_INVDESTALPHA] =		D3DPBLENDCAPS_INVDESTALPHA;
	blend_caps_lut[D3DBLEND_DESTCOLOR] =		D3DPBLENDCAPS_DESTCOLOR;
	blend_caps_lut[D3DBLEND_INVDESTCOLOR] =		D3DPBLENDCAPS_INVDESTCOLOR;
	blend_caps_lut[D3DBLEND_SRCALPHASAT] =		D3DPBLENDCAPS_SRCALPHASAT;
	blend_caps_lut[D3DBLEND_BOTHSRCALPHA] =		D3DPBLENDCAPS_BOTHSRCALPHA;
	blend_caps_lut[D3DBLEND_BOTHINVSRCALPHA] =	D3DPBLENDCAPS_BOTHINVSRCALPHA;

	

	fill_src_blend_lut(XGLBLEND_ZERO,			D3DBLEND_ZERO,			0,						0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_ONE,			D3DBLEND_ONE,			0,						0, D3DBLEND_ONE);
//	fill_src_blend_lut(XGLBLEND_SRCCOLOR,		D3DBLEND_SRCCOLOR,		D3DBLEND_DESTCOLOR,		0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_SRCCOLOR,		D3DBLEND_DESTCOLOR,		0,						0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_INVSRCCOLOR,	D3DBLEND_INVSRCCOLOR,	D3DBLEND_INVDESTCOLOR,	0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_SRCALPHA,		D3DBLEND_SRCALPHA,		0,						0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_INVSRCALPHA,	D3DBLEND_INVSRCALPHA,	0,						0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_DESTALPHA,		D3DBLEND_DESTALPHA,		D3DBLEND_SRCALPHA,		0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_INVDESTALPHA,	D3DBLEND_INVDESTALPHA,	D3DBLEND_INVSRCALPHA,	0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_SRCALPHASAT,	D3DBLEND_SRCALPHASAT,	D3DBLEND_SRCALPHA,		0, D3DBLEND_ONE);


	fill_dst_blend_lut(XGLBLEND_ZERO,			D3DBLEND_ZERO,			0,						0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_ONE,			D3DBLEND_ONE,			0,						0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_DESTCOLOR,		D3DBLEND_DESTCOLOR,		D3DBLEND_SRCCOLOR,		0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_INVDESTCOLOR,	D3DBLEND_INVDESTCOLOR,	D3DBLEND_INVSRCCOLOR,	0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_SRCALPHA,		D3DBLEND_SRCALPHA,		0,						0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_INVSRCALPHA,	D3DBLEND_INVSRCALPHA,	0,						0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_DESTALPHA,		D3DBLEND_DESTALPHA,		D3DBLEND_SRCALPHA,		0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_INVDESTALPHA,	D3DBLEND_INVDESTALPHA,	D3DBLEND_INVSRCALPHA,	0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_SRCALPHASAT,	D3DBLEND_SRCALPHASAT,	D3DBLEND_SRCALPHA,		0, XGLBLEND_ZERO);


//	fill_dst_blend_lut(XGLBLEND_INVSRCALPHA,	XGLBLEND_ZERO,	0,						0, XGLBLEND_ZERO);




	atest_caps_lut = new uint32[8];

	atest_caps_lut[0]						= 0;
	atest_caps_lut[D3DCMP_NEVER]			= D3DPCMPCAPS_NEVER;
	atest_caps_lut[D3DCMP_LESS]				= D3DPCMPCAPS_LESS;
	atest_caps_lut[D3DCMP_EQUAL]			= D3DPCMPCAPS_EQUAL;
	atest_caps_lut[D3DCMP_LESSEQUAL]		= D3DPCMPCAPS_LESSEQUAL;
	atest_caps_lut[D3DCMP_GREATER]			= D3DPCMPCAPS_GREATER;
	atest_caps_lut[D3DCMP_NOTEQUAL]			= D3DPCMPCAPS_NOTEQUAL;
	atest_caps_lut[D3DCMP_GREATEREQUAL]		= D3DPCMPCAPS_GREATEREQUAL;
	atest_caps_lut[D3DCMP_ALWAYS]			= D3DPCMPCAPS_ALWAYS;

	atest_lut = new uint32[8];

	fill_atest_lut(XGLCMP_NEVER,		D3DCMP_NEVER,			0,					0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_LESS,			D3DCMP_LESS,			0,					0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_EQUAL,		D3DCMP_EQUAL,			0,					0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_LESSEQUAL,	D3DCMP_LESSEQUAL,		D3DCMP_LESS,		0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_GREATER,		D3DCMP_GREATER,			0,					0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_NOTEQUAL,		D3DCMP_NOTEQUAL,		0,					0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_GREATEREQUAL,	D3DCMP_GREATEREQUAL,	D3DCMP_GREATER,		0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_ALWAYS,		D3DCMP_ALWAYS,			0,					0, D3DCMP_ALWAYS);






	vconv_lut[DEPTH_D][XGLORIGIN_UL][TEXTURE]			= vconv_D_UL_T;
	vconv_lut[DEPTH_W][XGLORIGIN_UL][TEXTURE]			= vconv_W_UL_T;
	vconv_lut[DEPTH_W_Z16][XGLORIGIN_UL][TEXTURE]		= vconv_W_Z16_UL_T;
	vconv_lut[DEPTH_W_Z24][XGLORIGIN_UL][TEXTURE]		= vconv_W_Z24_UL_T;
	vconv_lut[DEPTH_W_Z32][XGLORIGIN_UL][TEXTURE]		= vconv_W_Z32_UL_T;
	vconv_lut[DEPTH_Z][XGLORIGIN_UL][TEXTURE]			= vconv_Z_UL_T;

	vconv_lut[DEPTH_D][XGLORIGIN_LL][TEXTURE]			= vconv_D_LL_T;
	vconv_lut[DEPTH_W][XGLORIGIN_LL][TEXTURE]			= vconv_W_LL_T;	
	vconv_lut[DEPTH_W_Z16][XGLORIGIN_LL][TEXTURE]		= vconv_W_Z16_LL_T;	
	vconv_lut[DEPTH_W_Z24][XGLORIGIN_LL][TEXTURE]		= vconv_W_Z24_LL_T;	
	vconv_lut[DEPTH_W_Z32][XGLORIGIN_LL][TEXTURE]		= vconv_W_Z32_LL_T;	
	vconv_lut[DEPTH_Z][XGLORIGIN_LL][TEXTURE]			= vconv_Z_LL_T;	
	
	vconv_lut[DEPTH_D][XGLORIGIN_UL][NO_TEXTURE]		= vconv_D_UL_NT;
	vconv_lut[DEPTH_W][XGLORIGIN_UL][NO_TEXTURE]		= vconv_W_UL_NT;
	vconv_lut[DEPTH_W_Z16][XGLORIGIN_UL][NO_TEXTURE]	= vconv_W_Z16_UL_NT;
	vconv_lut[DEPTH_W_Z24][XGLORIGIN_UL][NO_TEXTURE]	= vconv_W_Z24_UL_NT;
	vconv_lut[DEPTH_W_Z32][XGLORIGIN_UL][NO_TEXTURE]	= vconv_W_Z32_UL_NT;
	vconv_lut[DEPTH_Z][XGLORIGIN_UL][NO_TEXTURE]		= vconv_Z_UL_NT;

	vconv_lut[DEPTH_D][XGLORIGIN_LL][NO_TEXTURE]		= vconv_D_LL_NT;
	vconv_lut[DEPTH_W][XGLORIGIN_LL][NO_TEXTURE]		= vconv_W_LL_NT;
	vconv_lut[DEPTH_W_Z16][XGLORIGIN_LL][NO_TEXTURE]	= vconv_W_Z16_LL_NT;
	vconv_lut[DEPTH_W_Z24][XGLORIGIN_LL][NO_TEXTURE]	= vconv_W_Z24_LL_NT;
	vconv_lut[DEPTH_W_Z32][XGLORIGIN_LL][NO_TEXTURE]	= vconv_W_Z32_LL_NT;
	vconv_lut[DEPTH_Z][XGLORIGIN_LL][NO_TEXTURE]		= vconv_Z_LL_NT;


	int yab;
	float r, g, b, y1, a1, b1;
	for (yab=0; yab<256; yab++) {
		y1 = ((yab >> 4) & 0xF) / 15.0f;
		a1 = ((yab >> 2) & 0x3) / 3.0f;
		b1 = (yab & 0x3) / 3.0f;

		r = y1 + 0.95f*a1 + 0.62f*b1;
		g = y1 - 0.28f*a1 + 0.64f*b1;
		b = y1 - 1.11f*a1 + 1.73f*b1;

		if (r > 1.0f) r = 1.0f;
		if (g > 1.0f) g = 1.0f;
		if (b > 1.0f) b = 1.0f;
		if (r < 0.0f) r = 0.0f;
		if (g < 0.0f) g = 0.0f;
		if (b < 0.0f) b = 0.0f;

		yiq_lut[yab] = (int(r * 31) << 11) | (int(g * 63) << 5) | (int(b * 31));
	}

	inittexturetables();
}





int operator==(DDPIXELFORMAT &pf1, DDPIXELFORMAT &pf2) {
//	return !memcmp(&pf1, &pf2, sizeof(DDPIXELFORMAT));
	/*
	log("pf1.dwFlags=" << pf1.dwFlags << "  pf2.dwFlags=" << pf2.dwFlags);
	log("pf1.dwRGBBitCount=" << pf1.dwRGBBitCount << "  pf2.dwRGBBitCount=" << pf2.dwRGBBitCount);
	log("pf1.dwRBitMask=" << pf1.dwRBitMask << "  pf2.dwRBitMask=" << pf2.dwRBitMask);
	log("pf1.dwGBitMask=" << pf1.dwGBitMask << "  pf2.dwGBitMask=" << pf2.dwGBitMask);
	log("pf1.dwBBitMask=" << pf1.dwBBitMask << "  pf2.dwBBitMask=" << pf2.dwBBitMask);
	log("pf1.dwRGBAlphaBitMask=" << pf1.dwRGBAlphaBitMask << "  pf2.dwRGBAlphaBitMask=" << pf2.dwRGBAlphaBitMask);
	*/
	return ((pf1.dwFlags == pf2.dwFlags) &&
			(pf1.dwRGBBitCount == pf2.dwRGBBitCount) &&
			(pf1.dwRBitMask == pf2.dwRBitMask) &&
			(pf1.dwGBitMask == pf2.dwGBitMask) &&
			(pf1.dwBBitMask == pf2.dwBBitMask) &&
			(pf1.dwRGBAlphaBitMask == pf2.dwRGBAlphaBitMask));
}



HRESULT CALLBACK enumTextures(LPDDPIXELFORMAT format, LPVOID) {
	int i;

	for (i=0; i<XGLTEX_MAX; i++) {

		if (*format == ddpixelformats[i]) {
			// Set a bit in the supported argument corresponding 
			// to the appropriate texture format
			xglpixelformats[i].pf = ddpixelformats[i];
			xglpixelformats[i].sbpp = ddpixelformats[i].dwRGBBitCount / 8;
			xglpixelformats[i].bpp = ddpixelformats[i].dwRGBBitCount / 8;
			xglpixelformats[i].supported = 1;
			xglpixelformats[i].set = 1;
			xglpixelformats[i].ckcc = ckccfuncs[i];
			if (xglpixelformats[i].pf.dwFlags & (DDPF_PALETTEINDEXED1|DDPF_PALETTEINDEXED2|DDPF_PALETTEINDEXED4|DDPF_PALETTEINDEXED8|DDPF_PALETTEINDEXEDTO8)) {
				xglpixelformats[i].paletted = 1;
			}
			return 1;
		}
	}
	return 1;
}


#define SetAltPixelFormat(format, altformat, texccfunc, ckccfunc, paletteemu) \
	if (!xglpixelformats[format].set) { \
		if (xglpixelformats[altformat].supported) { \
			xglpixelformats[format].pf = xglpixelformats[altformat].pf; \
			xglpixelformats[format].sbpp = ddpixelformats[format].dwRGBBitCount / 8; \
			xglpixelformats[format].bpp = xglpixelformats[altformat].bpp; \
			xglpixelformats[format].set = 1; \
			xglpixelformats[format].texcc = texccfunc; \
			xglpixelformats[format].ckcc = ckccfunc; \
			if (ddpixelformats[format].dwFlags & (DDPF_PALETTEINDEXED1|DDPF_PALETTEINDEXED2|DDPF_PALETTEINDEXED4|DDPF_PALETTEINDEXED8|DDPF_PALETTEINDEXEDTO8)) { \
				xglpixelformats[format].paletted = 1; \
			} \
			xglpixelformats[format].palemu = paletteemu; \
		} \
	}

#define NO_PALETTE_EMU 0
#define PALETTE_EMU 1


void inittexturetables() {
	int i;

	ddpixelformats = new DDPIXELFORMAT[XGLTEX_MAX];
	xglpixelformats = new XGLPixelFormat[XGLTEX_MAX];



	memset(ddpixelformats, 0, XGLTEX_MAX*sizeof(DDPIXELFORMAT));

	ddpixelformats[XGLTEX_RGB332].dwFlags = DDPF_RGB;
	ddpixelformats[XGLTEX_RGB332].dwRGBBitCount = 8;
	ddpixelformats[XGLTEX_RGB332].dwRBitMask = 0xE0;
	ddpixelformats[XGLTEX_RGB332].dwGBitMask = 0x1C;
	ddpixelformats[XGLTEX_RGB332].dwBBitMask = 0x03;

	ddpixelformats[XGLTEX_A8].dwFlags = DDPF_ALPHA;
	ddpixelformats[XGLTEX_A8].dwAlphaBitDepth = 8;

	ddpixelformats[XGLTEX_L8].dwFlags = DDPF_LUMINANCE;
	ddpixelformats[XGLTEX_L8].dwLuminanceBitCount = 8;
	ddpixelformats[XGLTEX_L8].dwLuminanceBitMask = 0xFF;

	ddpixelformats[XGLTEX_AL44].dwFlags = DDPF_LUMINANCE | DDPF_ALPHAPIXELS;
	ddpixelformats[XGLTEX_AL44].dwLuminanceBitCount = 8;
	ddpixelformats[XGLTEX_AL44].dwLuminanceBitMask = 0x0F;
	ddpixelformats[XGLTEX_AL44].dwLuminanceAlphaBitMask = 0xF0;

	ddpixelformats[XGLTEX_P8].dwFlags = DDPF_RGB | DDPF_PALETTEINDEXED8;
	ddpixelformats[XGLTEX_P8].dwRGBBitCount = 8;

	ddpixelformats[XGLTEX_ARGB8332].dwFlags = DDPF_RGB | DDPF_ALPHAPIXELS;
	ddpixelformats[XGLTEX_ARGB8332].dwRGBBitCount = 16;
	ddpixelformats[XGLTEX_ARGB8332].dwRBitMask = 0x00E0;
	ddpixelformats[XGLTEX_ARGB8332].dwGBitMask = 0x001C;
	ddpixelformats[XGLTEX_ARGB8332].dwBBitMask = 0x0003;
	ddpixelformats[XGLTEX_ARGB8332].dwRGBAlphaBitMask = 0xFF00;

	ddpixelformats[XGLTEX_RGB565].dwFlags = DDPF_RGB;
	ddpixelformats[XGLTEX_RGB565].dwRGBBitCount = 16;
	ddpixelformats[XGLTEX_RGB565].dwRBitMask = 0xF800;
	ddpixelformats[XGLTEX_RGB565].dwGBitMask = 0x07E0;
	ddpixelformats[XGLTEX_RGB565].dwBBitMask = 0x001F;

	ddpixelformats[XGLTEX_ARGB1555].dwFlags = DDPF_RGB | DDPF_ALPHAPIXELS;
	ddpixelformats[XGLTEX_ARGB1555].dwRGBBitCount = 16;
	ddpixelformats[XGLTEX_ARGB1555].dwRBitMask = 0x7C00;
	ddpixelformats[XGLTEX_ARGB1555].dwGBitMask = 0x03E0;
	ddpixelformats[XGLTEX_ARGB1555].dwBBitMask = 0x001F;
	ddpixelformats[XGLTEX_ARGB1555].dwRGBAlphaBitMask = 0x8000;

	ddpixelformats[XGLTEX_ARGB4444].dwFlags = DDPF_RGB | DDPF_ALPHAPIXELS;
	ddpixelformats[XGLTEX_ARGB4444].dwRGBBitCount = 16;
	ddpixelformats[XGLTEX_ARGB4444].dwRGBAlphaBitMask = 0xF000;
	ddpixelformats[XGLTEX_ARGB4444].dwRBitMask = 0x0F00;
	ddpixelformats[XGLTEX_ARGB4444].dwGBitMask = 0x00F0;
	ddpixelformats[XGLTEX_ARGB4444].dwBBitMask = 0x000F;

	ddpixelformats[XGLTEX_AL88].dwFlags = DDPF_LUMINANCE | DDPF_ALPHAPIXELS;
	ddpixelformats[XGLTEX_AL88].dwLuminanceBitCount = 16;
	ddpixelformats[XGLTEX_AL88].dwLuminanceBitMask = 0x00FF;
	ddpixelformats[XGLTEX_AL88].dwLuminanceAlphaBitMask = 0xFF00;

	ddpixelformats[XGLTEX_ARGB8888].dwFlags = DDPF_RGB | DDPF_ALPHAPIXELS;
	ddpixelformats[XGLTEX_ARGB8888].dwRGBBitCount = 32;
	ddpixelformats[XGLTEX_ARGB8888].dwRGBAlphaBitMask = 0xFF000000;
	ddpixelformats[XGLTEX_ARGB8888].dwRBitMask = 0x00FF0000;
	ddpixelformats[XGLTEX_ARGB8888].dwGBitMask = 0x0000FF00;
	ddpixelformats[XGLTEX_ARGB8888].dwBBitMask = 0x000000FF;

	ddpixelformats[XGLTEX_P4].dwFlags = DDPF_RGB | DDPF_PALETTEINDEXED4;
	ddpixelformats[XGLTEX_P4].dwRGBBitCount = 4;

	ddpixelformats[XGLTEX_RGB888].dwFlags = DDPF_RGB;
	ddpixelformats[XGLTEX_RGB888].dwRGBBitCount = 32;
	ddpixelformats[XGLTEX_RGB888].dwRBitMask = 0x00FF0000;
	ddpixelformats[XGLTEX_RGB888].dwGBitMask = 0x0000FF00;
	ddpixelformats[XGLTEX_RGB888].dwBBitMask = 0x000000FF;

	ddpixelformats[XGLTEX_RGB555].dwFlags = DDPF_RGB;
	ddpixelformats[XGLTEX_RGB555].dwRGBBitCount = 16;
	ddpixelformats[XGLTEX_RGB555].dwRBitMask = 0x7C00;
	ddpixelformats[XGLTEX_RGB555].dwGBitMask = 0x03E0;
	ddpixelformats[XGLTEX_RGB555].dwBBitMask = 0x001F;

	DX.D3DD->EnumTextureFormats(enumTextures, 0);



	SetAltPixelFormat(XGLTEX_RGB332,	XGLTEX_RGB565,		RGB332toRGB565,		ARGB8888toRGB565,	NO_PALETTE_EMU);
	SetAltPixelFormat(XGLTEX_A8,		XGLTEX_ARGB4444,	A8toARGB4444,		ARGB8888toARGB4444,	NO_PALETTE_EMU);
	SetAltPixelFormat(XGLTEX_L8,		XGLTEX_RGB565,		L8toRGB565,			ARGB8888toRGB565,	NO_PALETTE_EMU);
	SetAltPixelFormat(XGLTEX_AL88,		XGLTEX_ARGB4444,	AL88toARGB4444,		ARGB8888toARGB4444,	NO_PALETTE_EMU);
	SetAltPixelFormat(XGLTEX_AL44,		XGLTEX_ARGB4444,	AL44toARGB4444,		ARGB8888toARGB4444,	NO_PALETTE_EMU);
	SetAltPixelFormat(XGLTEX_ARGB8332,	XGLTEX_ARGB4444,	ARGB8332toARGB4444,	ARGB8888toARGB4444,	NO_PALETTE_EMU);
	SetAltPixelFormat(XGLTEX_RGB555,	XGLTEX_RGB565,		RGB555toRGB565,		ARGB8888toRGB565,	NO_PALETTE_EMU);

	// Try 32-bit textures, revert to 16 if necessary,
	SetAltPixelFormat(XGLTEX_P8,		XGLTEX_RGB888,		P8toRGB888,			ARGB8888toRGB888,	PALETTE_EMU);
	SetAltPixelFormat(XGLTEX_P8,		XGLTEX_RGB565,		P8toRGB565,			ARGB8888toRGB565,	PALETTE_EMU);

	// Same thing here
	SetAltPixelFormat(XGLTEX_AP88,		XGLTEX_ARGB8888,	AP88toARGB8888,		ARGB8888toARGB8888,	PALETTE_EMU);
	SetAltPixelFormat(XGLTEX_AP88,		XGLTEX_ARGB4444,	AP88toARGB4444,		ARGB8888toARGB4444,	PALETTE_EMU);


	for (i=0; i<XGLTEX_MAX; i++) {
		if (xglpixelformats[i].supported) {
			log("Hardware supports " << formatstostrings[i] << " texture format");
		}
	}
	
	for (i=0; i<XGLTEX_MAX; i++) {
		if (xglpixelformats[i].set && !xglpixelformats[i].supported) {
			if (formatstostrings[i][0]) log("Emulating pixel format " << formatstostrings[i] << "");
		}
	}

	for (i=0; i<XGLTEX_MAX; i++) {
		if (!xglpixelformats[i].set) {
			if (formatstostrings[i][0]) log("Unsupported pixel format " << formatstostrings[i] << ",  please contact the author");
		}
	}

}

