/*
 * Genital68K: Motorola 680X0 emulator
 * Copyright 2000, 2001 Bart Trzynadlowski, see "README.TXT" for terms of use
 */

#ifndef _GEN68K_H_
#define _GEN68K_H_

#ifdef __cplusplus
extern "C" {
#endif


/*****************************************************************************
* Generic Macros                                                            */

#define GENITAL68K_OKAY             0       /* no error */
#define GENITAL68K_NULL             0       /* null */
#define GENITAL68K_SUPERVISOR       0       /* affects supervisor space */
#define GENITAL68K_USER             1       /* function affects user space */
#define GENITAL68K_UNINITIALIZED    15      /* uninitialized interrupt */
#define GENITAL68K_SPURIOUS         24      /* spurious interrupt */
#define GENITAL68K_AUTOVECTOR       256     /* autovectored interrupt */


/*****************************************************************************
* Error Codes                                                               */

#define GENITAL68K_ERROR_FETCH      1       /* fetch error (PC bounds) */
#define GENITAL68K_ERROR_INVINST    2       /* invalid instruction */
#define GENITAL68K_ERROR_INTLEVEL   3       /* invalid interrupt level */
#define GENITAL68K_ERROR_INTVECTOR  4       /* invalid interrupt vector */
#define GENITAL68K_ERROR_INTPENDING 5       /* level already pending */
#define GENITAL68K_ERROR_STACKFRAME 6       /* unhandled stack frame */


/*****************************************************************************
* Data Types                                                                */

typedef unsigned GENITAL68K_UINT32;         /* unsigned 32-bit */
typedef int GENITAL68K_INT32;               /* signed 32-bit */
typedef unsigned short GENITAL68K_UINT16;   /* unsigned 16-bit */
typedef short GENITAL68K_INT16;             /* signed 16-bit */
typedef unsigned char GENITAL68K_UINT8;     /* unsigned 8-bit */
typedef char GENITAL68K_INT8;               /* signed 8-bit */


/*****************************************************************************
* Data Structures                                                           */

struct GENITAL68K_FETCHREGION
{
    GENITAL68K_UINT32   base;
    GENITAL68K_UINT32   limit;
    GENITAL68K_UINT32   ptr;
};

struct GENITAL68K_DATAREGION
{
    GENITAL68K_UINT32   base;
    GENITAL68K_UINT32   limit;
    GENITAL68K_UINT32   ptr;
    void                *handler;
};

struct GENITAL68K_CONTEXT_68000
{
    void                *fetch, *pcfetch;
    void                *read_byte, *read_word, *read_long;
    void                *write_byte, *write_word, *write_long;
    void                *super_fetch, *super_pcfetch;
    void                *super_read_byte, *super_read_word,
                        *super_read_long;
    void                *super_write_byte, *super_write_word,
                        *super_write_long;
    void                *user_fetch, *user_pcfetch;
    void                *user_read_byte, *user_read_word,
                        *user_read_long;
    void                *user_write_byte, *user_write_word,
                        *user_write_long;
    GENITAL68K_UINT32   intr[8], cycles, remaining;
    GENITAL68K_UINT32   d[8], a[8], sp, sr, pc, status;
    void                *Reset;
};

struct GENITAL68K_CONTEXT_68010
{
    void                *fetch, *pcfetch;
    void                *read_byte, *read_word, *read_long;
    void                *write_byte, *write_word, *write_long;
    void                *super_fetch, *super_pcfetch;
    void                *super_read_byte, *super_read_word,
                        *super_read_long;
    void                *super_write_byte, *super_write_word,
                        *super_write_long;
    void                *user_fetch, *user_pcfetch;
    void                *user_read_byte, *user_read_word,
                        *user_read_long;
    void                *user_write_byte, *user_write_word,
                        *user_write_long;
    GENITAL68K_UINT32   intr[8], cycles, remaining;
    GENITAL68K_UINT32   d[8], a[8], sp, sr, pc, fc, vbr, status;
    void                *Reset, *Bkpt;
};


/*****************************************************************************
* Functions and External Data                                               */

#define GENITAL68K_ID(ID)                                                    \
                                                                             \
extern struct GENITAL68K_CONTEXT_68000  ID##genital68kcontext_68000;         \
extern struct GENITAL68K_CONTEXT_68010  ID##genital68kcontext_68010;         \
                                                                             \
GENITAL68K_INT32    ID##Genital68KInit();                                    \
GENITAL68K_INT32    ID##Genital68KReset();                                   \
GENITAL68K_INT32    ID##Genital68KRun(GENITAL68K_INT32);                     \
GENITAL68K_INT32    ID##Genital68KProcessInterrupts();                       \
GENITAL68K_INT32    ID##Genital68KInterrupt(GENITAL68K_INT32,                \
                                            GENITAL68K_UINT32);              \
GENITAL68K_INT32    ID##Genital68KCancelInterrupt(GENITAL68K_INT32);         \
                                                                             \
GENITAL68K_UINT32   ID##Genital68KReadPC();                                  \
                                                                             \
void                ID##Genital68KSetFetch(void *, GENITAL68K_INT32);        \
void                ID##Genital68KSetPCFetch(void *, GENITAL68K_INT32);      \
void                ID##Genital68KSetReadByte(void *, GENITAL68K_INT32);     \
void                ID##Genital68KSetReadWord(void *, GENITAL68K_INT32);     \
void                ID##Genital68KSetReadLong(void *, GENITAL68K_INT32);     \
void                ID##Genital68KSetWriteByte(void *, GENITAL68K_INT32);    \
void                ID##Genital68KSetWriteWord(void *, GENITAL68K_INT32);    \
void                ID##Genital68KSetWriteLong(void *, GENITAL68K_INT32);    \
void                *ID##Genital68KGetFetch(GENITAL68K_INT32);               \
void                *ID##Genital68KGetPCFetch(GENITAL68K_INT32);             \
void                *ID##Genital68KGetReadByte(GENITAL68K_INT32);            \
void                *ID##Genital68KGetReadWord(GENITAL68K_INT32);            \
void                *ID##Genital68KGetReadLong(GENITAL68K_INT32);            \
void                *ID##Genital68KGetWriteByte(GENITAL68K_INT32);           \
void                *ID##Genital68KGetWriteWord(GENITAL68K_INT32);           \
void                *ID##Genital68KGetWriteLong(GENITAL68K_INT32);           \
                                                                             \
GENITAL68K_UINT8    *ID##Genital68KFetchPtr(GENITAL68K_UINT32);              \
GENITAL68K_UINT8    ID##Genital68KReadByte(GENITAL68K_UINT32);               \
GENITAL68K_UINT16   ID##Genital68KReadWord(GENITAL68K_UINT32);               \
GENITAL68K_UINT32   ID##Genital68KReadLong(GENITAL68K_UINT32);               \
void                ID##Genital68KWriteByte(GENITAL68K_UINT32,               \
                                            GENITAL68K_UINT8);               \
void                ID##Genital68KWriteWord(GENITAL68K_UINT32,               \
                                            GENITAL68K_UINT16);              \
void                ID##Genital68KWriteLong(GENITAL68K_UINT32,               \
                                            GENITAL68K_UINT32);              \
                                                                             \
void                ID##Genital68KSetContext(void *);                        \
void                ID##Genital68KGetContext(void *);                        \
GENITAL68K_UINT32   ID##Genital68KGetContextSize();                          \
                                                                             \
void                ID##Genital68KClearCycles();                             \
void                ID##Genital68KFreeTimeSlice();                           \
GENITAL68K_INT32    ID##Genital68KGetElapsedCycles();                        \

GENITAL68K_ID( );   /* default identifiers begin with nothing */


#ifdef __cplusplus
}
#endif

#endif  /* _GEN68K_H_ */
