@echo off
rem 14-05-2003 JvW Updated with CONFIRM popup at interactive run  (5.20)
rem 14-04-2003 JvW Updated with write-protection check            (5.18)
rem 03-04-2004 JvW Updated for rename DFSUNFD to DFSDISK scripts  (6.05)
echo.

if "%0"=="STARTEST"     echo on
if "%0"=="startest"     echo on

if "%OS2_SHELL%"=="" goto notos2
set dfsexe=dfsos2.exe
set cmdext=CMD
goto dfsee
:notos2
if "%OS%"==""        goto notnt
if "%OS%"=="DOS"     goto notnt
if "%OS%"=="MSDOS"   goto notnt
if "%OS%"=="DRDOS"   goto notnt
if "%OS%"=="IBMDOS"  goto notnt
if "%OS%"=="OPENDOS" goto notnt
set dfsexe=dfswin.exe
set cmdext=BAT
goto dfsee
:notnt
set dfsexe=dfsdos.exe
set cmdext=BAT
:dfsee

if "%1" == "?"   goto usage
if "%1" == "/?"  goto usage
if "%1" == "-?"  goto usage

echo Checking write-permission in current directory ...
if exist _write_._ok del _write_._ok > NUL
echo test > _write_._ok
if exist _write_._ok goto writeok
echo.
echo ERROR: The current directory is write-protected or the disk is full
echo.
echo        Please change the current directory to a disk or diskette
echo        with more than 200Kb of available space ...
echo.
goto end
:writeok
if exist _write_._ok del _write_._ok > NUL

echo Checking required DFSee files ...
if not exist DFSDISK.%cmdext% goto missingfile
if not exist DFSDISK.DFS      goto missingfile
if not exist %dfsexe%         goto missingfile

echo Checking DFSee registration ...
%dfsexe% -R -b -q query RValid
if not errorlevel 1 goto work
echo.
echo NOTE: Your DFSee version is not properly registred, this will cause
echo       some extra delays and reminder messages to be displayed  ...
echo.
echo       If you do NOT touch the keyboard, DFSee WILL continue and
echo       collect the needed information but you must be patient ...
echo.
echo       Typical processing time is several minutes (not hours!)
echo.
echo  Use the ENTER key now to begin the DFSTART procedure, and do
echo  not touch the keyboard after that before it completes.
pause > NUL
echo.

:work
set dfswitch=
set basename=dfstartx
if "%1" == ""    goto step1
if "%1" == "-R-" goto setswitch
if "%1" == "-7"  goto setswitch
if "%1" == "-a"  goto setswitch
if "%1" == "-b"  goto setswitch
if "%1" == "-q"  goto setswitch
if "%1" == "-Q"  goto setswitch
if "%1" == "-w"  goto setswitch
if "%1" == "-w-" goto setswitch
if "%1" == "1"   goto sequence
if "%1" == "2"   goto sequence
if "%1" == "3"   goto sequence
if "%1" == "4"   goto sequence
if "%1" == "5"   goto sequence
if "%1" == "6"   goto sequence
if "%1" == "7"   goto sequence
if "%1" == "8"   goto sequence
if "%1" == "9"   goto sequence
if "%1" == "0"   goto sequence
set basename=%1
goto step1

:sequence
set basename=dfstart%1
goto step1

:setswitch
set dfswitch=%1

:step1
echo.
echo This script will start a DFSee recovery session but will create some very
echo usefull backup files the first time it is used. To refresh the files when
echo you have made partitioning changes, delete %basename%.sk1 and new files
echo will be generated. Logging will be appended to %basename%.log.
echo.
echo For safety, DFSee will be started in READONLY mode, if you need to fix
echo something, and have found out how to do that, you can start this script
echo with the "-R-" option to allow writing to the disks, or alternatively,
echo you can START THE DFSee PROGRAM %dfsexe% DIRECTLY
echo         -------------------------------------------
echo.
echo In any case, YOU are responsible for any damage you cause :-)
echo.
echo For some help in using this script, use the command '%0  -?'

if exist %basename%.sk1 goto step2

if exist %basename%.sk? del %basename%.sk? > NUL
if exist %basename%.pd? del %basename%.pd? > NUL
if exist %basename%.sn? del %basename%.sn? > NUL
if exist %basename%.bn? del %basename%.bn? > NUL

echo.
echo Create partition-info backups and UNFDISK log-files ...
call DFSDISK
echo.
echo Rename DFSDISK files to %basename% name ...
echo.
ren dfsdiski.sk* %basename%.*
ren dfsdiski.pd* %basename%.*
ren dfsdiski.sn* %basename%.*
ren dfsdiski.bn* %basename%.*
echo.
echo Resulting %basename% backup and information files now:
echo.
dir %basename%.*
echo.

:step2
if "%2"=="" goto confirm
%dfsexe% -R %dfswitch% -l:%basename% %2 %3 %4 %5 %6 %7 %8 %9
goto showfiles
:confirm
%dfsexe% -R %dfswitch% -l:%basename% map -m * +#part#confirm Run any command you want to add to the %basename% logfile~~Then Exit DFSee ...
:showfiles
echo.
echo Log and backup files collected for the %basename% session sofar:
echo.
dir %basename%.*
echo.
echo For support, ZIP these files, add as much problem description as
echo you can, and send it to: support@dfsee.com
goto end


:missingfile
echo.
echo ERROR: Not all required DFSee files are present in the current directory!
echo        To run this DFSTART script successfully you also need to have:
echo.
echo        - DFSDISK.%cmdext%
echo        - DFSDISK.DFS
echo        - %dfsexe%
echo        - dfsee.key                       (when you have registred)
echo.
echo Check if these are in the current directory, and check if there is
echo at least 200Kb of free diskspace for the resulting logfiles
echo.
goto end

:usage
echo Start a DFSee recovery session, creating logs/backups on first time
echo.
echo Usage:  %0  [somename / number] [parameters]
echo.
echo         somename   =  Basename to be used for log and backupfiles.
echo                       Part of your (computer) name would be usefull.
echo.                      When no name is specified, 'dfstartx' is used.
echo.
echo         number     =  1 digit sequencenumber for resulting files
echo.
echo         parameters =  Any DFSee switch (%dfsexe% -?) or DFSee command
echo                       -R-         = turn off READONLY mode
echo                       -Q          = quit automatically, no user input
echo Examples:
echo  %0 7           Start a DFSee session, create the following files:
echo                      - dfstart7.SK?
echo                      - dfstart7.PD?    Where '?' is a disk number
echo                      - dfstart7.LOG
echo.
echo  %0 recover -Q  Create recovery information in the following files:
echo                      - RECOVER.SK?
echo                      - RECOVER.PD?     Where '?' is a disk number
echo                      - RECOVER.LOG     Session will Quit when finished
:end
