@echo off
rem 14-04-2003 JvW Updated with write-protection check            (5.18)
rem 20-03-2004 JvW Renamed to DFSDISK for better readability      (6.04)
echo.
echo Get DFSee UNFDISK information

echo Checking write-permission in current directory ...
if exist _write_._ok del _write_._ok > NUL
echo test > _write_._ok
if exist _write_._ok goto writeok
echo.
echo ERROR: The current directory is write-protected or the disk is full
echo.
echo        Please change the current directory to a disk or diskette
echo        with more than 300Kb of available space ...
echo.
goto end
:writeok
if exist _write_._ok del _write_._ok > NUL

if "%0"=="DISKTEST"     echo on
if "%0"=="disktest"     echo on

if "%OS2_SHELL%"=="" goto notos2
set dfsexe=dfsos2.exe
set cmdext=CMD
goto dfsee
:notos2
if "%OS%"==""        goto notnt
if "%OS%"=="DOS"     goto notnt
if "%OS%"=="MSDOS"   goto notnt
if "%OS%"=="DRDOS"   goto notnt
if "%OS%"=="IBMDOS"  goto notnt
if "%OS%"=="OPENDOS" goto notnt
if "%OS%"=="FREEDOS" goto notnt
set dfsexe=dfswin.exe
set cmdext=BAT
goto dfsee
:notnt
set dfsexe=dfsdos.exe
set cmdext=BAT
:dfsee

if exist dfsdiski.sk1 del  dfsdiski.sk1
if exist dfsdiski.sk2 del  dfsdiski.sk2
if exist dfsdiski.sk3 del  dfsdiski.sk3
if exist dfsdiski.sk4 del  dfsdiski.sk4
if exist dfsdiski.sk5 del  dfsdiski.sk5
if exist dfsdiski.sk6 del  dfsdiski.sk6
if exist dfsdiski.sk7 del  dfsdiski.sk7
if exist dfsdiski.sk8 del  dfsdiski.sk8
if exist dfsdiski.sk9 del  dfsdiski.sk9

if "%1" == "" echo (to get help on other usage just type:  '%0  ?')
echo.
if "%1" == "?"   goto usage
if "%1" == "/?"  goto usage
if "%1" == "-?"  goto usage

%dfsexe% -b -q query RValid
if not errorlevel 1 goto work
echo.
echo NOTE: Your DFSee version is not properly registred, this will cause
echo       some extra delays and reminder messages to be displayed  ...
echo.

:work
if "%2" == "*"   goto allsect
if "%2" == "a"   goto allsect
if "%2" == "A"   goto allsect
if "%2" == "All" goto allsect
if "%2" == "ALL" goto allsect
if "%2" == "all" goto allsect
if "%2" == ""    goto cbfast
if "%1" == "*" echo WARNING: specified geometry '%2' is ignored with disks *

:cbfast
echo Searching partition information on cylinder boundaries only. (fast)
set scmd=cyl
goto scmdset
:allsect
echo Searching partition information in ALL sectors (takes a long time!)
set scmd=all
:scmdset

set runcmd=-RO -Quit -batch -quiet -7bit run -Error:ignore dfsdisk.dfs

if "%1" == ""                     goto alldisks
if "%1" == "*"                    goto alldisks
if "%scmd%" == "all"  goto doallgeo
set geo=%2 %3 %4
goto dodisk
:doallgeo
set geo=%3 %4 %5
:dodisk
%dfsexe% -l:dfsdiski.sk%1 %runcmd% %1 %scmd% %geo%
goto showerrors

:alldisks
echo Detecting number of physical disks using %dfsexe% :
%dfsexe% -b -t- -e- query Disks
if errorlevel 50 echo goto badquery
if errorlevel 10 echo Only the first 9 disks will be collected ...
if errorlevel  9 goto disk9
if errorlevel  8 goto disk8
if errorlevel  7 goto disk7
if errorlevel  6 goto disk6
if errorlevel  5 goto disk5
if errorlevel  4 goto disk4
if errorlevel  3 goto disk3
if errorlevel  2 goto disk2
if errorlevel  1 goto disk1
goto disk0

:badquery
echo Number of disks unsupported with %0, no information is collected!
echo Diagnostic information will be in 'dfsdiski.sk0'
echo.
%dfsexe% -R -b -l:dfsdiski.sk0 query Disks
goto end

:disk9
%dfsexe% -l:dfsdiski.sk9 %runcmd% 9 %scmd%
:disk8
%dfsexe% -l:dfsdiski.sk8 %runcmd% 8 %scmd%
:disk7
%dfsexe% -l:dfsdiski.sk7 %runcmd% 7 %scmd%
:disk6
%dfsexe% -l:dfsdiski.sk6 %runcmd% 6 %scmd%
:disk5
%dfsexe% -l:dfsdiski.sk5 %runcmd% 5 %scmd%
:disk4
%dfsexe% -l:dfsdiski.sk4 %runcmd% 4 %scmd%
:disk3
%dfsexe% -l:dfsdiski.sk3 %runcmd% 3 %scmd%
:disk2
%dfsexe% -l:dfsdiski.sk2 %runcmd% 2 %scmd%
:disk1
%dfsexe% -l:dfsdiski.sk1 %runcmd% 1 %scmd%

:showerrors
if errorlevel 235 goto failure
if errorlevel 234 goto noscript
if errorlevel 001 goto failure
goto showdir

:noscript
echo.
echo ERROR: The required DFSee script 'DFSDISK.DFS' was not found.
echo Check if it is in the current directory, the same directory
echo as the execuatable %dfsexe% or a directory on the PATH
goto showdir

:failure
echo.
echo WARNING: Execution of the DFSDISK script seems to have failed.
echo This could be the result of unexpected disk geometry or
echo other strange behaviour of disk-drivers, BIOS and so on
echo.
echo Also check if %dfsexe% and the script file DFSDISK.DFS can be
echo found in the current directory, or a directory on the PATH.

:showdir
echo.
echo Resulting DFSee info logfiles:
dir dfsdiski.*
echo.
echo Check at least one of the dfsdiski.sk? files for obvious error messages
echo that could be corrected easily on a new run of %0! When it looks OK:
echo.
echo email these file(s) to support@dfsee.com for analysis (ZIP if possible)
echo Include as many details about the disk partitions as you remember.
echo.
goto end

:baddisk
echo.
echo Disk number %1 does not seem to be present (or locked)
:locked
echo A disk in your system is not accesible, possibly locked.
echo This might be caused by another FDISK, LVM or DFSee program being active.
echo Please close all other FDISK related programs before running %0
echo.
goto end

:disk0
echo No physical disks detected ...
echo.
goto end

:usage
echo A careful analysis of the generated info can lead to a series of %dfsexe%
echo commands like NEWMBR and CREATE to re-create missing/lost partitions.
echo.
echo Usage: %0 [* or Disk-nr [* or All or Cyl] [? or #cyl [#head [#sect]]]]
echo.
echo Default is search all disk on cylinder boundaries only (fast mode)
echo.
echo    * or Disk-nr   =  search specified disk(s), 1 .. 9  or * = all disks
echo.
echo         Cyl       =  search on cylinder boundaries only (fast, default)
echo    * or All       =  search all sectors, this will find any sector
echo                      but can be real slow. (like 8 hours for 40Gb disk)
echo.
echo    ? or #cyl      =  Number of cylinders value  1..65535 or ? = calculate
echo         #head     =  Number of heads     value  1..255
echo         #sect     =  Number of sectors   value  1..63
echo                      #head and #sect use defaults when not specified.
echo                      When a '?' is used for #cyl, it will be calculated
echo                      based on the known disk-size, #head and #sect
echo Examples:
echo    %0                     all disks, use standard geometry
echo    %0 * *                 all disks, every sector (slow, every geometry)
echo    %0 3                   disk 3 only, use standard geometry
echo    %0 1 1000 64 32        disk 1, geo: 1000 cyls, 64 heads, 32 sects
echo    %0 2 ? 240 63          disk 2, geo: 240 heads, 63 sects, #cyl calculated
echo    %0 2 All ? 240 63      disk 2, same as above, but search ALL sectors
:end
