program doortest;
(******************************************************************************

                                 DoorTest
                  ATLANTIS NETWORKING GAME ENGINE LIBRARY
                       by Jimmy Rose & Andy Stewart
                             Atlantis Software

    This is a sample program to demonstrate the functionality of A.N.G.E.L.
    procedures and functions. See "ANGEL.TXT" for full documentation.

Version: 1.0  
Updated: Oct 23, 2002
******************************************************************************)
{..APPTYPE CONSOLE}    { Remove this line if compiling under TP or VP          }

uses
  crt,
  dos,
  angel;

var
 a : char;
 s1: AIString;

begin
 aInit;                           { Initialize A.N.G.E.L. 		             }
 AI.Programname:='DoorTest';      { Set Doorname                             }
 AI.Version:='1.0';               { Set Version                              }
 AI.Author:='Jimmy Rose & Andy Stewart'; { Set Author                        }

 aClr;  { Clear Screen                                                       }


 aWriteLn('Testing A.N.G.E.L.' + #32 + AngelVersion + AngelSubVersion);
                 { Write A.N.G.E.L. + version                                }

 aWriteLn('Whack a key to tread onward!');
 aReadKey;      { Wait for a keypress                                        }

 aWriteXY(8,15,'OUCH!!!  That hurt, '+ user.uname);
                { Write, beginning at co-ordinates 8,15                      }

 snooze(1000); aClr;
                { 1 second snooze and Clear Screen                           }

 aShowFileFast('angel.ans'); aReadKey; { Show ANSI screen with no pause      }


{ ----------------------------------------------------------------------------}
 { Testing the ISA Color Codes                                               }
{ ----------------------------------------------------------------------------}
 aClr;
 BannerLine('Testing ISA Color Code Display',15,1); NewLnn(3);
 aWriteIccLn('^\0000 ^\0101 ^\0202 ^\0303 ^\0404 ^\0505 ^\0606 ^\0707');
 aWriteIccLn('^\0808 ^\0909 ^\0A0A ^\0B0B ^\0C0C ^\0D0D ^\0E0E ^\0F0F');
 aWriteIccLn('^\1010 ^\1111 ^\1212 ^\1313 ^\1414 ^\1515 ^\1616 ^\1717');
 aWriteIccLn('^\1818 ^\1919 ^\1A1A ^\1B1B ^\1C1C ^\1D1D ^\1E1E ^\1F1F');
 aWriteIccLn('^\2020 ^\2121 ^\2222 ^\2323 ^\2424 ^\2525 ^\2626 ^\2727');
 aWriteIccLn('^\2828 ^\2929 ^\2A2A ^\2B2B ^\2C2C ^\2D2D ^\2E2E ^\2F2F');
 aWriteIccLn('^\3030 ^\3131 ^\3232 ^\3333 ^\3434 ^\3535 ^\3636 ^\3737');
 aWriteIccLn('^\3838 ^\3939 ^\3A3A ^\3B3B ^\3C3C ^\3D3D ^\3E3E ^\3F3F');
 aWriteIccLn('^\4040 ^\4141 ^\4242 ^\4343 ^\4444 ^\4545 ^\4646 ^\4747');
 aWriteIccLn('^\4848 ^\4949 ^\4A4A ^\4B4B ^\4C4C ^\4D4D ^\4E4E ^\4F4F');
 aWriteIccLn('^\5050 ^\5151 ^\5252 ^\5353 ^\5454 ^\5555 ^\5656 ^\5757');
 aWriteIccLn('^\5858 ^\5959 ^\5A5A ^\5B5B ^\5C5C ^\5D5D ^\5E5E ^\5F5F');
 aWriteIccLn('^\6060 ^\6161 ^\6262 ^\6363 ^\6464 ^\6565 ^\6666 ^\6767');
 aWriteIccLn('^\6868 ^\6969 ^\6A6A ^\6B6B ^\6C6C ^\6D6D ^\6E6E ^\6F6F');
 aWriteIccLn('^\7070 ^\7171 ^\7272 ^\7373 ^\7474 ^\7575 ^\7676 ^\7777');
 aWriteIccLn('^\7878 ^\7979 ^\7A7A ^\7B7B ^\7C7C ^\7D7D ^\7E7E ^\7F7F');
 aWriteIccLn('^\0FPress any key to continue');
{ ----------------------------------------------------------------------------}
 aReadKey;

{ ----------------------------------------------------------------------------}
 { Testing Pause Variations                                           }
{ ----------------------------------------------------------------------------}
 aSetColor(15,0);
 aClr;
 aWriteLn('We will now test some of the Pause procedures. '); NewLn;
 aWriteLn('Non Animated Pauses - Pause(1)'); NewLn;
 Pause(1); aClr;

 aWriteLn('Non Animated Pauses - Pause(2)'); NewLn;
 Pause(2); aClr;

 aWriteLn('Basic Animated Pauses - Pause(3)'); NewLn;
 Pause(3); aClr;

 aWriteLn('Basic Animated Pauses - Pause(4)'); NewLn;
 Pause(4); aClr;

 aWriteLn('Basic Animated Pauses - Pause(5)'); NewLn;
 Pause(5);

 aClr;
 aWriteLn('Pause Tests'); NewLn;
 aWriteLn('Advanced Animated Pauses (6-9)'); NewLn;
 Pause(6); Pause(7); Pause(8); Pause(9);

{ ----------------------------------------------------------------------------}

{ ----------------------------------------------------------------------------}
 { Testing the two graphical input variations                                }
{ ----------------------------------------------------------------------------}
 aClr;
 NewLnn(2);
 aWriteIcc('^\03Please enter your name ^\0B: ^\0F');
 GInput1(s1,20,#176); { Graphical Input with no default value                }
 aWriteIccLn('^\LF^\LF^\03Thank you^\0B, ^\0E'+s1+'^\LF');
 Pause(1);

 aClr;
 NewLnn(2);
 aWriteIcc('^\03Press ^\0F[^\03ENTER^\0F]^\03 for automatic '+
           'insertion^\0F: ^\02');
 GInput2(s1,12,#176,'AutoInsert'); { Graphical Input with default value      }
 aWriteIccLn('^\07^\LF');
{ ----------------------------------------------------------------------------}

{ ----------------------------------------------------------------------------}
 { Testing aReadKey                                                          }
{ ----------------------------------------------------------------------------}
 aSetColor(2,0);
 aWrite('Press any key to continue : '); a := aReadKey;
 NewLnn(2);
 aWrite('You pressed the ');
 if ((a=#13) or (a=#10)) then aWrite('"[ENTER]"') else aWrite('"'+ a +'"');
 aWriteLn(' key!');
 NewLn; Pause(2);
{ ----------------------------------------------------------------------------}

{ ----------------------------------------------------------------------------}
 { Testing ANSI file display                                                 }
{ ----------------------------------------------------------------------------}
 aClr;
 aWriteLn('We will now display an ANSI file, press a key'); aReadKey;
 aShowFileFast('Menu.ans'); Pause(1);
{ ----------------------------------------------------------------------------}
{ ----------------------------------------------------------------------------}
 { Testing DisplayStatus                                                     }
{ ----------------------------------------------------------------------------}
 aClr; NewLnn(5); aSetFore(12);
 aWriteLn(center('The Status Bar Type is selectable.'));
 aWriteLn(center('Press a key to see the ISA type Status Bar.')); aReadKey;
 window(1,1,80,25); aClr;
 AI.StatusType := ISA; aClr; newlnn(10); snooze(1000);
 aWriteLn(center('Press a key to see the TriBBS type Status Bar.')); aReadKey;
 window(1,1,80,25); aClr;
 AI.StatusType := TRI;
  aClr; NewLnn(5); aSetFore(13);
 aWriteLn(center('Pretty cool, eh?'));
 aReadKey;

{ ----------------------------------------------------------------------------}
 { Testing ISA Color Code file display                                       }
{ ----------------------------------------------------------------------------}
 aClr;
 aWriteLn('We will now display an ISA Colorcode file, press a key'); aReadKey;
 aShowFile('OLD.NEW', 1, 1, true, false); NewLn;
 aWriteLn('ISA Colorcode display complete (Pipes will display the same way)');

{ ----------------------------------------------------------------------------}

{ ----------------------------------------------------------------------------}
 { Testing the aShowFile pause function                                      }
{ ----------------------------------------------------------------------------}
 aClr; aWriteLn('We will now test the pause function in aShowFile');aReadKey;
 aShowFile('Angel.txt', 3, 0, true, true); NewLn;
 aWrite('ISA Colorcode display complete (Pipes will display the same way)');

{ ----------------------------------------------------------------------------}

{ ----------------------------------------------------------------------------}
 { Testing the aWriteXY, aSetColor and aGotoXY functions                     }
{ ----------------------------------------------------------------------------}
 aClr; aSetColor(7,0);
 aWriteXY(8,15,'This will print at Column 8 Row 15. [Press Any Key]'); NewLn; aReadKey;
 aWriteLn('We will now change the color. [Press Any Key]'); aReadKey;
 aSetColor(11,4); aGotoXY(1,18);
 aWriteLn('This is a new color. [Press Any Key]'); aReadKey;
 aWriteLn('We will now change the color back'); NewLn;
 aSetColor(7,0); aWriteLn('This is the original color');
 NewLn;
 {Pause(3);}
 Pause(1);
{ ----------------------------------------------------------------------------}

{ ----------------------------------------------------------------------------}
 { Testing the aClrEol function                                              }
{ ----------------------------------------------------------------------------}
 aClr;
 aGotoXY(1,16);
 aWrite('We will reposition the cursor to the start of this line, '+
        'then call aClrEol');
 aReadKey;  aGotoXY(1,16); aClrEol; NewLn;
 aWriteLn('It worked! ;)');
 NewLn;
 {Pause(8);}
 Pause(1);
{ ----------------------------------------------------------------------------}

{ ----------------------------------------------------------------------------}
 { Testing the ISA Color Clear Color Code Function                           }
{ ----------------------------------------------------------------------------}
 aClr;
 aWriteIccLn('^\03Testing clearCC function for ISA codes^\LF');
 aWriteIcc('^\0BBefore ^\0F: ^\02');
 aWriteLn('^\01Testing(01) ^\02Testing(02) ^\CLTesting(CL) ^\LFTesting(LF)');
 aWriteIcc('^\0BAfter  ^\0F: ^\0A');
 aWriteLn(ClearCC('^\01Testing(01) ^\02Testing(02) '+
                  '^\CLTesting(CL) ^\LFTesting(LF)'));
 NewLnn(2);  { 2 CR/LF                                                       }
{ ----------------------------------------------------------------------------}

{ ----------------------------------------------------------------------------}
 { Testing the Pipe Color Clear Color Code Function                          }
{ ----------------------------------------------------------------------------}
 aWriteIccLn('^\03Testing clearCC function for Pipe codes');
 NewLn;
 aWriteIcc('^\0BBefore ^\0F: ^\02');
 aWriteLn('|01Testing(01) |11Testing(11) |21Testing(21) |B1Testing(B1)');
 aWriteIcc('^\0BAfter  ^\0F: ^\0A');
 aWriteLn(ClearCC('|01Testing(01) |11Testing(11) |21Testing(21) '+
                  '|B1Testing(B1)'));
 NewLnn(2);
{ ----------------------------------------------------------------------------}


 Pause(2);

 aClr;
 aSetColor(13,0); { Set screen color to Foreground = Magenta,                }
                  {                     Background = Black                   }

 aWriteLn('ISA "^\" Color Code [aWriteICC()/aWriteLnICC()] test.');
 NewLn;


{ ----------------------------------------------------------------------------}
 { Testing aGotoXY and PIPE Color Codes                                       }
{ ----------------------------------------------------------------------------}

 aClr;
 aGotoXY(20,12); aWritePcc('|14|B4   Pipe codes may also be used    ');
 aGotoXY(20,13); aWritePcc('|15|B1to change text & background colors');

 newLnn(3);
 Pause(2);
{ ----------------------------------------------------------------------------}

{ ----------------------------------------------------------------------------}
 { Testing BannerLine                                                        }
{ ----------------------------------------------------------------------------}
 aClr;
 WriteLn('BannerLine Tests'); NewLn;
 BannerLine('Centered Gray',8,0);
 BannerLine('Centered Blue',9,1);
 BannerLine('Centered Green',10,2);
 BannerLine('Centered Cyan',11,3);
 BannerLine('Centered Red',12,4);
 BannerLine('Centered Purple',13,5);
 BannerLine('Centered Brown',14,6);
 BannerLine('Centered Light Gray',15,7); NewLnn(2);
 BannerLine('Please See Angel.txt For Full Documentation',15,1);
 NewLn;
 aWriteLn('Wow <g>');
{ ----------------------------------------------------------------------------}

 aSetColor(7,0);
 NewLn; 
 aReadKey; aClr;
 newlnn(4);
 aWriteICCln('^\03A^\0F.^\03N^\0F.^\03G^\0F.^\03E^\0F.^\03L^\0F.^\03 reads '+
       'the following dropfiles^\oF:'); newln;
 aWriteICCln('^\0BDOOR32^\0F, ^\0BDOOR.SYS^\0F, ^\0BCHAIN.TXT^\0F, '+
       '^\0BTRIBBS.SYS^\0F, ');
 aWriteICCln('^\0BSFDOORS.DAT^\0F, ^\0BDORINFO.DEF^\0F, '+
       '^\0BPCBOARD.SYS^\0F.');
 newlnn(4);
 BannerLine('Press Any Key To Exit '+AI.Programname,15,1);
 aReadKey; NewLnn(4);
 NewLn;
 aExit(0); { You should always end your program with the aExit function }

END.
