PROGRAM SKELEDIT;  { LORD Skeleton Player Database Editor Utility }

  { Started creation using CHANEDIT source code 11/29/2007. }
  { Did official release of v1.00 as of Oct. 08, 2008. }
  { ================================================================== }

USES CRT, GoldWin, GoldFast, GoldRead, GoldMisc, ChasWare;

     {$I BONESVAR.INC}   {v1.00 released as of 10/08/2008.}
     { =================================================================================== }

CONST Version: STRING = 'v1.00';  {Created 11/29/07}

      Compile_Date: STRING = 'October 08, 2008.';

      Release_Date: STRING = 'October 08th, 2008.';  {10/08/08}
      { ------------------------------------------------ }

      CfgName: STRING = 'SKELEDIT.CFG';

      BonePlayer_FN: STRING = 'SKELPLAY.DAT';

      RealName    = '1';   LordName   = '2';   PlayNum   = '3';
      Visits      = '4';   HitMax     = '5';   Strength  = '6';
      Defense     = '7';   Charm      = '8';   Adopted   = '9';

      Jewels      = '0';   Pellets    = 'A';   Healing    = 'B';
      Skills      = 'C';   GemsInt    = 'D';   GoldInt    = 'E';
      Bank_Gems   = 'F';   Bank_Gold  = 'G';   Coins      = 'H';

      PaidGems    = 'I';   Wisdom     = 'J';   PaidGold   = 'K';
      Asleep      = 'L';   Fights     = 'M';   Killed     = 'N';
      NextTime    = 'O';   Kills      = 'P';   CampAttack = 'R';

      LostFight   = 'S';   Rescued    = 'T';   OMFight    = 'U';
      WhoAttack   = 'V';
      { -------------------------------------------------------- }

      { Q - Quit/Save Changes.   Y - Search for Player. 09/09/08 edit }
      { * - New Day for Player.  X - Delete Player Record. }
      { ------------------------------------------------------- }

      TwoBillion: LongInt = 2000000000;

      OneBillion: LONGINT = 1000000000;  {11/29/07. 1 Billion}

      Max_Visits: BYTE = 25;   {08/02/08: Max Visits/Day Limit}

      Max_IGM_Fights: BYTE = 250;  {09/09/08: Max Realm Fights/Day Limit}
      { =========================================================== }

VAR TSearch: SKELETON_PLAYER;   { for player searches }

    TLSEdit: SKELETON_PLAYER;

    Editor_Path: STRING;      { File Vars for SKELPLAY.DAT access }

    Editor_File:  FILE OF SKELETON_PLAYER;

    IGMDir: STRING;

    RecordNum   : BYTE;

    DebugVar: BOOLEAN;

      { TempNum, Used, Found: Accessed from BONESVAR.INC.   Used }
      { in record Seek process.  }
    { ================================================================================== }

PROCEDURE READ_CONFIG;      {Created/verified 11/29/07}
  VAR Config_File: TEXT;

  PROCEDURE MakeConfig;          {verified 11/29/07}
    VAR IGMLoc: STRING;
  BEGIN
    IGMLoc:= PromptStr(0,0,60,'Enter path to LORD Skeleton IGM',' Installation ','',FALSE);
    IGMLoc:= S2U(IGMLoc);

    Addtext(AddBack(IGMLoc),CfgName,TRUE);
  END;   { ------------------------------------------------------------- }

BEGIN
  IF NOT Exist(CfgName) THEN MakeConfig;      {verified 11/29/07}

  ASSIGN(Config_File,CfgName);
  RESET(Config_File);
  Readln(Config_File,IGMDir);
  CLOSE(Config_File);

  IGMDir:= S2U(IGMDir);

  { SKELEDIT: When run from compiler, verified that value of IGMDir is known at this point. }
END;       { Read_Config ------------------------------------------------- }


PROCEDURE READ_WARRIORS_FILE;    { Reads the IGM's SKELPLAY.DAT file. }
BEGIN
  Editor_Path:= S2U(IGMDIR+BonePlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  READ(Editor_File,TLSEdit);

  CLOSE(Editor_File);
END;     { ---------------------------------------------------- }


PROCEDURE WRITE_WARRIORS_FILE;      { Writes IGM's SKELPLAY.DAT file }
BEGIN
  Editor_Path:= S2U(IGMDIR+BonePlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  WRITE(Editor_File,TLSEdit);

  CLOSE(Editor_File);
END;     { WRITE_WARRIORS_FILE   ------------------------------ }


PROCEDURE SEARCH_PLAYER(Num:INTEGER);
      { Reads SKELPLAY.DAT. Does search on player record number }
BEGIN
  Editor_Path:= S2U(IGMDIR+BonePlayer_FN);
        {09/29/07: Changed Change_FN to Editor_Path.}

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,Num);
  READ(Editor_File,TSearch);

  CLOSE(Editor_File);
END;     { SEARCH_PLAYER  --------------------------------------------- }

    
FUNCTION Get(b:CHAR): STRING;
BEGIN
  CASE UpCase(b) OF
     RealName : Get:='`!'+TLSEdit.RealName;

     LordName : Get:='`0'+TLSEdit.LordName;

     PlayNum  : Get:='`@'+N2S(TLSEdit.PlayNum);
                   {Contains player's LORD player #.}

     Visits   : IF TLSEdit.Visits = 0
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+N2S(TLSEdit.Visits);

     HitMax   : IF TLSEdit.HitMax = 0
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+COMMA(TLSEdit.HitMax);

     Strength : IF TLSEdit.Strength = 0
                   THEN  Get:= '`%None'
                   ELSE  Get:= '`0'+COMMA(TLSEdit.Strength);

     Defense  : IF TLSEdit.Defense = 0
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+COMMA(TLSEdit.Defense);

     Charm    : IF TLSEdit.Charm = 0
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+COMMA(TLSEdit.Charm);

     { ================ Revised 09/08/08 ================= }
     Adopted  : IF TLSEdit.Adoptions = 0    {09/08/08 edit}
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+N2S(TLSEdit.Adoptions);

     { ================ Revised 09/13/08 ================= }
     Jewels   : IF TLSEdit.Gems = 0       {09/13/08 edit}
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+COMMA(TLSEdit.Gems);

     { ================ Revised 09/08/08 ================= }
     Pellets  : IF TLSEdit.Pellets = 0      {09/08/08 edit}
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+N2S(TLSEdit.Pellets);  {BYTE format}

     Healing  : IF TLSEdit.Potions = 0      {09/08/08 edit}
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+COMMA(TLSEdit.Potions);

     Skills   : IF TLSEdit.Skills = 0    {09/08/08 edit}
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+N2S(TLSEdit.Skills);  {BYTE format}

     GemsInt  : IF TLSEdit.Gems_Int = 0     {09/08/08 edit}
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`%'+COMMA(TLSEdit.Gems_Int);

     GoldInt  : IF TLSEdit.Gold_Int = 0
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`%'+COMMA(TLSEdit.Gold_Int);

     { ================ Added/Revised 09/08/08 ================= }
     Bank_Gems : IF TLSEdit.GemsBank = 0     {09/13/08 edit}
                   THEN  Get:= '`%None'
                   ELSE  Get:= '`#'+COMMA(TLSEdit.GemsBank);

     Bank_Gold : IF TLSEdit.GoldBank = 0     {09/13/08 edit}
                   THEN  Get:= '`%None'
                   ELSE  Get:= '`#'+COMMA(TLSEdit.GoldBank);

     Coins    : IF TLSEdit.Gold = 0    {09/08/08 edit}
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+COMMA(TLSEdit.Gold);

     PaidGems : IF TLSEdit.Paid_GemsInt THEN Get:= '`@Yes! '  {09/08/08 edit}
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Wisdom   : IF TLSEdit.Wisdom = 0       {09/08/08 edit}
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+COMMA(TLSEdit.Wisdom);

     PaidGold : IF TLSEdit.Paid_GoldInt THEN Get:= '`@Yes! '  {Added 09/08/08}
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Asleep   : IF TLSEdit.Sleeping THEN Get:= '`@Yes! '      {Added 09/08/08}
                  ELSE Get:= '`0Nope!';  {Boolean VAR}

     Fights   : IF TLSEdit.IGM_Fights = 0    {Added 09/08/08}
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+N2S(TLSEdit.IGM_Fights);

     Killed   : IF TLSEdit.Was_Killed THEN Get:= '`@Yes! '      {Added 09/08/08}
                  ELSE Get:= '`0Nope!';  {Boolean VAR}        {09/13/08 edit}

     { ================ Added 09/09/08 ======================= }
     NextTime : Get:='`#'+N2S(TLSEdit.Next_Time);
                   {Contains player's Next LORD Day value. Added 09/09/08}

     { ================ Added 09/13/08 ======================= }
     Kills    : IF TLSEdit.Enemy_Kills = 0    {Added 09/13/08}
                  THEN  Get:= '`%None'
                  ELSE  Get:= '`0'+N2S(TLSEdit.Enemy_Kills);

     CampAttack : IF TLSEdit.Camp_Attack THEN Get:= '`@Yes! '   {Added 09/13/08}
                    ELSE Get:= '`0Nope!';  {Boolean VAR}

     LostFight   : IF TLSEdit.Camp_Dead THEN Get:= '`@Yes! '   {Added 09/13/08}
                    ELSE Get:= '`0Nope!';  {Boolean VAR}

     Rescued    : IF TLSEdit.Fairy_Rescue THEN Get:= '`@Yes! '   {Added 09/13/08}
                    ELSE Get:= '`0Nope!';  {Boolean VAR}

     OMFight    : IF TLSEdit.Fought_OldMan THEN Get:= '`@Yes! '   {Added 09/13/08}
                    ELSE Get:= '`0Nope!';  {Boolean VAR}

     WhoAttack  : Get:='`@'+TLSEdit.Who_Attack;  {Added 09/13/08}
                   {Name of Attacker in sleeper's Camp}
  END;

  CursorOff;   {10/15/07.  needed to fix bug found by Dennis Collins}
               { in 2006 when he checked on KLBEDIT. }

    { When program's user would change a setting in a dialog box, when }
    { they returned to the main screen, the cursor would be back on the }
    { screen, so this keeps the cursor deactivated while the editor runs. }
END;     { GET Func. ----------------------------------------------------- }


{ 1 }PROCEDURE DO_REAL_NAME;          {Created 11/29/07: VERIFIED 11/29/07}
BEGIN
  TLSEdit.RealName:=
  PromptStr(0,0,50,'Enter REAL name for player',' Player Real Name Change ',TLSEdit.RealName,FALSE);

  WRITE_WARRIORS_FILE;
  CWriteXy(22,4,Replicate(50,' '));  { Write data on position 25, Line #4. }
  CWriteXy(22,4,Get(RealName));
END;


{ 2 }PROCEDURE DO_LORD_NAME;           {Created 11/29/07: VERIFIED 11/29/07}
BEGIN
  TLSEdit.LordName:=
  PromptStr(0,0,20,'Enter LORD Name for player',' Player Lord Name Change ',TLSEdit.LordName,FALSE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,5,Replicate(20,' '));
  CwriteXY(22,5,Get(LordName));
END;


    { In normal usage, don't allow users to change LORD Player Numbers. }

{ 3 }PROCEDURE DO_PLAYER_NUMBER;              {Created 11/29/07: Verified 05/13/08}
BEGIN
  TLSEdit.PlayNum:=
    PromptNum(0,0,'Enter player''s LORD Player # (0-160)?',' LORD Player Number Change ',TLSEdit.PlayNum,0,160,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(59,5,Replicate(5,' '));    { Allow room for 3 digits, and 2 blank spaces. 07/13/05}
  CWriteXY(59,5,Get(PlayNum));
END;


{ 4 }PROCEDURE DO_VISITS;               {Created 11/29/07: VERIFIED 11/29/07}
BEGIN
  TLSEdit.Visits:=             {Revised 07/27/08}
    PromptNum(0,0,'Enter Visits Today (0-25)?',' Visits Today Change',TLSEdit.Visits,0,Max_Visits,TRUE);
                {08/02/08: edited to use Max_Visits const.}

  WRITE_WARRIORS_FILE;
  CwriteXY(22,6,Replicate(5,' '));
  CwriteXY(22,6,Get(Visits));
END;   {IGM's Max Visits/Day Limit is 25.}


{ 5 }PROCEDURE DO_HITMAX;                 {Created 11/29/07: VERIFIED 11/29/07}
BEGIN
  TLSEdit.HitMax:=
  PromptNum(0,0,'Enter Max HitPoints amount (0-16,000)?',' Max HitPoints Today Change',TLSEdit.HitMax,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(59,6,Replicate(6,' '));
  CWriteXY(59,6,Get(HitMax));
END;


{ 6 }PROCEDURE DO_STRENGTH;                 {Created 11/29/07: VERIFIED 11/29/07}
BEGIN
  TLSEdit.Strength:=
  PromptNum(0,0,'Enter Strength Points amount (0-16,000)?',' Strength Change ',TLSEdit.Strength,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,7,Replicate(6,' '));
  CWriteXY(22,7,Get(Strength));
END;


{ 7 }PROCEDURE DO_DEFENSE;               {Created 11/29/07: VERIFIED 11/29/07}
BEGIN
  TLSEdit.Defense:=
  PromptNum(0,0,'Enter Defense Points (0-16,000)?',' Defense Change ',TLSEdit.Defense,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(59,7,Replicate(6,' '));
  CwriteXY(59,7,Get(Defense));
END;


{ 8 }PROCEDURE DO_CHARM;               {Created 11/29/07: VERIFIED 11/29/07}
BEGIN
  TLSEdit.Charm:=
  PromptNum(0,0,'Enter Charm Points (0-16,000)?',' Charm Change ',TLSEdit.Charm,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,8,Replicate(6,' '));
  CwriteXY(22,8,Get(Charm));
END;


{ 9 }PROCEDURE DO_ADOPTIONS;       {Created/Verified 09/08/08}
BEGIN
  TLSEdit.Adoptions:=
    PromptNum(0,0,'Enter Kids Adopted (0-100)?',' Kids Adopted Change', TLSEdit.Adoptions,0,100,TRUE);
           {09/13/08: Changed to BYTE. IGM doesn't offer many}
           {chances to gain Kids each day.}

  WRITE_WARRIORS_FILE;
  CWriteXY(59,8,Replicate(6,' '));
  CWriteXY(59,8,Get(Adopted));
END;


{ 0 }PROCEDURE DO_GEMS_FOUND;      {Edited Created/Verified 09/08/08}
BEGIN
  TLSEdit.Gems:=
    PromptNum(0,0,'Enter Gems Found (0-16,000)?',' Gems Change', TLSEdit.Gems,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,9,Replicate(4,' '));
  CwriteXY(22,9,Get(Jewels));
END;


{ A }PROCEDURE DO_POWER_PELLETS;      {Created/Verified 09/08/08}
BEGIN
  TLSEdit.Pellets:=
    PromptNum(0,0,'Enter Banked Power Pellets (0-250)?',' Pellets Change', TLSEdit.Pellets,0,250,TRUE);

  WRITE_WARRIORS_FILE;                   {BYTE format var}
  CWriteXY(59,9,Replicate(12,' '));
  CWriteXY(59,9,Get(Pellets));
END;


{ B }PROCEDURE DO_HEALING_POTIONS;   {Created/Verified 09/08/08}
BEGIN
  TLSEdit.Potions:=
    PromptNum(0,0,'Enter Healing Potions (0-16,000)?',' Healing Potions Change', TLSEdit.Potions,0,16000,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,10,Replicate(12,' '));
  CwriteXY(22,10,Get(Healing));
END;


{ C }PROCEDURE DO_SKILL_POINTS;     {Created/Verified 09/08/08}
BEGIN
  TLSEdit.Skills:=                       {BYTE format var}
     PromptNum(0,0,'Enter Skill Points (0-5)?',' Skill Points Today Change', TLSEdit.Skills,0,5,TRUE);
                {Limit is 5 Skill Points per day.}

  WRITE_WARRIORS_FILE;
  CWriteXY(59,10,Replicate(12,' '));
  CWriteXY(59,10,Get(Skills));
END;


{ D }PROCEDURE DO_GEMS_INTEREST;     {Created/Verified 09/08/08}
BEGIN
  TLSEdit.Gems_Int:=
    PromptNum(0,0,'Enter Gems Interest (0-200,000)?',' Gems Interest Change ',TLSEdit.Gems_Int,0,Max_GemsInt,TRUE);

  WRITE_WARRIORS_FILE;
  CwriteXY(22,11,Replicate(10,' '));
  CwriteXY(22,11,Get(GemsInt));
END;


{ E }PROCEDURE DO_GOLD_INTEREST;     {Created/Verified 09/08/08}
BEGIN
  TLSEdit.Gold_Int:=
    PromptNum(0,0,'Enter Gold Interest (0-200 Million)?',' Gold Interest Today Change', TLSEdit.Gold_Int,0,Max_GoldInt,TRUE);
            {Uses Max_GoldInt const. value is 200 Million.}

  WRITE_WARRIORS_FILE;
  CWriteXY(56,11,Replicate(14,' '));     {Uses Max_GoldInt constant}
  CWriteXY(56,11,Get(GoldInt));   {09/13/08: Changed to position 56}
END;


{ F }PROCEDURE DO_TREASURY_GEMS;     {Created/Verified 09/08/08}
BEGIN
  TLSEdit.GemsBank:=
     PromptNum(0,0,'Enter Treasury Gems (0-2 Million)?',' Treasury Gems Change ',
        TLSEdit.GemsBank,0,Max_GemsBank,TRUE);
            {09/09/08: Replaced TwoMillion CONST with Max_GemsBank.}

  WRITE_WARRIORS_FILE;
  CWriteXY(22,12,Replicate(9,' '));
  CWriteXY(22,12,Get(Bank_Gems));
END;


{ G }PROCEDURE DO_TREASURY_GOLD;     {Created/Verified 09/08/08}
BEGIN
  TLSEdit.GoldBank:=
    PromptNum(0,0,'Enter Treasury Gold (0-2 Billion)?',
             ' Treasury Gold Change ',TLSEdit.GoldBank,0,TwoBillion,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(54,12,Replicate(13,' '));  {Covers use of commas with 2 Billion amount.}
  CWriteXY(54,12,Get(Bank_Gold));
END;         {09/17/08: Changed to position 54. verified usage}


{ H }PROCEDURE Do_GOLD_FOUND;   {Created/Verified 09/08/08}
BEGIN
  TLSEdit.Gold:=
     PromptNum(0,0,'Enter Gold Found/Lost (0-1 Billion)?',' Gold Coins Change ',
        TLSEdit.Gold,0,OneBillion,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,13,Replicate(13,' '));   {Covers use of commas with 1 Billion amount.}
  CWriteXY(22,13,Get(Coins));
END;


{ I }PROCEDURE DO_PAID_GEMSINT;     {rewrote 09/13/08: verified 09/13/08}
BEGIN
  IF TLSEdit.Paid_GemsInt = TRUE THEN TLSEdit.Paid_GemsInt:= FALSE
    ELSE IF TLSEdit.Paid_GemsInt = FALSE THEN TLSEdit.Paid_GemsInt:= TRUE;

  WRITE_WARRIORS_FILE;
  CWriteXY(59,13,Replicate(6,' '));
  CWriteXY(59,13,Get(PaidGems));
END;


{ J }PROCEDURE DO_WISDOM_POINTS;       {Rewrote 09/13/08: verified 09/13/08}
BEGIN
  TLSEdit.Wisdom:=
    PromptNum(0,0,'Enter Wisdom Points (0-1 Billion)?',
        ' Wisdom Points Change', TLSEdit.Wisdom,0,OneBillion,TRUE);

      { 1234567890123 = 13 characters in length, with commas. 10 w/o commas.}
      { use OneBillion constant to define editing range. }

  WRITE_WARRIORS_FILE;
  CWriteXY(22,14,Replicate(14,' '));     {uses Limit of 1 Billion.}
  CWriteXY(22,14,Get(Wisdom));
END;        {09/13/08: Renamed Do_Wisdom to Do_Wisdom_Points}


{ K }PROCEDURE DO_PAID_GOLDINT;     {09/08/08: BOOLEAN: verified 09/13/08}
BEGIN
  IF TLSEdit.Paid_GoldInt = TRUE THEN TLSEdit.Paid_GoldInt:= FALSE
    ELSE IF TLSEdit.Paid_GoldInt = FALSE THEN TLSEdit.Paid_GoldInt:= TRUE;

  WRITE_WARRIORS_FILE;
  CWriteXY(59,14,Replicate(6,' '));
  CWriteXY(59,14,Get(PaidGold));
                      {position 57,14 used here}
END;


{ L }PROCEDURE DO_SLEEPING;     {09/08/08: BOOLEAN: verified 09/13/08}
BEGIN
  IF TLSEdit.Sleeping = TRUE THEN TLSEdit.Sleeping:= FALSE
    ELSE IF TLSEdit.Sleeping = FALSE THEN TLSEdit.Sleeping:= TRUE;

  WRITE_WARRIORS_FILE;
  CWriteXY(22,15,Replicate(6,' '));
  CWriteXY(22,15,Get(Asleep));
                      {position 22,15 used here}
END;


{ M }PROCEDURE DO_REALM_FIGHTS;       {Created/Verified 09/08/08}
BEGIN
  TLSEdit.IGM_Fights:=
    PromptNum(0,0,'Enter Realm Fights Left (0-250)?',
          ' Realm Fights Change', TLSEdit.IGM_Fights,0,Max_IGM_Fights,TRUE);
               {09/09/08: use Max_IGM_Fights const. value is 250.}

  WRITE_WARRIORS_FILE;         {BYTE format var}
  CWriteXY(59,15,Replicate(6,' '));
  CWriteXY(59,15,Get(Fights));
END;


{ N }PROCEDURE DO_WAS_KILLED;     {09/08/08: BOOLEAN: verified 09/13/08}
BEGIN
  IF TLSEdit.Was_Killed = TRUE THEN TLSEdit.Was_Killed:= FALSE
    ELSE IF TLSEdit.Was_Killed = FALSE THEN TLSEdit.Was_Killed:= TRUE;

  WRITE_WARRIORS_FILE;
  CWriteXY(22,16,Replicate(6,' '));
  CWriteXY(22,16,Get(Killed));
                      {position 22,16 used here}
END;


{ O }PROCEDURE DO_NEXT_TIME;       {09/09/08: verified 09/13/08}
BEGIN
  TLSEdit.Next_Time:=
    PromptNum(0,0,'Enter Day # of next Game Play (0-9,999)?',
            ' Next LORD Day Change',TLSEdit.Next_Time,0,9999,TRUE);
         {Adapted from ROL2EDIT code}

  WRITE_WARRIORS_FILE;              {WORD format var}
  CWriteXY(59,16,Replicate(6,' '));
  CWriteXY(59,16,Get(NextTime));
END;


{ P }PROCEDURE DO_ENEMY_KILLS;    {Created 09/13/08: verified 09/13/08}
BEGIN
  TLSEdit.Enemy_Kills:=
    PromptNum(0,0,'Enter Enemy Kills (0-300)?',' Enemy Kills Change ',TLSEdit.Enemy_Kills,0,300,TRUE);

  WRITE_WARRIORS_FILE;
  CWriteXY(22,17,Replicate(6,' '));
  CWriteXY(22,17,Get(Kills));
END;


{ R }PROCEDURE DO_CAMP_ATTACK;  {Created 09/13/08: verified 09/13/08}
BEGIN
  IF TLSEdit.Camp_Attack THEN TLSEdit.Camp_Attack:= FALSE
    ELSE IF NOT TLSEdit.Camp_Attack THEN TLSEdit.Camp_Attack:= TRUE;

  WRITE_WARRIORS_FILE;
  CWriteXY(59,17,Replicate(6,' '));
  CWriteXY(59,17,Get(CampAttack));
END;


{ S }PROCEDURE DO_CAMP_DEAD;      {Created 09/13/08: verified 09/13/08}
BEGIN
  IF TLSEdit.Camp_Dead THEN TLSEdit.Camp_Dead:= FALSE
    ELSE IF NOT TLSEdit.Camp_Dead THEN TLSEdit.Camp_Dead:= TRUE;

  WRITE_WARRIORS_FILE;
  CWriteXY(24,18,Replicate(6,' '));
  CWriteXY(24,18,Get(LostFight));
END;


{ T }PROCEDURE DO_FAIRY_RESCUE;   {Created 09/13/08: verified 09/13/08}
BEGIN
  IF TLSEdit.Fairy_Rescue THEN TLSEdit.Fairy_Rescue:= FALSE
    ELSE IF NOT TLSEdit.Fairy_Rescue THEN TLSEdit.Fairy_Rescue:= TRUE;

  WRITE_WARRIORS_FILE;
  CWriteXY(60,18,Replicate(6,' '));
  CWriteXY(60,18,Get(Rescued));
END;


{ U }PROCEDURE DO_FOUGHT_OLDMAN;  {Created 09/13/08: verified 09/13/08}
BEGIN
  IF TLSEdit.Fought_OldMan THEN TLSEdit.Fought_OldMan:= FALSE
    ELSE IF NOT TLSEdit.Fought_OldMan THEN TLSEdit.Fought_OldMan:= TRUE;

  WRITE_WARRIORS_FILE;
  CWriteXY(24,19,Replicate(6,' '));
  CWriteXY(24,19,Get(OMFight));
END;


{ V }PROCEDURE DO_WHO_ATTACK;      {Created 09/13/08: verified 09/13/08}
BEGIN
  TLSEdit.Who_Attack:=
    PromptStr(0,0,20,'Name of Camper''s Attacker',' Attacker''s Name Change ',TLSEdit.Who_Attack,FALSE);

  WRITE_WARRIORS_FILE;
  CWriteXY(56,19,Replicate(22,' '));
  CWriteXY(56,19,Get(WhoAttack));
END;
{ ##################################################################### }


{ note: To use Y, N responses via keyboard, one has to use
  the ALT key. Or simply use the mouse to click on the option wanted. }

{ * }PROCEDURE DO_NEW_DAY;     {Created 11/29/07: VERIFIED}
BEGIN
  CWGotoXY(5,24);
  CWriteLn('  `0Running `!"Reset Player''s Stats" `0process. 3-second delay.');

  DELAY(3000);

           { Adapted from ROL2EDIT code 09/09/08. }
  IF (TLSEdit.PlayNum < 0) OR (TLSEdit.PlayNum > 160) THEN
    BEGIN
      TLSEdit.PlayNum:= 160;

      PromptOK('Advisory:',' Resetting invalid LORD Player # field to 160. |'
					  +'The IGM will correct the field to its correct value when |'
					  +'it runs its New Day Maintenance process. ');
    END;
  { ------------------------------------------------------------------ }

  IF TLSEdit.Visits > 0 THEN        {Created 11/29/07: VERIFIED}
    BEGIN
      TLSEdit.Visits:= 0;
      PromptOK('Advisory:',' Resetting the Visits Today field to Zero.');
    END;   {BYTE format field. Can't have negative values}

  { --------------------------------------------------- }
  IF TLSEdit.HitMax < 0 THEN        {Created 11/29/07: VERIFIED 05/13/08}
    BEGIN
      TLSEdit.HitMax:= 0;
      PromptOK('Advisory:',' Reset negative Max HitPoints field to Zero.');
    END;

  IF TLSEdit.HitMax > 0 THEN        {Created 11/29/07: VERIFIED}
    BEGIN
      TLSEdit.HitMax:= 0;
      PromptOK('Advisory:',' Resetting the Max HitPoints field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLSEdit.Strength < 0 THEN      {Created 11/29/07: VERIFIED 05/13/08}
    BEGIN
      TLSEdit.Strength:= 0;
      PromptOK('Advisory:',' Reset negative Strength Points field to Zero.');
    END;

  IF TLSEdit.Strength > 0 THEN      {Created 11/29/07: VERIFIED}
    BEGIN
      TLSEdit.Strength:= 0;
      PromptOK('Advisory:',' Resetting the Strength Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLSEdit.Defense < 0 THEN       {Created 11/29/07: VERIFIED 05/13/08}
    BEGIN
      TLSEdit.Defense:= 0;
      PromptOK('Advisory:',' Reset negative Defense Points field to Zero.');
    END;

  IF TLSEdit.Defense > 0 THEN       {Created 11/29/07: VERIFIED}
    BEGIN
      TLSEdit.Defense:= 0;
      PromptOK('Advisory:',' Resetting the Defense Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLSEdit.Charm < 0 THEN         {Created 11/29/07: VERIFIED 05/13/08}
    BEGIN
      TLSEdit.Charm:= 0;
      PromptOK('Advisory:',' Reset negative Charm Points field to Zero.');
    END;

  IF TLSEdit.Charm > 0 THEN         {Created 11/29/07: VERIFIED}
    BEGIN
      TLSEdit.Charm:= 0;
      PromptOK('Advisory:',' Resetting the Charm Points field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLSEdit.Adoptions > 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Adoptions:= 0;
      PromptOK('Advisory:',' Resetting the Kids Adopted field to Zero.');
    END;     {BYTE format field. Can't have negative values}

  { --------------------------------------------------- }
  IF TLSEdit.Gems < 0 THEN          {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Gems:= 0;
      PromptOK('Advisory:',' Reset negative Gems field to Zero.');
    END;

  IF TLSEdit.Gems > 0 THEN          {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Gems:= 0;
      PromptOK('Advisory:',' Resetting the Gems field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLSEdit.Pellets > 0 THEN          {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Gold:= 0;
      PromptOK('Advisory:',' Resetting the Skill Pellets field to Zero.');
    END;      {BYTE format field. Can't have negative values}

  { --------------------------------------------------- }
  IF TLSEdit.Potions < 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Potions:= 0;
      PromptOK('Advisory:',' Reset negative Healing Potions field to Zero.');
    END;

  IF TLSEdit.Potions > 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Potions:= 0;
      PromptOK('Advisory:',' Resetting the Healing Potions field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLSEdit.Skills > 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Skills:= 0;
      PromptOK('Advisory:',' Resetting the Skill Points field to Zero.');
    END;         {BYTE format field. Can't have negative values}

  { --------------------------------------------------- }
  IF TLSEdit.Gems_Int < 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Gems_Int:= 0;
      PromptOK('Advisory:',' Reset negative Gems Interest field to Zero.');
    END;

  IF TLSEdit.Gems_Int > 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Gems_Int:= 0;
      PromptOK('Advisory:',' Resetting the Gems Interest field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLSEdit.Gold_Int < 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Gold_Int:= 0;
      PromptOK('Advisory:',' Reset negative Gold Interest field to Zero.');
    END;

  IF TLSEdit.Gold_Int > 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Gold_Int:= 0;
      PromptOK('Advisory:',' Resetting the Gold Interest field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLSEdit.GemsBank < 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.GemsBank:= 0;
      PromptOK('Advisory:',' Reset negative Treasury Gems field to Zero.');
    END;

  { 09/09/08: Never change valid Treasury Gems data. Deleted old code block. }

  { --------------------------------------------------- }
  IF TLSEdit.GoldBank < 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.GoldBank:= 0;
      PromptOK('Advisory:',' Reset negative Treasury Gold field to Zero.');
    END;

  { 09/09/08: Never change valid Treasury Gold data. Deleted old code block. }

  { --------------------------------------------------- }
  IF TLSEdit.Gold < 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Gold:= 0;
      PromptOK('Advisory:',' Reset negative Gold Found field to Zero.');
    END;

  IF TLSEdit.Gold > 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Gold:= 0;
      PromptOK('Advisory:',' Resetting the Gold Found field to Zero.');
    END;

  { --------------------------------------------------- }
  IF TLSEdit.Wisdom < 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Reset negative Wisdom Points field to Zero.');
    END;

  IF TLSEdit.Wisdom > 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Resetting the Wisdom Points field to Zero.');
    END;

  { --------------------------------------------------- }
  TLSEdit.Paid_GemsInt:= FALSE;   {Added 09/08/08}
   { --------------------------------------------------- }

  TLSEdit.Paid_GoldInt:= FALSE;   {Added 09/08/08}
  { --------------------------------------------------- }

  { Sleeping: Don't change its value. 09/13/08 edit }

  { IGM_Fights: Don't change value if it is over Zero. 09/17/08 }

  TLSEdit.Was_Killed:= FALSE;            {Added 09/08/08}
  { --------------------------------------------------- }

  { TLSEdit.Next_Time: Don't change its value. 09/09/08 }
  { ----------------------------------------------------------- }

  IF TLSEdit.Enemy_Kills < 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Enemy_Kills:= 0;
        PromptOK('Advisory:',' Reset negative Enemy Kills field to Zero.');
    END;

  IF TLSEdit.Enemy_Kills > 0 THEN        {Rewrote Created/Verified 09/08/08}
    BEGIN
      TLSEdit.Enemy_Kills:= 0;
        PromptOK('Advisory:',' Resetting the Enemy Kills field to Zero.');
    END;

  { A player could achieve more than 255 total kills during a day }
  { of both Monsters and Sleeping Campers, so VAR needs to be }
  { INTEGER format since BTYE vars can't go past 255. 09/13/08 note }
  { ----------------------------------------------------------- }

  TLSEdit.Camp_Attack:= FALSE;            {Added 09/13/08}
  { ----------------------------------------------------------- }

  TLSEdit.Camp_Dead:= FALSE;            {Added 09/13/08}
  { ----------------------------------------------------------- }

  TLSEdit.Fairy_Rescue:= FALSE;            {Added 09/13/08}
  { ----------------------------------------------------------- }

  TLSEdit.Fought_OldMan:= FALSE;            {Added 09/13/08}
  { ----------------------------------------------------------- }

  TLSEdit.Who_Attack:= ' ';               {Added 09/13/08}
     {20-character string variable. Reset to blank space}
  { ----------------------------------------------------------- }

          { 09/09/08: Adapted from ROL2EDIT code. }
  IF TLSEdit.GemsBank > Max_GemsBank THEN   {Do Over-Limit reset - Treasury Gems}
    BEGIN
      TLSEdit.GemsBank:= Max_GemsBank;

      PromptOK('Advisory:',' Resetting Over-Limit Treasury Gems to 1 Million.');  {revised 12/26/06}
    END;

  { --------------------------------------------------- }
          { 09/09/08: Adapted from ROL2EDIT code. }
  IF TLSEdit.GoldBank > TwoBillion THEN   {Do Over-Range reset - Treasury Gold}
    BEGIN
      TLSEdit.GoldBank:= TwoBillion;

      PromptOK('Advisory:',' Resetting Over-Range Treasury Gold to Two Billion.');
    END;
  { ========================================================= }
END;     { DO_NEW_DAY  ================================== }


FUNCTION  MAX_PLAYERS: WORD; { Gets the number of customer records }
BEGIN
  MAX_PLAYERS:= 1;

  Editor_Path:= S2U(IGMDIR+BonePlayer_FN);

  IF NOT Exist(Editor_Path) THEN Exit;

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  MAX_PLAYERS:= FileSize(Editor_File);

  CLOSE(Editor_File);
END;     { MAX_PLAYERS  --------------------------------------------- }


FUNCTION GetRecordNum: STRING;
BEGIN
  GetRecordNum:='`$'+N2S(RecordNum + 1)+' `%of `@'+N2S(MAX_PLAYERS);
    { First record # displayed will be 1, not 0. }
END;     { GetRecordNum ---------------------------------------------- }


PROCEDURE SHOW_MENU;          {Created 11/29/07: VERIFIED}
BEGIN
  ClrScr;

  CWritelnC('`%** `$LORD Skeleton `0Player Database Editor `!'+Version+' `%**');  {Line 1}
  CWritelnC('`@SKELPLAY.DAT `%Record Number: '+GetRecordNum);              {Line 2}
  CWriteLn(' ');

  { CwGotoXY, CWriteXY notes: X is position #, Y is Line #. }

  CWGotoXY(3,4);   { Line 4 }
  CWriteLN('`#(`%1`#) `!Real Name    `%: '+Get(RealName));

  { -------------------------------------------- }
  CWGotoXY(3,5);                {Line 5}
    CWrite('`#(`%2`#) `!LORD Name    `%: '+Get(LordName));

  CWGotoXY(45,5);
  CWriteLN('`#(`%3`#) `!Player #`%: '+Get(PlayNum));
  { -------------------------------------------- }

  CWGotoXY(3,6);                 {Line 6}
    CWrite('`#(`%4`#) `!Visits Today `%: '+Get(Visits));

  CWGotoXY(38,6);
  CWriteLN('`#(`%5`#) `!Max HitPoints  `%: '+Get(HitMax));
  { -------------------------------------------- }

  CWGotoXY(3,7);                {Line 7}
    CWrite('`#(`%6`#) `!Strength Pts `%: '+Get(Strength));

  CWGotoXY(38,7);
  CWriteLN('`#(`%7`#) `!Defense Points `%: '+Get(Defense));
  { -------------------------------------------- }

  CWGotoXY(3,8);                 {Line 8}
    CWrite('`#(`%8`#) `!Charm Points `%: '+Get(Charm));

  CWGotoXY(38,8);
  CWriteLN('`#(`%9`#) `!Kids Adopted   `%: '+Get(Adopted));
  { -------------------------------------------- }

  CWGotoXY(3,9);                 {Line 9}
    CWrite('`#(`%0`#) `!Gems Found   `%: '+Get(Jewels));

  CWGotoXY(38,9);
  CWriteLN('`#(`%A`#) `!Power Pellets  `%: '+Get(Pellets));
  { -------------------------------------------- }

  CWGotoXY(3,10);                 {Line 10}
    CWrite('`#(`%B`#) `!Heal. Potions`%: '+Get(Healing));

  CWGotoXY(38,10);
  CWriteLN('`#(`%C`#) `!Skill Points   `%: '+Get(Skills));  {09/13/08 edit}
  { -------------------------------------------- }

  CWGotoXY(3,11);                 {Line 11}
    CWrite('`#(`%D`#) `!Gems Interest`%: '+Get(GemsInt));

  CWGotoXY(35,11);
  CWriteLN('`#(`%E`#) `!Gold Interest`%: '+Get(GoldInt));
  { -------------------------------------------- }

  CWGotoXY(3,12);                 {Line 12}
    CWrite('`#(`%F`#) `!Treasury Gems`%: '+Get(Bank_Gems));

  CWGotoXY(33,12);
  CWriteLN('`#(`%G`#) `!Treasury Gold  `%: '+Get(Bank_Gold));
  { -------------------------------------------- }

  CWGotoXY(3,13);                 {Line 13}
    CWrite('`#(`%H`#) `!Gold Found   `%: '+Get(Coins));

  CWGotoXY(38,13);
  CWriteLN('`#(`%I`#) `!Paid Gems Int  `%: '+Get(PaidGems));
  { -------------------------------------------- }

  CWGotoXY(3,14);                 {Line 14}
    CWrite('`#(`%J`#) `!Wisdom Points`%: '+Get(Wisdom));

  CWGotoXY(38,14);   {09/08/08}
  CWriteLN('`#(`%K`#) `!Paid Gold Int? `%: '+Get(PaidGold));
                 {Created/Verified 09/08/08}
  { -------------------------------------------- }

  CWGotoXY(3,15);    {09/08/08}   {Line 15}
    CWrite('`#(`%L`#) `!Asleep in IGM`%: '+Get(Asleep));
                 {Created/Verified 09/08/08}

  CWGotoXY(38,15);
  CWriteLn('`#(`%M`#) `!Realm Fights   `%: '+Get(Fights));  {09/13/08 edit}
  { -------------------------------------------- }

  CWGotoXY(3,16);   {09/08/08}    {Line 16}
  CWrite('`#(`%N`#) `!Dead in Camp?`%: '+Get(Killed));
                 {Created/Verified 09/08/08}

  CWGotoXY(38,16);         {Added 09/09/09}
  CWriteLn('`#(`%O`#) `!Next Game Day  `%: '+Get(NextTime));
             {Added 09/09/08: verified 09/13/08}
  { -------------------------------------------- }

  { ################## Added 09/13/08 ######################## }

  CWGotoXY(3,17);      {Line 17}  {09/13/08: verified 09/13/08}
    CWrite('`#(`%P`#) `!Enemy Kills  `%: '+Get(Kills));  {Layout verified}

  CWGotoXY(38,17);                {09/13/08: verified 09/13/08}
  CWriteLn('`#(`%R`#) `!Attack in Camp?`%: '+Get(CampAttack));

  CWGotoXY(3,18);      {Line 18}   {09/13/08: verified 09/13/08}
    CWrite('`#(`%S`#) `!Killed in Camp?`%: '+Get(LostFight));

  CWGotoXY(38,18);                  {09/13/08: verified 09/13/08}
  CWriteLn('`#(`%T`#) `!Rescue by Fairy?`%: '+Get(Rescued));

  CWGotoXY(3,19);      {Line 19}   {09/13/08: verified 09/13/08}
    CWrite('`#(`%U`#) `!Fought Old Man?`%: '+Get(OMFight));

  CWGotoXY(34,19);                  {09/13/08: verified 09/13/08}
  CWriteLn('`#(`%V`#) `!Name of Attacker`%: '+Get(WhoAttack));

  { ######################################################### }

  BLANK(1);   {Blank line needed.  Line 20. 09/13/08 edit}
  { -------------------------------------------------- }

  CWGotoXY(3,21);                           {09/13/08 edit}
  CWrite('`2(`0X`2) `%Search by Name');     {09/13/08 edit}

  CWGotoXY(40,21);                          {09/13/08 edit}
  CWriteLn('`2(`0Y`2) `%Delete Player record');   {09/13/08 edit}
  { -------------------------------------------- }

  CWGotoXY(3,22);                              {09/13/08 edit}
  CWrite('`2(`0]`2) `%Advance One Record');    {09/13/08 edit}

  CWGotoXY(40,22);                              {09/13/08 edit}
  CWriteLn('`2(`0[`2) `%Back Up One Record');   {09/13/08 edit}
  { -------------------------------------------- }

  CWGotoXY(3,23);                               {09/13/08 edit}
  CWriteln('`2(`0*`2) `%Reset Player Stats');   {09/13/08 edit}
  { -------------------------------------------- }

  CWGotoXY(3,24);    {Line #24}      {09/13/08 edit}
  Cwrite('`$    Input key to change, or `%Q `$to quit and save.');

END;     { SHOW_MENU  ------------------------------------------------------ }



    { 09/09/08: Changed from code S to code Y for Search Player. }
{ Y }PROCEDURE DO_PLAYER_SEARCH;
VAR Counter, YN : BYTE;
    Temp, OTemp : STRING;

BEGIN
  Editor_Path:= S2U(IGMDIR+BonePlayer_FN);

  IF NOT Exist(Editor_Path) THEN Exit;
     { if no SKELPLAY.DAT then we can't search and
       couldn't have made it here to begin with. }

  Counter:= 0;
  Temp:= PromptStr(0,0,50,' Enter full or partial name: ',' Player Search ','',FALSE);
  OTemp:= Temp;
  Temp:= S2U(Temp);  { upcase the whole string }

  REPEAT
    SEARCH_PLAYER(Counter);

    { This next evaluation is checking to see if TEMP exists anywhere in  }
    {  either field of record.  If YES, then execute the next section,    }
    {  otherwise increment counter and move on.  Note: Using FUNCTION NoColor  }
    {  to strip Lord color codes for string eval and display. }

	 IF (POS(Temp,S2U(TSearch.LordName))>0) OR (POS(Temp,NoColor(S2U(TSearch.RealName)))>0) THEN
     BEGIN
       YN:= PromptYesNo('','Are you looking for:|'+TSearch.LordName+' known as '+NoColor(TSearch.RealName)+'?');

       IF YN=1 THEN {1 means YES answer}
         BEGIN
            RecordNum:= Counter; { LORD Player # to display matches the counter }

            READ_WARRIORS_FILE;
            SHOW_MENU;
            Exit; { bail out of loop since we got who we want }
          END;
     END;

    Inc(Counter);
  UNTIL Counter = MAX_PLAYERS;
     { End of repeat loop, repeats until we get to the }
     { last player record in the database file. }

  { if we make it to here, then there were no matches. }

  PromptOK(' Search Error! ','No match found for '+OTemp+'!');
END;   { DO_PLAYER_SEARCH ====================================== }



{ X }PROCEDURE DO_PLAYER_DELETION;   {Created 11/29/07: VERIFIED 05/13/08}
  VAR YN: BYTE;
BEGIN
  { I hate having to bust up lines due to "line too long" error }
  { messages! The next 3 lines are all one line of code. Chas.}

  YN:= PromptYesNo
   (' Warning Will Robinson! Player Deletion! ','Are you sure you want to delete the player :|'+TLSEdit.LordName+' known'
     +' as '+NoColor(TLSEdit.RealName)+'?');

  IF YN = 1 THEN {1 means YES answer}
    BEGIN
      TLSEdit.RealName:= 'X';
      TLSEdit.LordName:= '* DELETED *';
      TLSEdit.PlayNum:= 160;
        { Note: PlayNum 160 should not be in use by any valid players.}
      TLSEdit.Visits:= 0;

      TLSEdit.Adoptions:= 0;      {added 09/08/08. 09/13/08 relocation}
      TLSEdit.IGM_Fights:= 0;     {added 09/08/08. 09/13/08 relocation}
      TLSEdit.Pellets:= 0;        {added 09/08/08. 09/13/08 relocation}
      TLSEdit.Skills:= 0;         {added 09/08/08. 09/13/08 rename}

      TLSEdit.Enemy_Kills:= 0;    {added 09/13/08}
      TLSEdit.HitMax:= 0;
      TLSEdit.Strength:= 0;
      TLSEdit.Defense:= 0;

      TLSEdit.Charm:= 0;
      TLSEdit.Gems:= 0;
      TLSEdit.Potions:= 0;        {added 09/08/08}
      TLSEdit.Gems_Int:= 0;

      TLSEdit.Gold_Int:= 0;
      TLSEdit.GemsBank:= 0;
      TLSEdit.GoldBank:= 0;
      TLSEdit.Gold:= 0;

      TLSEdit.Wisdom:= 0;
      TLSEdit.Camp_Attack:= FALSE;     {Added 09/13/08}
      TLSEdit.Camp_Dead:= FALSE;       {Added 09/13/08}
      TLSEdit.Fairy_Rescue:= FALSE;    {Added 09/13/08}

      TLSEdit.Fought_OldMan:= FALSE;     {Added 09/13/08}
      TLSEdit.Paid_GemsInt:= FALSE;    {added 09/08/08. 09/13/08 relocation}
      TLSEdit.Paid_GoldInt:= FALSE;    {added 09/08/08. 09/13/08 relocation}
      TLSEdit.Sleeping:= FALSE;        {added 09/08/08. 09/13/08 relocation}

      TLSEdit.Was_Killed:= FALSE;      {added 09/08/08. 09/13/08 rename}
      TLSEdit.Who_Attack:= ' ';        {Added 09/13/08}
      TLSEdit.Next_Time:= 0;           {09/13/08 relocation}
      { =================================== }

      WRITE_WARRIORS_FILE;

      PromptOK(' Record Deletion: ','Actual record deletion will be handled by the IGM the |'
                 +'next day, when it runs the New Day maintenance process. ');

      SHOW_MENU;
    END;
END;       {  DO_PLAYER_DELETION ==============================  }


(*  {Disabled 03:55 pm 05/13/08 after usage}

{ # }PROCEDURE DO_NEWDAY_TESTING;   {Created 05/13/08: VERIFIED 05/13/08}
BEGIN
  TLSEdit.HitMax:= -1000;
  TLSEdit.Strength:= -1000;
  TLSEdit.Defense:= -1000;
  TLSEdit.Charm:= -1000;

  TLSEdit.Gems:= -1000;
  TLSEdit.Adoptions:= -1000;

  TLSEdit.Gold:= -1000000;         {Reset to -1,000,000}
  TLSEdit.Potions:= -1000000;       {Reset to -1,000,000}

  TLSEdit.Wisdom:= -1000000;         {Reset to -1,000,000}
  TLSEdit.Paid_Gems:= -1000000;       {Reset to -1,000,000}

  TLSEdit.Gems_Int:= -1000000;         {Reset to -1,000,000}
  TLSEdit.Gold_Int:= -1000000;       {Reset to -1,000,000}

  TLSEdit.Gold_Interest:= -1000000;         {Reset to -1,000,000}
  TLSEdit.GoldBank:= -1000000;       {Reset to -1,000,000}

  TLSEdit.GemsBank:= -1000000;         {Reset to -1,000,000}
  TLSEdit.GOLD_FOUND:= -1000000;       {Reset to -1,000,000}

  { ============================================================================== }

  WRITE_WARRIORS_FILE;

  PromptOK(' NewDay Testing: ','Variables reset to negative values for use in testing |'
               +'how the New Day for Player process handles them. ');

  SHOW_MENU;

END;  { DO_NEWDAY_TESTING ===================================== }    *)


PROCEDURE RUN_EDITOR;       {Created 11/29/07: VERIFIED}
  VAR Code: CHAR;
BEGIN
  SHOW_MENU;

  REPEAT
    Code:= AInput('1234567890ABCDEFGHIJKLMNOPQRSTUVXY][*#');
            {Added # 05/13/08 for use with DO_NEWDAY_TESTING.}
            {Added K and L. Added M & N. 09/08/08}
            { Added code 0. Changed S to Y code. 09/09/08 }
            { 09/13/08: Added codes P,R,S,T,U, and V.}

    CASE Code OF
      '1' : DO_REAL_NAME;

      '2' : DO_LORD_NAME;

      '3' : BEGIN
              CWGotoXY(1,21);   {Show text on Line 22}   {09/08/08}

              CWriteLn('  `0The `$LORD Player Number `0field is display-only.  I don''t see   ');
                             {blank spaces at end are required. 09/13/08 note}
              CWriteLn('  `0a valid reason to allow it to be edited.  2-seconds delay. ');
              CWriteLn('                                                                      ');  {09/13/08. needed here}
                   {BLANK cmd fails to clear underlying text, so can't be used here}

              DELAY(3000);    {09/13/08 edit}

              IF DebugVar THEN   {coded 07/22/07: VERIFIED 05/13/08}
                BEGIN
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is ');
                  CWriteLn('  `0allowed to modify the Player Number field.  Do so with ');
                  CWriteLn('  `@CAUTION `0because it is a `@VERY `0important database field.');
                  DELAY(2000);      {edited 07/27/08 to use 2 sec}

                  DO_PLAYER_NUMBER;
                END;

              SHOW_MENU;
            END;

      '4' : DO_VISITS;

      '5' : DO_HITMAX;

      '6' : DO_STRENGTH;

      '7' : DO_DEFENSE;

      '8' : DO_CHARM;

      { Items 9 through L Added/Edited 09/08/08 for usage }
      { with additional IGM code added from Realm of Lore IGM. }

      '9' : DO_ADOPTIONS;      {09/08/08}

      '0' : DO_GEMS_FOUND;     {09/08/08}

      'A' : DO_POWER_PELLETS;        {09/08/08}

      'B' : DO_HEALING_POTIONS;   {09/08/08}

      { Items C-J were Adapted from ROL2EDIT code: 11/29/2007 }

      'C' : DO_SKILL_POINTS;      {09/08/08}

      'D' : DO_GEMS_INTEREST;     {09/08/08}

      'E' : DO_GOLD_INTEREST;     {09/08/08}

      'F' : DO_TREASURY_GEMS;    {09/08/08}

      'G' : DO_TREASURY_GOLD;     {09/08/08}

      'H' : DO_GOLD_FOUND;        {09/08/08}

      'I' : DO_PAID_GEMSINT;     {09/13/08 rewrite}

      'J' : DO_WISDOM_POINTS;    {09/13/08 rewrite}

      'K' : DO_PAID_GOLDINT;     {09/08/08}

      'L' : DO_SLEEPING;         {09/08/08}

      'M' : DO_REALM_FIGHTS;     {09/08/08}

      'N' : DO_WAS_KILLED;           {09/08/08}

      'O' : BEGIN             {Created 09/09/08: verified 09/13/08}
              CWGotoXY(1,21);
              CWriteLn('  `0The `$Next LORD Game Day `0field is display-only.  I don''t see   ');
              CWriteLn('  `0a valid reason to allow it to be edited.  3-second delay.  ');
              CWriteLn('                                                               ');  {09/13/08. needed here}
                   {BLANK cmd fails to clear underlying text, so can't be used here}
              DELAY(3000);

              IF DebugVar THEN   {Created 09/09/08: verified 09/13/08}
                BEGIN
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is ');
                  CWriteLn('  `0allowed to modify the Next LORD Day field.  Do so with ');
                  CWriteLn('  `@CAUTION `0because editing its value may mess up the IGM.');
                  DELAY(3000);

                  DO_NEXT_TIME;
                END;

              SHOW_MENU;
            END;

      { Items P, and R through V Added 09/13/08 for usage }
      { with IGM code added from Realm of Lore IGM. }

      'P' : DO_ENEMY_KILLS;          {09/13/08}

      { ------------------------------------------------------ }
      { Q - reserved for QUIT/SAVE Changes command processing. }
      { ------------------------------------------------------ }

      'R' : DO_CAMP_ATTACK;          {09/13/08}

      'S' : DO_CAMP_DEAD;          {09/13/08}

      'T' : DO_FAIRY_RESCUE;          {09/13/08}

      'U' : DO_FOUGHT_OLDMAN;          {09/13/08}

      'V' : DO_WHO_ATTACK;          {09/13/08}
      { ==================================================== }


      'X' : DO_PLAYER_DELETION;

      'Y' : DO_PLAYER_SEARCH;   {09/09/08: Changed code from S to Y.}

      (*  '#' : DO_NEWDAY_TESTING;   {Coded 05/13/08: VERIFIED 05/13/08}  *)

      ']' : BEGIN
              Inc(RecordNum);
              IF RecordNum > (MAX_PLAYERS - 1) THEN RecordNum:= 0;  {05/07/04 edit}

              READ_WARRIORS_FILE;
              SHOW_MENU;
            END;

      '[' : BEGIN
              IF RecordNum=0
                THEN RecordNum:= (MAX_PLAYERS - 1)
                ELSE Dec(RecordNum);

              READ_WARRIORS_FILE;
              SHOW_MENU;
            END;

      '*' : BEGIN
              DO_NEW_DAY;

              SHOW_MENU;

              WRITE_WARRIORS_FILE;
            END;

    END;       {CASE Code - ending}
  UNTIL Code = 'Q';
END;       { RUN_EDITOR ---------------------------------------------------------- }


PROCEDURE EXIT_SCREEN;          {Created 11/29/07: VERIFIED}
BEGIN
  { the | character will cause a linefeed, I forget what max chars }
  { are.  Anyhow, say whatever you want here or remove it totally }

  PromptOK(' LORD Skeleton''s Player Database Editor Credits: ',
      'SKELEDIT.EXE '+Version+'.  Copyright 2007-2008 by Donald Tidmore. |'

      +'** Dedicated to my friends Wayne Brown and Paul Romine.  ** ||' {12/28/07}

      {  +'** Compile Date:  '+Compile_Date+'  Oct. 09, 2008 release. ||'  }

      +'v1.00 released officially on:  '+Release_Date+'  ||'   {Added 10/08/08}

      +'Database Path: '+Editor_Path);

         {Compile_Date and Release_Date end with period.}
END; { EXIT_SCREEN ============================================ }


BEGIN    { Main SKELEDIT.pas BEGIN/END structure }
  ClrScr;

  CursorOff;                  {Pellets Tool-Kit process}
  UseLordColors:= TRUE;

  DebugVar:= FALSE;   {07/22/07 Code}

  IF S2U(ParamStr(1)) = '/DEBUG'  {07/22/07 Code}
    THEN DebugVar:= True;

  ReadVars.ReadHelp:= NIL;  { removes the HELP button in the prompts. }   {Pellets Tool-Kit process}

  WinNoClose:= TRUE;
      { removes the prompt window close button in upper left. }
    {Gold Toolkit process}

  RecordNum:= 0;

  IF Exist('SKELPLAY.DAX') THEN DeleteFile('SKELPLAY.DAX');

  READ_CONFIG;  {process existing SKELEDIT.cfg file.}

  Editor_Path:= S2U(IGMDIR+BonePlayer_FN);

  IF Exist(Editor_Path) THEN READ_WARRIORS_FILE
  ELSE
    BEGIN
      CWriteLn(' ');
      CWriteLn('  `@ERROR:  `0SKELEDIT `!could not locate the `@LORD Skeleton''s ');
      CWriteLn('  `#SKELPLAY.DAT `!file, which is `%REQUIRED `!for you to edit ');
      CWriteLn('  `!the IGM''s database records.');

      CWriteLn(' ');
      CWriteLn('  `0SKELEDIT `!looked for this file, which was not found: ');
      CWriteLn('    `$'+Editor_Path);

      CWriteLn(' ');
      CWriteLn('  `%Requires usage of `#LORD Skeleton `!v0.78+ Betas.');    {09/08/08}

      CWriteLn('  `#Note: `%v1.00 won''t work with `!SKELETON.EXE `0v0.81+ Betas.'); {10/08/08}

      CWriteLn('  `!Terminating `0SKELEDIT `!after 3 seconds delay.  ');

      DELAY(3000);
      HALT;
    END;
  { =========================================================== }

  RUN_EDITOR;

  EXIT_SCREEN;

  ResetStartUpMode;     {Gold Toolkit process}
END. { SKELEDIT.pas }


{ Official release of v1.00 done on/around Oct. 09th, 2008. }

{ First stage code editing finished 01:51 am 11/29/2007. }
{ Player database covered down to Healing variable so far. }
{ First compile done for RealName to Healing vars version. }

{ Second stage code editing finished 03:21 am 11/29/2007 }
{ covering remaining variables from Gems_Int to Paid_Gems. }
{ 2nd stage compilations & testing finished 05:08 am. }
{ All variables are now covered by the Editor screen, }
{ and they are all tested for non-negative value situations. }
{ Changed to v0.25 Beta at 05:09 am, 11/29/2007. }

{ All other old comments moved to LRS-ARCH.TXT on 10/09/2008. }

