PROGRAM LordMenu;           {Released v1.50 on Aug. 29th, 2008.}

USES dos, crt, LordLock, Chasware;

CONST Version = '`%Version `$1.5'; 
           {08/28/08: v1.5. Do official release 08/29/08.}

      Compile_Date: STRING[22] = 'August 28, 2008.';

      Version_Date: STRING[22] = 'Aug. 29th, 2008..';  {Added 06/06/07}
{ ====================================================== }

VAR flag,miscint, x, y: INTEGER;
	 newok: BOOLEAN;
	 datafile: TEXT;
	 backup: TEXT;
	 menu: TEXT;
	 igms: TEXT;
	 test: TEXT;
	 LordPath: STRING;
	 mych: CHAR;
	 saveexit: POINTER;
	 RIP: BOOLEAN;
	 IgmCount: INTEGER;

	 Data_String: STRING[255];  {12/04/05}
	 Program_Path: STRING;     {12/04/05: Path info FOR LORDMENU.DAT config file}
	 PartyFile_FN: STRING;        {12/04/05: Path info FOR 3rdparty.dat}
	 Text_File_FN: STRING;     {12/04/05: Path info FOR ANSI or RIP text file}
		 {02/02/07: renamed Party_Path_FN to PartyFile_FN.}

	 Config_File: TEXT;  {Added 02/03/07}
	 Config_FN: STRING;  {Added 02/03/07: path to LORDMENU.DAT config file.}

	 LM2Count_FN: STRING;  {04/19/08: use to access LM2COUNT.DAT file.}
	 LM2Skip_FN: STRING;  {04/19/08: use to access LM2-SKIP.DAT file.}
	 Lines_Count: BYTE;   {04/22/08: relocated from Count_IGMs proc}

	 { OrigMode: INTEGER;  } {02/03/07: used to store video MODe.}
	 { ================================================================================ }

PROCEDURE LWrite(s: STRING);          {Added 12/04/05 from lordstat.pas}
  VAR f,g,h: STRING;
      Done: BOOLEAN;
      q: BYTE;
BEGIN
  Done:= FALSE;

  IF NOT POS('`',S) > 0 THEN
    BEGIN
      WriteLn(s);
      EXIT;
    END;

  REPEAT
    IF s[POS('`',S)+1] IN ['0','1','2','3','4','5','6','7','8','9','!','@','#','$','%'] THEN
      BEGIN
        g:= '';

        FOR Q:= 1 TO POS('`',S)-1 DO g:= g + s[q];

        Write(G);

        CASE s[POS('`',S)+1] OF
          '1': TextColor(1);       {Color: 1 - Dark Blue}
          '2': TextColor(2);       {Color: 2 - Dark Green}
          '3': TextColor(3);       {Color: 3 - Dark Cyan}
          '4': TextColor(4);       {Color: 4 - Dark Red/Magenta}
          '5': TextColor(5);       {Color: 5 - Dark Violet}
          '6': TextColor(6);       {Color: 6 - Brown}
          '7': TextColor(7);       {Color: 7 - Light Gray}
          '8': TextColor(8);       {Color: 8 - Dark Gray}
          '9': TextColor(9);       {Color: 9 - Light Blue}
          '0': TextColor(10);      {Color: 10 - Light Green}
          '!': TextColor(11);      {color: 11 - Light Cyan}
          '@': TextColor(12);      {Color: 12 - Bright Red}
          '#': TextColor(13);      {Color: 13 - Light Violet}
          '$': TextColor(14);      {color: 14 - Yellow}
          '%': TextColor(15);      {color: 15 - White}
        END;  {CASE}

        f:= '';

        FOR Q:= (POS('`',S)+2) to Length(s) DO
          f:= f + s[q];

        s:= f;
      END;  {IF S[....] - Ending}

  UNTIL POS('`',S) = 0;

  Write(s);
END;   { LWrite ====================================== }

  { 11/22/05: Fixed indentation to here. 05:19 pm }


PROCEDURE LWriteLn(s: STRING);    {Added 12/04/05 from lordstat.pas}
  VAR f,g,h: STRING;
      Done: BOOLEAN;
      q: BYTE;
BEGIN
  Done:= FALSE;

  IF NOT POS('`',S) > 0 THEN
    BEGIN
      WriteLn(s);
      EXIT;
    END;

  REPEAT
    IF s[POS('`',S)+1] IN ['0','1','2','3','4','5','6','7','8','9','!','@','#','$','%'] THEN
      BEGIN
        g:= '';

        FOR Q:= 1 TO POS('`',S)-1 DO g:= g + s[q];

        Write(G);

        CASE s[POS('`',S)+1] OF
          '1': TextColor(1);
          '2': TextColor(2);
          '3': TextColor(3);
          '4': TextColor(4);
          '5': TextColor(5);
          '6': TextColor(6);
          '7': TextColor(7);
          '8': TextColor(8);
          '9': TextColor(9);
          '0': TextColor(10);
          '!': TextColor(11);
          '@': TextColor(12);
          '#': TextColor(13);
          '$': TextColor(14);
          '%': TextColor(15);
        END; {CASE}

        f:= '';

        FOR Q:= (POS('`',S)+2) to Length(s) DO
          f:= f + s[q];

        s:= f;
      END;
	UNTIL POS('`',S) = 0;

  WriteLn(s);
END;   {LWRITELN ====================================== }


{ ############################################################## }
{ Added 02/03/07 from HUTCFG2.PAS code. }

FUNCTION GetPath(S: pathstr): STRING;
  VAR DS: dirstr;    { PathStr, etc VARs require DOS unit. }
		NS: namestr;
		ES: extstr;
BEGIN
  Fsplit(S, DS,NS,ES);
  GetPath:= DS;
END;  { GetPath =============================================== }


PROCEDURE LOCAL_PAUSE;  {Added 02/03/07 from HUTCFG2 code.}
  VAR MKey: CHAR;
BEGIN;                  { FOR Local MODe screen usage only. }
  LWriteLn('     `$<`@PAUSE`$> ');
  MKey:= ReadKey;          { ReadKey: not usable remotely. }
END;   { LOCAL_PAUSE ========================================= }


	{Added 02/03/07 using MODIFied HUTCFG2.PAS code.}
FUNCTION ASK_LORD_PATH(Orig_Path:STRING): STRING;
  VAR ALP_Done: BOOLEAN;
      ALP_Temp: STRING;
BEGIN
  ALP_Done:= FALSE;

  REPEAT
    ALP_Temp:= '';
    BLANK(1);
    LWriteLn('`0  Path to LORD files `%(EX. C:\Internet\Lord\)? `!');
    READLN(ALP_Temp);

    IF Copy(ALP_Temp,Length(ALP_Temp),1) <> '\'
      THEN ALP_Temp:= ALP_Temp+'\';

    ALP_Temp:= S2U(ALP_Temp);  {Capitalize data STRING. 02/03/07}

    IF ALP_Temp='\' THEN
      BEGIN
        ALP_Temp:= Orig_Path;
        ALP_Done:= TRUE;
      END
    ELSE
      BEGIN
        IF NOT Exist(ALP_Temp+'LORD.EXE') THEN
          BEGIN
            BLANK(1);
            LWriteLn('  `0That is `#NOT `@LORD''s directory`%! ');
            LWriteLn('    `!"LORD.EXE" `0was not found there`%!');
            BLANK(1);

            LOCAL_PAUSE;
          END
        ELSE  ALP_Done:= TRUE;
      END;
  UNTIL ALP_Done;

  BLANK(1);
  LWriteLn('  `!Your `@LORD `!path was accepted. Resuming execution of `0LORDMENU.'); {02/03/07}

  ASK_LORD_PATH:= ALP_Temp;

  DELAY(2000);
END;   { ASK_LORD_PATH ==================================== }


   { Created 02/03/07 using MODIFied LPEDIT32.PAS code.}
   { Used FOR purpose of testing new code FOR LordMenu.PAS use.}
   { Code tested inside HUTCFG2.PAS AND fully Verified 02/03/07. }
PROCEDURE READ_LORDMENU_CONFIG;     {Created 02/03/07. Verified 02/03/07}
  VAR RLC_Temp: STRING;
  { =================================== }

  PROCEDURE MAKE_CONFIG;      {Created 02/03/07: Verified 02/03/07}
  BEGIN
	  { Obtain info from user FOR location of LORD game: }

    BLANK(1);
    LWriteLn('  `$LORDMENU.EXE `!could not locate its config file `%LORDMENU.DAT.');
    LWriteLn('  `!Please type the directory path to your LORD game below.');
       {Verified both statements 02/03/07}

    LordPath:= ASK_LORD_PATH(RLC_Temp);   {Verified 02/03/07}
       {Data STRING returned is already capitalized,}
       {AND already has ending backslash added, IF needed.}

    { ------------ Content of WRITE_LORDMENU_CONFIG ---------- }
    Config_FN:= LordPath+'LORDMENU.DAT';    {Verified 02/03/07}

    FileMode:= $12;

    ASSIGN(Config_File,Config_FN);    {Verified 02/03/07}
    REWRITE(Config_File);

    WriteLn(Config_File,LordPath);

    CLOSE(Config_File);
    { ---------------------------------------------------- }

    BLANK(1);
    LWriteLn('  `0Finished writing `!LORDMENU.DAT `%data file.');   {Verified 02/03/07}
    LWriteLn('    `%Created file:  `$'+Config_FN);  {Verified 02/03/07}
  END;   { -------------------------------------------- }

BEGIN
  Config_FN:= 'LORDMENU.DAT';  {LordPath isn't known yet.}

  IF NOT Exist(Config_FN) THEN MAKE_CONFIG;

  FileMode:= $12;

  ASSIGN(Config_File,Config_FN);
  RESET(Config_File);

  READLN(Config_File,LordPath);

  CLOSE(Config_File);

  Config_FN:= LordPath+'LORDMENU.DAT';
    {Re-establish value of Config_FN, now that LordPath value is known.}

END;   { READ_LORDMENU_CONFIG ---------------------------------- }
{ ==================== END 02/03/07 test code ============== }


PROCEDURE myexit;
BEGIN
  ExitProc:= Saveexit;

  ClrScr;

  HALT(0);
END; {myexit}


FUNCTION UCase(s:STRING): STRING;
  VAR plz: INTEGER;
      zlp: STRING;
BEGIN
  FOR plz := 1 TO length(s) DO zlp[plz]:= UpCase(s[plz]);
  UCase := zlp;
END; {UpCase}


{ 04/18/08 note: replace with Chasware unit's Cwgoto_Xy code }

FUNCTION sgoto_xy(x,y:INTEGER): STRING;
  VAR s,s2: STRING;
BEGIN
  s:= #27+'[';
  STR(y,s2);
  s:= s+s2;
  STR(x,s2);
  s:= s+';'+s2+'f';
  sgoto_xy := s;
END; {sgoto_xy}


FUNCTION lord2ansi(s: STRING): STRING;
  VAR az: INTEGER;
      bz: CHAR;
      cz: STRING[255];  {12/04/05: Changed from STRING;  to STRING[255]; DGT}
BEGIN
  cz:= '';

  FOR az := 1 TO length(s) DO
    BEGIN
      IF s[az]='`' THEN
        BEGIN
          bz:= s[az+1];
          CASE bz of
            '1': cz:= cz+'[0;40;34m';
            '2': cz:= cz+'[0;40;32m';
            '3': cz:= cz+'[0;40;36m';
            '4': cz:= cz+'[0;40;31m';
            '5': cz:= cz+'[0;40;35m';
            '6': cz:= cz+'[0;40;33m';
            '7': cz:= cz+'[0;40;37m';
            '8': cz:= cz+'[1;40;30m';
            '9': cz:= cz+'[1;40;34m';
            '0': cz:= cz+'[1;40;32m';
            '!': cz:= cz+'[1;40;36m';
            '@': cz:= cz+'[1;40;31m';
            '#': cz:= cz+'[1;40;35m';
            '$': cz:= cz+'[1;40;33m';
            '%': cz:= cz+'[1;40;37m';
          END; {CASE bz}
		  END; {color}

      IF (s[az-1]<>'`') AND (s[az]<>'`') THEN cz:= cz+s[az];
    END; {length s}

  lord2ansi:= cz;
END; {lord2ansi}


FUNCTION stripped(t: STRING): STRING;
BEGIN
  FOR miscint := 1 TO length(t) DO IF t[miscint] ='`'
    THEN DELETE(t,miscint,2);

  stripped := t;
END; {stripped}


PROCEDURE GetNewColor(ch1,ch2: CHAR;flag:byte;VAR f,b:byte;VAR newok:BOOLEAN);
  VAR sb,c:byte;
BEGIN
  newok:= TRUE;

  CASE ch2 of
     '1'..'9': c:= byte(ch2)-48;
     '0': c:= 10;
     '!': c:= 11;
     '@': c:= 12;
     '#': c:= 13;
     '$': c:= 14;
     '%': c:= 15;
     '^': IF flag=1 THEN c:= 0;

	  ELSE NewOk:= FALSE;
  END;  {CASE CH2}

  CASE ch1 of
	  '`':  IF c<>b THEN f:= c;

    '~':  BEGIN
            sb:= c MOD 8;
            IF sb<>f THEN b:= sb;
          END;
  END;  {CASE CH1}
END;



	{ Created 04/19/08. Verified 04/19/08 }
PROCEDURE COUNT_IGMS;
  VAR LordParty, Counter_File, Skip_File: TEXT;
				{04/19/08 5:10 pm. Renamed TempFile to Counter_File}
      CI_Temp: STRING;
      IGMs_Count, Skip_Count: BYTE;  {04/22/08: moved Lines_Count to global vars}

  CONST Search1: STRING = '.EXE *';       {used by DDIGM-based IGMs}
				  {04/19/08 4:38 pm: Changed VAR to CONST, changed name.}
          {Used by: Realm of Vanadia igms; Haunted House, Larissa's Lair, }
          {Morph's Gymnasium, Weapons of War, LORD Wheel. }

        Search2: STRING = '.EXE /N*';       {used by ANGEL-based IGMs}
          {04/19/08 4:38 pm: Changed VAR to CONST, changed name.}
          { Used by: Fairy Town, Caves of Despair, Starport, }
          { Fun & Games, Warrior's Graveyard v2.0b, Midsummer's Dream, }
          { Forest of the Raven, Seth's Cottage, Elaikses Tower, Ski Resort. }

        Search3: STRING = '\SHAUNA *';   {used by SHAUNA igm}

        Search4: STRING = '.BAT *';
          {used by WISE ONE, Daemonica, Latrine, Lester's Palace igms}
          {Village of the Phoenix, Robin Hood, The Lottery, Gate Way To Heaven}

        Search5: STRING = 'GRIZ *';        {Grizelda's House}
        Search6: STRING = 'APOTH *';       {The Apothecary}
        Search7: STRING = '/TLORD /N*';    {Felicity's Temple, Gallagher's Performance}
          {Also used by Haunted Mansion}

        Search8: STRING = 'JADOV *';       {Jadov}
        Search9: STRING = 'JUNKYARD /N*';  {Lord Junkyard}
        Search10: STRING = 'BACKALLY.EXE';   {Thor's Backalley Bar}
        Search11: STRING = 'BACHURCH.EXE';   {Thor's Backalley Church}

        Search12: STRING = '.EXE /CP';     {Joanne's Tavern, Marty's Mercantile, }
          {A Visit To Santa Claus, Overlord's Quik-E-Mart, Lord Stables by K. Parish }
          {Nudist Colony, Xenon's Town Square, Juancho's Paradise, Lord Hunter}
          {Kaldor's Court, Dave's Inn, Blarney Stone, Vampire of Shadow Vale, }
          {Warlock of Shadow Vale. 04/22/08: Castle Colddrake}

        Search13: STRING = 'SUBURB *';       {Lord Suburbia}
        Search14: STRING = '.EXE LORD *';    {Moondust County Fair}
        Search15: STRING = 'SLOTTO *';       {Seth's Tribute Lotto}

        Search16: STRING = '.EXE /L ';       {Village Stables, Village Well}
          {Village Blacksmith, Village Mine, Village Dump}

        Search17: STRING = 'FOI\ /N*';       {Forest of Intrigue}
        Search18: STRING = 'LORDWHOR *';     {Lord's Brothel}
        Search19: STRING = 'SKULL.EXE /C';   {Old Skull Inn}
        Search20: STRING = 'EGYPT *';   {City of the Sun}
        Search21: STRING = 'CLAN.DAT /N*';  {Clan Master's Inn}
        Search22: STRING = 'PMARKET *';  {Player's Market}
        Search23: STRING = 'LMCHAP13 *';  {Chapel of St. George}
        Search24: STRING = 'CROSSINN *';  {Crossroads Inn}
        Search25: STRING = 'KNIGHTS *';   {Knights of the Golden Horseshoe}
        Search26: STRING = 'OLDMAN /N*';  {The Old Man}

        Search27: STRING = '.EXE -D';    {04/22/08: Used by Seth's Cottage}
          {Used by all Manndoor-based LORD/32 IGMs also. 04/25/08 note}

  LABEL Skip_Counter_Code;
BEGIN;
  BLANK(1);

  LWriteLn('  `# `%Counting number of IGMs installed in `$3RDPARTY.DAT `%... ');

  PartyFile_FN:= LordPath+'3RDPARTY.DAT';
  LM2Count_FN:=  LordPath+'LM2COUNT.DAT';  {work file #1. 04/19/08 4:47 pm}
  LM2Skip_FN:=   LordPath+'LM2-SKIP.DAT';  {work file #2. 04/19/08 4:47 pm}

  IGMs_Count:= 0;   {initialize IGMs Counter VAR to zero}
  Skip_Count:= 0;   {initialize Skipped Lines VAR to zero}
  Lines_Count:= 0;  {initialize Total Lines Checked VAR to zero}

  {04/19/08 4:44 pm: Changed from COUNTIGM.TMP to LM2COUNT.DAT}

  IF EXIST(LM2Count_FN) THEN EraseFile(LM2Count_FN);   {04/19/08 4:47 pm}
     {if 1st temp work file exists, delete it now.}

  IF EXIST(LM2Skip_FN) THEN EraseFile(LM2Skip_FN);     {04/19/08 4:47 pm}
     {if 2nd temp work file exists, delete it now.}
  { ==================================================== }

  FileMode:= $12;   {Added 04/19/2008 for 3RDPARTY.DAT file}
	 {Used to replace Lockfile and Unlockfile command lines}

  ASSIGN(LordParty,PartyFile_FN);   {Access & Open LORD 3rdparty.dat file}
  RESET(LordParty);

  FileMode:= $12;   {Added 04/19/2008 for LM2COUNT.DAT file}

  ASSIGN(Counter_File,LM2Count_FN);     {Create & Open Lordmenu work file #1}
  REWRITE(Counter_File);

	 {Added 4 lines for usage of LM2Skip.DAT file 04/19/08 4:24 pm}

  FileMode:= $12;   {Added 04/19/2008 for LM2-SKIP.DAT file}

  ASSIGN(Skip_File,LM2Skip_FN);     {Create & Open LordMenu work file #2}
  REWRITE(Skip_File);

  WHILE NOT EOF(LordParty) DO
    BEGIN
      ReadLn(LordParty,CI_Temp);

      INC(Lines_Count,1);

      CI_Temp:= NoColor(CI_Temp);
      CI_Temp:= S2U(CI_Temp);
        {Remove LORD color codes from text string}
        {Capitalize all letters used in text string}

        { Determine if the data line is for an IGM Command Line entry: }
      IF (POS(Search1,CI_Temp) <> 0)
              {Covers syntax required by most DDIGM-based IGMs}

          OR (POS(Search2,CI_Temp) <> 0)
                {Covers syntax required by ANGEL-based IGMs}

          OR (POS(Search3,CI_Temp) <> 0)  OR (POS(Search4,CI_Temp) <> 0)

          OR (POS(Search5,CI_Temp) <> 0)  OR (POS(Search6,CI_Temp) <> 0)

          OR (POS(Search7,CI_Temp) <> 0)  OR (POS(Search8,CI_Temp) <> 0)

          OR (POS(Search9,CI_Temp) <> 0)  OR (POS(Search10,CI_Temp) <> 0)

          OR (POS(Search11,CI_Temp) <> 0)  OR (POS(Search12,CI_Temp) <> 0)

          OR (POS(Search13,CI_Temp) <> 0)  OR (POS(Search14,CI_Temp) <> 0)

          OR (POS(Search15,CI_Temp) <> 0)  OR (POS(Search16,CI_Temp) <> 0)

          OR (POS(Search17,CI_Temp) <> 0)  OR (POS(Search18,CI_Temp) <> 0)

          OR (POS(Search19,CI_Temp) <> 0)  OR (POS(Search20,CI_Temp) <> 0)

          OR (POS(Search21,CI_Temp) <> 0)  OR (POS(Search22,CI_Temp) <> 0)

          OR (POS(Search23,CI_Temp) <> 0)  OR (POS(Search24,CI_Temp) <> 0)

          OR (POS(Search25,CI_Temp) <> 0)  OR (POS(Search26,CI_Temp) <> 0)

          OR (POS(Search27,CI_Temp) <> 0)  THEN     {04/22/08}

        BEGIN
            { Bypass any lines that include the following text phrases: }

          IF (POS('PARTY SOFTWARE OPTION',CI_Temp) <> 0) OR
               (POS('EXAMPLE OF CORRECT USAGE',CI_Temp) <> 0) OR
               (POS('PROGRAM.EXE <PARMS>',CI_Temp) <> 0) OR
               (POS('NAME AS IT APPEARS TO USERS',CI_Temp) <> 0) OR
               (POS('TWO LINES ARE NEEDED',CI_Temp) <> 0)  THEN
            BEGIN
              WriteLn(Skip_File,'SKIPPED LINE: '+CI_Temp);  {04/19/08 4:25 pm}
                 {Write IGM data string line to the LM2-SKIP.DAT file.}

              INC(Skip_Count,1);

              GOTO Skip_Counter_Code;
            END;

            { --- Done if data string is an IGM Command Line entry: --- }
          INC(IGMs_Count,1);
            {Increment Installed IGMs Counter by 1}

          WriteLn(Counter_File,CI_Temp);
            {Write IGM command line to the LM2COUNT.DAT file.}

          Skip_Counter_Code:  {LABEL. 04/19/08}
          { ---------------- }
        END
      ELSE        { Data line was not an IGM Command Line entry: }
        BEGIN
          WriteLn(Skip_File,'BYPASSED LINE: '+CI_Temp);  {04/19/08 4:25 pm}
              {Write IGM data string line to the LM2-SKIP.DAT file.}

          INC(Skip_Count,1);
        END;
    END;  {While loop}

  {Stopped using Unlockfile commands 5:09 pm 04/19/08}

  CLOSE(LordParty);
  CLOSE(Counter_File);
  CLOSE(Skip_File);        {04/19/08 4:29 pm}

  BLANK(1);
  LWriteLn('  `0Finished processing `%3RDPARTY.DAT.  `0Number of installed ');
  LWriteLn('  `0IGMs detected is:  `$'+N2S(IGMs_Count)+'.  `0Number of text lines in the file');
  LWriteLn('  `0skipped is:   `@'+N2S(Skip_Count)+'.  `0Total lines checked in the `@LORD');
  LWriteLn('  `!"Other Places" `0data file was:  `!'+N2S(Lines_Count)+'.');

  BLANK(1);
  LWriteLn('  `0LordMenu may not detect some igms with unorthodox IGM command line ');
  LWriteLn('  `0syntax, so the Installed IGMs Count may not always be correct.');
  LWriteLn('  `#------------------------------------------------------------- ');

  DELAY(2000);  {04/18/08 debug usage}

  BLANK(1);
END;   {COUNT_IGMS ======================================= }


PROCEDURE MAKE_MENU;
  VAR xyz, t: STRING;
BEGIN
  ClrScr;

  PartyFile_FN:= LordPath+'3RDPARTY.DAT';

  IF NOT EXIST(PartyFile_FN) THEN
    BEGIN
      LWriteLn('   `!You need to set the correct path to `@LORD `!before making the menu.');
      LWriteLn('   `%-=<`#press a key`%>=-');  {02/03/07: used light violet}

      mych:= ReadKey;
      mych:= #0;

      EXIT;
    END;       {NOT file exists 3rdparty.dat}

  BLANK(1);   {added 04/18/2008}

  LWriteLn('   `!Writing file now ....');

  FileMode:= $12;   {Added 06/12/07}

  ASSIGN(test,LordPath+'LMTEST.TXT');    {02/03/07: added LordPath}
		  {used for making the RIP Graphics Menu file.}
  REWRITE(test);

  PartyFile_FN:= LordPath+'3RDPARTY.DAT';

  ASSIGN(igms,PartyFile_FN);
  RESET(igms);

  WHILE NOT EOF(igms) DO
    BEGIN
      READLN(igms,Data_String);

      IF (pos(';',Data_String) <> 1) AND (Data_String <> '')
        THEN WriteLn(test,Data_String);
    END;  {WHILE NOT EOF(igms)}

  CLOSE(igms);
  CLOSE(test);

  { ===================== Debug code block ============================ }

  COUNT_IGMS;  {Added/Verified 04/19/08: Perform count # of installed igms}

	  { Detected IGMs count is not perfect, but process does accurately }
	  { count the total # of lines in 3RDPARTY.DAT. 04/22/08 notes. }
  { ========================== end of debug code ====================== }

  (*  LWriteLn('  `!Test of Dennis''s code:  There are `$'+N2S(Measure(PartyFile_FN))+' `!igms installed.');
	  {04/25/08 debug code: verified}  {Disabled 03:20 pm after testing. 04/25/08}  *)

  Text_File_FN:= LordPath+'3RDALT.TXT';

  IF EXIST(Text_File_FN) THEN
    BEGIN
      FileMode:= $12;   {Added 06/12/07}

      ASSIGN(backup,LordPath+'3RDALT.BAK');
      REWRITE(backup);

      FileMode:= $12;   {Added 06/12/07}

      ASSIGN(menu,Text_File_FN);    {Create new 3RDALT.TXT file}
      RESET(menu);

      WHILE NOT EOF(menu) DO
        BEGIN
          READLN(menu,Data_String);
          WriteLn(backup,Data_String);
        END;  {While NOT EOF(menu)}

      CLOSE(menu);           {Closes the 3RDALT.TXT file}
      CLOSE(backup);         {Closes the 3RDALT.BAK temp file}

      BLANK(1);

      LWriteLn('   `!Old menu saved as `%3RDALT.BAK');
      BLANK(1);
    END; {3RDALT.TXT exists}

  FileMode:= $12;   {Added 06/12/07}

  ASSIGN(menu,Text_File_FN);   {Re-open the 3RDALT.TXT file}
  REWRITE(menu);

  IF RIP THEN      {Used for RIP Graphics Menu}
    BEGIN
      WriteLn(menu,'[0;30;40m[2J');
      WriteLn(menu,'');
      Write(menu,'!|1K|*|w0000270L02|1B0Z0E020QOY0209000F080700000F0700000Z|Y00000100');
      Write(menu,'|1U2T8W00000000<>0<>0|1U3X8W00000000<>1<>1|1U518W00000000<>2<>2');
      Write(menu,'|1U658W00000000<>3<>3|1U798W00000000<>4<>4|1U8D8W00000000<>5<>5');
      Write(menu,'|1U9H8W00000000<>6<>6|1UAL8W00000000<>7<>7|1UBP8W00000000<>8<>8');
      Write(menu,'|1UCT8W00000000<>9<>9|1UDX8W00000000<>0<>0');
      Write(menu,'|1B1Y0E020QOY020A000F080700000F0700001Y|1U0Q8W00000000<><enter><>^M');
      WriteLn(menu,'|1UF18W00000000<><enter><>^M|#|#|#');
    END; {rip}

  Write(menu,'[?7h[40m[2J[0;34m [1;46m[5C[40m[46m[3C[40m[46m[3C[40m   [s');
  Write(menu,'[u[0;34m[2;1H [1;46m[40m  [46m[40m[s');
  Write(menu,'[u[46m[1C[40m [46m[40m  [46m[40m  [0;34m[3;1H[s');
		{*********** CHANGED from WRITE to WRITELN *****************}

  WriteLn(menu,'[u [1;37mChoose your path wisely [0;34m <[1;30;40m ');
	  {04/18/08: Added ending ANSI code sequence at Jason Hud's suggestion}

  x:= 3;
  y:= 4;
  IgmCount:= 0;

  FileMode:= $12;   {Added 06/12/07}

  ASSIGN(igms,LordPath+'LMTEST.TXT');   {02/03/07: added LordPath}
  RESET(igms);

  WHILE NOT EOF(igms) DO
    BEGIN
      INC(IgmCount);    {Counts # of lines in 3RDPARTY.DAT}

      IF (((IgmCount - 1) MOD 40) = 0) AND (IgmCount <> 1) THEN
        BEGIN
          IF rip THEN Write(menu,sgoto_xy(1,5))
            ELSE Write(menu,sgoto_xy(1,2));

          FOR miscint:= 1 TO 23 DO WriteLn(menu,'');

    Write(menu,'[?7h[40m[2J[0;34m [1;46m[5C[40m[46m[3C[40m[46m[3C[40m   [s');
    Write(menu,'[u[0;34m[2;1H [1;46m[40m  [46m[40m[s');
    Write(menu,'[u[46m[1C[40m [46m[40m  [46m[40m  [0;34m[3;1H[s');
                   {*********** CHANGED from WRITE to WRITELN *****************}

    { 06/06/07: These 3 lines *HAVE* to be written this way due to }
    { fact that Pascal statements can't exceed 128 spaces in length. }

          WriteLn(menu,'[u [1;37mChoose your path wisely [0;34m');
          x:= 3;
          y:= 4;
        END;  {IF statement - ending}

      READLN(igms,Data_String);
      READLN(igms,Data_String);

      STR(IgmCount,xyz);

      IF (pos('$$$ LORDOPOLY $$$',UCase(stripped(Data_String)))>0)
        THEN LWriteLn('   `0$$$ `!LORD`%opoly `0$$$')

        ELSE IF (pos('LORD COUNTY FAIR:',UCase(stripped(Data_String)))>0)
          THEN LWriteLn('   `!LORD County Fair ')

          ELSE IF (pos('SEARCH THE FOREST FOR VIOLET',UCase(stripped(Data_String)))>0)
          THEN LWriteLn('   `%Search for `#Violet''s Cottage');
      { End of IF statement }

      {********************** ROUTINES CHANGED ************************}
      IF odd(IgmCount) THEN  {ADDED}
        {Old code:}  { Write(menu,sgoto_xy(x,y)+'[1;40;37m[[1;40;36m'+xyz+'[1;40;37m][40;37m '+lord2ansi(Data_String))}

        Write(menu,sgoto_xy(1,y)+'[1;37m[[36m'+xyz+'[37m] '{[37m} +lord2ansi(Data_String))
                    {^this sets the column to 1}

      ELSE  {ADDED}
        BEGIN
          {Old code: }   {WriteLn(menu,sgoto_xy(x,y)+'[1;40;37m[[1;40;36m'+xyz+'[1;40;37m][40;37m '+lord2ansi(Data_String));  }

          WriteLn(menu,sgoto_xy(40,y)+'[1;37m[[36m'+xyz+'[37m] '{[37m}+lord2ansi(Data_String));
                     {^this sets the column to 40}
          INC(y); {ADDED increments the line count starting at line 4}
        END;
        {**********************************************}
    END;  {WHILE NOT EOF(igms)}

  CLOSE(igms);

  WriteLn(menu,'[0;40;37m');

  CLOSE(menu);

  FileMode:= $12;   {Added 06/12/07}

  ASSIGN(test,LordPath+'LMTEST.TXT');    {02/03/07: added LordPath}
  {$I-}   ERASE(test);  {$I+}

  x:= 0;

  LWriteLn('   `!Completed `%... `!The `$Other Places `!in `@LORD `!now uses the');
  LWriteLn('   `!menu I created `%...  `!Go play `@LORD `!AND check it out.');

  BLANK(1);

  LWriteLn('   `%-=<`#press a key`%>=-');   {02/03/07: used light violet}

  mych:= ReadKey;
  mych:= #0;
END; {MAKE_MENU}


	 { 06/06/07: Created Program_Info proc. }
PROCEDURE PROGRAM_INFO;      {Edited 06/06/07: VERIFIED 06/12/07}
BEGIN
  BLANK(1);

  LWriteLn('    `@LORD Utility`%: `0LordMenu `%'+Version+'.');

  LWriteLn('    `!Compile Date:  `$'+Compile_Date);  {edited 07/12/07}
  BLANK(1);

  LWriteLn('    `0v1.50: `!Officially released on:  `#'+Version_Date);  {07/12/07}
  BLANK(1);           {re-enabled 2 lines 08/28/08}

  LWriteLn('  `#============================================================== ');
  LWriteLn('  `@ `$AUTHOR`%:   `0Donald Tidmore  `#- `$ktidmore@bellsouth.net');
  LWriteLn('      `0Fidonet Mail`%:  `$Donald Tidmore 1:123/450.');
  LWriteLn('  `@ `!Copyright `0Donald Tidmore `%2006-2008.');    {06/12/07: moved up to here}
  BLANK(1);

  LWriteLn('  `@ `$Adopted from`%:  `0Lloyd Hannesson.  `!Copyright `%2002-2006.');  {edited 07/12/07}
  LWriteLn('  `@ `$Created by`%:    `0Robert Fogt. `!Copyright `%1998.');
  BLANK(1);

  LWriteLn('  `@ `!Dedicated to `%Robert Fogt `!and `%Lloyd Hannesson.');
  BLANK(1);

  LWriteLn('  `@ `!Supported platforms:  `!DOS LORD `%and `!LORD/32.');
  BLANK(1);

END;  { PROGRAM_INFO ====================================== }


BEGIN {main program}
  { OrigMode:= LastMODe;  } {02/03/07: Save user's current video MODe.}

  BLANK(1);  {Added 04/18/2008}
  LWriteLn('     `!Loading `0LordMenu `%..... `!Processing config file. ');
	  {02/03/07: Added "LordMenu", "Processing config file." to statement.}

  SaveExit:= Exitproc;
  ExitProc:= @myexit;

  Program_Path:= GetPath(paramSTR(0));     {Added 02/03/07: Verified}
	  { returns drive & directory path with ending backslash }
	  { FOR where LORDMENU.EXE has been executed from. }

  Program_Path:= S2U(Program_Path);  {02/03/07: capitalize program path}

  { ###################################################################### }
  READ_LORDMENU_CONFIG;     {Created 02/03/07. Verified 02/03/07}

	  { 02/03/07: Accesses LORDMENU.DAT file to get LORD's location from it. }
	  { IF file does not exist, it is created by asking user where LORD is. }
	  { Only works IF LORD.EXE is in directory specIFied by the user. }

	  { 02/03/07: Verified that LORDMENU.EXE knows correct value of Config_FN }
	  { at this point after execution of READ_LORDMENU_CONFIG. }

  Config_FN:= LordPath+'LORDMENU.DAT';  {Insurance code against glitches}

	 { 05/28/07: deleted disabled debug testing statements. }

  DELAY(2500);  {Added 02/03/07}

  { ############## end of 02/03/07 code. ################################# }

  PartyFile_FN:= LordPath+'3RDPARTY.DAT';  {rewrote to use LordPath 02/03/07}

  IF NOT EXIST(PartyFile_FN) THEN   {Verified 05/28/07}
    BEGIN
      { ====================== Added 02/03/2007 ========================= }
      { 02/03/07 Note: IF 3RDPARTY.DAT does not exist in the LORD directory }
      { THEN there is NO point in continuing to execute LORDMENU.  So it will }
      { now show an error message AND terminate immediately. Donald. }

      BLANK(1);   {02/03/07}
      LWriteLn('  `@ERROR:  `!Can not find a 3RDPARTY.DAT file to process.');   {02/03/07}
      LWriteLn('  `%Searched FOR:  `0'+PartyFile_FN);      {02/03/07}
      BLANK(1);  {02/03/07}         {Verified 05/28/07}

      LWriteLn('  `!Terminating execution of `$LORDMENU.EXE `!in 3 seconds.');   {02/03/07}
      DELAY(3000);  {02/03/07: Verified 05/28/07}
        {short delay is needed FOR use while testing program from compiler.}

      HALT(0);  {02/03/07}
      { ==================== end of 02/03/07 code block ============ }
    END {no 3rdparty.dat}
  ELSE
    BEGIN
      DELETE(LordPath,pos('LORDMENU.EXE',LordPath),12);
    END;  {3rdparty.dat found}

  REPEAT
    ClrScr;

    LWriteLn('   `!LordMenu '+version+' `%by `0Donald Tidmore.');
    BLANK(1);  {12/04/05}

    LWriteLn('   `!Config File:  `$'+Config_FN);  {02/03/07: Verified}
    BLANK(1);   {02/03/07}

    LWriteLn('   `0LordMenu `!creates an alternate menu that is displayed by ');
    LWriteLn('   `@LORD `!when a player enters `!Other Places `0from the main menu.');
    LWriteLn('   `!You must have the game of `@LORD `!version 3.50 or higher ');
    LWriteLn('   `!installed on your system. ');

    BLANK(1);
    LWriteLn('   `!You should run this program every time you `0Add or Remove `!an IGM.');
    LWriteLn('   `!Or when you revise IGM entry lines inside the `%3RDPARTY.DAT `!file.');

    BLANK(1);
    LWriteLn('     `@[`$1`@] `0LORD Path:  `$'+LordPath);
    LWriteLn('     `#Note:  `%Change the LORD Path IF it is not correct.');

    LWriteLn('     `@[`$2`@] `0Create Menu `!with RIP support');
    LWriteLn('     `@[`$3`@] `0Create Menu `!without RIP support');
    LWriteLn('     `@[`$4`@] `0Uninstall LordMenu.');
    LWriteLn('     `@[`$5`@] `0View program info screen.');  {Added 06/06/07}
    BLANK(1);   {06/06/07}       {06/12/07: Changed I code to 5.}

    LWriteLn('     `@[`$Q`@] `0Quit');  {06/12/07: changed to use Q code only.}

    BLANK(1);
    LWriteLn('  `!Option 2 is the preferred menu.  Use `%Q `!to exit LordMenu.');   {06/12/07: Added second sentence}
    LWriteLn('  `0Use option 3 if you hate RIP, or you don''t use it.');
		  {02/03/07: Split into two sentences FOR better readability on WinXP screens.}
		  { 06/06/07: Added ",or you don't use it." clause.}

    BLANK(1);
    LWrite('  `!Enter 1,2,3,4,5 or Q `%(for Quit) `0-=> `$ ');
			 {06/12/07: Changed LWriteLn to LWrite.}

    mych:= ReadKey;
    mych:= UpCase(mych);

    LWriteLn('  `$'+mych);  {06/12/07}

    CASE mych of
      '1': BEGIN
             LordPath:= ASK_LORD_PATH(LordPath);  {Added 02/03/07}

             PartyFile_FN:= LordPath+'3RDPARTY.DAT';

               { 02/03/07 note: IF NOT EXIST code block is not needed now, }
               { since LORDMENU is now configured to terminate IF 3rdparty.dat }
               { file does not exist.  Keep for awhile in case I'm wrong. }

             IF NOT EXIST(PartyFile_FN) THEN
               BEGIN
                 BLANK(1);
                 LWriteLn('   `!ERROR!!  Could not find 3rdparty.dat, incorrect path');

                 BLANK(1);
                 LWriteLn('   `%-=<`#press a key`%>=-');  {02/03/07: used light violet}

                 mych:= ReadKey;
                 mych:= #0;

                 LordPath := '`$UNKNOWN!!  `%set this first.';
               END;   {IF NOT Exist}
           END; {1}

      '2': BEGIN
             RIP:= TRUE;

             MAKE_MENU;
          END; {2}

     '3': BEGIN
            RIP:= FALSE;

            MAKE_MENU;
          END; {3}

     '4': BEGIN
            x:= 0;
            ClrScr;

            BLANK(1);
            Text_File_FN:= LordPath+'3RDALT.TXT';

            IF EXIST(Text_File_FN) THEN
              BEGIN
                FileMode:= $12;   {Added 06/12/07}

                ASSIGN(menu,Text_File_FN);
                {$I-}  ERASE(menu);   {$I+}

                IF ioresult <> 0 THEN
                  BEGIN
                    LWriteLn('   `@ERROR:  `!Could NOT delete 3RDALT.TXT file.');  {06/06/07 edit}
                    LWriteLn('   `!So you must delete the file from DOS manually.');
                       {06/06/07: Split into two statements.}
                  END {ioresult <>0}
                ELSE
                  BEGIN
                    LWriteLn('   `!Successful ... 3RDALT.TXT deleted ... LORD is back to normal.');
                  END;

                BLANK(1);
                LWriteLn('   `%-=<`#press a key`%>=-');  {02/03/07: used light violet}

                mych:= ReadKey;
                mych:= #0;
              END  {file 3RDALT.TXT exists}
            ELSE
              BEGIN  {3RDALT.TXT file not found}
                LWriteLn('   `!Could not find 3RDALT.TXT!!!!');

                BLANK(1);

                LWriteLn('   `!Either LordMenu has not been installed, or the Path is incorrect.');

                BLANK(1);
                LWriteLn('   `%-=<`#Press a key`%>=-');     {02/03/07: used light violet}

                mych:= ReadKey;
                mych:= #0;
              END; {3RDALT.TXT does not exist}
          END; {4}

     '5': BEGIN         {Added 06/06/07: Rewrote 06/12/07: verified}
            BLANK(1);
            LWriteLn('   `!Displaying `0LordMenu `!program info.');

            PROGRAM_INFO;  {Created 06/06/07: verified}

            LWriteLn('   `%-=<`#Press a key`%>=-');

            mych:= ReadKey;
            mych:= #0;
          END;

     'Q': BEGIN        {06/12/07: Changed from 5 to Q.}
                {06/12/07: Changed PartyFile_FN references to Config_FN.}
            Config_FN:= LordPath+'LORDMENU.DAT';        {02/03/07: added LordPath}
                 {06/12/07: Changed from 3RDPARTY.DAT to LORDMENU.DAT}

            IF NOT EXIST(Config_FN) THEN
              BEGIN
                FileMode:= $12;   {Added 06/12/07}

                ASSIGN(Config_File,Config_FN);  {02/03/07: changed to use Config_FN.}
                REWRITE(Config_File);

                Write(Config_File,LordPath);

                CLOSE(Config_File);
                    {02/03/07: Changed 4 lines to use Config_File instead of DataFile.}
              END;       {no 3rdparty.dat}
          END; {5}
    END; {CASE}
  UNTIL (mych = 'Q');  {06/12/07: dropped "OR (Mych = '5') coding.}
	  {02/03/07: dropped usage of "AND (Mych='R')" section.}

  WriteLn(' ');        {Added 02/03/07}
END.  {main program}

{ Notes: Can not figure out why program clears screen when it exits. }
{ Tried saving current video MODe AND restoring it, but that didn't help. }
{ Disabled the OrigMode lines since they didn't help any. 02/03/07 Dgt. }

       {DGT: Changed compile date.  Changed to v1.34. 01/18/07}
		 {DGT. v1.36. Used after finished testing of LORDMENU.DAT }
       { file access AND file creation code processes. 02/03/07. }

{ 06/06/07: Fixed code indentation, entire file. }

     { 01/17/06: removed Chasware unit after Dennis Collins updates done. }
     { 01/18/06: Includes revisions made by Dennis Collins on Jan. 18th. }
        {07/12/07: Changed 1.38 to 1.40. non-beta}
 {06/06/07: v1.38 Beta}
        {04/18/2008: Changed to v1.41 Beta}
        {05/01/08: v1.42 beta}
  { 04/18/2008: Restored usage of Chasware unit. }

