#!/usr/bin/perl
# By Russ Johnson, 10/10/99 
# Distributed under the GPL.
# Please send any modifications to Russ Johnson at russj@dimstar.net for
# inclusion in future versions.
#
# Version 1.0
#
# Cleanfiles - A file area cleaner for BBBS.  

die "usage: cleanfiles.pl <regex filename> <lt|gt> <age in days>\n" unless @ARGV==3;

opendir(dir, ".");@files = grep(/$ARGV[0]/, readdir(dir));closedir(dir);

exit if ($#files == -1);

foreach $file (@files)
{
 if (-M $file > $ARGV[2] && $ARGV[1] eq "gt")
 {
  unlink($file) unless -d $file;
 }
  if (-M $file < $ARGV[2] && $ARGV[1] eq "lt")
 {
  unlink($file) unless -d $file;
 }
}

$files="@files";
$length=@files;

open(desc, "descript.ion")  || die "can't open file descript.ion -- $!";
open(tmp, ">tmp.$$$") || die "can't open tmp.$$$ -- $!";

while($file = <desc>)
{
 chomp ($file);
 @name = split(/ /,$file);
 @files = split(/ /,$files);
 $idx=0;
 while($idx < $length)
 {
  if ($files[$idx] eq $name[0])
  {
   print tmp ($file,"\n");
  }
  $idx++;
 }
}

unlink ("descript.ion") || die "Can't delete the old descript.ion file -- $!";
rename ("tmp.","descript.ion") || die "Can't move tmp. to descript.ion -- $!";
