Uses
  Crt, TpzCrc;

Const
  Version       = '1.00';

  Jam_Deleted   = $80000000;
  JamSubBufSize = 4096;

Type

   JamSubBuffer = Array[1..JamSubBufSize] of Char;

   JamHdrType = Record                                 { .JHR start }
                  Signature: Array[1..4] of Char;
                  Created: LongInt;
                  ModCounter: LongInt;
                  ActiveMsgs: LongInt;
                  PwdCRC: LongInt;
                  BaseMsgNum: LongInt;
                  HighWaterMark: Longint;
                  Extra: Array[1..996] of Char;
                End;

JamMsgHdrType = Record                                 { .JHR 1024 }
                  Signature   : Array[1..4] of Char;
                  Rev         : Word;
                  Resvd       : Word;
                  SubFieldLen : LongInt;
                  TimesRead   : LongInt;
                  MsgIdCrc    : LongInt;
                  ReplyCrc    : LongInt;
                  ReplyTo     : LongInt;
                  ReplyFirst  : LongInt;
                  ReplyNext   : LongInt;
                  DateWritten : LongInt;
                  DateRcvd    : LongInt;
                  DateArrived : LongInt;
                  MsgNumber   : LongInt;
                  Attr1       : LongInt;
                  Attr2       : LongInt;
                  TextOfs     : LongInt;
                  TextLen     : LongInt;
                  PwdCrc      : LongInt;
                  Cost        : LongInt;
                End;

   JamIdxType = Record                          { .JDX }
                  MsgToCrc    : LongInt;
                  HdrLoc      : LongInt;
                End;

  JamLastType = Record                          { .JRL }
                  NameCrc     : LongInt;
                  UserNum     : LongInt;
                  LastRead    : LongInt;
                  HighRead    : LongInt;
                End;

 SubFieldType = Record
                  LoId        : Word;
                  HiId        : Word;
                  DataLen     : LongInt;
                  Data        : Array[1..1000] of Char;
                End;

    TxtType = Array[1..65000] of char;

    JamType = Record
                Hdr           : JamHdrType;
                MsgHdr        : JamMsgHdrType;
                HdrFile       : File;
                Idx           : JamIdxType;
                IdxFile       : File of JamIdxType;
                Last          : JamLastType;
                LastFile      : File of JamLastType;
                TxtFile       : File;
                SubField      : SubFieldType;
              End;

Var
  OldHdrFile    : File;
  OldTxtFile    : File;
  OldIdxFile    : File of JamIdxType;

  NewHdrFile    : File;
  NewTxtFile    : File;
  NewIdxFile    : File of JamIdxType;

  LastFile      : File of JamLastType;

  Hdr           : JamHdrType;
  MsgHdr        : JamMsgHdrType;
  Idx           : JamIdxType;

  LastNum       : Byte;
  Last          : Array[1..16] of JamLastType;
  SubField      : SubFieldType;
  Txt           : ^TxtType;
  MsgToUser     : String;

  Path          : String[79];
  Count         : Longint;

  Deleted       : Boolean;
  TotalMsg      : Longint;
  TotalDeleted  : Longint;

Function LowCrc32String(s:string):longint;
Var
  Crc32:longint;
  x:byte;
Begin
  If s='' Then LowCrc32String:=0
  Else Begin
    For x:=1 to length(s) Do
      If (s[x] in ['A'..'Z']) Then s[x] := Chr(Ord(s[x]) + 32);
    crc32:=$FFFFFFFF;
    For x:=1 to Length(s) Do Crc32:=UpdC32(Ord(s[x]),crc32);
    LowCrc32String:=Crc32;
  End;
End;

Function StUpCase(S : String) : String;
Var
  SLen : Byte Absolute S;
  x    : Byte;
Begin
  For x := 1 To SLen Do S[x]:=UpCase(S[x]);
  StUpCase := S;
End;

Procedure Stop;
Begin
  WriteLn('');
  Halt;
End;

Begin

  ClrScr;

  WriteLn('');
  WriteLn(' Program   TerMail JAM-packer UNLIMITED messages '+Version+' FREEWARE by Bo Bendtsen');

  If Paramcount<>1 Then
  Begin
    WriteLn(' Syntax    JAMPACK jam-base');
    WriteLn(' Example   JAMPACK ECHO\TERMINAT');
    Stop;
  End;

  Path:=StUpcase(Paramstr(1));

  New(Txt);

  WriteLn(' JAM-base  '+Path);
  WriteLn(' Packed    0');
  WriteLn(' Deleted   0');

  TotalMsg:=0;
  TotalDeleted:=0;
  LastNum:=0;

  Assign(OldHdrFile,Path+'.JHR');
  Assign(OldTxtFile,Path+'.JDT');
  Assign(OldIdxFile,Path+'.JDX');

  Assign(NewHdrFile,Path+'.$HR');
  Assign(NewTxtFile,Path+'.$DT');
  Assign(NewIdxFile,Path+'.$DX');

  Assign(LastFile,Path+'.JLR');

  {$I-} Reset(OldHdrFile, 1); {$I+}
  If IOResult<>0 Then
  Begin
    WriteLn(' File ?    '+Path+'.JHR');
    Stop;
  End;

  {$I-} Reset(OldTxtFile, 1); {$I+}
  If IOResult<>0 Then
  Begin
    WriteLn(' File ?    '+Path+'.JDT');
    Stop;
  End;

  {$I-}
  Rewrite(NewHdrFile, 1);
  Rewrite(NewTxtFile, 1);
  Rewrite(NewIdxFile);
  {$I+}
  If IOResult<>0 Then
  Begin
    WriteLn(' Error     Could not open temporary files');
    Stop;
  End;

  {$I-} Reset(LastFile); {$I+}
  If IOResult=0 Then
  Begin
    While (LastNum<16) And Not Eof(LastFile) Do
    Begin
      Inc(LastNum);
      Read(LastFile,Last[LastNum]);
    End;
    Close(LastFile);
  End;

  BlockRead(OldHdrFile, Hdr, SizeOf(Hdr));
  Inc(Hdr.ModCounter);
  BlockWrite(NewHdrFile, Hdr, SizeOf(Hdr));

  While Not Eof(OldHdrFile) And Not Keypressed Do
  Begin

    BlockRead(OldHdrFile, MsgHdr, SizeOf(MsgHdr));

    Deleted:=MsgHdr.Attr1 And Jam_Deleted<>0;

    If Not Deleted Then
    Begin

      Idx.HdrLoc:=FilePos(NewHdrFile);

      If MsgHdr.TextLen>65000 Then MsgHdr.TextLen:=65000;
      Seek(OldTxtFile,MsgHdr.TextOfs);
      MsgHdr.TextOfs:=FilePos(NewTxtFile);

      Inc(TotalMsg);

      For Count:=1 To LastNum Do
        If Last[Count].LastRead=MsgHdr.MsgNumber Then
          Last[Count].LastRead:=TotalMsg;

      MsgHdr.MsgNumber:=TotalMsg;

      BlockRead(OldTxtFile,Txt^,MsgHdr.TextLen);
      BlockWrite(NewTxtFile,Txt^,MsgHdr.TextLen);
      BlockWrite(NewHdrFile, MsgHdr, SizeOf(MsgHdr));

      GotoXY(14,4);

    End
    Else Begin
      Inc(TotalDeleted);
      GotoXY(14,5);
    End;

    WriteLn(MsgHdr.MsgNumber);

    MsgToUser:='';

    If MsgHdr.SubFieldLen>0 Then
    Begin
      Count:=1;
      While (Count <= MsgHdr.SubFieldLen) Do
      Begin

        BlockRead(OldHdrFile, SubField, 8);

        If SubField.Datalen>Sizeof(Subfield.Data) Then
        Begin
          Seek(OldHdrFile,Filepos(OldHdrFile)+Subfield.DataLen);
          Subfield.LoId:=$FF;
          Subfield.HiId:=$FF;
        End
        Else Begin
          If Not Deleted Then
            BlockWrite(NewHdrFile, SubField, 8);
          BlockRead(OldHdrFile, SubField.Data, SubField.DataLen);
          If Not Deleted Then
            BlockWrite(NewHdrFile, SubField.Data, SubField.DataLen);
        End;
        Inc(Count,SubField.DataLen+8);

        If SubField.LoId=3 Then
        Begin {MsgTo}
          MsgToUser[0] := Chr(SubField.DataLen and $ff);
          Move(SubField.Data, MsgToUser[1], Ord(MsgToUser[0]));
        End;

      End;
    End;

    If Not Deleted Then
    Begin
      Idx.MsgToCrc:=LowCrc32String(MsgToUser);
      Write(NewIdxFile,Idx);
    End;

  End;

  Dispose(Txt);

  Close(OldHdrFile);
  Close(OldTxtFile);

  Close(NewHdrFile);
  Close(NewTxtFile);
  Close(NewIdxFile);

  GotoXY(1,6);

  If Keypressed Then
  Begin
    WriteLn(' Program   Aborted');
    Erase(NewHdrFile);
    Erase(NewTxtFile);
    Erase(NewIdxFile);
  End
  Else Begin

    WriteLn(' Removed   ',TotalDeleted);
    WriteLn(' Total     ',TotalMsg);
    WriteLn(' Program   Database packed and re-indexed.');

    Erase(OldHdrFile);
    Erase(OldTxtFile);
    Erase(OldIdxFile);

    Rename(NewHdrFile,Path+'.JHR');
    Rename(NewTxtFile,Path+'.JDT');
    Rename(NewIdxFile,Path+'.JDX');

    If LastNum>0 Then
    Begin
      ReWrite(LastFile);
      For Count:=1 To LastNum Do
      Begin
        If Last[Count].LastRead>Last[Count].HighRead Then
          Last[Count].HighRead:=Last[Count].HighRead;
        Write(LastFile,Last[Count]);
      End;
      Close(LastFile);
    End;

  End;

  Stop;

End.
