{
  TheOne Oneliner for RA sourcecode (c) 1999 Vertigo/Dementia.

  Original a PPE for PcBoard by D-Vibe/Rebels. Coded for RA in 1998 by
  Vertigo/Dementia. This sourcecode is released under the GNU GPL, of
  which you will find a copy in the archive named COPYING. If you don't
  have a copy of the GPL, please visit the website of the Free Software
  Foundation at http://www.fsf.org to obtain your own copy.

  Some of the credits for this code go to Madcat, since this sourcecode
  is derived from LawLiners 2.0 and he's the principal author of the
  LawLiners 1.xx series. Also big thanks to Synopsis for providing
  his door units.
}

Program DementiaTheOne;

Uses Main,Fossil,RA,Who,RAUsered,SpChat;

{============================================================================
                               data structs
=========================================================================== }

Const ConstMaxLines = 20;
      LinerBlockX   = 2;
      LinerBlockY   = 2;
      LineLength    = 48;
      EditScrX      = 16;
      EditScrY      = 12;
      EditColor     = 15;
      Version       = 'v1.10';
Type

 LinerType = record
                Writer : String[35];
                Text   : String[LineLength];
              end;

 LinerMainType = array[1..ConstMaxLines] of LinerType;
 LinerFileType = File of LinerMainType;

 LConfigRecord = Record
                   DefLineCol    : byte;
                   MaxWrites     : byte;
                   Seperate      : Boolean;
                   RandomCls     : Boolean;
                   Handle	 : Boolean;
	           TopTenUcase   : Boolean;
                   UseQuotes     : Boolean;
                   AllowMacros   : Boolean;
		   CenterLiners  : Boolean;
                   ZandaScreen   : Boolean;
                 End;

 ConfigFileType = File Of LConfigRecord;

 LUserRecord    = record
                     Name : string[35];
                     Wrote: word;
                  end;

 UserArray      = Array[1..1700] of LUserRecord;
 UserFileType   = File of UserArray;

 LStatRecord    = Record
                    TotalFireUps       : Word;
                    TotalLines         : Word;
                    TotalWriteSessions : Word;
 		  End;

 LStatFileType = File Of LStatRecord;

(* ==========================================================================
                                VARIABLES
========================================================================== *)


Var { global vars, explanation below. Only 5 of them. Could've been worse. }
{files}
  LinerFile     : LinerFileType;
  ConfigFile    : ConfigFileType;
  UserFile      : UserFileType;
  Lines         : LinerMainType;
  StatFile	: LStatFileType;
  Config        : LConfigRecord;
  Stats		: LStatRecord;
  TempLine      : LinerType;
  UserList	: ^UserArray;
{globs}
  ViewLiners  	: Boolean; { Current Status of toggle -> View liners, View usernames }
  ViewEgg	: Boolean; { Is user in the easteregg? }
  HasWritten    : Boolean; { Has the User written a liner in this session? }
  NrWritten     : byte;    { Nr of Lines user wrote this session; }
  t		: char;    { Temp character }
{==}

Const
  ConfigFileName = 'THEONE.CFG';
  LinerFileName  = 'THEONE.DAT';
  StatFileName   = 'THEONE.STT';
  UserFileName   = 'THEONE.USR';
  LineAnsiName 	 = 'THEONE.ANS';
  EditAnsiName   = 'THEDIT.ANS';
  TwitName	 = 'TWIT.LST';


(* ==========================================================================
   CONVERT STRING TO AMiGA-LiKE ELITE CASE (MOD FROM SYNOPSIS' FUNCTION)
========================================================================== *)


Function ACase(Const HStr:String):String;assembler;
asm
		push	ds
		lds	si,HStr
		les	di,@result
		lodsb
		stosb
		xor	ah,ah
		xchg	cx,ax
		jcxz	@@99
@@10:		lodsb
		cmp	al,'a'
		jb	@@11
		cmp	al,'z'
		ja	@@11
		sub	al,32
@@11:		cmp	al,'I'
		je	@@40
		jne	@@50
@@40:		add	al,32
@@50:		stosb
		loop	@@10
@@99:		pop	ds
end;



(* ==========================================================================
                       SYNOPSIS' DOOR INIT FUNCTONS
========================================================================== *)

procedure initparams;
var
  i    : byte;
  para : string;
  ch   : char;

  procedure helpscreen;
  begin
    FClrScr;
    Fwriteln('========================================================');
    Fwriteln(' Usage : theone.exe [options]'#10);
    Fwriteln(' [Options] are : -C<ComPort>      Set ComPort');
    Fwriteln('                 -N<Node>         Set Node');
    Fwriteln('                 -? or -H         This HelpScreen');
    Fwriteln('========================================================');
    Writeln('');
    halt(1);
  end;

begin
  for i:=1 to paramcount do
  begin
     para:=ucase(paramstr(i));
     if (para[1]='-') or (para[1]='/') then
      begin
        ch:=para[2];
        delete(para,1,2);
        case ch of
         'C' : FParaSetPort(para);
         'N' : FUser.Node:=Val(para);
     '?','H' : helpscreen;
        else
         helpscreen;
        end;
       end;
   end;
end;

procedure init;
begin
{check para's}
  if (length(getenv('RA')) < 1) then
  begin
    writeln('Cannot find the RA environment setting!');
    halt(10);
  end else
  begin
    radir := getEnv('RA');
    if (radir[length(radir)] <> '\') then radir := radir + '\';
  end;
  initparams;
{DoorInfo}
  if not RAInit then Error(RAErrorTxt);
   RADoesTitle:=Title;
{Init Fossil}
  if not FInitDoor then
   Error(FErrorTxt);
end;


(* ==========================================================================
                      MOVING PRESS-ENTER PROMPT
========================================================================== *)
Procedure MovingAnyKey;
Const
  MovingWords : array[1..13] of string=( '@X07P@X08rESS ENTER',
   					 '@X0FP@X07r@X08ESS ENTER',
                                         '@X07P@X0Fr@X07E@X08SS ENTER',
					 '@X08P@X07r@X0FE@X07S@X08S ENTER',
					 '@X08Pr@X07E@X0FS@X07S @X08ENTER',
					 '@X08PrE@X07S@X0FS @X08ENTER',
					 '@X08PrES@X07S E@X08NTER',
					 '@X08PrESS @X0FE@X07N@X08TER',
					 '@X08PrESS @X07E@X0FN@X07T@X08ER',
					 '@X08PrESS E@X07N@X0FT@X07E@X08R',
					 '@X08PrESS EN@X07T@X0FE@X07R',
					 '@X08PrESS ENT@X07E@X0FR',
					 '@X08PrESS ENTE@X07R');

Var
  Tel : byte;
  TempX,Tempy : Byte;
  XyPos : XYAttr;
  ctmp : char;
Begin
  Tel :=1;
  FGetXYAttr(XyPos);
  While True do
  Begin
    FgotoXy(XyPos.X,XyPos.Y);
    FWrite(MovingWords[Tel]);
    FDelayKey(1);
    if FKeyPressed then
    begin
      FReadKey;
      Break;
    end;
    If Tel<13 then Inc(tel) else Tel :=1;
  End;
End;


(* ==========================================================================
                         TITLE FADE EASTEREGG THINGIE
========================================================================== *)

Procedure FadeTitle;

 Procedure Fadewrite(str:string; x:byte; y:byte);
 const colors : array[1..11] of byte = (15,11,7,3,9,8,9,3,7,11,15);
 var tmp:byte;
 begin
   for tmp:= 1 to 11 do
   begin
     fgotoxy(x,y);
     fcolor(colors[tmp]);
     fwrite(str);
     fdelay(1);
   end;
 end;

Const FadeMtrx : array[1..3] of string = ('THE','ONELiNER','V1.06');
Const xfadepos : array[1..3] of byte   = (17,21,30);
Var   tmp      : byte;
Begin
  for tmp:=1 to 3 do fadewrite(fademtrx[tmp],xfadepos[tmp],1)
End;


(* ==========================================================================
                               ACRONYM CONVERSION
========================================================================== *)


function isklinker(chr : char) : boolean;
const klinker : string[5] = 'aeiou';
var t:byte;
begin
  isklinker := false;
  for t := 1 to 5 do
  begin
    if (chr = klinker[t]) then
    begin
      isklinker := true;
      exit;
    end;
  end;
end;


function acronym(name:string) : string;
var i,t : byte;
    acr : string;
begin
  acr:='';
  i:=0;
  while (i<length(name)) and (length(acr)<3) do
  begin
    inc(i);
    if isklinker(name[i]) or (name[i] = ' ') then continue
       else acr := acr + name[i];
  end; { hardcoded stuff :( }
  if (name='Vertigo')    or (name='vertigo') then acr:='vtg';
  if (name='Silence')    or (name='silence') then acr:='slc';
  if (name='Da Butcher') or (name='Da butcher') then acr:='db ';
  acronym := acr;
end;


(* ==========================================================================
                            EXIT FADE THINGIE
========================================================================== *)

Procedure ExitFade;

Procedure Fadewrite(str:string; x:byte; y:byte);
const colors : array[1..11] of byte = (8,9,3,7,11,15,11,7,3,9,8);
var tmp:byte;
begin
  for tmp:= 1 to 11 do
  begin
    fgotoxy(x,y);
    fcolor(colors[tmp]);
    fwrite(str);
    fdelay(1);
  end;
end;


var tmp:byte;
begin
    for tmp:= 1 to 8 do
    begin
      fgotoxy(53,13+tmp); fwrite('                            ');
    end;
    fgotoxy(60,17);
    fdelay(1);
    fadewrite('Maybe next time, ok?',57,17);
end;


(* ==========================================================================
                           DISPLAY PICTURE EASTEREGG
========================================================================== *)

Procedure EasterEgg;
Begin
 ViewEgg := true;
 fdelay(1); fgotoxy(1,2);   fwrite('@X08                     @X06');
 fdelay(1); fgotoxy(1,3);   fwrite('@X08              @X06@X6C@X07');
 fdelay(1); fgotoxy(1,4);   fwrite('@X08           @X06@X6C@X0C@X6C@X07');
 fdelay(1); fgotoxy(1,5);   fwrite('@X08           @X6C@X0C@X6C޲@X07');
 fdelay(1); fgotoxy(1,6);   fwrite('@X08          @X06@X6C@X0C@X6C@X0C');
 fdelay(1); fgotoxy(1,7);   fwrite('@X08          @X6C@X0C');
 fdelay(1); fgotoxy(1,8);   fwrite('@X08          @X6C@X0C@X6C@X07');
 fdelay(1); fgotoxy(1,9);   fwrite('@X08          @X06@X6C@X0C@X6C߲@X0C');
 fdelay(1); fgotoxy(1,10);  fwrite('@X08         @X68 @X06  @X08  @X06@X0C@X6C߲@X0C');
 fdelay(1); fgotoxy(1,11);  fwrite('@X08        @X06 @X6C@X0C@X06 @X07@X0F @X06@X0C');
 fdelay(1); fgotoxy(1,12);  fwrite('@X08        @X06@X6C@X06@X6C@X0C@X06@X6C@X0C');
 fdelay(1); fgotoxy(1,13);  fwrite('@X08         @X06@X6C@X0F @X0C');
 fdelay(1); fgotoxy(1,14);  fwrite('@X08    @X03 @X06@X0C@X6C@X0C@X6C@X0C');
 fdelay(1); fgotoxy(1,15);  fwrite('@X08  @X0B@X3B@X03@X38@X06@X6C@X0C@X6C@X0C@X6C@X0C');
 fdelay(1); fgotoxy(1,16);  fwrite('@X08  @X38 @X3B@X03۲@X38@X06@X6C@X0C@X6C@X06@X6C@X0C@X6C@X0C');
 fdelay(1); fgotoxy(1,17);  fwrite('@X08  @X38@X03@X38@X03@X38@X03@X6C@X0C@X6C@X06@X6C@X0C@X6C@X0C');
 fdelay(1); fgotoxy(1,18);  fwrite('@X08  @X38@X0F @X06@X6C@X06@X6C@X0C @X06@X6C@X07');
 fdelay(1); fgotoxy(1,19);  fwrite('@X08  @X38@X08@X06@X6C@X06@X6C@X0F @X6C@X06 ');
 fdelay(1); fgotoxy(1,20);  fwrite('@X08  @X38@X08@X06@X6C@X0C@X06@X08@X04  @X06@X6C@X0C @X06');
 fdelay(1); fgotoxy(1,21);  fwrite('@X08   @X6C@X06 @X08 @X04 @X08 @X0C @X06@X6C@X06@X07');
 {===============================} fdelay(5);
 fdelay(1); fgotoxy(26,2);  fwrite('@X06                    ');
 fdelay(1); fgotoxy(26,3);  fwrite('@X6C @X68@X08             ');
 fdelay(1); fgotoxy(26,4);  fwrite('@X6C@X68@X06  @X08          ');
 fdelay(1); fgotoxy(26,5);  fwrite('@X0C@X6C@X06@X6C@X06   @X68@X0F         ');
 fdelay(1); fgotoxy(26,6);  fwrite('@X0C@X6C@X06    @X68@X0F        @X08');
 fdelay(1); fgotoxy(26,7);  fwrite('@X0C@X6C@X06@X6C@X06   @X68@X0F       ');
 fdelay(1); fgotoxy(26,8);  fwrite('@X0C@X06@X0C@X6C@X0C@X6C@X06  @X68@X0F       ');
 fdelay(1); fgotoxy(26,9);  fwrite('@X6C@X0C@X06@X0C@X6C@X06@X6C@X06   @X68@X0F      ');
 fdelay(1); fgotoxy(26,10); fwrite('@X0C@X6Cܲ@X0C@X06 @X08 @X6C@X06   @X68@X0F      ');
 fdelay(1); fgotoxy(26,11); fwrite('@X0C@X6C@X0C@X06 @X07@X0F  @X06   @X08@X68@X08    ');
 fdelay(1); fgotoxy(26,12); fwrite('@X0C@X6C@X06@X0C@X6C@X06@X6C@X06  @X08     ');
 fdelay(1); fgotoxy(26,13); fwrite('@X0C@X6C@X06@X0C@X6C@X0C@X6C@X06 @X08  .   ');
 fdelay(1); fgotoxy(26,14); fwrite('@X0C@X6C@X0C@X6C@X0C@X6C@X0C@X6C@X06   @X08@X03@X08 ');
 fdelay(1); fgotoxy(26,15); fwrite('@X0C @X6C@X0C@X6C@X0C@X6C@X0C@X06      @X08@X03@X38@X0F');
 fdelay(1); fgotoxy(26,16); fwrite('@X6C@X0F @X0C@X6C@X0C@X6C@X0C@X6C@X06@X6C@X06@X08     @X38@X0F');
 fdelay(1); fgotoxy(26,17); fwrite('@X0C @X6C@X0C@X6C@X06@X6C@X0F @X08     @X38@X08 ');
 fdelay(1); fgotoxy(26,18); fwrite('@X6C@X0C @X6C@X0C@X6C@X0F @X08      @X38@X08 ');
 fdelay(1); fgotoxy(26,19); fwrite('@X08   @X0C@X6C@X0C@X6C@X06@X6C@X0F @X08      @X38@X08 ');
 fdelay(1); fgotoxy(26,20); fwrite('@X6C@X0C @X6C@X06        @X08 ');
 fdelay(1); fgotoxy(26,21); fwrite('@X06@X0C@X6C@X0C@X06           @X08  ');
 {===============================} FadeTitle;
End;


(* ==========================================================================
                                INFO SCREENS
========================================================================== *)


Procedure TwitScreen;
Begin
  RaUserDoes('DMA TheOne '+version+' - User is a twit!');
  FSaveScreen;
  FClrScr;
  FwriteLn('');
  FwriteLn('@X08');
  Fwriteln('');
  FwriteLn('  @X0F Forget that idea buddy! The sysop locked you out from writing lines!');
  FwriteLn('                            You''re Twit-Listed !');
  FwriteLn('');
  FwriteLn('@X08');
  FGotoXy(35,9);
  MovingAnyKey;
  FRestoreScreen;
  RaUserDoes('DMA TheOne '+version+' - Browsing Menu');
End;

Procedure NoMoreScreen;
Begin
  RaUserDoes('DMA TheOne '+version+' - Viewing InfoScreen');
  FSaveScreen;
  FClrScr;
  FwriteLn('');
  FwriteLn('@X08');
  Fwriteln('');
  FwriteLn('                         @X0F Uh-Uh! Forget that idea! =]');
  Fwrite('                    You allready stated your opinions ');
  If (config.MaxWrites>1) then FwriteLn(Str(config.MaxWrites)+' times now!') else FwriteLn('for now!');
  FwriteLn('');
  FwriteLn('@X08');
  FGotoXy(35,9);
  MovingAnyKey;
  FRestoreScreen;
  RaUserDoes('DMA TheOne '+version+' - Browsing Menu');
End;

Procedure InfoScreen;
Begin
  RaUserDoes('DMA TheOne '+version+' - Viewing Info');
  FSaveScreen;
  FClrScr;
  FwriteLn('@X07 .___%\____:__%\_______%\___ ..__%\__%\_______%\__.:.___________%\____%\____..');
  FwriteLn('  \______  \\____________  \ :%  _______________  \%O ____.O .________o ._%:.');
  FwriteLn('   \O\\  \O.\____Oo\  \%  %o.o.\___%o.\  \o __%oo.%\ \O \:L');
  FwriteLn('  . o: |\  o|%__%\.\    /. /__%:O\  .  |:.O /:.> \.\');
  FwriteLn(' : _|. |_|_\ . |\__\%   \ ./:    |\_%|_. \     |.  ./ .%___\  \');
  FwriteLn('  %__________|________   |\%.%|__||________  \ \___| |   |_%___________\a');
  FwriteLn('  \___________\_______|__| | \%:.\__\\______%|__| \%__/  |.|__|:%____________%a');
  Fwrite('@X08 @X07\__\|@X08@X07.@X08@X07.@X08@X07/__/@X08@X07:.@X08');
  FwriteLn('@X07|%__/@X08=@X07.@X08');
  FwriteLn('@X07');
  FwriteLn('  You are looking at TheOne '+version+', coded by Vertigo/Dementia. This is the ');
  FwriteLn('  Ra-door version of a ppe originally released by D-Vibe/Rebels, so all the ');
  FwriteLn('  credits for the design and the ansi''s go to him. If you happen to run pcb,');
  FwriteLn('  please check out D-Vibe''s ppe''s, they rock.');
  FwriteLn('');
  FwriteLn('           @X08[@X0FY@X08] @X07  - Enter a line');
  FwriteLn('           @X08[@X0FN@X08] @X07  - Quit The OneLiner, quits to the bbs.');
  FwriteLn('           @X08[@X0FW@X08] @X07  - Who wrote what line, shows usernames.');
  FwriteLn('           @X08[@X0FI@X08] @X07  - Info and helpscreen, you''re looking at it.');
  FwriteLn('           @X08[@X0F*,!@X08]@X07 - Easter eggs, try them!');
  FwriteLn('');
  FwriteLn(' @X08@X07');
  FGotoXy(35,22);
  MovingAnyKey;
  FRestoreScreen;
  RaUserDoes('DMA TheOne '+version+' - Browsing Menu');
End;


(* ==========================================================================
                               USERLIST ROUTINES
========================================================================== *)

Function NamesInUserList: Word; { returns number of actual usernames in struct }
Var
  Tel : word;
  Temp: word;
Begin
  Temp :=0;
  For Tel :=1 to 1700 do
    if UserList^[tel].Name<>'' then Inc(temp);
  NamesInUserList :=temp;
End;


Function InUserList(Name:String): Boolean;
{ Returns if Handle/Name allready exists in Userlist Structure }
Var
  Tel : word;
Begin
  InUserList := True;
  For Tel :=1 to 1700 do
    if UCase(UserList^[tel].Name)=UCase(Name) then Exit;
  InUserList := False;
End;


Procedure SortUserList; { Sorts Userlist structure in memory }
Var
  Tel   : Word;
  Tel2  : Word;
  Temp  : LUserRecord;
Begin
  If UserList^[1].Name='' then Exit;

  For Tel := 1 to NamesInUserList do
     for tel2 := 1 to NamesInUserList-1 do
       If UserList^[tel2].Wrote<UserList^[tel2+1].Wrote then
          Begin
            Temp := UserList^[tel2];
            UserList^[tel2] :=UserList^[tel2+1];
            UserList^[tel2+1] :=Temp;
          End;
End;


Function CreateUserFile:Boolean;  { creates a new clean Userfile and writes it to disk }
Var
  t : shFile;
  i : word;
Begin
  CreateUserFile := False;
  If (Not shCreate(t,ExePath+UserFileName,$11)) then
    Begin
      FClrScr;
      FWriteLn('@X0F ERROR: @X07 Something went wrong creating the User datafile.');
      FWriteLn('@X0F        @X07 Please notify your sysop.');
      Dispose(UserList);
      Halt(10);
    End
  Else
    Begin
      New(UserList);
      FillChar(UserList^,SizeOf(UserList^),0);
      shWrite(t,UserList^,sizeof(UserList^));
      shClose(t);
      CreateUserFile := True;
    End;
End;


Function ReadUserList:boolean; { read Userlist from disk to struct }
var
  t : shFile;
  i : word;
begin
  ReadUserList:=false;
  If MaxAvail<SizeOf(UserList^) then Exit;
  if shOpen(t,ExePath+UserFileName,$40) then
   begin
     if shSize(t)=sizeof(UserList^) then
      begin
        New(UserList);
        shRead(t,UserList^,sizeof(UserList^),i);
        ReadUserList:=true;
      end;
   end else ReadUserList := CreateUserFile;
end;


Procedure WriteTopTen; { dump record struct to screen }
Var
  Count,Tmp : byte;
  CurCol    : Byte;
Begin
  For Count := 10 downto 2 do
  Begin
    if (UserList^[Count].Name<>'') then
    Begin
      FGotoXy(57,3+(Count-1));
      FColor(3);
      if Config.TopTenUcase then FWrite(acase(UserList^[Count].Name))
          else FWrite(UserList^[Count].Name);
      FColor(8);
      FGotoXy(57+Length(Userlist^[count].name),3+(Count-1));
      For tmp := 1 to (17-Length(UserList^[Count].Name)) do Fwrite('.');
      FGotoXy(75+(4-Length(str(Userlist^[count].wrote))),3+(Count-1));
      FColor(7); FWrite(Str(UserList^[Count].Wrote));
     End Else
    Begin
      FGotoXy(57,3+(Count-1));
      Fwrite('@X08Empty!');
    End;
 End;
   FGotoXy(57,3);
   FColor(11);
   if Config.TopTenUcase then FWrite(acase(UserList^[1].Name))
       else FWrite(UserList^[1].Name);
   FColor(8);
   For tmp := 1 to (17-Length(UserList^[1].Name)) do Fwrite('.');
   FGotoXy(75+(4-Length(str(Userlist^[1].wrote))),3);
   FColor(15); FWrite(Str(UserList^[1].Wrote));
End;


Function GetRecNr(Name:String): word; { gets record number of Name }
Var
  tel : word;
Begin
  For tel :=1 to 1700 do
  Begin
    if UCase(UserList^[tel].Name)=UCase(Name) then
    Begin
      GetRecNr :=tel;
      Exit;
    End;
  End;
End;


Procedure SaveUsers; { saves userfile struct to disk }
Var t : ShFile;
Begin
  shOpen(t,ExePath+UserFileName,$42);
  shWrite(t,UserList^,sizeof(UserList^));
  shClose(t);
End;


Procedure UpDateUserRec(Name:String); { Updates the actual userrecord }
Var
  Tel : byte;
Begin
  If (not InUserList(Name)) and (NamesInUserList<1700) then
  Begin
    UserList^[NamesInUserList+1].Name := Name;
    UserList^[NamesInUserList].Wrote :=1;
  End Else Inc(UserList^[GetRecNr(Name)].Wrote);
  SortUserList;
  SaveUsers;
End;


Procedure UpdateUser; { Call this, and all procedures above come into action :) }
Begin
  If Config.Handle then
    UpDateUserRec(RADI.UserInfo.Handle) Else
    UpdateUserRec(RADI.UserInfo.Name);
End;


(* ==========================================================================
                            MISC DATAFILE ROUTINES
========================================================================== *)


Procedure MakeClearLinerStruct;  { fills up new linerdata structure with clean data }
Var Count : Byte;
Begin
  For Count := 1 to ConstMaxLines do
    begin
      Lines[count].writer := 'Vertigo';
      Lines[count].text   := '';
    End;
   Lines[ConstMaxLines-1].text := 'THE ONELiNER '+version+' By Vertigo [DEMENTiA]!';
   Lines[ConstMaxLines].text   := 'Start Writing!';
End;


Function CreateDataFile:Boolean;  { creates a new clean datastructure and writes it to disk }
Var
  t : shFile;
  i : word;
Begin
  CreateDataFile := False;
  FSaveScreen;
  FClrScr;
  MakeClearLinerStruct;
  If (Not shCreate(t,ExePath+LinerFileName,$11)) then
    Begin
      FWriteLn('@X0F ERROR: @X07 Something went wrong creating the liner datafile.');
      FWriteLn('@X0F        @X07 Please notify your sysop.');
    End
  Else
    Begin
      shWrite(t,Lines,sizeof(Lines));
      shClose(t);
      FwriteLn(' @X0C  @X0F First time startup detected!');
      FwriteLn(' @X0E  @X07 Created new datafile.');
      FwriteLn(' @X0A  @X07 Enjoy Dementia TheOne '+version+'! ');
      FwriteLn('');
      MovingAnyKey;
      CreateDataFile := True;
    End;
End;


Function CreateStatsFile:Boolean;  { creates a new clean datastructure and writes it to disk }
Var
  t : shFile;
  i : word;
Begin
  CreateStatsFile := False;
  FClrScr;
  Stats.TotalFireups       := 1;
  Stats.TotalLines         := 1;
  Stats.TotalWriteSessions := 1; { not math. correct but div zero messages suck }
  If (Not shCreate(t,ExePath+StatFileName,$11)) then
    Begin
      FWriteLn('@X0F ERROR: @X07 Something went wrong creating the stats datafile.');
      FWriteLn('@X0F        @X07 Please notify your sysop.');
    End;
  shWrite(t,Stats,sizeof(Stats));
  shClose(t);
  CreateStatsFile := True;
End;


function ReadStats:boolean; { reads config from disk to struct }
var
  t : shFile;
  i : word;
begin
  ReadStats:=false;
  if shOpen(t,ExePath+StatFileName,$40) then
   begin
     if shSize(t)=sizeof(Stats) then
      begin
        shRead(t,Stats,sizeof(Stats),i);
        ReadStats:=true;
      end;
     shClose(t);
   end else ReadStats := CreateStatsFile;
end;


Procedure SaveStats;
Var Count : Byte;
    t	  : ShFile;
Begin
{  Inc(Stats.TotalUsers);}
  If (NrWritten > 0) then inc(Stats.TotalWriteSessions);
  shOpen(t,ExePath+StatFileName,$42);
  shWrite(t,Stats,sizeof(Stats));
  shClose(t);
End;


function ReadConfig:boolean; { reads config from disk to struct }
var
  t : shFile;
  i : word;
begin
  ReadConfig:=false;
  if shOpen(t,ExePath+ConfigFileName,$40) then
   begin
     if shSize(t)=sizeof(Config) then
      begin
        shRead(t,Config,sizeof(Config),i);
        ReadConfig:=true;
      end;
     shClose(t);
   end;
end;


Function ReadLiners:boolean; { read liners from disk to struct }
var
  t : shFile;
  i : word;
begin
  ReadLiners:=false;
  if shOpen(t,ExePath+LinerFileName,$40) then
   begin
     if shSize(t)=sizeof(Lines) then
      begin
        shRead(t,Lines,sizeof(Lines),i);
        ReadLiners:=true;
      end;
   shClose(t);
   end else Readliners := CreateDataFile;
end;

(* ==========================================================================
                             DISPLAY LINERS
========================================================================== *)

Function CenterLiner(Const Line:String;Const Len:Byte):String;
Var TempStr  : String;
Var ColorStr : string;
Begin
  TempStr:='';
  If Config.UseQuotes then TempStr := '@X08"';
  TempStr  := TempStr + Attr2PCB(Config.DefLineCol) + Line;
  If Config.UseQuotes then TempStr := TempStr + '@X08"';
  TempStr :=  FPadC(TempStr,Len,' ');
  CenterLiner := TempStr;
End;


Function PrintLiner(Const Line:String;Const Len:Byte):String;
Var TempStr : String;
Begin
  TempStr:='';
  If Config.UseQuotes then TempStr := '@X08"' Else TempStr := ' ';
  TempStr  := TempStr + Attr2PCB(Config.DefLineCol) + Line;
  If Config.UseQuotes then TempStr := TempStr + '@X08"' Else TempStr := TempStr + ' ';
  TempStr :=  FPadE(TempStr,Len,' ');
  PrintLiner := TempStr;
End;

Procedure WriteNormalLiners(From:Byte);
Var Count : Byte;
Begin
  ViewLiners := True;
  ViewEgg    := False;
  For Count := From to ConstMaxlines do
  Begin
    FGotoXy(LinerBlockX,LinerBlockY+(count-from));
    If Config.CenterLiners Then
       Fwrite(CenterLiner(Lines[count].text,LineLength)) Else
       Fwrite(PrintLiner(Lines[count].text,LineLength));
  End;
End;


Procedure WriteAcroLiners(From:Byte); { For ZandaLayout (tm) }
Var Count : Byte;
    Hstr  : String;
const acrosize = 6;
Begin
  ViewLiners := True;
  ViewEgg    := False;
  For Count := From to ConstMaxlines do
  Begin
    FGotoXy(LinerBlockX+1,LinerBlockY+(count-from));
    Fcolor(7); Fwrite(Acronym(Lines[count].Writer));
    Fcolor(8); Fwrite(': ');
    FGotoXy(LinerBlockX+acrosize,LinerBlockY+(count-from));
    Hstr := Fcopy(Lines[count].text,1,LineLength-Acrosize-2);
    If Config.CenterLiners Then
       Fwrite(CenterLiner(Hstr,LineLength-acrosize)) Else
       Fwrite(PrintLiner(Hstr,LineLength-acrosize));
  End;
End;


Procedure WriteLiners(From:Byte);
Begin
  If Config.ZandaScreen then WriteAcroLiners(from) else WriteNormalLiners(from);
End;



Procedure WriteUsers;
Var Count : Byte;
Begin
  ViewLiners := False;
  ViewEgg    := False;
  For Count := 1 to ConstMaxlines do
  Begin
    FGotoXy(LinerBlockX,LinerBlockY+count-1);
    Fwrite(PrintLiner(Lines[count].Writer,LineLength));
  End;
End;


Procedure WriteStats;
Var Div1,Div2 : Real;
    Tmp : Word;
Begin
  Div1 := Stats.TotalFireUps;
  Div2 := Stats.TotalWriteSessions;
  Tmp := Round(100*(Div2 / Div1));
  FColor(7);
  FGotoXy(74+(5-Length(Str(Stats.Totallines))),19);
  Fwrite(Str(Stats.TotalLines));
  FGotoXy(54+(3-Length(Str(Tmp))),20);
  Fwrite((Str(Tmp)));
End;


(* ==========================================================================
                               TWIT PROCEDURE
========================================================================== *)


Function IsTwit(NameStr:String): Boolean; { Is user a twit? }
Var
  T            : TFile;
  TempName     : String;
Begin
  IsTwit :=FALSE;
  If (Not TOpen(T,ExePath+TwitName,$40)) Then
  Begin
    TCreate(T,ExePath+TwitName,$40);
    TOpen(T,ExePath+TwitName,$40);
  End;

  While Not tEof(T) do
  Begin
    TempName := tReadLn(T);
    If TempName[1]<>';' then
      If UCase(TempName)=UCase(NameStr) then
        Begin
         IsTwit :=TRUE;
         tClose(T);
         Exit;
       End;
    End;
  tClose(T);
End;


Function Twit:Boolean;
Begin
  If Config.Handle then
     Twit := IsTwit(RADI.UserInfo.Handle) Else
     Twit := IsTwit(RADI.UserInfo.Name);
End;


(* ==========================================================================
                             ENTER LINERS SECTION
========================================================================== *)

Procedure SaveLiners; { - schuift liners 1 omhoog,
                        - geeft de laatste liner de waarde van templine,
		        - schrijft de liners van struct naar disk
			- Update de UserRecord van de linewriter met +1 }

  Procedure ShoveLinersUp; { Shove liners up WHAT, i hear you ask? ;) }
  Var Count,Tel : Byte;
  Begin
    For Count := 1 to ConstMaxLines-1 Do
     Begin
       Lines[Count].Writer :=  Lines[Count+1].Writer;
       Lines[Count].Text :=  Lines[Count+1].Text;
     End;
  End;

Var Count : Byte;
    t	  : ShFile;
Begin
  ShoveLinersUp;
  Lines[ConstMaxLines].Text := TempLine.Text;
  If Config.Handle Then
     Lines[ConstMaxLines].Writer := RADI.UserInfo.Handle else
     Lines[ConstMaxLines].Writer := RADI.UserInfo.Name;
  shOpen(t,ExePath+LinerFileName,$42);
  shWrite(t,Lines,sizeof(Lines));
  shClose(t);
  UpdateUser;
End;



(* ==========================================================================
                            Greeting egg
========================================================================== *)


Procedure ShowGreetingScreen;
Begin
  FClrScr;
  fwriteln(' @X08@X07');
  fwriteln('               @X0Fdementia would like to greet the following people:@X07');
  fwriteln(' @X08@X07');
  fwriteln(' ');
  fwriteln('  gaijin, da butcher, marduk kurios, synopsis, deadline, squell, stime, gec,');
  fwriteln('  revox, tcr, rudeboy, mr.merde, madcat, heretic, sonic, tairez, demoralize,');
  fwriteln('  tdd, tico, theperic, keynes, devious, scid, gewse, tuffguy, sdog, silence,');
  fwriteln('  impure, valocity, sentinel, twelve, smoke, emphyrio, beer, slackjaw, tiro,');
  fwriteln('  psycho, scorp, spark, warp, squizzy, tfd, moose, exile, samplex, morphine,');
  fwriteln('  troop, mike ehlert, confusion, maarten bekers, the pharao, steel, dirtbag,');
  fwriteln('  redhound, rapid fire, niobium, skullrazor, count zero, virago, mr.fanatic,');
  fwriteln('  cyclone, thunderhawk, kenetic, sfinx, radical, xtreeman, djr, the avenger,');
  fwriteln('  the kiefdevil, locksmith, hardey, infidel friar, delusion, industrial man,');
  fwriteln('  mailman, pino, brain, e-motion, the fury, tgk, macker md-90''s, jay, orion,');
  fwriteln('  inclusive, salvation, dork lemming, vladimir, the watcher, kindaya, icy-d,');
  fwriteln('  tragos, jungleboy, thunderstrike, consieler, tymusz, magic, maniac, valos.');
  fwriteln('  thank you all for making the scene into something unique and worthwhile.  ');
  fwriteln('                                                                            ');
  fwriteln(' @X08@X07');
  FGotoXy(35,20);
  MovingAnyKey;
  if (not config.seperate) then
  begin
    FSendFile(ExePath+LineAnsiName,false);
    WriteTopTen;
    WriteStats;
    WriteLiners(1);
  end;
End;



Function GetStr(x,y,Strlength:byte):Byte;
var tmp : byte;
    t   : Char;
    CurPos : Byte;
Begin
  FGotoXy(x,y);
  FColor(EditColor);
  For Tmp := 1 to StrLength do Fwrite('');
  FColor(7);
  FGotoXy(x,y);
  CurPos := 1;
  While(t<>Enter) do
  Begin
{==============================}
    if (templine.text = 'show me the greetings') then
    begin
      TempLine.Text := '';
      GetStr := 0;
      ShowGreetingScreen;
      Exit;
    end;
{==============================}
    T := FreadKey;
      Case (t) of
      Esc    : Begin
		 templine.text := '';
                 GetStr := 0;
                 Exit;
                End;
      BackSp : If CurPos > 1 then
                 Begin
                   Dec(CurPos);
	           FGotoXy(X+curpos-1,y);
                   FColor(EditColor);
        	   Fwrite('');
                   FColor(7);
                   FGotoXy(1,1); {afleidingsmanouvre voor terminate bug}
                   FGotoXy(X+curpos-1,y);
                   Delete(TempLine.Text,CurPos,2);
                 End;
         Enter  : Begin
                    GetStr := CurPos;
	            Exit;
                  End;
      Else
                 If ((CurPos <= StrLength) and (CurPos < LineLength)) then
                 Begin
                   FGotoXy(X+CurPos-1,Y);
                   Fwrite(t);
                   templine.text := templine.text + t ;
                   Inc(CurPos);
                 End;
      End;
   End;
End;


Procedure SeperateEditScreen; { set up seperate edit screen }
Begin
  With Config Do
  Begin
    FSaveScreen;
    FClrScr;
    FSendFile(ExePath+EditAnsiName,false);
    TempLine.Text := '';
    FGotoXyA(EditScrX,EditScrY,8);            Fwrite('"');
    FGotoXyA(EditScrX+LineLength,EditScrY,8); Fwrite('"');
    If (GetStr(EditScrX+1,EditScrY,LineLength-1)>1) Then
    Begin
      If (Not Config.AllowMacros) Then TempLine.Text := FKillPcb(TempLine.Text);
      SaveLiners;
      HasWritten:=true;
      inc(nrwritten);
      inc(stats.totallines);
      FSendFile(ExePath+LineAnsiName,False);
      WriteLiners(1) ;
      WriteTopTen;
      WriteStats;
    End Else FRestoreScreen;
  End;
End;


Procedure EditScreen; { set up normal editscreen }
Begin
  With Config Do
  Begin
    WriteLiners(2);
    TempLine.Text := '';
    FGotoXyA(LinerBlockX,LinerBlocky+(ConstMaxlines-1),8);            Fwrite('"');
    FGotoXyA(LinerBlockX+LineLength,LinerBlocky+(ConstMaxlines-1),8); Fwrite('"');
    If (getStr(LinerBlockX+1,LinerBlocky+(ConstMaxlines-1),LineLength-1)>1) Then
    Begin
      If (Not Config.AllowMacros) Then TempLine.Text := FKillPcb(TempLine.Text);
      FGotoXyA(LinerBlockX,LinerBlocky+(ConstMaxlines-1),8);            Fwrite(' ');
      FGotoXyA(LinerBlockX+LineLength,LinerBlocky+(ConstMaxlines-1),8); Fwrite(' ');
      SaveLiners;
      WriteTopTen;
      HasWritten:=true;
      inc(nrwritten);
      Inc(Stats.Totallines);
    End;
    WriteLiners(1);
    WriteStats;
  End;
End;


Procedure EnterLiner; { kiest tussen seperate of normaal }
Begin
  RaUserDoes('DMA TheOne '+version+' - Entering A Line');
  If Twit Then TwitScreen Else
  Begin
    If ((Config.MaxWrites = 0) or (NrWritten < Config.MaxWrites)) Then
       Begin
         If Config.Seperate Then SeperateEditScreen
         Else EditScreen;
       End Else
       Begin
         NoMoreScreen;
         If (Not ViewLiners) Then WriteLiners(1);
       End;
  End;
  RaUserDoes('DMA TheOne '+version+'+ - Browsing Menu');
End;


Procedure ToggleLinerScreen; { toggles the users <-> liners view }
Begin
 ViewLiners := Not ViewLiners;
 If ViewLiners Then
   WriteLiners(1) Else
   WriteUsers;
End;

Procedure ToggleEasterEgg; { toggles the users <-> liners view }
Begin
 ViewEgg := Not ViewEgg;
 If ViewEgg Then EasterEgg else writeliners(1);
End;



(* ==========================================================================
 				EXIT ROUTINE
========================================================================== *)


Procedure DeInit; { de exit-routine }
Begin
  RaWriteDoor;
  SaveStats;
  Dispose(UserList);
  if (Nrwritten=0) then ExitFade;
  FgotoXy(1,1); {just to be sure}
  If (Config.RandomCls) Then FRandomCls else FClrScr;
  FWriteLn('@X07Thanks for using this [@X0FDEMENTiA@X07] production.');
  FWriteLn('@X07Coded by [@X0FVertigo@X07].');
  fdelay(10);
  Halt(0);
End;



(* ==========================================================================
 				MAIN PROGRAM
========================================================================== *)

Begin
  Init;
  If (Not ReadConfig) then
  Begin
    FClrScr;
    FWriteLn('@X0FERROR:@X07 Cannot open ConfigFile, returning to : '+ Racfg.SystemName);
    FDelay(50);
    Halt(10);
  End;

  If (Not ReadStats) then
  Begin
    FClrScr;
    FWriteLn('@X0FERROR:@X07 Cannot open Stats Data file, returning to : '+ Racfg.SystemName);
    Fdelay(50);
    Halt(10);
  End;

  If (Not ReadLiners) then
  Begin
    FClrScr;
    FWriteLn('@X0FERROR:@X07 Cannot open Liner Data file, returning to : '+ Racfg.SystemName);
    Fdelay(50);
    Halt(10);
  End;

  If (Not ReadUserList) then
  Begin
    FClrScr;
    FWriteLn('@X0FERROR:@X07 Cannot open UserFile, returning to : '+ Racfg.SystemName);
    Fdelay(50);
    Halt(10);
  End;

  NrWritten := 0;
  Inc(Stats.TotalFireUps);
  FSendFile(ExePath+LineAnsiName,false);
  WriteTopTen;
  WriteStats;
  WriteLiners(1);

  While True Do
  Begin
    T := Freadkey;
    Case t of
     'y','Y'           : EnterLiner;
     'n','N',Enter,Esc : DeInit;
     'i','I' 	       : InfoScreen;
     'w','W'           : ToggleLinerScreen;
     '!'               : FadeTitle;
     '*'               : ToggleEasterEgg;
    End;
  End;

  DeInit; {klabeng!}
End.
