
program LinerCfg;
uses Main,CfgUnit;

{*****************************************************************************
                   Copied&Pasted Variables from the Var unit ;)
*****************************************************************************}

const
  version='v1.10';
  title='TheOne '+version;
  copyright=title+' (C) 1999 Vertigo/Dementia';
{Config}
  ConfigFile='THEONE.CFG';

type


 CfgRec = Record
          {general}
            DefLineCol    : byte;
            MaxWrites     : byte;
            Seperate      : Boolean;
            RandomCls     : Boolean;
            Handle	  : Boolean;
            TopTenUcase   : Boolean;
            UseQuotes     : Boolean;
            AllowMacros   : Boolean;
            CenterLiners  : Boolean;
            ZandaScreen   : Boolean;
          End;

var
{General}
  Cfg           :  CfgRec;

procedure SetDefault;far;
begin
  with Cfg do
   begin
     DefLineCol  := 7;
     MaxWrites   := 2;
     Seperate    := True;
     RandomCls   := True;
     Handle	 := True;
     TopTenUcase := True;
     UseQuotes   := True;
     CenterLiners:= True;
     AllowMacros := True;
     ZandaScreen := False;
    end;
end;


procedure writeconfig;
var
  t : shFile;
  i : word;
begin
{write file}
  if shCreate(t,ExePath+ConfigFile,$41) then
   begin
     shWrite(t,Cfg,sizeof(CfgRec));
     shClose(t);
   end;
end;


function ReadConfig:boolean;
var
  t : shFile;
  i : word;
begin
  ReadConfig:=false;
  if shOpen(t,ExePath+ConfigFile,$40) then
   begin
     if shSize(t)=sizeof(CfgRec) then
      begin
        shRead(t,Cfg,sizeof(CfgRec),i);
        ReadConfig:=true;
      end;
     shClose(t);
   end;
end;


{*****************************************************************************
                        Real Config Program Starts here
*****************************************************************************}


Procedure CfgMain;
var
  curr : byte;
  m    : CfgMenu;
begin
  with Cfg do
   begin
     NewMenu(m,'',0);
     repeat
       AddMenu(m,1,'Default Linecolor',HexB(DefLineCol));
       AddMenu(m,2,'Maximum Linewrites',Str(MaxWrites));
       AddMenu(m,3,'Seperate Editscreen',YesNo[Seperate]);
       AddMenu(m,4,'Use fancy cls',YesNo[RandomCls]);
       AddMenu(m,5,'Use Handle',YesNo[Handle]);
       AddMenu(m,6,'Top 10 Elite Case',YesNo[TopTenUcase]);
       AddMenu(m,7,'Use Quote Signs',YesNo[UseQuotes]);
       AddMenu(m,8,'Allow Color Macros',YesNo[AllowMacros]);
       AddMenu(m,9,'Center Liners',YesNo[CenterLiners]);
       AddMenu(m,10,'Alternate Layout',YesNo[ZandaScreen]);
       AddMenu(m,11,'Set Defaults','');
       AddMenu(m,12,'Exit & Save','');
       Curr:=DoMenu(m);
       case curr of
        1 : GetAttr(m,DefLineCol,MenuItem(m));
        2 : GetByte(m,MaxWrites);
        3 : Seperate := Not Seperate;
        4 : RandomCls := Not RandomCls;
        5 : Handle := Not Handle;
        6 : TopTenUcase := Not TopTenUcase;
        7 : UseQuotes := Not UseQuotes;
        8 : AllowMacros := Not AllowMacros;
        9 : CenterLiners := Not CenterLiners;
       10 : ZandaScreen := Not ZandaScreen;
       11 : GetDefault(false,@SetDefault);
       12 : Curr:=0;
       end;
     until Curr=0;
     DisposeMenu(m);
   end;
end;

begin
  CfgPrg:=copyright;
  WorkScreen;
  if not ReadConfig then
   GetDefault(true,@SetDefault);
  CfgMain;
  WriteConfig;
  ShutDown;
end.

