PROGRAM LogUsage;

USES Dos, OpDate, PopTypes, Misc;

VAR
  f : File Of DateTimeRec;
  EndTime,
  StartTime : DateTimeRec;
  Err : Integer;
  st : Byte;
  Task : String[3];

PROCEDURE UpdateUsageStat(StartTime,EndTime: DateTimeRec; StatType: Byte; Path: PathStr);
VAR
  StatRec : TPortalStat;
  StatFil : File Of TPortalStat;
  i, StartHour, StartMin, StartSec, EndHour, EndMin, EndSec : Byte;
  Dow : DayType;
BEGIN
  IF IOResult=0 THEN ;
  Assign(StatFil,'PORTAL'+GetPoPTask+'.STA');
  FileMode:=$22;
  FillChar(StatRec, SizeOf(StatRec), 0);
  Reset(StatFil);
  IF IoResult<>0 THEN
  BEGIN
    Rewrite(StatFil);
    StatRec.Start:=StartTime;
  END ELSE
    Read(StatFil,StatRec);
  IF IOResult=0 THEN ;
  DoW:=DayOfWeek(StartTime.D);
  TimeToHMS(EndTime.T,EndHour,EndMin,EndSec);
  TimeToHMS(StartTime.T,StartHour,StartMin,StartSec);
  i:=StartHour;
  WITH StatRec DO
  BEGIN
    REPEAT
      IF i=StartHour THEN
      BEGIN
        IF EndHour<>StartHour THEN
          Inc(Usage[StatType,DoW,i],60-StartMin)
        ELSE
          Inc(Usage[StatType,DoW,i],EndMin-StartMin);
      END ELSE
      BEGIN
        IF i<>EndHour THEN
          Inc(Usage[StatType,DoW,i],60)
        ELSE
          Inc(Usage[StatType,DoW,i],EndMin);
      END;
      Inc(i);
      IF i>23 THEN
      BEGIN
        i:=0;
        DoW:=Succ(DoW);
      END;
    UNTIL (i>EndHour) OR ((EndHour=23) and (i=0));
  END;
  Seek(StatFil,0); Write(StatFil,StatRec); Close(StatFil);
END;

BEGIN
  WriteLn('Portal usage statistic updater');
  Task:=GetPoPTask;
  IF Task='' THEN Task:='00' ;
  Assign(f,'POPUSAGE.T'+Task);
  Reset(f);
  IF IOResult=0 THEN
  BEGIN
    EndTime.D:=Today; EndTime.T:=CurrentTime;
    WriteLn('Stopping timer');
    Read(f,StartTime);
    IF ParamCount<1 THEN st:=0 ELSE Val(ParamStr(1),st,Err);
    UpdateUsageStat(StartTime,EndTime,st,'');
    Close(f); Erase(f);
  END ELSE
  BEGIN
    WriteLn('Starting timer');
    Rewrite(f);
    StartTime.T:=CurrentTime; StartTime.D:=Today;
    Write(f,StartTime);
    Close(f);
  END;
END.
