UNIT UserEdit;
{ͻ}
{ UserBrowser                                   Last changed: 28.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{ͻ}
{ Changes made by the German Portal Team                                   }
{                                                                          }
{ By                : Carsten Brandt                                       }
{                     Marcus Roeckrath                                     }
{ First Modification: 10 September 1998                                    }
{ Last Modification : 21 September 1998                                    }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, OpDate, OpField, OpString, PoPTypes;

TYPE
  KeyType  = RECORD
               Lo,Hi:   SmallWord;
             END;

  DiverseType=RECORD
    TempDate, TempDate2   : DateString;
    TempTime    : Time;
  END;

{--------------Maximus-------------------}

(*


/* Masks for usr.bits1, below */

#define BITS_HOTKEYS     0x0001 /* Hotkeys, independent of HOTFLASH level   */
#define BITS_NOTAVAIL    0x0002 /* If set, user is NOT normally available   *
                                 * for chat.                                */
#define BITS_FSR         0x0004 /* Full-screen reading in msg areas         */
#define BITS_NERD        0x0008 /* Yelling makes no noise on sysop console  */
#define BITS_NOULIST     0x0010 /* Don't display name in userlist           */
#define BITS_TABS        0x0020 /* User can handle being sent raw tabs      */
#define BITS_ENCRYPT     0x0040 /* pwd is a MD5 digest, not plaintext       */
#define BITS_RIP         0x0080 /* Remote Imaging Prototocol support        */
#define BITS_BIT8        0x0100 /* Used to be 'usr.msg'                     */
#define BITS_BIT9        0x0200 /* Used to be 'usr.msg'                     */
#define BITS_BITA        0x0400 /* Used to be 'usr.msg'                     */
#define BITS_BITB        0x0800 /* Used to be 'usr.msg'                     */
#define BITS_BITC        0x1000 /* Used to be 'usr.msg'                     */
#define BITS_BITD        0x2000 /* Used to be 'usr.msg'                     */
#define BITS_BITE        0x4000 /* Used to be 'usr.msg'                     */
#define BITS_BITF        0x8000 /* Used to be 'usr.msg'                     */


/* Masks for usr.bits2, below */

#define BITS2_BADLOGON   0x0001 /* MAX: if user's last logon attempt was bad*/
#define BITS2_IBMCHARS   0x0002 /* MAX: if user can receive high-bit chars  */
#define BITS2_RSVD1      0x0004 /* MAX: *obsolete* 1.02 avatar flag         */
#define BITS2_BORED      0x0008 /* Use the line-oriented editor             */
#define BITS2_MORE       0x0010 /* Wants the "MORE?" prompt                 */
#define BITS2_RSVD2      0x0020 /* OPUS: set=wants Ansi                     */
#define BITS2_CONFIGURED 0x0040 /* OPUS: set=used Maximus before            */
#define BITS2_CLS        0x0080 /* OPUS: set=transmit ^L, clear=ignore ^L   */
#define BITS2_BIT8       0x0100 /* used to be 'usr.keys'                    */
#define BITS2_BIT9       0x0200 /* used to be 'usr.keys'                    */
#define BITS2_BITA       0x0400 /* used to be 'usr.keys'                    */
#define BITS2_BITB       0x0800 /* used to be 'usr.keys'                    */
#define BITS2_BITC       0x1000 /* used to be 'usr.keys'                    */
#define BITS2_BITD       0x2000 /* used to be 'usr.keys'                    */
#define BITS2_BITE       0x4000 /* used to be 'usr.keys'                    */
#define BITS2_BITF       0x8000 /* used to be 'usr.keys'                    */

#define SEX_UNKNOWN       0x0000
#define SEX_MALE          0x0001
#define SEX_FEMALE        0x0002

/* Masks for usr.delflag, below.  WARNING!  Only the first eight bits       *
 * of this flag should be used for compatibility with df_save!              */

#define UFLAG_DEL   0x01
#define UFLAG_PERM  0x02

/* Masks for usr.xp_flag, below */

#define XFLAG_EXPDATE    0x0001 /* Use the xp_date to control access        */
#define XFLAG_EXPMINS    0x0002 /* Use the xp_mins number to control access */
#define XFLAG_DEMOTE     0x0004 /* Demote user to priv level in usr.xp_priv */
#define XFLAG_AXE        0x0008 /* Just hang up on user                     */

/* Constants for usr.video, below */

#define GRAPH_TTY         0x00 /* The current user's graphics setting...    */
#define GRAPH_ANSI        0x01
#define GRAPH_AVATAR      0x02
#define GRAPH_RIP         0x03 /* ???????????????, look at BITS_RIP (above) */

*)

        MaximusUserType = record
          name          : String[35];    {}
          city          : String[35];    {}
          alias         : String[20];    {}
          phone         : String[14];    {}
          lastread_ptr  : SmallWord;
          timeremaining : SmallWord;
          pwd           : String[15];    {}
          times         : SmallWord;     {}
          Help          : byte;          {}
          Group         : SmallWord;
          video         : Byte;          {}
          nulls         : Byte;
          Bits          : Byte;
          dob_year      : SmallWord;     {}
          Bits2         : SmallWord;
          Max2Priv      : SmallWord;
        { DataPhone     : array[1..19] of Byte;}
          DataPhone     : String[18];
          StructLen     : Byte;
          Time          : SmallWord;     {}
          DelFlag       : SmallWord;
          Msgs_Posted   : LongInt;
          Msgs_Read     : LongInt;
          Width         : Byte;
          Len           : Byte;
          Credit        : SmallWord;
          Debit         : SmallWord;
          xp_priv       : SmallWord;
          Union1        : LongInt;
          XP_Mins       : LongInt;
          XP_Flags      : Byte;
          Sex           : Byte;
          Ludate        : LongInt;
          xKeys         : KeyType;
          Lang          : byte;
          DefProto      : Shortint;      {-}
          Up            : LongInt;       {}
          Down          : LongInt;       {}
          DownToDay     : LongInt;       {}
          Rsvd45        : String[17];
          Call          : SmallWord;
          Compress      : Byte;
          DF_Save       : Byte;
          Extra         : LongInt;
          Date_1STCall  : LongInt;
          Date_PWD_CHG  : LongInt;
          Nup           : LongInt;
          NDown         : LongInt;
          NDownToday    : LongInt;
          Time_Added    : SmallWord;
          MSG           : String[63];
          FILES         : String[63];
          Dob_Day       : Byte;
          Dob_Month     : Byte;
          Point_Credit  : LongInt;
          Point_Debit   : LongInt;
          Date_NewFile  : LongInt;
          Priv          : SmallWord;
          Rsvd6         : String[53];
          Diverse       : DiverseType;
        END;




{--------------QuickBBS------------------}

  FlagTYPE = RECORD
              A,B,C,D: BYTE;
            END;

  LASTREADType = ARRAY[1..200] of SmallInt;

  QBBSUserType = record
                 Name        : String[35];
                 City        : String[25];
                 Pwd         : String[15];
                 DataPhone,
                 HomePhone   : String[12];
                 LastTime    : String[5];
                 LastDate    : String[8];
                 Attrib      : Byte;
                 Flags       : FlagType;
                 Credit,
                 Pending,
                 TimesPosted,
                 HighMsgRead,
                 SecLvl,
                 Times,
                 Ups,
                 Downs,
                 UpK,
                 DownK,
                 TodayK      : SmallWord;
                 Elapsed,
                 Len         : SmallInt;
                 CombinedPtr : SmallWord; (* Record number in COMBINED.BBS *)
                 AliasPtr    : SmallWord; (* Record number in ALIAS.BBS    *)
                 Birthday    : Longint;
                 Diverse     : DiverseType;
               end;

  SBBSUserType = record
                 Name:               S35;
                 City:               String[25];
                 Password:           String[15];
                 DataPhone,
                 HomePhone:          String[12];
                 LastTime:           String[5];
                 LastDate:           String[8];
                 Attrib:             Byte;
                 Flags:              FlagType;
                 Credit,
                 Pending:            SmallInt;
                 MsgsPosted,
                 HighMsgRead,
                 SecLvl,
                 Times,
                 Ups,
                 Downs,
                 UpK,
                 DownK:              SmallWord;
                 TodayK:             SmallInt;
                 Elapsed:            SmallInt;
                 Len:                SmallInt;
                 ExtraSpace1:        Array[1..2] of byte;
                 Age:                Byte;
                 ExtraUserrecPtr:    SmallInt;
                 ExtraSpace2:        Array[1..3] of Byte;
                 Diverse     : DiverseType;
               end;

    CombinedType   =ARRAY[1..200] Of boolean;

  {Extra for super-bbs}
    MsgToIdxRecord = String[35];
    ExtraUserRec=Record                                 (*  SUSERS.BBS  *)
               Name:               MsgToIdxRecord;
               Birthday:           String[8];
               Attrib:             SmallWord;
               Flags:              Array[1..4] of Byte; { Not yet used }
               Firsttime:          String[5];
               FirstDate:          String[8];
               CombinedBoards:     Array[1..25]  of Byte;
               SysOpComment:       String[79];
               DefaultProto:       Char;                { Not yet used }
               UserRecPtr:         SmallInt;
               Colors:             Array[1..10] of byte;
               FileListType:       Byte;                { Not yet used }
               Alias:              MsgToIdxRecord;
               MinutesUsed:        Longint;
               ViewFileName:       String[12]; { SeeAlso attrib bits 4 - 6 }
               MenuToRun:          String[8];
               Timeinbank:         SmallWord;
               TodayCalls:         Byte;
               LanguageFileN:      String[8];  { *.LNG }
               ExtraSpace:         Array[1..425] of Byte;
             End;

{----------------OPUS 1.10-1.14-------------------}

    Opus110UserType=RECORD    {BBSTYPE 3} {Not fully supported!!!!!}
                     Name           : String[35];
                     City           : String[35];
                     Pwd            : String[15];
                     UsrTel         : String[15];
                     Alias          : String[31];
                     Times          : SmallWord;
                     ClassPriv      : Byte;
                     Help           : Byte;
                     Tabs           : Byte;
                     Language       : Byte;
                     Nulls          : SmallWord;
                     Msg            : SmallWord;
                     Bits           : SmallWord;
                     ClassLock      : Keytype;
                     LuDate         : LongInt;
                     Time           : SmallInt;
                     Flag           : SmallWord;
                     UpLd           : LongInt;
                     DnLd           : LongInt;
                     DnLdl          : SmallInt;
                     Files          : SmallWord;
                     Width          : Byte;
                     Len            : Byte;
                     Credit         : SmallWord;
                     Debit          : SmallWord;
                     SpcOEC         : String[7];
                     SAccnt         : ARRAY[1..5] OF Byte;
                     ExFlag         : Byte;
                     XDate          : LongInt;
                     CrMin          : LongInt;
                     DbMin          : LongInt;
                     ULikes         : String[31];
                     FuDate         : LongInt;
                     Reserved       : ARRAY[1..16] OF Byte;
                     LastMsg        : ARRAY[1..256] OF SmallWord;
                     OPUS_Id        : LongInt;
                     Extern_Id      : ARRAY[1..7] OF LongInt;
                     Extern_Inf     : ARRAY[1..7] OF String[31];
                     Diverse        : DiverseType;
                   END;

{--------Remote Access 1.11----------}

  RALASTREADrecord = array[1..200] of SmallWord;

  RAUSERSIDXrecord = record
                     NameCRC32,
                     HandleCRC32    : LongInt;
                   end;

  RAUSERSXIrecord  = record
                     Handle         : String[35];
                     Comment        : String[80];
                     FirstDate      : Date;
                     CombinedInfo   : array[1..25] of Byte;
                     BirthDate,
                     SubDate        : S8;
                     ScreenWidth,
                     MsgArea,
                     FileArea,
                     Language,
                     DateFormat     : Byte;
                     ForwardTo      : S35;
                     ExtraSpace     : Array[1..43] of Byte;
                   end;

  RAUSERTYPE    = record
                     Name           : S35;
                     Location       : S25;
                     Password       : S15;
                     DataPhone,
                     VoicePhone     : S12;
                     LastTime       : S5;
                     LastDate       : S8;
                     Attribute      : Byte;

                      { Bit 0 : Deleted
                            1 : Clear screen
                            2 : More prompt
                            3 : ANSI
                            4 : No-kill
                            5 : Xfer priority
                            6 : Full screen msg editor
                            7 : Quiet mode }

                     Flags          : FlagType;
                     Credit,
                     Pending        : SmallWord;
                     MsgsPosted,
                     LastRead,
                     Security,
                     NoCalls,
                     Uploads,
                     Downloads,
                     UploadsK,
                     DownloadsK     : SmallWord;
                     TodayK,
                     Elapsed        : SmallInt;
                     ScreenLength   : SmallWord;
                     LastPwdChange,
                     Attribute2,

                      { Bit 0 : Hot-keys
                            1 : AVT/0
                            2 : Full screen message viewer
                            3 : Hidden from userlist }


                     Group          : Byte;
                     XIrecord       : SmallWord;
                     ExtraSpace     : array[1..3] of Byte;
                     Diverse       : DiverseType;
                   end;


PROCEDURE UserEditor;

PROCEDURE IncMaxProtocol(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
PROCEDURE IncMaxVideoLevel(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
PROCEDURE ChangeMaxRipStatus(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
PROCEDURE IncOpusUserLevel(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
PROCEDURE IncMaximusUserLevel(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
PROCEDURE IncMaxHelpLevel(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
PROCEDURE BinConv32(EFP: EntryFieldPtr; PostEdit: Boolean);
FUNCTION  ValidateBin32(EFP: EntryFieldPtr; Var ErrCode: Word; Var ErrorSt: StringPtr): Boolean;

IMPLEMENTATION

USES OpDos, OpEntry, OpCrt, OpWindow, OpCmd, OpConst, OpMenu,
     OpSelect, Dos,
     Globals, RBrowser, StrUtil, intercom, OproUtil, MailCfg, NetFile,
     LogFile, UnixDate, Crc, Util, Resource;

VAR
  ESR               : PPoPEntryScreen;
  f, F2, F3, F4     : TNetFile;
  up                : Pointer;


FUNCTION MaxVideo(i:BYTE):S6;
BEGIN
  CASE i OF
    0 : MaxVideo:='TTY';
    1 : MaxVideo:='Ansi';
    2 : MaxVideo:='Avatar';
  END;
END;

FUNCTION MaxRip(i:BYTE):S3;
BEGIN
  CASE (i AND $80) SHR 7 OF
    0 : MaxRip:='No';
    1 : MaxRip:='Yes';
  END;
END;

FUNCTION MaxProtocol(i:INTEGER) : S10;
BEGIN
  CASE i OF
    -6 : MaxProtocol:='Zmodem';
    -5 : MaxProtocol:='SEAlink';
    -4 : MaxProtocol:='1K-Xmodem';
    -3 : MaxProtocol:='Telink';
    -2 : MaxProtocol:='Xmodem';
    -1 : MaxProtocol:='None';
  0..9 : MaxProtocol:='Extern '+Long2Str(i+1);
  END;
END;

FUNCTION Digits(i:BYTE):CHAR;
BEGIN
  CASE i OF
     0.. 9 : Digits:=CHAR(48+i);
    10..15 : Digits:=CHAR(55+i);
  END;
END;

FUNCTION PwField(i: TBBSType):WORD;
BEGIN
  CASE i OF
    btSBBS,
    btProBoard,
    btOpus170,
    btQBBS    : PwField:=7;
    btOpus110,
    btMax     : PwField:=8;
    btRA      : PwField:=6;
  END;
END;

PROCEDURE GetAUserRec(VAR f: TNetFile; VAR Buffer; RecNum: LongInt; K,W: Boolean); far;
BEGIN
  f.GetRec(Buffer,RecNum, K, W);
END;

PROCEDURE PutAUserRec(VAR f: TNetFile; VAR Buffer; RecNum: LongInt); far;
BEGIN
  f.PutRec(Buffer,RecNum);
END;

PROCEDURE Edit_Combined(VAR Save:BOOLEAN);      { EDIT Combined record }
VAR
  cp:POINTER;
  CpEsr:TPoPEntryScreen;
BEGIN
  Topic:=0;
  GetEsr(EsrUserQBBSCombined,3,CpEsr);
  WITH CpESR DO
  BEGIN
    cp:=GetUserRecord;
    If QBBSUsertype(up^).CombinedPtr<>0 then
      f3.GetRec(cp^,QBBSUsertype(up^).CombinedPtr,NoKeep,NoWait)
    ELSE
      FillChar(cp^,SizeOf(CombinedType),0);
    Process;
    If (QBBSUsertype(up^).CombinedPtr=0) then
      QBBSUsertype(up^).CombinedPtr:=f3.FileSize;
    If QBBSUsertype(up^).CombinedPtr<>0 then
    BEGIN
      f3.PutRec(cp^,QBBSUsertype(up^).CombinedPtr);
      Save:=TRUE;
    END;
    Done;
  END;
  ESR^.Select;
END;

PROCEDURE Edit_ExtraInfo(VAR Save:BOOLEAN);      { EDIT SBBS Extra information }
VAR
  cp:POINTER;
  ExEsr:TPoPEntryScreen;
BEGIN
  Topic:=0;
  GetEsr(EsrUserSBBSExtra,3,ExEsr);
  WITH ExESR DO
  BEGIN
    cp:=GetUserRecord;
    If SBBSUserType(up^).ExtraUserRecPtr>=0 then
      f4.GetRec(cp^,SBBSUsertype(up^).ExtraUserRecPtr,NoKeep,NoWait)
    ELSE
      FillChar(cp^,SizeOf(ExtraUserRec),0);
    Process;
    If (SBBSUsertype(up^).ExtraUserRecPtr<0) then
      SBBSUsertype(up^).ExtraUserRecPtr:=f4.FileSize;
    If SBBSUsertype(up^).ExtraUserRecPtr>=0 then
    BEGIN
      f4.PutRec(cp^,SBBSUsertype(up^).ExtraUserRecPtr);
      Save:=TRUE;
    END;
    Done;
  END;
  ESR^.Select;
END;

PROCEDURE PreProcessUserRecord;         { Konverterer en record til STRINGs }
VAR
  Uyear, Umonth, Uday, Uhour,Umins, Usecs      : Word;
  Dt:DateTime;
BEGIN
  CASE Cfg.BBS.BBSType OF
    btQBBS,
    btSBBS:
       BEGIN
         WITH QBBSUsertype(up^).Diverse DO
         BEGIN
           TempDate  :=Copy(QBBSUsertype(up^).LastDate,4,2)+'/'+Copy(QBBSUsertype(up^).LastDate,1,2)+'-'+
                       Copy(QBBSUsertype(up^).LastDate,7,2);
(*           UnpackUnix((QBBSUsertype(up^).Birthday),Uyear,Umonth,Uday,Uhour,Umins,Usecs);
             TempDate2:=DMYToDateString('dd/mm-yy',INTEGER(Uday),INTEGER(Umonth),INTEGER(Uyear)); *)
           TempTime  :=TimeStringToTime('hh:mm',QBBSUsertype(up^).LastTime);
         END;
       END;
    btOpus110:
       BEGIN
         WITH Opus110UserType(up^) DO
         BEGIN
           Name    :=AsciiZ2Str(Name  ,35);
           City    :=AsciiZ2Str(City  ,35);
           Pwd     :=AsciiZ2Str(Pwd   ,15);
           UsrTel  :=AsciiZ2Str(UsrTel,15);
           Alias   :=AsciiZ2Str(Alias ,15);
           WITH Diverse DO
           BEGIN
             UnpackUnix((LuDate-25200),Uyear,Umonth,Uday,Uhour,Umins,Usecs);
             TempDate:=DMYToDateString('dd/mm-yy',INTEGER(Uday),INTEGER(Umonth),INTEGER(Uyear));
             TempTime:=HMSToTime(BYTE(Uhour),BYTE(Umins),Byte(Usecs));
           END;
         END;
       END;
    btMax:
       BEGIN
         WITH MaximusUserType(up^) DO
         BEGIN
           Name    :=AsciiZ2Str(Name  ,35);
           City    :=AsciiZ2Str(City  ,35);
           Pwd     :=AsciiZ2Str(Pwd   ,15);
           Phone   :=AsciiZ2Str(Phone ,14);
           Alias   :=AsciiZ2Str(Alias ,20);
           Fillchar(Diverse,SizeOf(DiverseType),0);
{-----------------}
           With Diverse do
           BEGIN
             Dt.Day:=LuDate AND 31;
             Dt.Month:=(LuDate SHR 5) AND 15;
             Dt.Year:=80+(LuDate SHR 9) AND 63;
             Dt.Sec:=(LuDate SHR 15) AND 63;
             Dt.Min:=(LuDate SHR 21) AND 63;
             Dt.Hour:=(LuDate SHR 27) AND 31;
             TempDate:=DMYToDateString('dd/mm-yy',dt.Day,dt.month,dt.year);
             TempTime:=HMSToTime(Dt.Hour,Dt.Min,Dt.Min);
           END;
{-----------------}
         END;

       End;
  END;
END;

PROCEDURE PostProcessUserRecord;         { Konverterer STRINGs til c-style }
BEGIN
  CASE Cfg.BBS.BBSType OF
    btQBBS,
    btSBBS:
       WITH QBBSUsertype(up^).Diverse DO
       BEGIN
         QBBSUsertype(up^).LastTime := TimeToTimeString('hh:mm',TempTime);
         QBBSUsertype(up^).LastDate := Copy(TempDate,4,2)+'-'+Copy(TempDate,1,2)+'-'+Copy(TempDate,7,2);
       END;
    btOpus110:
       BEGIN
         WITH Opus110UserType(up^) DO
         BEGIN
           str2AsciiZ(Name,Name,36);
           Str2AsciiZ(City,City,36);
           Str2AsciiZ(Pwd,Pwd,15);
           Str2AsciiZ(UsrTel,UsrTel,15);
           Str2AsciiZ(Alias,Alias,15);
         END;
       END;
    btMax:
       BEGIN
         WITH MaximusUserType(up^) DO
         BEGIN
           str2AsciiZ(Name,Name,36);
           Str2AsciiZ(City,City,36);
           Str2AsciiZ(Pwd,Pwd,16);
           Str2AsciiZ(Phone,Phone,15);
           Str2AsciiZ(Alias,Alias,21);
         END;
       End;
  END;
END;

  FUNCTION OpusPriv(i:BYTE):S15;
  BEGIN
    CASE i OF
       1 : OpusPriv:='Twit';
       3 : OpusPriv:='Disgraced';
       4 : OpusPriv:='Limited';
       5 : OpusPriv:='Normal';
       6 : OpusPriv:='Worthy';
       7 : OpusPriv:='Privileged';
       8 : OpusPriv:='Favored';
       9 : OpusPriv:='Extra';
      10 : OpusPriv:='Clerk';
      11 : OpusPriv:='Assistant SysOp';
      13 : OpusPriv:='SysOp';
      14 : OpusPriv:='Hidden';
      16 : OpusPriv:='PREREGISTERED';
      ELSE OpusPriv:=' - ';
    END;
  END;

  FUNCTION MaximusPriv(i:SMALLWORD):S15;
  BEGIN
    CASE i OF
       0 : MaximusPriv:='Transient';
      10 : MaximusPriv:='Demoted';
      20 : MaximusPriv:='Limited';
      30 : MaximusPriv:='Normal';
      40 : MaximusPriv:='Worthy';
      50 : MaximusPriv:='Privil';
      60 : MaximusPriv:='Favored';
      70 : MaximusPriv:='Extra';
      80 : MaximusPriv:='Clerk';
      90 : MaximusPriv:='Asst SysOp';
     100 : MaximusPriv:='SysOp';
   65535 : MaximusPriv:='Hidden';
      ELSE MaximusPriv:=' - ';
    END;
  END;

  FUNCTION MaximusHelp(i:BYTE):S15;
  BEGIN
    CASE i OF
       2 : MaximusHelp:='Expert';
       4 : MaximusHelp:='Regular';
       6 : MaximusHelp:='Novice';
      32 : MaximusHelp:='Hotflash';
      ELSE MaximusHelp:='---';
    END;
  END;

FUNCTION UserGetStr(VAR Buffer; VAR f: TNetFile):STRING; far; { Returnerer den streng der bliver }
VAR                                          { Vist i browseren                 }
  t,
  s:STRING;
BEGIN
  CASE cfg.BBS.BBSType OF
  btQBBS,
  btSBBS:
      BEGIN
        With QbbsUserType(Buffer) DO
        BEGIN
          Str(SecLvl,t);
          s:=Cpad(Name,36)+Cpad(T,16)+copy(city,1,24);
        END;
      END;
  btOpus110:
      BEGIN
        WITH Opus110Usertype(buffer) DO
          s:=Cpad(asciiz2str(Name,36),36)+Cpad(OpusPriv(ClassPriv DIV 16),16)+copy(AsciiZ2Str(city,36),1,24);
      END;
  btRA:
      BEGIN
        With RAUserType(Buffer) DO
        BEGIN
          Str(Security,t);
          s:=Cpad(Name,36)+Cpad(T,16)+copy(Location,1,24);
        END;
      END;
  btMax:
      BEGIN
        WITH MaximusUsertype(buffer) DO
          s:=Cpad(asciiz2str(Name,36),36)+Cpad(MaximusPriv(Priv),16)+copy(AsciiZ2Str(city,36),1,24);
      END;
  END;
  UserGetStr:=s;
END;

PROCEDURE IncOpusUserLevel(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
BEGIN
  CASE Factor OF
    +1 : BEGIN
           INC(byte(Value),16);
           IF byte(Value)>224 THEN Byte(Value):=16;
           IF byte(Value)=32  THEN Byte(Value):=48;
           IF byte(Value)=192 THEN Byte(Value):=208;
         END;
    -1 : BEGIN
           DEC(Byte(Value),16);
           IF Byte(Value)<=0   THEN Byte(Value):=224;
           IF Byte(Value)=32  THEN Byte(Value):=16;
           IF Byte(Value)=192 THEN Byte(Value):=176;
         END;
  END;
  s:=OpusPriv(Byte(Value) div 16);
END;

PROCEDURE IncMaximusUserLevel(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
BEGIN
  CASE Factor OF
    +1 : BEGIN
           IF SMALLWORD(Value)=65535 THEN SMALLWORD(Value):=0
           ELSE
             IF SMALLWORD(Value)=100 THEN SMALLWORD(Value):=65535
             ELSE Inc(SMALLWORD(Value),10);
         END;
    -1 : BEGIN
           IF SMALLWORD(Value)=65535 THEN SMALLWORD(Value):=100
           ELSE
             IF SMALLWORD(Value)=0 THEN SMALLWORD(Value):=65535
             ELSE Dec(SMALLWORD(Value),10);
         END;
  END;
  s:=MaximusPriv(SMALLWORD(Value));
END;

PROCEDURE IncMaxHelpLevel(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
BEGIN
  CASE Factor OF
    +1 : BEGIN
           INC(Integer(Value),2);
           IF Integer(Value)=8  THEN Integer(Value):=32;
           IF Integer(Value)=34 THEN Integer(Value):=2;
         END;
    -1 : BEGIN
           DEC(Integer(Value),2);
           IF Integer(Value)<=0 THEN Integer(Value):=32;
           IF Integer(Value)=30   THEN Integer(Value):=6;
         END;
  END;
  s:=MaximusHelp(Integer(Value));
END;

PROCEDURE IncMaxVideoLevel(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
BEGIN
  CASE Factor OF
    +1 : BEGIN
           INC(Integer(Value),1);
           IF Integer(Value)=3  THEN Integer(Value):=0;
         END;
    -1 : BEGIN
           DEC(Integer(Value),1);
           IF Integer(Value)<0 THEN Integer(Value):=2;
         END;
  END;
  s:=MaxVideo(Integer(Value));
END;

PROCEDURE ChangeMaxRipStatus(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
BEGIN
  CASE Factor OF
    +1,-1 : BYTE(Value) := BYTE(Value) XOR $80;
  END;
  s:=MaxRip(BYTE(Value));
END;

PROCEDURE IncMaxProtocol(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
BEGIN
  CASE Factor OF
    +1 : BEGIN
           INC(Integer(Value),1);
           IF Integer(Value)=10  THEN Integer(Value):=-6;
         END;
    -1 : BEGIN
           DEC(Integer(Value),1);
           IF Integer(Value)<=-7 THEN Integer(Value):=10;
         END;
  END;
  s:=MaxProtocol(Integer(Value));
END;


FUNCTION UserCRC(CONST S: STRING): LONGINT;
VAR
  UCRC      :LONGINT;
  COUNTER   :INTEGER;
  SS        :STRING;
BEGIN
  Ucrc := $FFFFFFFF;
  SS:=TRIM(S);
  FOR counter := 1 TO (Length(SS)) DO
     Ucrc := UpdCrc32(BYTE(SS[counter]),Ucrc);
  UserCRC:=Ucrc;
END;

Procedure ShowRatio;
VAR
  s:S20;
BEGIN
  CASE Cfg.BBS.BBSType OF
    btQBBS,
    btSBBS:
      BEGIN
        If QBBSUsertype(up^).Upk <> 0 then
          s:=LongIntForm('###',(QBBSUsertype(up^).Downk div QBBSUsertype(up^).UpK))
        Else
          s:='N/A';
        FastText(s,12,64);
      END;
    btOpus110:
      BEGIN
        If Opus110UserType(up^).UpLd <> 0 then
          s:=LongIntForm('###',(Opus110UserType(up^).Dnld div Opus110UserType(up^).Upld))
        Else
          s:='N/A';
        FastText(s,13,64);
       {gotoXY(61,1);}
       {Write(HEXL(UserCRC(StUpCase(Opus110UserType(up^).Name))));}
      END;
    btRA:
      BEGIN
        If RaUserType(up^).UpLoadsK <> 0 then
          s:=LongIntForm('###',(RaUserType(up^).DownloadsK div RaUserType(up^).UploadsK))
        Else
          s:='N/A';
        FastText(s,12,64);
       {gotoXY(61,1);
       Write(HEXL(UserCRC(copy(AsciiZ2Str(RaUserType(up^).Name,35),1,Byte(RaUserType(up^).Name[0])))));}
      END;
    btMax:
      BEGIN
        If MaximusUserType(up^).Up <> 0 then
          s:=LongIntForm('###',(MaximusUserType(up^).Down div MaximusUserType(up^).Up))
        Else
          s:='N/A';
        FastText(s,13,64);
      END;
  END;
END;

Procedure _UserPostEdit(ESP:EntryScreenPtr); far;
BEGIN
  IF ESP^.GetCurrentID=PwField(Cfg.BBS.BBStype) THEN
  BEGIN
    EntryFieldPtr(ESP^.FindField(PwField(Cfg.BBS.BBStype)))^.efOptionsOn(EfPasswordMode);
    ESP^.DrawField(PwField(Cfg.BBS.BBStype));
  END;
  IF Esp^.CurrentFieldModified THEN Esp^.ResetScreen;
END;

Procedure PreProc(ESP:EntryScreenPtr); far;
BEGIN
  IF ESP^.GetCurrentID=PwField(Cfg.BBS.BBStype) THEN
    EntryFieldPtr(ESP^.FindField(PwField(Cfg.BBS.BBSType)))^.efOptionsOff(EfPasswordMode);
END;

PROCEDURE _UserUpd(ASP: AbstractSelectorPtr); far;
BEGIN
  ShowRatio;
  FastText(Long2Str(f.FILEPOS)+'/'+Long2Str(f.FILESIZE)+'     ',1,13);
END;

PROCEDURE UserEditProc1(VAR Buffer; VAR Changed:BOOLEAN; RecNum, MaxRec: LongInt); far;

  PROCEDURE Edit_Flags;      { EDIT user Flags }
  VAR
    Temp  : windowptr;
    InKey : Word;
    m     : TPoPMenu;
    key   : WORD;

    FUNCTION flagon(mask : Word) : S5;
    BEGIN
      IF QBBSUsertype(up^).Attrib AND mask<>0 THEN flagon:='ON ' ELSE flagon:='OFF';
    END;

  BEGIN
    Topic:=1;
    mywin(Temp,23,8,59,16,4,'User Flags',True);
    getmenu(MNUUEQBBSFlags,4,m);
    MenuCommands.AddCommand(ccUser1,1,14624,0); {14624=scancode of space}
    REPEAT
      WITH Temp^ DO
      BEGIN
        wfastwrite(flagon(1),1,29,cfg.color[4].TextColor);
        wfastwrite(flagon(2),2,29,cfg.color[4].TextColor);
        wfastwrite(flagon(4),3,29,cfg.color[4].TextColor);
        wfastwrite(flagon(8),4,29,cfg.color[4].TextColor);
        wfastwrite(flagon(16),5,29,cfg.color[4].TextColor);
        wfastwrite(flagon(32),6,29,cfg.color[4].TextColor);
        wfastwrite(flagon(64),7,29,cfg.color[4].TextColor);
      END;
      M.Process;
      Key:=M.MenuChoice;
      CASE Key OF
        1..7 : BEGIN
                 IF m.GetLastCommand<>ccQuit THEN
                   QBBSUsertype(up^).Attrib:=QBBSUsertype(up^).Attrib XOR (1 SHL (Key-1));
               END;
      END;
    UNTIL m.GetLastCommand=ccQuit;
    m.Done;
    KillWindow(Temp);
  END;

  PROCEDURE Edit_lastread;      { EDIT LastRead record }
  VAR
    lp:POINTER;
    lresr:TPoPEntryScreen;
  BEGIN
    Topic:=0;
    GetEsr(EsrUSERLastRead,4,lrEsr);
    lp:=LrEsr.GetUserRecord;
    FILLCHAR(lp^,400,0);
    f2.GetRec(lp^,f.FILEPOS-1,NoKeep,NoWait);
    lrEsr.Process;
    f2.PutRec(lp^,f.FILEPOS-1);
    lrEsr.Done;
    ESR^.Select;
  END;

Var
  FuncKeyWin : WindowPtr;
  s:S80;
BEGIN
  PreProcessUserRecord;
  MyWin(FuncKeyWin,1,ScreenHeight-1,80,ScreenHeight,2,'',False);
  WITH FuncKeyWin^, cfg.color[2] DO
  BEGIN
    wFastWrite('F1=Help         F2=             F3=            F4=               F5=            ',
               1, 1, HighlightColor);
    IF Cfg.BBS.BBSType=btQBBS THEN
      s:='F9=               '
    ELSE
    BEGIN
      s:='F9=Extra info.    ';
      EntryCommands.AddCommand(ccUser9,1,Word(256*67),0);      { Edit Extra SBBS info }
    END;
    wFastWrite('F6=Edit Flags   F7=Edit Combin. F8=Edit Lastrd.'+s+'F0=            ',
                    2,1,highlightColor);
  END;
  ESR^.Select;
  ESR^.SetNextField(0);
  ESR^.SetScreenUpdateProc(_UserUpd);
  WITH EntryCommands DO
  BEGIN
    AddCommand(ccUser6,1,Word(256*64),0);      { Edit Bits  }
    AddCommand(ccUser7,1,Word(256*65),0);      { Edit Combined }
    AddCommand(ccUser8,1,Word(256*66),0);      { Edit LastRead }
  END;
  REPEAT
    ESR^.Process;
    CASE ESR^.GetLastCommand OF
      ccUser6  : Edit_Flags;
      ccUser7  : Edit_Combined(Changed);
      ccUser8  : Edit_LastRead;
      ccUser9  : Edit_ExtraInfo(Changed);
    END;
  UNTIL ESR^.GetLastCommand=ccQuit;
  KillWindow(FuncKeyWin);
  Changed:=TRUE;
  PostProcessUserRecord;
END;

PROCEDURE UserEditProc3(VAR Buffer; VAR Changed:BOOLEAN; RecNum,MaxRec: LongInt); far;

  PROCEDURE Edit_Flags;      { EDIT user Flags }
  VAR
    Temp  : windowptr;
    InKey : Word;
    m     : TPoPMenu;
    key   : WORD;

    FUNCTION flagon(mask : Word) : S6;
    BEGIN
      Case Mask of
        288        : BEGIN
                       IF Opus110UserType(up^).bits AND mask=32 THEN
                         flagon:='ANSI  '
                       ELSE
                       IF Opus110UserType(up^).Bits AND mask=256 THEN
                         flagon:='AVATAR'
                       ELSE
                         flagon:='ASCII ';
                     END;
        4,8,64,4096,
        8192,16384 : BEGIN
                       IF Opus110UserType(up^).bits AND mask<>0 THEN flagon:='OFF' ELSE flagon:='ON ';
                     END Else
                     BEGIN
                       IF Opus110UserType(up^).bits AND mask<>0 THEN flagon:='ON ' ELSE flagon:='OFF';
                     END
      END;
    END;

  BEGIN
    mywin(Temp,23,7,59,17,4,'User Flags',True);
    GetMenu(MnuUEOPUS110Flags,4,m);
    MenuCommands.AddCommand(ccUser1,1,14624,0); {14624=scancode of space}
    REPEAT
      WITH Temp^ DO
      BEGIN
        wfastwrite(flagon(4),1,29,cfg.color[4].TextColor);
        wfastwrite(flagon(8),2,29,cfg.color[4].TextColor);
        wfastwrite(flagon(16),3,29,cfg.color[4].TextColor);
        wfastwrite(flagon(32+256),4,29,cfg.color[4].TextColor);
        wfastwrite(flagon(64),5,29,cfg.color[4].TextColor);
        wfastwrite(flagon(128),6,29,cfg.color[4].TextColor);
        wfastwrite(flagon(4096),7,29,cfg.color[4].TextColor);
        wfastwrite(flagon(8192),8,29,cfg.color[4].TextColor);
        wfastwrite(flagon(16384),9,29,cfg.color[4].TextColor);
      END;
      M.Process;
      Key:=M.MenuChoice;
      CASE Key OF
        7..9     : BEGIN
                     IF m.GetLastCommand<>ccQuit THEN
                       Opus110UserType(up^).bits:=Opus110UserType(up^).Bits XOR (1 SHL (Key+5));
                   END;
        1..3,
        5,6      : BEGIN
                     IF m.GetLastCommand<>ccQuit THEN
                       Opus110UserType(up^).bits:=Opus110UserType(up^).Bits XOR (1 SHL (Key+1));
                   END;
        4        : BEGIN
                     IF m.GetLastCommand<>ccQuit THEN
                     BEGIN
                       CASE (Opus110UserType(up^).Bits AND 288) OF
                         0   : Opus110UserType(up^).bits:=Opus110UserType(up^).Bits XOR 32;
                         32  : Opus110UserType(up^).bits:=Opus110UserType(up^).Bits XOR (288);
                         256 : Opus110UserType(up^).bits:=Opus110UserType(up^).Bits XOR (256);
                       END;
                     END;
                   END;
      END;
    UNTIL m.GetLastCommand=ccQuit;
    m.Done;
    KillWindow(Temp);
  END;

Var
  FuncKeyWin : WindowPtr;
  Ucrc,l     : Word;
  X          : Byte;
BEGIN
  PreProcessUserRecord;
  MyWin(FuncKeyWin,1,ScreenHeight-1,80,ScreenHeight,2,'',False);
  WITH FuncKeyWin^, cfg.color[2] DO
  BEGIN
    wFastWrite('F1=             F2=             F3=            F4=               F5=            ',
                    1,1,highlightColor);
    wFastWrite('F6=Edit Flags   F7=             F8=            F9=               F0=            ',
                    2,1,highlightColor);
  END;
  ESR^.Select;
  ESR^.SetNextField(0);
  ESR^.SetScreenUpdateProc(_UserUpd);
  REPEAT
    WITH EntryCommands DO
    BEGIN
      AddCommand(ccUser6,1,Word(256*64),0);      { Edit Bits  }
    END;
    ESR^.Process;
    CASE ESR^.GetLastCommand OF
      ccUser6 : Edit_Flags;
    END;
  UNTIL ESR^.GetLastCommand=ccquit;
  Changed:=TRUE;
  KillWindow(FuncKeyWin);
  PostProcessUserRecord;
END;

PROCEDURE UserEditProc4(VAR Buffer; VAR Changed:BOOLEAN; RecNum, MaxRec: LongInt); far;
Var
  FuncKeyWin : WindowPtr;

  PROCEDURE Edit_Flags;      { EDIT user Flags }
  VAR
    Temp  : windowptr;
    InKey : Word;
    m     : TPoPMenu;
    key   : WORD;

    FUNCTION flagon(mask : Word) : S5;
    BEGIN
      IF QBBSUsertype(up^).Attrib AND mask<>0 THEN flagon:='ON ' ELSE flagon:='OFF';
    END;

  BEGIN
    Topic:=1;
    mywin(Temp,23,8,59,16,4,'User Flags',True);
    getmenu(MNUUEQBBSFlags,4,m);
    MenuCommands.AddCommand(ccUser1,1,14624,0); {14624=scancode of space}
    REPEAT
      WITH Temp^ DO
      BEGIN
        wfastwrite(flagon(1),1,29,cfg.color[4].TextColor);
        wfastwrite(flagon(2),2,29,cfg.color[4].TextColor);
        wfastwrite(flagon(4),3,29,cfg.color[4].TextColor);
        wfastwrite(flagon(8),4,29,cfg.color[4].TextColor);
        wfastwrite(flagon(16),5,29,cfg.color[4].TextColor);
        wfastwrite(flagon(32),6,29,cfg.color[4].TextColor);
        wfastwrite(flagon(64),7,29,cfg.color[4].TextColor);
      END;
      M.Process;
      Key:=M.MenuChoice;
      CASE Key OF
        1..7 : BEGIN
                 IF m.GetLastCommand<>ccQuit THEN
                   QBBSUsertype(up^).Attrib:=QBBSUsertype(up^).Attrib XOR (1 SHL (Key-1));
               END;
      END;
    UNTIL m.GetLastCommand=ccQuit;
    m.Done;
    KillWindow(Temp);
  END;

  PROCEDURE Edit_lastread;      { EDIT lastread record }
  VAR
    ESR   : TPoPEntryScreen;
    InKey : Word;
    m     : TPoPMenu;
    x,y   : byte;
    key   : WORD;
  BEGIN
    Topic:=0;
    ESR.Process;
  END;

BEGIN
  PreProcessUserRecord;
  MyWin(FuncKeyWin,1,ScreenHeight-1,80,ScreenHeight,2,'',False);
  WITH FuncKeyWin^, cfg.color[2] DO
  BEGIN
    wFastWrite('F1=             F2=             F3=            F4=               F5=            ',
                    1,1,highlightColor);
    wFastWrite('F6=Edit Flags   F7=Edit Combin. F8=            F9=               F0=            ',
                    2,1,highlightColor);
  END;
  ESR^.Select;
  ESR^.SetNextField(0);
  ESR^.SetScreenUpdateProc(_UserUpd);
  REPEAT
    WITH EntryCommands DO
    BEGIN
      AddCommand(ccUser6,1,Word(256*64),0);      { Edit Bits  }
      AddCommand(ccUser7,1,Word(256*65),0);      { Edit Combined }
(*      AddCommand(ccUser8,1,Word(256*66),0);      { Edit LastRead }  *)
    END;
    ESR^.Process;
    CASE ESR^.GetLastCommand OF
      ccUser6  : Edit_Flags;
      ccUser7  : Edit_Combined(Changed);
{SA: Don't look good???????      ccUser8  : Edit_LastRead;}
    END;
  UNTIL ESR^.GetLastCommand=ccQuit;
  KillWindow(FuncKeyWin);
  Changed:=TRUE;
  PostProcessUserRecord;
END;

  FUNCTION Maxflagon(mask : Word) : S6;
  BEGIN
    IF MaximusUserType(up^).Bits AND mask<>0 THEN Maxflagon:='On ' ELSE Maxflagon:='Off';
  END;

  procedure FlagsCustomStringProc(var Name : String; Key : LongInt;
                                  Selected, Highlighted : Boolean;
                                  WPtr : RawWindowPtr); far;
  var
    s : S5;
  begin
    s:=MaxFlagOn(1 SHL (Key-1));
    Move(s[1], Name[Length(Name)-4], Length(s));
  end;

PROCEDURE UserEditProc7(VAR Buffer; VAR Changed:BOOLEAN; RecNum,MaxRec: LongInt); far;


  PROCEDURE Edit_Flags;      { EDIT Maximus user Flags }
  VAR
    m     : TPoPMenu;
    key   : WORD;
  BEGIN
    Topic:=199;
    GetMenu(MNUUEMaxFlags,3,m);
    M.SetCustomStringProc(FlagsCustomStringProc);
    REPEAT
      M.Process;
      Key:=M.MenuChoice;
      CASE Key OF
        1..6 : BEGIN
                  IF m.GetLastCommand<>ccQuit THEN
                  BEGIN
                    MaximusUserType(up^).Bits := MaximusUserType(up^).Bits XOR (1 SHL (Key-1));
                    Save:=True;
                  END;
                END;
      END;
    UNTIL m.GetLastCommand=ccQuit;
    m.Done;
    Topic:=0;
  END;

(*
  PROCEDURE Edit_Flags;      { EDIT user Flags }
  VAR
    Temp  : windowptr;
    InKey : Word;
    m     : TPoPMenu;
    key   : WORD;

    FUNCTION flagon(mask : Word) : S6;
    BEGIN
      Case Mask of
        288        : BEGIN
                       IF MaximusUserType(up^).bits AND mask=32 THEN
                         flagon:='ANSI  '
                       ELSE
                       IF MaximusUserType(up^).Bits AND mask=256 THEN
                         flagon:='AVATAR'
                       ELSE
                         flagon:='ASCII ';
                     END;
        4,8,64,4096,
        8192,16384 : BEGIN
                       IF Opus110UserType(up^).bits AND mask<>0 THEN flagon:='OFF' ELSE flagon:='ON ';
                     END Else
                     BEGIN
                       IF Opus110UserType(up^).bits AND mask<>0 THEN flagon:='ON ' ELSE flagon:='OFF';
                     END
      END;
    END;

  BEGIN
    mywin(Temp,23,7,59,17,4,'User Flags',True);
    getmenu(MNUUEOPUS110Flags,4,m);
    MenuCommands.AddCommand(ccUser1,1,14624,0); {14624=scancode of space}
    REPEAT
      WITH Temp^ DO
      BEGIN
        wfastwrite(flagon(4),1,29,cfg.color[4].TextColor);
        wfastwrite(flagon(8),2,29,cfg.color[4].TextColor);
        wfastwrite(flagon(16),3,29,cfg.color[4].TextColor);
        wfastwrite(flagon(32+256),4,29,cfg.color[4].TextColor);
        wfastwrite(flagon(64),5,29,cfg.color[4].TextColor);
        wfastwrite(flagon(128),6,29,cfg.color[4].TextColor);
        wfastwrite(flagon(4096),7,29,cfg.color[4].TextColor);
        wfastwrite(flagon(8192),8,29,cfg.color[4].TextColor);
        wfastwrite(flagon(16384),9,29,cfg.color[4].TextColor);
      END;
      M.Process;
      Key:=M.MenuChoice;
      CASE Key OF
        7..9     : BEGIN
                     IF m.GetLastCommand<>ccQuit THEN
                       Opus110UserType(up^).bits:=Opus110UserType(up^).Bits XOR (1 SHL (Key+5));
                   END;
        1..3,
        5,6      : BEGIN
                     IF m.GetLastCommand<>ccQuit THEN
                       Opus110UserType(up^).bits:=Opus110UserType(up^).Bits XOR (1 SHL (Key+1));
                   END;
        4        : BEGIN
                     IF m.GetLastCommand<>ccQuit THEN
                     BEGIN
                       CASE (Opus110UserType(up^).Bits AND 288) OF
                         0   : Opus110UserType(up^).bits:=Opus110UserType(up^).Bits XOR 32;
                         32  : Opus110UserType(up^).bits:=Opus110UserType(up^).Bits XOR (288);
                         256 : Opus110UserType(up^).bits:=Opus110UserType(up^).Bits XOR (256);
                       END;
                     END;
                   END;
      END;
    UNTIL m.GetLastCommand=ccQuit;
    m.Done;
    KillWindow(Temp);
  END;
*)
Var
  FuncKeyWin : WindowPtr;
  Ucrc,l     : Word;
  X          : Byte;
BEGIN
  PreProcessUserRecord;
  MyWin(FuncKeyWin,1,ScreenHeight-1,80,ScreenHeight,2,'',False);
  WITH FuncKeyWin^, cfg.color[2] DO
  BEGIN
    wFastWrite('F1=             F2=             F3=            F4=               F5=            ',
                    1,1,highlightColor);
    wFastWrite('F6=Edit Flags   F7=             F8=            F9=               F0=            ',
                    2,1,highlightColor);
  END;
  ESR^.Select;
  ESR^.SetNextField(3);
  ESR^.SetScreenUpdateProc(_UserUpd);
  REPEAT
(*  WITH EntryCommands DO
    BEGIN
      AddCommand(ccUser6,1,Word(256*64),0);      { Edit Bits  }
    END;
    *)
    ESR^.Process;
(*   CASE ESR^.GetLastCommand OF
      ccUser6 : Edit_Flags;
    END;
    *)

  UNTIL ESR^.GetLastCommand=ccquit;
  Changed:=TRUE;
  KillWindow(FuncKeyWin);
  PostProcessUserRecord;
END;

PROCEDURE InitUserBuf(VAR Buffer); far;
BEGIN
  CASE cfg.BBS.BBSType OF
    btQBBS,
    btSBBS:
      BEGIN
        FILLCHAR(Buffer,SizeOf(QBBSUserType)-SizeOf(DiverseType),0);
      END;
    btOpus110:
      BEGIN
        FILLCHAR(Buffer,SizeOf(Opus110UserType)-SizeOf(DiverseType),0);
        Opus110UserType(Buffer).ClassPriv:=16;
      END;
  END;
END;

FUNCTION UserIsGreater(VAR r1,r2):BOOLEAN; far;  { Sorteringskriterie }
BEGIN
  CASE Cfg.BBS.BBSType OF
    btQBBS,
    btSBBS:
      UserIsGreater:=(QbbsUserType(r1).Name>QbbsUserType(r2).Name);
    btOPus110:
      UserIsGreater:=(AsciiZ2Str(Opus110UserType(r1).Name,36)>AsciiZ2Str(Opus110UserType(r2).Name,36));
  END;
END;

FUNCTION ReverseBinaryL(L: Keytype) : string;
  {-Return reverse binary string for LongInt (WORD*2-array)}
VAR
  I : BYTE;
  N : Byte;
BEGIN
  N := 1;
  ReverseBinaryL[0] := #32;
  FOR I := 31 DOWNTO 0 DO
  BEGIN
    CASE I OF
      0..15  : ReverseBinaryL[33-N] := Digits(Ord(L.Lo and WORD(1 shl I) <> 0)); {0 or 1}
      16..31 : ReverseBinaryL[33-N] := Digits(Ord(L.Hi and WORD(1 shl (I-16)) <> 0)); {0 or 1}
    END;
    INC(N);
  END;
END;

FUNCTION Str2Bin32(S: String; Var B: KEYTYPE): Boolean;

  FUNCTION BinMag(i:BYTE): LONGINT;
  BEGIN
    BinMag:=1 SHL (i-1);
  END;

VAR
  i, BinL,BinH : Word;
BEGIN
  Str2Bin32:=False;
  BinL:=0;
  BinH:=0;
  s:=LeftPadCh(s,'0',32);
  FOR i:=1 TO 32 DO
    CASE i OF
      1..16  : BEGIN
                 IF s[i]='1' THEN Inc(BinL,BinMag(i)) ELSE
                   IF s[i]<>'0' THEN Exit;
               END;
      17..32 : BEGIN
                 IF s[i]='1' THEN Inc(BinH,BinMag(i-16)) ELSE
                   IF s[i]<>'0' THEN Exit;
               END;
    END;
  Str2Bin32:=True;
  B.Lo:=BinL;
  B.Hi:=BinH;
END;

FUNCTION ValidateBin32(EFP: EntryFieldPtr; Var ErrCode: Word; Var ErrorSt: StringPtr): Boolean;
VAR
  B: KEYTYPE;
  S: String[80];
BEGIN
  ValidateBin32:=False;
  WITH EFP^ DO
  BEGIN
    StripPicture(efEditSt^,s);
    IF Not Str2Bin32(s,b) THEN
    BEGIN
      ErrCode:=ecBadFormat;
      ErrorSt:=@emInvalidNumber;
    END ELSE
      ValidateBin32:=True;
  END;
END;

PROCEDURE BinConv32(EFP: EntryFieldPtr; PostEdit: Boolean);
VAR
  s: String[80];
BEGIN
  WITH EFP^ DO
    IF PostEdit THEN
    BEGIN
      StripPicture(efEditSt^, s);
      IF Not Str2Bin32(s,KEYTYPE(efVarPtr^)) THEN LongInt(efVarPtr^):=0;
    END ELSE
    BEGIN
      s:=ReverseBinaryL(KEYTYPE(efVarPtr^));
      MergePicture(s, efEditSt^);
    END;
END;

FUNCTION MakeQbbsScreen: Boolean;
BEGIN
  New(ESR);
  IF ESR<>NIL THEN
  BEGIN
    IF Cfg.BBS.BBSType=btQBBS THEN GetEsr(EsrUserQBBSMain,2,ESR^)
                              ELSE GetEsr(EsrUserSBBSMain,2,ESR^);
    up:=ESR^.GetUserRecord;
    ESR^.SetPostEditProc(_UserPostEdit);
    ESR^.SetPreEditProc(PreProc);
    ESR^.SetScreenUpdateProc(_UserUpd);
    MakeQbbsScreen:=True;
  END ELSE
    MakeQbbsScreen:=False;
END;

FUNCTION MakeOpus110Screen: Boolean;
BEGIN
  New(ESR);
  IF ESR<>NIL THEN
  BEGIN
    GetEsr(EsrUserOPUS110Main,2,ESR^);
    up:=ESR^.GetUserRecord;
    ESR^.SetPostEditProc(_UserPostEdit);
    ESR^.SetPreEditProc(PreProc);
    ESR^.SetScreenUpdateProc(_UserUpd);
    MakeOpus110Screen:=True;
  END ELSE
    MakeOpus110Screen:=False;
END;

FUNCTION MakeMaximusScreen: Boolean;
BEGIN
  New(ESR);
  IF ESR<>NIL THEN
  BEGIN
    GetEsr(EsrUserMaximusMain,2,ESR^);
    up:=ESR^.GetUserRecord;
    ESR^.SetPostEditProc(_UserPostEdit);
    ESR^.SetPreEditProc(PreProc);
    ESR^.SetScreenUpdateProc(_UserUpd);
    MakeMaximusScreen:=True;
  END ELSE
    MakeMaximusScreen:=False;
END;

FUNCTION MakeRAScreen: Boolean;
BEGIN
  New(ESR);
  IF ESR<>NIL THEN
  BEGIN
    GetEsr(EsrUserRAMain,2,ESR^);
    up:=ESR^.GetUserRecord;
    ESR^.SetPostEditProc(_UserPOstEdit);
    ESR^.SetPreEditProc(PreProc);
    ESR^.SetScreenUpdateProc(_UserUpd);
    MakeRAScreen:=True;
  END ELSE
    MakeRAScreen:=False;
END;

PROCEDURE UserEditor;
VAR
  filename,
  FileName2,
  FileName3,
  FileName4 :PathStr;
  ExitCode  :WORD;
BEGIN
{$IFNDEF PoPLite}
  IF SetIntercom(IcUserEd,Call,false) THEN
  BEGIN
    CASE Cfg.BBS.BBSType OF
      btQBBS,
      btSBBS:
        BEGIN
          FileName:=Cfg.BBS.UserFile;
          FileName2:=AddBackSlash(JustPathName(cfg.BBS.UserFile))+'LASTREAD.BBS';
          FileName3:=AddBackSlash(JustPathName(cfg.BBS.UserFile))+'COMBINED.BBS';
          FileName4:=AddBackSlash(JustPathName(cfg.BBS.UserFile))+'SUSERS.BBS';
          If Not (ExistFile(FileName)) then
            AskError(8,'No Userfile Found',4)
          else
          BEGIN
            IF MakeQbbsScreen THEN
            BEGIN
              f.Open(FileName,158,True);
              f2.Open(FileName2,400,True);
              f3.Open(FileName3,200,True);
              IF Cfg.BBS.BBSType=btSBBS THEN f4.Open(FileName4,SizeOf(ExtraUserRec),True);
              GetARec:=GetAUserRec;
              PutARec:=PutAUserRec;
              Allowed:=10;
              CASE Cfg.BBS.BBSType OF
                btQBBS:
                  BrowseRecords(f,QBBSUsertype(up^),ExitCode,'USER BROWSER (QBBS)',
                                'User name                           Security.lvl    City',
                                UserGetStr,UserEditProc1,InitUserBuf,UserIsGreater);
                btSBBS:
                  BrowseRecords(f,QBBSUsertype(up^),ExitCode,'USER BROWSER (SBBS)',
                                'User name                           Security.lvl    City',
                                UserGetStr,UserEditProc1,InitUserBuf,UserIsGreater);
              END;
              GetARec:=DefGetRec;
              PutARec:=DefPutRec;
              IF Cfg.BBS.BBSType=btSBBS THEN f4.Close;
              f3.Close;
              f2.Close;
              f.CLOSE;
              Dispose(ESR, Done);
            END ELSE
              AddLog('!', 'Not enough memory to initialize User Editor');
          END;
        END;
      btOpus110:
        BEGIN
          If Not (ExistFile(Cfg.BBS.UserFile)) then
            AskError(8,'No Userfile found',4)
          Else
          BEGIN
            IF MakeOpus110Screen THEN
            BEGIN
              f.Open(Cfg.BBS.UserFile,1024,True);
              Allowed:=10;
              BrowseRecords(f,up^,ExitCode,'USER BROWSER (OPUS 1.10)',
                            'User name                           Security.lvl    City',
                            UserGetStr,UserEditProc3,InitUserBuf,UserIsGreater);
              f.CLOSE;
              Dispose(ESR, Done);
            END ELSE
              AddLog('!', 'Not enough memory to initialize User Editor');
          END;
        END;
      btRA:
        BEGIN
          If Not (ExistFile(Cfg.BBS.UserFile)) then
            AskError(8,'No Userfile found',4)
          Else
          BEGIN
            IF MakeRAScreen THEN
            BEGIN
              f.Open(Cfg.BBS.UserFile,SizeOf(RaUserType)-SizeOf(DiverseType),True);
              Allowed:=10;
              BrowseRecords(f,up^,ExitCode,'USER BROWSER (Remote Access 1.11)',
                            'User name                           Security.lvl    City',
                            UserGetStr,UserEditProc4,InitUserBuf,UserIsGreater);
              f.CLOSE;
              Dispose(ESR, Done);
            END ELSE
              AddLog('!', 'Not enough memory to initialize User Editor');
          END;
        END;
      btMax:
        BEGIN
          If Not (ExistFile(cfg.BBS.UserFile)) then
            AskError(8,'No Userfile found',4)
          Else
          BEGIN
            IF MakeMaximusScreen THEN
            BEGIN
              f.Open(cfg.BBS.UserFile,SizeOf(MaximusUserType)-SizeOf(DiverseType),True);
              Allowed:=10;
              BrowseRecords(f,up^,ExitCode,'USER BROWSER ( Maximus 3.0 )',
                            'User name                           Security.lvl    City',
                            UserGetStr,UserEditProc7,InitUserBuf,UserIsGreater);
              f.CLOSE;
              Dispose(ESR, Done);
            END ELSE
              AddLog('!', 'Not enough memory to initialize User Editor');
          END;
        END;
      ELSE
        AskError(8,'Sorry, The UserBrowser does not support your BBS-type',4);
    END;
  END;
{$ELSE}
  AskError(10, 'Not implemented in Portal of Power/Lite', 2);
{$ENDIF}
END;

END.
