UNIT TransVid;
{ͻ}
{ Screen routines for protocols                 Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, PoPTypes, OpDate, OpWindow;

PROCEDURE ShowCurrentFileName(CONST s: String; sp,fs:LONGINT; Eff:BYTE; w: Boolean);
PROCEDURE ShowErrorCheckingMethod(CONST s: String; w: Boolean);
PROCEDURE ShowBlockSize(b: Word; w: Boolean);
PROCEDURE ShowError(CONST s: String; ErrorMsg, InLog, w: Boolean);
PROCEDURE ShowCurrentByte(b: LongInt; w: Boolean);
PROCEDURE FileReceived(CONST s : String; CONST LogStr: String; w:BOOLEAN);
PROCEDURE FileSent(CONST s: String; CONST LogStr: String; w:BOOLEAN);
PROCEDURE SetupTransferWindows(Dual: Boolean);
PROCEDURE RemoveTransferWindows;
FUNCTION  CrcStr(Crc32: Boolean): S3;

IMPLEMENTATION

USES OpCrt, OpString,
     OproUtil, Com, StrUtil, LogFile, MailUtil, NetFile, SimpDB,
     Globals, Util;

TYPE
  TvVars=RECORD
    errorcount     : ARRAY[False..True] OF Integer;
    UseDualWindows : Boolean;
    FilesInWin,
    FilesOutWin    : WindowPtr;
    CurrentFileWin : ARRAY[False..True] OF WindowPtr;
    StartDateTime  : ARRAY[False..True] OF DateTimeRec;
    EndTime,
    FSize,
    StartPos       : ARRAY[False..True] OF LONGINT;
  END;

VAR
 Tv:^TvVars;

  PROCEDURE RemoveTransferWindows;
  BEGIN
    WITH Tv^ DO
    BEGIN
      IF UseDualWindows THEN KillWindow(CurrentFileWin[TRUE]);
      KillWindow(CurrentFileWin[FALSE]);
      KillWindow(FilesOutWin);
      KillWindow(FilesInWin);
    END;
    Dispose(Tv);
  END;

  PROCEDURE SetupTransferWindows(Dual: Boolean);
  VAR
    b:Boolean;
  BEGIN
    New(Tv);
    WITH Tv^ DO
    BEGIN
      UseDualWindows:=dual;

      mywin(filesinwin,3,9,18,18,2,'Files In',False);
      FOR b:=False TO dual DO
      BEGIN
        errorcount[b]:=0;
        StartPos[b]:=0;
        FSize[b]:=0;
        mywin(currentfilewin[b],19,4+(5*Byte(Not dual))+(10*Byte(b)),62,13+(5*BYTE(Not dual))+(10*BYTE(b)),2,
              'Current File',False);
        WITH CurrentFileWin[b]^ DO
        BEGIN
          wFastText('File      :',1,2);
          wFastText('Size      :',2,2);
          wFastText('Time      :              ETA:',3,2);
          wFastText('Transfrd  :              CPS:',4,2);
          wFastText('Block size:',5,2);
          wFastText('Method    :',6,2);
          wFastText('Error #   :',7,2);
          wFastText('Last msg  :',8,2);
        END;
      END;
      mywin(filesoutwin,63,9,78,18,2,'Files Out',False);
    END;
  END;

  PROCEDURE ShowNumberOfErrors(w:Boolean);
  BEGIN
    WITH Tv^ DO
    BEGIN
      WITH CurrentFileWin[w]^ DO
      BEGIN
        Select;
        wfastwrite(LongIntForm('##,###,###',errorcount[w]),7,14,cfg.color[2].highlightcolor);
      END;
    END;
  END;

  PROCEDURE ShowCurrentFileName(CONST s: String; sp,fs:LONGINT; Eff:BYTE; w:Boolean);
  VAR
    TransTime:LONGINT;
  BEGIN
    WITH Tv^ DO
      WITH Tv^.CurrentFileWin[w]^ DO
      BEGIN
        Select;
        WITH StartDateTime[w] DO
        BEGIN
          t:=CurrentTime;
          d:=Today;
        END;
        wFastWrite(LongIntForm('##,###,###',fs),2,14,cfg.color[2].highlightColor);
        StartPos[w]:=sp;
        FSize[w]:=fs;
        ShowCurrentByte(sp,w);
        ShowBlockSize(0,w);
        errorcount[w]:=0;
        ShowNumberOfErrors(w);
        TransTime:=Trunc((FSize[w]-StartPos[w])/(eff/100)*10/ComPort^.GetBaudRate);
        EndTime[w]:=StartDateTime[w].t+TransTime;
        wfastwrite(TimeToTimeString('hH:mm:ss',TransTime),3,14,cfg.color[2].highlightcolor);
        wfastwrite(TimeToTimeString('hH:mm:ss',TransTime),3,32,cfg.color[2].highlightcolor);
        wFastWrite(CPad(StUpCase(JustFileName(s)),12),1,14,cfg.color[2].HighlightColor);
      END;
    ShowError('',False,false,w);
    IF Sp>0 THEN ShowError('Resuming from '+Long2Str(sp),False,False,w);
  END;

  PROCEDURE ShowCurrentByte(b : LongInt; w:Boolean);
  VAR
    CT, EtaTime, CPS : LongInt;
  BEGIN
    WITH Tv^ DO
    BEGIN
      CurrentFileWin[w]^.Select;
      CurrentFileWin[w]^.wfastwrite(LongIntForm('##,###,###',b),4,14,cfg.color[2].highlightcolor);
      CT:=CurrentTime;
      IF CT<StartDateTime[w].t THEN INC(CT,SecondsInDay);
      IF (CT-StartDateTime[w].t)<>0 THEN
        CPS:=(b-StartPos[w]) DIV (CT-StartDateTime[w].t)
      ELSE
        CPS:=0;
      CurrentFileWin[w]^.wfastwrite(LongIntForm('##,###', CPS),4,32,cfg.color[2].highlightcolor);
      EtaTime:=EndTime[w]-CT;
      IF EtaTime>0 THEN
        CurrentFileWin[w]^.wfastwrite(TimeToTimeString('hH:mm:ss',EtaTime),3,32,cfg.color[2].highlightcolor)
      ELSE
        CurrentFileWin[w]^.wfastwrite('Overdue!',3,32,cfg.color[2].highlightcolor);
    END;
  END;

  PROCEDURE ShowBlockSize(b : Word; w:Boolean);
  BEGIN
    WITH Tv^ DO
    BEGIN
      CurrentFileWin[w]^.Select;
      CurrentFileWin[w]^.wfastwrite(LongIntForm('    ##,###',b),5,14,cfg.color[2].highlightcolor);
    END;
  END;

  PROCEDURE ShowErrorCheckingMethod(CONST s : String; w:Boolean);
  BEGIN
    WITH Tv^ DO
    BEGIN
      CurrentFileWin[w]^.Select;
      CurrentFileWin[w]^.wfastwrite(CPad(s,18),6,14,cfg.color[2].highlightcolor);
    END;
  END;

  PROCEDURE ShowError(CONST s: String; ErrorMsg: Boolean; InLog: Boolean; w: Boolean);
  BEGIN
    WITH Tv^ DO
    BEGIN
      CurrentFileWin[w]^.Select;
      IF InLog THEN AddLog('*',s);
      CurrentFileWin[w]^.wfastwrite(CPad(s,28),8,14,cfg.color[2].highlightcolor);
      IF ErrorMsg THEN
      BEGIN
        Inc(errorcount[w]);
        ShowNumberOfErrors(w);
      END;
    END;
  END;

  PROCEDURE FileReceived(CONST s : String; CONST LogStr: String; w:BOOLEAN);
  VAR
    Ext:S3;
    RealEndTime  : DateTimeRec;
    Effektivitet : Real;
    Secs,l,Bytes : LongInt;
    Days         : Word;
    Ift          : TInboundFile;
    IftF         : PTitFile;
    IsMail,IsReq : Boolean;
    i            : Integer;
  BEGIN
    WITH Tv^ DO
    BEGIN
      FilesInWin^.Select;
      Inc(StatRec^.DayStat[0].FilesIn);
      WITH RealEndTime DO
      BEGIN
        d:=ToDay;
        t:=CurrentTime;
      END;
      Datetimediff(StartDateTime[w],RealEndTime,days,Secs);
      Bytes:=FSize[w]-StartPos[w];
      IF Secs=0 THEN Secs:=1;
      Effektivitet:=Bytes/Secs/ComPort^.GetBaudRate*1000;
      AddLog('+','CPS: '+Long2Str(Bytes DIV Secs)+' ('+Long2Str(Bytes)+' bytes)  Efficiency: '+Form('###.#',Effektivitet)+'%');
      AddLog('+','Received-'+LogStr+' '+cfg.inbound[GlobNodeStat]+JustFileName(s));
      FilesInWin^.ScrollVert(1);
      FilesInWin^.wfastwrite(StUpCase(s),8,2,cfg.color[2].highlightcolor);
      Inc(FReceived);

      IsMail:=FALSE;
      IsReq:=FALSE;
      i:=POS('.',s);
      IF i>0 THEN
      BEGIN
        Ext:=StUpCase(Copy(s,i+1,3));
        IF LENGTH(s)=12 THEN
        BEGIN
          VAL('$'+COPY(s,1,8),l,i);
          IF i=0 THEN
          BEGIN
            IF (Ext='PKT') THEN
              IsMail:=True
            ELSE
              IF (Ext='R'+HexB(Cfg.TaskNumber)) {OR (Ext='PTF')} THEN
                IsReq:=True
              ELSE
                IF (Ext[3] IN ['0'..'9']) THEN
                BEGIN
                  Dec(Ext[0]);
                  IF (POS(Ext,'MO*TU*WE*TH*FR*SA*SU')>0) THEN IsMail:=True;
                END;
          END; {ELSE
            IF (Ext='TIC') AND (Copy(s,1,2)='TK') THEN IsReq:=True;}
        END;
      END;
      IF NOT IsReq THEN
      BEGIN
        IF IsMail THEN
          GotSomeMail:=True
        ELSE
        BEGIN
          GotSomeFiles:=True;
          IF NOT (((Ext='TIC') {AND (Copy(s,1,2)='TK')}) OR (Ext='PTF')) THEN
          BEGIN
            FillChar(Ift, SizeOf(Ift), 0);
            WITH Ift DO
            BEGIN
              FileName:=JustName(s); {COPY(s+'.',1,POS('.',s)-1);}
              RecvTime:=CurrentTime;
              RecvDate:=Today;
              From:=RemHello.Address;
              TaskNum:=Cfg.TaskNumber;
            END;
            New(IftF, Open(True));
            IF IftF<>NIL THEN
            BEGIN
              IftF^.AddRec(Ift);
              Dispose(IftF, Close);
            END ELSE
              AddLog('!','Not enough memory to open: PORTAL.TIT');
          END;
        END;
      END;
    END;
  END;

  PROCEDURE FileSent(CONST s: String; CONST LogStr: String; w:BOOLEAN);
  VAR
    RealEndTime      : DateTimeRec;
    Effektivitet : Real;
    Secs,Bytes   : LongInt;
    Days         : Word;
  BEGIN
    WITH Tv^ DO
    BEGIN
      FilesOutWin^.Select;
      Inc(StatRec^.DayStat[0].FilesOut);
      WITH RealEndTime DO
      BEGIN
        d:=ToDay;
        t:=CurrentTime;
      END;
      Datetimediff(StartDateTime[w], RealEndTime, days, Secs);
      IF Secs=0 THEN Secs:=1;
      Bytes:=FSize[w]-StartPos[w];
      Effektivitet:=Bytes/Secs/ComPort^.GetBaudRate*1000;

      AddLog('+','CPS: '+Long2Str(Bytes DIV Secs)+' ('+Long2Str(Bytes)+' bytes)  Efficiency: '+Form('###.#',Effektivitet)+'%');
      AddLog('+','Sent-'+LogStr+' '+s);

      filesoutwin^.ScrollVert(1);
      filesoutwin^.wfastwrite(StUpCase(JustFileName(s)),8,2,cfg.color[2].highlightcolor);
      Inc(FSent);
    END;
  END;

  FUNCTION CrcStr(Crc32: Boolean): S3;
  BEGIN
    IF Crc32 THEN CrcStr:='/32' ELSE CrcStr:='/16';
  END;

END.
