UNIT StrUtil;
{ͻ}
{ String utilities                              Last changed: 20.04.96  DW }
{                                                                          }
{                         (C) Copyright 1989-93 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, PoPTypes;

FUNCTION  ReplaceEnv(S: String): String;
FUNCTION  NextWord(ch:CHAR; VAR s:STRING):STRING;
FUNCTION  ReverseStr(CONST s: STRING): STRING;
FUNCTION  CPad(CONST s: String; l: Byte): String;
FUNCTION  Address2Str(CONST Address: TFidoAddress): S40;
PROCEDURE Replace(VAR S1: String; CONST S2, S3: String; N: Integer);
FUNCTION  Asciiz2Str(VAR AsciiZStr; MaxLen: Byte): String;
PROCEDURE Str2AsciiZ(InStr: String; VAR AsciiZStr; Len: Byte);
FUNCTION  ReplaceStr(InStr: String; CONST FName: S12): String;
FUNCTION  ToChar(x : Word): S2;
FUNCTION  Address(Net, Node: Integer): S8;

IMPLEMENTATION

USES OpString, Dos;

  FUNCTION ReplaceEnv(S: String): String;
  Var
    x,y,z : byte;
    tmp   : String;
  Begin
    IF (Length(s)>3) AND (Pos('%',s)<>0) Then
    BEGIN
      z:=1;
      WHILE z<Length(s) DO
      BEGIN
        x:=z;
        WHILE (s[x]<>'%') AND (x<=Length(s)) DO
          Inc(x);
        y:=x+1;
        WHILE NOT (s[y] in ['%',' ']) AND (y<Length(s)) DO
          Inc(y);
        IF s[y]=' ' THEN
          z:=y+1
        ELSE
          IF (y<=Length(s)) AND (s[y]<>'%') THEN
            z:=255
          ELSE
          BEGIN
            Tmp:=GetEnv(StUpCase(Copy(s,x+1,y-x-1)));
            Delete(s,x,y-x+1);
            Insert(Tmp,s,x);
            z:=x+Length(Tmp);
          END;
      END;
    END;
    ReplaceEnv:=S;
  END;

  FUNCTION NextWord(ch: Char; VAR s: STRING): STRING;
  VAR
    ss : STRING;
    p:BYTE;
  BEGIN
    p:=POS(ch,s);
    IF p>0 THEN
    BEGIN
      ss:=Copy(s, 1, Pos(ch,s)-1);
      Delete(s, 1, Length(ss)+1);
    END
    ELSE
    BEGIN
      ss:=s;
      s:='';
    END;
    NextWord:=ss;
  END;

  FUNCTION ReverseStr(CONST s:STRING): STRING;
  VAR
    ss : STRING;
    i  : Byte;
  BEGIN
    ss:='';
    FOR i:=Length(s) DOWNTO 1 DO
      ss:=ss+s[i];
    ReverseStr:=ss;
  END;

  FUNCTION CPad(CONST s: String; l: Byte): String;
  BEGIN
    CPad:=Copy(Pad(s,l),1,l);
  END;

  FUNCTION  Address2Str(CONST Address: TFidoAddress): S40;
  BEGIN
    WITH Address DO
      Address2Str:=Long2Str(Zone)+':'+Long2Str(Net)+'/'+Long2Str(Node)+'.'+Long2Str(Point);
  END;

  FUNCTION ReplaceStr(InStr: String; CONST FName: S12): String;
  VAR
    i : Byte;
  BEGIN
    FOR i:=Length(FName) DOWNTO 1 DO
    BEGIN
      Replace(InStr,'$'+Long2Str(i),FName[i],0);
    END;
    ReplaceStr:=InStr;
  END;

  FUNCTION Asciiz2Str(VAR AsciiZStr; MaxLen: Byte): String;
  VAR
    AsciiZArray    : ARRAY[1..254] OF Char ABSOLUTE AsciiZStr;
    Tmp            : String;
    a              : Byte;
  BEGIN
    Tmp:='';
    a:=1;
    WHILE (AsciiZArray[a] <> #0) AND (a <= MaxLen) DO
    BEGIN
      Tmp:=Tmp+AsciiZArray[a];
      Inc(a);
    END;
    Asciiz2Str:=Tmp;
  END;

  PROCEDURE Str2AsciiZ(InStr: String; VAR AsciiZStr; Len:BYTE);
  BEGIN
    FillChar(AsciiZStr, Len, 0);
    IF Length(InStr)<Len THEN Len:=Length(InStr) ELSE Dec(Len);
    Move(InStr[1], AsciiZStr, Len);
  END;

  PROCEDURE Replace(VAR S1: String; CONST S2, S3: String; N: Integer);
  VAR
    i              : Byte;
  BEGIN
    REPEAT
      i := pos(S2, S1);
      n := 0;
      IF i > 0 THEN
      BEGIN
        Delete(S1, i, Length(S2));
        Insert(S3, S1, i);
        Dec(n);
      END;
    UNTIL (i = 0) OR (n = 0);
  END;

  FUNCTION tochar(x: Word) : S2;
  BEGIN
    ToChar := LongIntForm('@@', x);
  END;

  FUNCTION Address(Net, Node : Integer) : S8;
  BEGIN
    Address:=HexW(WORD(Net))+HexW(WORD(Node));
  END;

END.
