UNIT Share;
{ͻ}
{ Lowlevel routines to use SHARE.EXE            Last changed: 20.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

FUNCTION ShareInstalled: Boolean;
FUNCTION Lock(VAR f: file; Start,Size: LongInt; VAR ErrCode: Word): Boolean;
FUNCTION UnLock(VAR f: file; Start,Size: LongInt): Boolean;

IMPLEMENTATION

USES Dos
{$IFDEF OS2}
     , Os2Base
{$ENDIF}
     ;

{$IFDEF OS2}
  FUNCTION ShareInstalled: Boolean;
  BEGIN
    ShareInstalled:=True;
  END;

{$ELSE}
  FUNCTION ShareInstalled: Boolean; Assembler;
  ASM
    mov   ax,$1000
    int   $2f
    cmp   al,$ff
    mov   al,1             { assume ok }
    je    @1
    dec   al
@1:
  END;
{$ENDIF}

{$IFDEF OS2}
  FUNCTION Lock(VAR f: file; Start,Size: LongInt; VAR ErrCode: Word): Boolean;
  VAR
    UnLockRange, LockRange : FileLock;
  BEGIN
    FillChar(UnlockRange, SizeOf(UnLockRange), 0);
    LockRange.lOffset:=Start;
    LockRange.lRange:=Size;
    ErrCode:=DosSetFileLocks(FileRec(f).Handle, UnLockRange, LockRange,0,0);
{writeln(ErrCode,' ',Start,' ',Size);}
    Lock:=(ErrCode<>33);
    Lock:=True;
  END;

{$ELSE}
  FUNCTION Lock(VAR f: file; Start,Size: LongInt; VAR ErrCode: Word): Boolean;
  VAR
    Regs: Registers;
  BEGIN
    Regs.ax:=$5c00;
    Regs.bx:=FileRec(f).Handle;
    regs.di:=Word(Size);
    Regs.si:=Word(Size shr 16);
    Regs.dx:=Word(Start);
    Regs.cx:=Word(Start shr 16);
    Intr($21,regs);
    ErrCode:=Regs.ax;
    Lock:=NOT (Odd(Regs.Flags) AND (Regs.ax=$21));
  END;
{$ENDIF}

{$IFDEF OS2}
  FUNCTION UnLock(VAR f: file; Start,Size: LongInt): Boolean;
  VAR
    UnLockRange, LockRange : FileLock;
  BEGIN
    FillChar(LockRange, SizeOf(LockRange), 0);
    UnLockRange.lOffset:=Start;
    UnLockRange.lRange:=Size;
    UnLock:=(DosSetFileLocks(FileRec(f).Handle, UnLockRange, LockRange,0,0)<>33);
  END;

{$ELSE}
  FUNCTION UnLock(VAR f: file; Start,Size: LongInt): Boolean;
  VAR
    Regs: Registers;
  BEGIN
    Regs.ax:=$5c01;
    Regs.bx:=FileRec(f).Handle;
    regs.di:=Word(Size);
    Regs.si:=Word(Size shr 16);
    Regs.dx:=Word(Start);
    Regs.cx:=Word(Start shr 16);
    intr($21,regs);
    UnLock:=Not (Odd(Regs.Flags) And (Regs.ax=$21));
  END;
{$ENDIF}

END.
