UNIT SelfChk;
{ͻ}
{ Self test module                              Last changed: 04.06.99  MR }
{                                                                          }
{                       (C) Copyright 1992 by                              }
{                            Arne Schpers                                 }
{                            published in c't 7/92                         }
{                                                                          }
{                       (C) Copyright 1999 by                              }
{                            Marcus Roeckrath                              }
{                           2:2449/523@fidonet                             }
{                        marcus.roeckrath@gmx.de                           }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, Dos, OPCrt;

TYPE ChkTwoLong = ARRAY[0..1] OF LONGINT;

CONST Copyright : STRING[34] = 'Self Test - Arne Schpers/c''t 1992';
      VirMsg    : STRING[34] = 'Error : Program modified/infected!';
      OkMsg     : STRING[16] = '-- Program Ok --';

FUNCTION SelfTest(VAR OrgVals : ChkTwoLong) : BOOLEAN;


IMPLEMENTATION

TYPE EXEHdrTyp = RECORD
       Signature        : SmallWord;
       ImgLo, ImgHi     : SmallWord;
       RelocItems       : SmallWord;
       HdrSize          : SmallWord;
       MinHeap, MaxHeap : SmallWord;
       StartSP, StartSS : SmallWord;
       Checksum         : SmallWord;
       StartIP, StartCS : SmallWord;
       RelocStart       : SmallWord;
     END;

     RelocTblType = ARRAY[0..9999] OF POINTER;

VAR RunningChk : ChkTwoLong;

PROCEDURE ErrStop(Msg : STRING; Stop : SmallWord);
CONST Abort : STRING[16] = 'Program aborted!';
BEGIN
  Writeln(#13#10, Msg);
  Writeln(#13#10, Abort);
  Halt(Stop);
END;

PROCEDURE CalcCheck(N : SmallWord);
BEGIN
  Inc(RunningChk[0], Lo(N)+Hi(N));
  RunningChk[1] := RunningChk[1] XOR N;
  RunningChk[1] := (RunningChk[1] SHL 1) OR BYTE(RunningChk[1] < 0);
END;

CONST
  StartMsg  : STRING[15] = 'Self Test Modul';
  WrProtect : STRING[62] = 'Error : Program write protected - Initialisation not possible!';
  NoPrgFile : STRING[31] = 'Error : Program file not found!';
  BadHeader : STRING[48] = 'Error : File header could not be read correctly!';
  OldDosVer : STRING[72] = 'Test requires DOS 3.0 or higher!' + #13#10 +
                           'Program will continue without testing!';
  InitMsg   : STRING[33] = '-- Initialisation of self test --';
  TestMsg   : STRING[54] = '-- Testing program for modifications and infections --';

FUNCTION SelfTest(VAR OrgVals : ChkTwoLong) : BOOLEAN;
VAR ProgFile         : FILE;
    Header           : EXEHdrTyp;
    RelocTbl         : ^RelocTblType;
    RelocIndex       : SmallWord;
    X, ChkBytes      : SmallWord;
    ChkStart, ChkEnd : ^SmallWord;
    ChkDone          : BOOLEAN;
    I                : LONGINT;
BEGIN
  Writeln(#13#10, StartMsg);
  IF Lo(DosVersion) < 3 THEN BEGIN
    Writeln(#13#10, OldDosVer);
    Delay(1000);
  END
  ELSE BEGIN
    X := FileMode;
    IF (OrgVals[0] OR OrgVals[1]) = 0 THEN BEGIN
      FileMode := 2;
      Writeln(InitMsg);
    END
    ELSE BEGIN
      FileMode := 0;
      Writeln(TestMsg);
    END;
    Assign(ProgFile, ParamStr(0));
    {$I-} Reset(ProgFile, 1); {$I+}
    FileMode := X;
    X := IOResult;
    IF X = 5 THEN BEGIN
      ErrStop(WrProtect, 255);
    END
    ELSE BEGIN
      IF X <> 0 THEN BEGIN
        ErrStop(NoPrgFile, 255);
      END
      ELSE BEGIN
        BlockRead(ProgFile, Header, SizeOf(Header), X);
        IF X <> SizeOf(Header) THEN BEGIN
          ErrStop(BadHeader, 255);
        END
        ELSE BEGIN
          GetMem(RelocTbl, SizeOf(Pointer)*Header.RelocItems);
          Seek(ProgFile, Header.RelocStart);
          BlockRead(ProgFile, RelocTbl^, SizeOf(Pointer)*Header.RelocItems);
          RunningChk[0] := 0;
          RunningChk[1] := 0;
          ChkStart := @Header;
          FOR X := 1 TO 13 DO BEGIN
            CalcCheck(ChkStart^);
            Inc(LONGINT(ChkStart), 2);
          END;
          ChkDone := FALSE;
          ChkStart := Ptr(PrefixSeg+$10, 0);
          RelocIndex := 0;
          WHILE NOT ChkDone DO BEGIN
            IF RelocIndex = Header.RelocItems THEN BEGIN
              ChkEnd := Ptr(DSeg, 0);
              ChkDone := TRUE;
            END
            ELSE ChkEnd := Ptr(Seg(RelocTbl^[RelocIndex]^)+PrefixSeg+$10, Ofs(RelocTbl^[RelocIndex]^));
            I := Ofs(ChkEnd^) DIV 16;
            Inc(LONGINT(ChkEnd), I*$FFF0);
            Inc(RelocIndex);
            IF LONGINT(Seg(ChkEnd^)) SHL 4 + Ofs(ChkEnd^) < LONGINT(DSeg) SHL 4 THEN BEGIN
              IF LONGINT(Seg(ChkEnd^)) SHL 4 + Ofs(ChkEnd^) > LONGINT(Seg(ChkStart^)) SHL 4 + Ofs(ChkStart^) THEN BEGIN
                ChkBytes := (Seg(ChkEnd^) - Seg(ChkStart^))*16 + Ofs(ChkEnd^) - Ofs(ChkStart^);
                FOR X := 1 TO ChkBytes DIV 2 DO BEGIN
                  CalcCheck(ChkStart^);
                  Inc(LONGINT(ChkStart), 2);
                END;
                IF Odd(ChkBytes) THEN BEGIN
                  CalcCheck(ChkStart^ AND $FF);
                  Inc(LONGINT(ChkStart), 1);
                END;
                CalcCheck(ChkEnd^ - PrefixSeg - $10);
                Inc(LONGINT(ChkEnd), 2);
                ChkStart := ChkEnd;
              END
              ELSE Writeln('Huh?');
            END;
          END;
          IF (OrgVals[0] OR OrgVals[1]) = 0 THEN BEGIN
            Seek(ProgFile, (LONGINT(Header.HdrSize) + DSeg - PrefixSeg - $10)*16 + Ofs(OrgVals[0]));
            BlockWrite(ProgFile, RunningChk, SizeOf(RunningChk));
            SelfTest := TRUE;
          END
          ELSE SelfTest := (RunningChk[0] = OrgVals[0]) AND (RunningChk[1] = OrgVals[1]);
          Close(ProgFile);
          FreeMem(RelocTbl, SizeOf(Pointer)*Header.RelocItems);
        END;
      END;
    END;
  END;
END;

END.
