UNIT PTpl;
{ͻ}
{ Template routines                             Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{ͻ}
{ Changes made by the German Portal Team                                   }
{                                                                          }
{ By                : Marcus Roeckrath                                     }
{ First Modification: 17 August 1999                                       }
{ Last Modification : 17 August 1999                                       }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, Dos, OpDate, PoPTypes;

VAR
  StartTime,
  EndTime   : Time;
  OkPath    : PathStr;

PROCEDURE AddTpl(CONST FNam: PathStr; CONST Where: S20; CONST sr: SearchRec);

IMPLEMENTATION

USES OpString, OpRoot,
     OproUtil, FileUtil, StrUtil, MailUtil, LogFile, OpusMsg, Globals, Util;

  PROCEDURE FileToPkt(CONST FNam: PathStr);
  VAR
    f : FILE;
    p : Pointer;
    siz,test:Word;
    ph: TPktHeader;
    pmh:TPktMsgHeader;
    s:STRING;
  BEGIN
    Addlog('+','Converting '+FNam+' to PKT-file');
    Assign(f, FNam); FileMode:=ShareRW+ShareDenyRW;
    Reset(f,1);
    siz:=FileSize(f);
    GetMem(p,siz);
    BLOCKREAD(f,p^,siz,test);
    CLOSE(f);
    DeleteFile(FNam);
    Assign(f,RspFile);
    ReWrite(f,1);
    FillOutPktHeader(Cfg.Addresses[Cfg.MainAdrNum],Call,ph);
    BlockWrite(f,ph,SizeOf(ph),test);
    WITH pmh DO
    BEGIN
      StartMsg:=2;
      OrigNode:=Cfg.Addresses[Cfg.MainAdrNum].Node;
      DestNode:=Call.Node;
      OrigNet:=Cfg.Addresses[Cfg.MainAdrNum].Net;
      DestNet:=Call.Net;
      s:=ToChar(ph.day)+' '+COPY(MonthString[ph.month],1,3)+' '+ToChar(ph.year MOD 100)+
         '  '+ToChar(ph.hour)+':'+ToChar(ph.min)+':'+ToChar(ph.sec)+#0;
      MOVE(s[1],pmh.time,20);
      attr:=MsgSent+MsgPrivate;
    END;
    BlockWrite(f,pmh,SizeOf(pmh),Test);
    s:=AsciiZ2Str(RemHello.SysOp,20)+#0+cfg.SysOp+#0+'Files from '+Cfg.System+#0+
       KludgeLines(Cfg.Addresses[Cfg.MainAdrNum],Call)+#13#10;
    BlockWrite(f,s[1],Length(s),test);
    BlockWrite(f,p^,siz,test);
    s:=#0#0#0;
    BlockWrite(f,s[1],Length(s),test);
    CLOSE(f);
    FreeMem(p,siz);
  END;

  FUNCTION TplPartNumber(CONST s: S20):BYTE;
  CONST
    Parts='*HEADER*FWDHEADER*NOTFOUND*FOUND*FWDBODY*TOOMANY*TOOBIG*TIMEOUT*FOOT*FWDFOOT*';
           {   1       8        18      27    33      41      49     56     64     69 }
  BEGIN
    TplPartNumber:=Pos('*'+s+'*',Parts);
  END;

  PROCEDURE AddTpl(CONST FNam: PathStr; CONST Where: S20; CONST sr: SEARCHREC);
  VAR
    Dt             : DateTime;
    endit, endtpl, found : Boolean;
    f, rsp, tpl    : PBufTextFile;
    ss, s, t       : String;
    hour,min,sec,wh: BYTE;
  BEGIN
    New(Tpl, Init(StartPath+PoPTemplateFileName, SOpenRead+ShareDenyW, 2048));
    IF Tpl=NIL THEN Exit;
    Found:=False;
    WHILE NOT Tpl^.EoF AND NOT found DO
    BEGIN
      Tpl^.ReadLn(s);
      s:=StUpCase(s);
      IF Copy(s, 1, 1+Length(Where))='/'+where THEN found:=True;
    END;
    IF Found THEN
    BEGIN
      IF NOT ChkDir(JustPathName(FNam)) THEN
      BEGIN
        MakeFullDir(JustPathName(FNam));
        AddLog('!', 'Creating outbound: '+JustPathName(FNam));
      END;
      wh:=TplPartNumber(where);
      New(Rsp, InitCreate(FNam, SOpenWrite, 256));
      endtpl:=False;
      WHILE NOT Tpl^.EoF AND NOT endtpl DO
      BEGIN
        Tpl^.ReadLn(s);
        IF Copy(s, 1, 1)='/' THEN endtpl:=True ELSE
        BEGIN
          { Global wild cards }
          Replace(s, '$oursysop',Cfg.SysOp,0);
          Replace(s, '$oursystem',Cfg.System,0);
          Replace(s, '$curtime', currenttimestring('hh:mm:ss'), 0);
          Replace(s, '$curdate', todaystring('dd/mm-yy'), 0);

          { Part-specific wild cards }

          IF wh IN [18,27,33,41,49,56] THEN
            Replace(s, '$gotfilename', CPad(sr.name,12), 0);

          IF wh IN [27,33,41,49,56] THEN
          BEGIN
            Replace(s, '$filesize', LongIntForm('#########',sr.size), 0);

            UnPackTime(sr.Time, Dt);
            WITH Dt DO
            BEGIN
              t:=ToChar(Day)+'/'+ToChar(Month)+'-'+ToChar(Year MOD 100)+' ';
              Replace(s, '$filedate', t, 0);
              t:=ToChar(Hour)+':'+ToChar(Min)+':'+ToChar(Sec)+' ';
              Replace(s, '$filetime', t, 0);
            END;
          END;

          CASE wh OF
             1  : Replace(s, '$sysopname', RemHello.sysop, 0);
             8  : Replace(s,'$sysopname',FwdSysOpName,0);
            18  : BEGIN
                    Replace(s, '$filesize', 'UNKNOWN  ', 0);
                    Replace(s, '$filedate', 'UNKNOWN  ', 0);
                    Replace(s, '$filetime', 'UNKNOWN  ', 0);
                    Replace(s, '$filedesc', '', 0);
                  END;
    27,33,41,49 : BEGIN
                    IF Pos('$filedesc', s)<>0 THEN
                    BEGIN
                      ss:='';
                      IF wh=27 THEN
                      BEGIN
                        New(f, Init(OkPath+'\FILES.BBS', SOpenRead+ShareDenyNone, Max64k(MaxAvail-1024)));
                        endit:=False;
                        IF f<>NIL THEN
                        BEGIN
                          WHILE NOT endit AND NOT f^.EoF DO
                          BEGIN
                            f^.ReadLn(ss);
                            IF Pos(sr.Name, ss)=1 THEN
                            BEGIN
                              Delete(ss, 1, Length(sr.Name)+1);
                              WHILE Copy(ss, 1, 1)=' ' DO
                                Delete(ss, 1, 1);
                              endit:=True;
                            END;
                          END;
                          Dispose(f, Done);
                        END;
                        IF NOT endit THEN ss:='';
                      END ELSE
                        ss:=ReplaceStr(OkPath, sr.name);
                      Replace(s, '$filedesc', ss, 0);
                    END;
                  END;
             64 : BEGIN
                    Replace(s, '$filescnt', Long2Str(sr.attr), 0);
                    Replace(s, '$filesize', Long2Str(sr.size), 0);
                    EndTime:=CurrentTime;
                    timediff(starttime, EndTime, Hour, Min, Sec);
                    t:=ToChar(Hour)+':'+ToChar(Min)+':'+ToChar(Sec);
                    Replace(s, '$reqtime', t, 0);
                  END;
          END;
          Replace(s, #0, '', 0);
          Rsp^.WriteLn(s);
        END;
      END;
      Dispose(Rsp, Done);
      IF (wh=64) And (Cfg.Request.RspAsPkt) THEN FileToPkt(FNam);
    END;
    Dispose(Tpl, Done);
  END;

END.
