UNIT OutUtil;
{ͻ}
{ Outbound utilities                            Last changed: 30.06.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, Dos, PoPTypes;

CONST
  STypeArray  : Array[1..3] OF String[1] = ('','^','#');

  STNothing = 1;
  STDelete  = 2;
  STTrunc   = 3;

PROCEDURE SendAFile(CONST FName: PathStr; CONST Address: TFidoAddress; Flavor: Char; Stype: Byte);
FUNCTION  RequestAFile(CONST FName: S12; CONST Address: TFidoAddress; CONST Password: S20): Boolean;
FUNCTION  MakeAPoll(CONST Address: TFidoAddress; Flavor: Char): Boolean ;
FUNCTION  SelectMailType(VAR Escaped : Boolean; HelpTopic: WORD) : Byte;

PROCEDURE GlueNode(CONST Address: TFidoAddress);
PROCEDURE UnGlueNode(CONST Address: TFidoAddress);

IMPLEMENTATION

USES OpString, OpCmd,
     OproUtil, MailUtil, NetFile{FileUtil}, Resource, Globals;

  PROCEDURE SendAFile(CONST FName: PathStr; CONST Address: TFidoAddress; Flavor: Char; Stype: Byte);
  VAR
    TempFile : TNetFile;
    s        : String;
    Found    : Boolean;
  BEGIN
    IF TempFile.OpenWithMode(HoldFileName(Address,True)+Flavor+'LO', 1, True, ShareRW+ShareDenyW) THEN
    BEGIN
      Found:=False;
      WHILE NOT Found AND Not TempFile.EoF DO
      BEGIN
        TempFile.ReadLine(s);
        IF (s<>'') AND (s[1] IN ['^','~','#']) THEN Delete(s,1,1);
        Found:=(StUpCase(s)=StUpCase(FName));
      END;
    END;
    IF NOT Found THEN
    BEGIN
      TempFile.Seek(TempFile.FileSize);
      TempFile.WriteLine(STypeArray[SType]+FName);
    END;
    TempFile.Close;
  END;

  FUNCTION RequestAFile(CONST FName: S12; CONST Address: TFidoAddress; CONST Password: S20): Boolean;
  VAR
    ReqFile : TNetFile;
    Found   : Boolean;
    s       : String;
  BEGIN
    IF ReqFile.OpenWithMode(HoldFileName(Address,True)+'REQ', 1, True, ShareRW+ShareDenyW) THEN
    BEGIN
      Found:=False;
      WHILE NOT ReqFile.EoF AND NOT Found DO
      BEGIN
        ReqFile.ReadLine(s);
        IF (Length(s)>0) AND (s[1] <> ';') THEN
        BEGIN
          IF Pos(' ',s)>0 THEN s:=Copy(s, 1, Pos(' ',s)-1);
          Found:=StUpCase(s)=StUpCase(FName);
        END;
      END;
      ReqFile.Seek(ReqFile.FileSize);
      IF NOT Found THEN
      BEGIN
        IF Password='' THEN
          ReqFile.WriteLine(FName)
        ELSE
          ReqFile.WriteLine(FName+' !'+Password);
      END;
      ReqFile.Close;
      RequestAFile:=NOT Found;
    END ELSE
      RequestAFile:=False;
  END;

  FUNCTION MakeAPoll(CONST Address: TFidoAddress; Flavor: Char): Boolean ;
  VAR
    PollFile : FILE;
  BEGIN
    Assign(PollFile, HoldFileName(Address,True)+Flavor+'LO');
    Reset(PollFile,1);
    IF IOResult=0 THEN
    BEGIN
      MakeAPoll:=False;
    END ELSE
    BEGIN
      Rewrite(PollFile,1);
      MakeAPoll:=True;
    END ;
    Close(PollFile);
  END;

  FUNCTION SelectMailType(VAR Escaped: Boolean; HelpTopic: Word): Byte;
  VAR
    m         : TPoPMenu;
    OldTopic,
    LastCmd,
    key       : Word;
  BEGIN
    OldTopic:=Topic;
    Topic:=HelpTopic;
    GetMenu(MnuOMSelMailType,3,m);
    m.ProcessMenu(Key, LastCmd);
    Escaped:=(LastCmd=ccQuit);
    SelectMailType:=Byte(Key);
    Topic:=OldTopic;
  END;

  PROCEDURE GlueNode(CONST Address: TFidoAddress);
  VAR
    GlueFile : FILE;
  BEGIN
    Assign(GlueFile, HoldFileName(Address,True)+'GLU');
    ReWrite(GlueFile,1);
    Close(GlueFile);
    IF IOResult<>0 THEN ;
  END;

  PROCEDURE UnGlueNode(CONST Address: TFidoAddress);
  VAR
    GlueFile : FILE;
  BEGIN
    Assign(GlueFile, HoldFileName(Address,True)+'GLU');
    Erase(GlueFile);
    IF IOResult<>0 THEN ;
  END;

END.
