UNIT OpusMsg;
{ͻ}
{ Lser/skriver opus style *.msg breve          Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, PoPTypes, Dos;

CONST
  MsgPrivate = $0001;
  MsgCrash   = $0002;
  MsgRead    = $0004;
  MsgSent    = $0008;
  MsgFile    = $0010;
  MsgFwd     = $0020;
  MsgOrphan  = $0040;
  MsgKill    = $0080;
  MsgLocal   = $0100;
  MsgHold    = $0200;
  Msgxx2     = $0400;
  MsgFreq    = $0800;
  MsgRReq    = $1000;
  MsgRcpt    = $2000;
  MsgAReq    = $4000;
  MsgUpdReq  = $8000;

TYPE
  MsgHdrType = RECORD
                 FromUser  : String[35];
                 ToUser    : String[35];
                 Subject   : String[71];
                 DateTime  : String[19];
                 TimesRead : Word;
                 DestNode  : Integer;
                 OrigNode  : Integer;
                 Cost      : Word;
                 OrigNet   : Integer;
                 DestNet   : Integer;
                 DestZone  : Integer;
                 OrigZone  : Integer;
                 DestPoint : Integer;
                 OrigPoint : Integer;
                 ReplyTo   : Word;
                 Attribute : Word;
                 NextReply : Word;
               END;

FUNCTION GetHighestMsg(CONST Path: PathStr): Word;
FUNCTION ReadMsg(CONST Path:PathStr; MNum:Word; VAR Hdr: MsgHdrType; VAR TxtLen: LongInt; VAR Txt: Pointer): BOOLEAN;
PROCEDURE WriteMsg(CONST Path: PathStr; MNum: Word; Hdr: MsgHdrType; Len:WORD; Txt: Pointer);

PROCEDURE SetTimeStamp(VAR Hdr:MsgHdrType);

PROCEDURE FindMsgAdr(CONST h: MsgHdrType; buf:POINTER; Len:WORD; VAR Orig,Dest:TFidoAddress);
PROCEDURE FindMsgKludges(Buf:POINTER; Len:WORD; VAR Dir,Imp,Hold:BOOLEAN);

IMPLEMENTATION

USES OpString, OpDate, OpRoot,
     StrUtil, LogFile, Util, MailUtil, Globals;


PROCEDURE FindMsgAdr(CONST h: MsgHdrType; buf:POINTER; Len:WORD; VAR Orig,Dest:TFidoAddress);
VAR
  Test:INTEGER;
  x:WORD;
  s:STRING;
  Tmp:TFidoAddress;
BEGIN
  FILLCHAR(Dest,SizeOf(TFidoAddress),0);
  FILLCHAR(Orig,SizeOf(TFidoAddress),0);
  Dest.Net:=h.DestNet;
  Dest.Node:=h.DestNode;
  Orig.Net:=h.OrigNet;
  Orig.Node:=h.OrigNode;
  x:=0;
  s:='';
  REPEAT
    INC(x);
  UNTIL (CT(buf^)[x]=#1) OR (x>=len);
  DEC(x);
  REPEAT
    INC(x);
    IF (CT(buf^)[x] IN [#10,#13]) THEN
    BEGIN
      IF (COPY(s,1,5)=#1'FMPT') THEN VAL(COPY(s,6,10),Orig.Point,Test) ELSE
        IF (COPY(s,1,5)=#1'TOPT') OR (COPY(s,1,5)=#1'*2PT') THEN VAL(COPY(s,6,10),Dest.Point,Test) ELSE
          IF (COPY(s,1,6)=#1'MSGID') THEN
          BEGIN
            DELETE(s,1,POS(' ',s));
            GetAdressFromStr(NextWord(' ',s),Orig);
          END
          ELSE
            IF COPY(s,1,5)=#1'INTL' THEN
            BEGIN
              DELETE(s,1,POS(' ',s));
              GetAdressFromStr(NextWord(' ',s),Tmp);
              Dest.Zone:=Tmp.Zone;
              Dest.Net :=Tmp.Net ;
              Dest.Node:=Tmp.Node;
              GetAdressFromStr(s,Tmp);
              Orig.Zone:=Tmp.Zone;
              Orig.Net :=Tmp.Net ;
              Orig.Node:=Tmp.Node;
            END;
      s:='';
    END ELSE
    BEGIN
      s:=s+CT(buf^)[x];
    END;
  UNTIL ((s<>'') AND (s[1]<>#1)) OR (x>=len);
  IF Dest.Zone=0 THEN Dest.Zone:=Cfg.Addresses[Cfg.MainAdrNum].Zone;
  IF Orig.Zone=0 THEN Orig.Zone:=Cfg.Addresses[Cfg.MainAdrNum].Zone;
END;

PROCEDURE FindMsgKludges(Buf:POINTER; Len:WORD; VAR Dir,Imp,Hold:BOOLEAN);
VAR
  i:WORD;
  ch:CHAR;
  s:STRING;
BEGIN
  Dir:=FALSE;
  Imp:=FALSE;
  Hold:=FALSE;
  i:=0;
  s:='';
  WHILE (i<=Len) DO
  BEGIN
    ch:=CT0(Buf^)[i];
    IF (ch<>#10) AND (ch<>#13) THEN s:=s+Ch ELSE
    BEGIN
      IF s<>'' THEN
      BEGIN
        IF s[1]<>#1 THEN Break;
        IF COPY(s,1,6)=#1'FLAGS' THEN
        BEGIN
          s:=Trim(COPY(s,7,255))+' ';
          IF POS('DIR ',s)>0 THEN Dir:=TRUE;
          IF POS('IMM ',s)>0 THEN Imp:=TRUE;
          IF POS('HLD ',s)>0 THEN Hold:=TRUE;
        END;
      END;
      s:='';
    END;
    INC(i);
  END;
END;

PROCEDURE SetTimeStamp(VAR Hdr:MsgHdrType);
VAR
  D,M,Y,DoW:WORD;
  s:STRING;
BEGIN
  WITH Hdr DO
  BEGIN
    GetDate(Y,M,D,DoW);
    s:=LongIntForm('@#',d)+' '+COPY(MonthString[m],1,3)+' '+LongIntForm('##',Y MOD 100)+'  '+CurrentTimeString('hh:mm:ss');
    Str2AsciiZ(s,DateTime,20);
  END;
END;

FUNCTION GetHighestMsg(CONST Path: PathStr): Word;
VAR
  SRec : SearchRec;
  High, MNum : Word;
  Ok         : Integer;
BEGIN
  FindFirst(AddBackSlash(Path)+'*.MSG',AnyFile,Srec);
  High:=0;
  WHILE DOSError=0 DO
  BEGIN
    Val(Copy(SRec.Name,1,Pos('.',SRec.Name)-1),MNum,Ok);
    IF MNum>High THEN High:=MNum;
    FindNext(SRec);
  END;
  FindClose(SRec);
  GetHighestMsg:=High;
END;

FUNCTION ReadMsg(CONST Path: PathStr; MNum:Word; VAR Hdr: MsgHdrType; VAR TxtLen: LongInt; VAR Txt: Pointer): BOOLEAN;
VAR
  f:FILE;
  test:WORD;
  s: PathStr;
BEGIN
  ReadMsg:=FALSE;
  s:=AddBackSlash(Path)+Long2Str(MNum)+'.MSG';
  ASSIGN(f,s); FileMode:=ShareRead+ShareDenyW;
  RESET(f,1);
  IF IoResult<>0 THEN EXIT;
  BLOCKREAD(f,Hdr,SizeOf(Hdr),Test);
  IF Test<SizeOf(Hdr) THEN
  BEGIN
    CLOSE(f);
    EXIT;
  END;
  TxtLen:=FileSize(f)-FilePos(f);
  IF (TxtLen>64000) OR NOT GetMemCheck(Txt, TxtLen) THEN
  BEGIN
    CLOSE(f);
    EXIT;
  END;
  BlockRead(f, txt^, TxtLen, Test);
  CLOSE(f);
  IF (Test<TxtLen) OR (MaxAvail<4096) THEN
    FreeMemCheck(txt,TxtLen)
  ELSE
    ReadMsg:=TRUE;
END;

PROCEDURE WriteMsg(CONST Path: PathStr; MNum: Word; Hdr: MsgHdrType; Len:WORD; Txt:POINTER);
VAR
  MsgFile : File;
  Written : Word;
BEGIN
  Assign(MsgFile, AddBackSlash(Path)+Long2Str(MNum)+'.MSG');
  ReWrite(MsgFile,1);
  BlockWrite(MsgFile,Hdr,SizeOf(Hdr),Written);
  IF Written<>SizeOf(Hdr) THEN
    AddLog('!','Error writing message')
  ELSE
    BlockWrite(MsgFile,Txt^, Len,Written);
  IF Written<>Len THEN
    AddLog('!','Error writing message');
  Close(MsgFile);
END;

END.
