UNIT NewImp;
{ͻ}
{ New Import                                    Last changed: 20.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-94 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}
{ͻ}
{ Changes made by the German Portal Team                                   }
{                                                                          }
{ By                : Marcus Roeckrath                                     }
{ First Modification: 08 February 1999                                     }
{ Last Modification : 13 October 1999                                      }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}

INTERFACE

USES Use32;

PROCEDURE ImportConfig;

IMPLEMENTATION

USES Oproot, Opstring, Dos, PopTypes, Resource, StrUtil, Netfile, LogFile,
     MailUtil, Globals, Input, OpDate, OpWindow, Oproutil, Config;

  PROCEDURE ImportConfig;
  VAR
    MainStrDict : StringDictPtr;
    TmpFile     : TNetFile;
    Oldsection,
    Section,
    TokenNr     : LongInt;
    Fname       : PathStr;
    AstCount,
    AdrNum      : Byte;
    TickRec     : TTickArea;
    FileFwdRec  : TFileFwd;
    nltrec      : TNLTranslat;
    ScdRec      : TSchedule;
    okfrec      : Tokfile;
    AreaRec     : TMsgArea;
    NlsRec      : TNodelistseg;
    Win         : WindowPtr;
    Overwrite   : Boolean;
    MFSrec      : TFileListSegment;

    PROCEDURE Split(s: String; VAR Token, Rest: String);
    BEGIN
      s:=trimspaces(s);
      Token:=StUpCase(NextWord(' ',s));
      Rest:=s;
    END;

    PROCEDURE ImportFile(FName: PathStr);
    VAR
      LocalStrDict : StringDictPtr;
      f : Text;
      s : String;
      Token, Rest  : STRING;

      FUNCTION TrimRest:STRING;
      BEGIN
        TrimRest:=TrimSpaces(Rest);
      END;

      FUNCTION BooleanRest:BOOLEAN;
      BEGIN
        BooleanRest:=(StUpCase(TrimRest)='YES');
      END;

      PROCEDURE ImportSystem;
      VAR
        Test2  : Longint;
        Test   : integer;
        z      : byte;
      BEGIN
        CASE TokenNr OF
           1 : Cfg.Version := CfgVersion; {Val(rest, Cfg.Version, test);}
           2 : Val(rest, Cfg.Tasknumber, test);
           3 : cfg.Swapdir:=Trimrest;
           4 : cfg.OutBound:=trimrest;
           5 : Cfg.Banner:=trimrest;
           6 : Cfg.DefaultMacro:=trimrest;
           7 : cfg.Editor:=trimrest;
           8 : cfg.LogFileName:=trimrest;
           9 : Val(rest, cfg.loglevel, test);
          10 : cfg.UseYearinlog:=BooleanRest;
          11 : cfg.nodelist:=trimrest;
          12 : BEGIN
                 if MainStrDict^.Member(TrimRest, test2) then
                   cfg.Nodelisttyp:=NodelistType(Test2 - 520);
               END;
          13 : Val(rest, cfg.mainAdrNum, test);
          14 : BEGIN
                 Rest:=trimspaces(rest);
                 Inc(Adrnum);
                 GetAdressFromStr(Rest,Cfg.Addresses[AdrNum]);
               END;
          15 : Val(rest, cfg.Pointnet, test);
          16 : Cfg.UsefakeAddress:=BooleanRest;
          17 : cfg.Sysop:=TrimRest;
          18 : Cfg.System:=TrimRest;
          19 : Cfg.SwapOnExec:=BooleanRest;
          20 : Cfg.EnterBBSText:=TrimRest;
          21 : Cfg.DoingMailText:=TrimRest;
          22 : Cfg.PressESCText:=TrimRest;
          23 : Val(TrimRest,cfg.maxringing, test);
          24 : BEGIN
                 rest:=TrimRest;
                 cfg.Zmhstart:=TimestringtoTime('hh:mm',copy(rest,1,5));
                 cfg.zmhend:=timestringtotime('hh:mm',copy(rest,7,5));
               END;
          25 : Cfg.CallTime:=TimeStringToTime('hh:mm:ss',TrimRest);
          26 : Cfg.CallWidth:=TimeStringToTime('hh:mm:ss',TrimRest);
          27 : Cfg.ConnectFastest:=BooleanRest;
          28 : Cfg.OutReReadDelay:=TimeStringToTime('hh:mm:ss',TrimRest);
          29 : cfg.FuncReqPwd:=TrimRest;
          30 : Cfg.UseJanus:=BooleanRest;
          31 : cfg.UseEmsi:=BooleanRest;
          32 : Cfg.FastCalls:=BooleanRest;
          33 : Cfg.KeepEmptyDirs:=BooleanRest;
          34 : Cfg.Curmudgeon:=BooleanRest;
          35 : Cfg.ReReadOnCall:=BooleanRest;
          36 : Cfg.Inbound[NsUnknown]:=TrimRest;
          37 : cfg.Inbound[NsKnown]:=TrimRest;
          38 : Cfg.Inbound[NsPassword]:=TrimRest;
          39 : Val(TrimRest,cfg.inboundToDo[NsUnknown],test);
          40 : Val(TrimRest,cfg.inboundToDo[Nsknown],test);
          41 : Val(TrimRest,cfg.inboundToDo[Nspassword],test);
          42 : BEGIN
                 rest:=TrimRest;
                 if rest[1]='C' then z:=1 else z:=2;
                 Val(copy(rest,2,2),test2, test);
                 delete(rest,1,4);
                 Val(NextWord('@',rest),cfg.fkey[z,test2].Errorlevel,test);
                 cfg.fkey[z,test2].Description:=rest;
               END;
          43 : Cfg.ZModemDummyPkt:=BooleanRest;
        END;
      END;

      PROCEDURE ImportBBs;
      Var
        Test  : longint;
        test2 : integer;
      BEGIN
        CASE TokenNr of
          1 : BEGIN
                if MainStrDict^.Member(TrimRest, test) then
                  Byte(Cfg.BBs.BBsType):=Test - 500;

              END;
          2 : cfg.BBs.Path:=TrimRest;
          3 : cfg.BBs.UserFile:=TrimRest;
          4 : Val(TrimRest,cfg.bbs.minbaud,test2);
          5 : Cfg.BBs.MinBaudFile:=TrimRest;
          6 : Val(TrimRest,cfg.bbs.userErrorLevel,test2);
          7 : BEGIN
                rest:=TrimRest;
                Val(NextWord(' ',rest),test,test2);
                cfg.bbs.Multi[test].key:=rest[1];
                delete(rest,1,2);
                cfg.bbs.Multi[test].BatName:=rest;
              END;
        END;
      END;

      PROCEDURE ImportModem;
      Var
        test3,
        test2,
        test : Integer;

      BEGIN
        CASE TokenNr of
          1  : Val(TrimRest,cfg.Modem.CommPort, test);
          2  : Val(TrimRest,cfg.modem.BaudRate, test);
          3  : Cfg.Modem.PreInit:=TrimRest;
          4  : Cfg.Modem.Init:=TrimRest;
          5  : Cfg.Modem.NoAnswer:=TrimRest;
          6  : Cfg.Modem.Dial:=TrimRest;
          7  : Cfg.Modem.Busy:=TrimRest;
          8  : Cfg.Modem.HangUp:=TrimRest;
          9  : Cfg.Modem.Answer:=TrimRest;
          10 : Cfg.Modem.ReInit:=TimeStringToTime('hh:mm:ss',TrimRest);
          11 : Cfg.Modem.LockedBaud:=TrimRest;
          12 : BEGIN
                 rest:=TrimRest;
                 Val(NextWord(' ',Rest),test2,test);
                 Cfg.Modem.ExitStr[test2].ConStr:=NextWord('@',rest);
                 Val(rest,Cfg.Modem.ExitStr[test2].Errlvl,test);
               END;
          13 : BEGIN
                 rest:=TrimRest;
                 Val(NextWord(' ',rest),test3,test);
                 Val(NextWord('@',rest),Cfg.Modem.ModemType[Test3].Bit,test);
                 cfg.Modem.ModemType[test3].Dial:=NextWord('@',Rest);
                 Cfg.Modem.ModemType[test3].DialOut:=NextWord('@',rest)='YES';
                 Val(rest,cfg.modem.ModemType[test3].Baud,test);
               END;
          14 : Cfg.Modem.WaitTime:=TimeStringToTime('hh:mm:ss',TrimRest);
          15 : Cfg.Modem.InternalFax:=BooleanRest;
          16 : Cfg.Modem.LinkStat:=TrimRest;
          17 : Val(TrimRest, Cfg.Modem.LogLines, Test);
          18 : Val(TrimRest, Cfg.Modem.ConnectTime, Test);
          19 : Cfg.Modem.UseLCR:=BooleanRest;
          20 : Cfg.Modem.UseRingAnaly:=BooleanRest;
          21 : BEGIN
                 Rest:=TrimRest;
                 Val(NextWord(' ',Rest), test2, test);
                 Cfg.Statistics.MdmProtocol[test2]:=Rest;
               END;
        END;
      END;

      PROCEDURE ImportScreen;
      BEGIN
        CASE TokenNr of
          1 : Cfg.Screen.BlankTime:=TimeStringToTime('hh:mm:ss',TrimRest);
          2 : Cfg.Screen.chkSnow:=BooleanRest;
          3 : Cfg.Screen.KeepOffScrMode:=BooleanRest;
          4 : Cfg.Screen.ScrMode:=BooleanRest;
          5 : Cfg.Screen.HardWareBlank:=BooleanRest;
          6 : Cfg.Screen.ExplodingWin:=BooleanRest;
          7 : Cfg.Screen.FourDigitsYear:=BooleanRest;
        END;
      END;

      PROCEDURE ImportListFile;
      Var
        test2,
        test : integer;
      BEGIN
        CASE TokenNr of
           1 : cfg.ListFiles.FileList:=TrimRest;
           2 : Cfg.ListFiles.NewsList:=TrimRest;
           3 : Cfg.ListFiles.Header:=TrimRest;
           4 : Cfg.ListFiles.Footer:=TrimRest;
           5 : Cfg.ListFiles.TopFile:=TrimRest;
           6 : Cfg.ListFiles.StatFile:=TrimRest;
           7 : Cfg.ListFiles.Adopt:=BooleanRest;
           8 : Cfg.ListFiles.AdoptComment:=TrimRest;
           9 : Cfg.ListFiles.DupeCheck:=BooleanRest;
          10 : Cfg.ListFiles.Stat:=BooleanRest;
          11 : Cfg.ListFiles.IncludeTop:=BooleanRest;
          12 : Val(TrimRest,Cfg.ListFiles.Top,test);
          13 : Cfg.ListFiles.DkDate:=BooleanRest;
          14 : Val(TrimRest,Cfg.ListFiles.NewsDays,test);
          15 : Val(TrimRest,Cfg.Listfiles.thresHold,test);
          16 : Cfg.ListFiles.RemMissing:=BooleanRest;
          17 : Cfg.ListFiles.OkPortal:=BooleanRest;
          18 : Cfg.ListFiles.ZapZero:=BooleanRest;
          19 : Cfg.ListFiles.Touch:=BooleanRest;
          20 : BEGIN
                 rest:=TrimRest;
                 Val(NextWord(' ',rest),Test2,test);
                 Cfg.ListFiles.CrapFiles[test2]:=rest;
               END;
          21 : BEGIN
                 rest:=TrimRest;
                 Val(NextWord(' ',rest),Test2,test);
                 Cfg.ListFiles.ExcludeFiles[test2]:=rest;
               END;
          22 : BEGIN
                 rest:=TrimRest;
                 Val(NextWord(' ',rest),Test2,test);
                 Cfg.ListFiles.NoDupeCheck[test2]:=rest;
               END;
          23 : BEGIN
                 rest:=TrimRest;
                 Val(NextWord(' ',rest),Test2,test);
                 Cfg.ListFiles.NonAdoptFiles[test2]:=rest;
               END;
          24 : BEGIN
                 rest:=TrimRest;
                 Val(NextWord(' ',rest),Test2,test);
                 Cfg.ListFiles.NonAdoptAreas[test2]:=rest;
               END;
          25 : BEGIN
                 rest:=TrimRest;
                 Val(NextWord(' ',rest),Test2,test);
                 Cfg.ListFiles.PrivateAreas[test2]:=rest;
               END;
          26 : Cfg.ListFiles.DoBefore:=TrimRest;
          27 : Cfg.ListFiles.DoAfter:=TrimRest;
          28 : Cfg.ListFiles.DoPack:=TrimRest;
          29 : Cfg.ListFiles.DupeReport:=TrimRest;
          30 : BEGIN
                 Rest:=TrimRest;
                 Val(NextWord(' ',rest),test2,test);
                 Cfg.ListFiles.TXTFreq[test2]:=Rest;
               END;
          31 : Cfg.ListFiles.OkBimodemPath:=TrimRest;
        END;
      END;

      PROCEDURE ImportRequest;
      Var
        test : integer;
      BEGIN
        CASE TokenNr of
           1 : Val(TrimRest,Cfg.Request.Limit[NsUnknown,RlPrDay].MaxFiles,test);
           2 : Val(TrimRest,Cfg.Request.Limit[NsUnknown,RlPrcall].MaxFiles,test);
           3 : Cfg.request.Limit[NsUnKnown,RlPrDay].Maxtime:=TimeStringToTime('hh:mm:ss',TrimRest);
           4 : Cfg.request.Limit[NsUnKnown,RlPrcall].MaxTime:=TimeStringToTime('hh:mm:ss',TrimRest);
           5 : Val(TrimRest,Cfg.Request.Limit[NsUnknown,RlPrDay].MaxBytes,test);
           6 : Val(TrimRest,Cfg.Request.Limit[NsUnknown,RlPrcall].MaxBytes,test);
           7 : Val(TrimRest,Cfg.Request.Limit[Nsknown,RlPrDay].MaxFiles,test);
           8 : Val(TrimRest,Cfg.Request.Limit[Nsknown,RlPrcall].MaxFiles,test);
           9 : Cfg.request.Limit[NsKnown,RlPrDay].Maxtime:=TimeStringToTime('hh:mm:ss',TrimRest);
          10 : Cfg.request.Limit[NsKnown,RlPrcall].MaxTime:=TimeStringToTime('hh:mm:ss',TrimRest);
          11 : Val(TrimRest,Cfg.Request.Limit[Nsknown,RlPrDay].MaxBytes,test);
          12 : Val(TrimRest,Cfg.Request.Limit[Nsknown,RlPrcall].MaxBytes,test);
          13 : Val(TrimRest,Cfg.Request.Limit[NsPassWord,RlPrDay].MaxFiles,test);
          14 : Val(TrimRest,Cfg.Request.Limit[NsPassword,RlPrcall].MaxFiles,test);
          15 : Cfg.request.Limit[NsPassword,RlPrDay].Maxtime:=TimeStringToTime('hh:mm:ss',TrimRest);
          16 : Cfg.request.Limit[NsPassword,RlPrcall].MaxTime:=TimeStringToTime('hh:mm:ss',TrimRest);
          17 : Val(TrimRest,Cfg.Request.Limit[Nspassword,RlPrDay].MaxBytes,test);
          18 : Val(TrimRest,Cfg.Request.Limit[NsPassword,RlPrcall].MaxBytes,test);
          19 : Cfg.Request.RspAsPkt:=BooleanRest;
          20 : Cfg.Request.SkipAfterFirst:=BooleanRest;
          21 : Val(TrimRest,Cfg.Request.MinBaud,test);
          22 : Val(TrimRest,Byte(Cfg.Request.ReqOnUs),test);
          23 : Val(TrimRest,Cfg.Request.ReqOnUsCost,test);
        END;
      END;

      PROCEDURE ImportMailScanner;
      Var
        test : integer;
      BEGIN
        CASE TokenNr of
           1 : Cfg.MailScanner.NetMailDir:=TrimRest;
           2 : Cfg.MailScanner.Secure:=BooleanRest;
           3 : Cfg.MailScanner.BadMsgs:=TrimRest;
           4 : Cfg.MailScanner.SaveDupesDir:=TrimRest;
           5 : Val(TrimRest,Cfg.MailScanner.MaxDupes,test);
           6 : Cfg.MailScanner.EchotossLog:=TrimRest;
           7 : Cfg.MailScanner.StripCrash:=BooleanRest;
           8 : Cfg.MailScanner.SetAKASent:=BooleanRest;
           9 : Cfg.MailScanner.PvtEchoMail:=BooleanRest;
          10 : Cfg.MailScanner.SaveFwdMail:=BooleanRest;
          11 : Cfg.MailScanner.routeFile:=TrimRest;
          12 : Cfg.MailScanner.ForWardMail:=BooleanRest;
          13 : Cfg.MailScanner.KillFWdFiles:=BooleanRest;
          14 : Cfg.MailScanner.OldExt:=BooleanRest;
          15 : Val(TrimRest,cfg.MailScanner.DefaultPacker,test);
          16 : Val(TrimRest,cfg.MailScanner.NetMailBoard,test);
        END;
      END;

      PROCEDURE ImportFileFwd;
      Var
        test : Integer;
      BEGIN
        CASE TokenNr of
          1 : Cfg.FwdFile.preCmd:=TrimRest;
          2 : Cfg.FwdFile.SecureDir:=TrimRest;
          3 : Val(TrimRest,cfg.FwdFile.MsgAttribute,test);
          4 : Cfg.FwdFile.KillSent:=BooleanRest;
          5 : Cfg.FwdFile.MsgPrivate:=BooleanRest;
          6 : Cfg.FwdFile.Subject:=TrimRest;
        END;
      END;

      PROCEDURE ImportTick;
      BEGIN
        CASE TokenNr of
          1 : Cfg.Tick.DupeDir:=TrimRest;
          2 : Cfg.Tick.HoldDir:=TrimRest;
          3 : Cfg.Tick.BeforeMoving:=TrimRest;
          4 : Cfg.Tick.RequestMissing:=BooleanRest;
        END;
      END;

      PROCEDURE ImportBiMail;
      Var
        test2,
        test : Integer;

      BEGIN
        CASE tokenNr Of
          1 : BEGIN
                rest:=TrimRest;
                Val(NextWord(' ',rest),test2,test);
                Cfg.Bimail.BiOverRide[Test2]:=Rest;
              END;
          2 : Cfg.Bimail.NoSendOverRide:=BooleanRest;
          3 : Val(TrimRest, Cfg.Bimail.MaxBaud,test);
          4 : Cfg.BiMail.BiModemPath:=TrimRest;
        END;
      END;

      PROCEDURE ImportNodeListComp;
      Var
        Test,
        Test2 : Integer;

      BEGIN
        CASE TokenNr of
          1 : Cfg.NlCompiler.CostFileName:=TrimRest;
          2 : Cfg.NlCompiler.IntPreFix:=TrimRest;
          3 : Cfg.Nlcompiler.OurPreFix:=TrimRest;
          4 : Cfg.NlCompiler.UseFidoUserLst:=BooleanRest;
          5 : BEGIN
                rest:=TrimRest;
                Val(NextWord(' ',rest), test2, test);
                if test=0 then Cfg.NlCompiler.MtypeStr[Test2]:=rest;
              END;
        END;
      END;

      PROCEDURE ImportDumbTerm;
      VAR Test : INTEGER;
      BEGIN
        CASE TokenNr of
          1 : Cfg.DumbTerm.CrSendsLF:=BooleanRest;
          2 : Cfg.DumbTerm.DestructiveBS:=BooleanRest;
          3 : Cfg.DumbTerm.ModemInit:=TrimRest;
          4 : BEGIN
                Val(TrimRest, Cfg.DumbTerm.TimeOutNoCarrier, Test);
                IF (Test <> 0) OR (Cfg.DumbTerm.TimeOutNoCarrier > 7200)
                  THEN Cfg.DumbTerm.TimeOutNoCarrier := 300;
              END;
          5 : BEGIN
                Val(TrimRest, Cfg.DumbTerm.TimeOutCarrier, Test);
                IF (Test <> 0) OR (Cfg.DumbTerm.TimeOutCarrier > 7200)
                  THEN Cfg.DumbTerm.TimeOutCarrier := 300;
              END;
          6 : BEGIN
                Val(TrimRest, Cfg.DumbTerm.ExtTermErrorlevel, Test);
                IF (Test <> 0) OR (Cfg.DumbTerm.ExtTermErrorlevel > 248)
                  THEN Cfg.DumbTerm.ExtTermErrorlevel := 0;
              END;
        END;
      END;

      PROCEDURE ImportExtprot;
      var
        test,
        test2 : integer;
      BEGIN
        rest:=TrimRest;
        Val(NextWord(' ',rest),test2,test);
        CASE TokenNr of
          1 : Cfg.ExtProt[test2].Key:=rest[1];
          2 : Cfg.ExtProt[test2].Name:=Rest;
          3 : Cfg.ExtProt[test2].AskdlName:=rest='YES';
          4 : Cfg.ExtProt[test2].AutoStart:=Rest;
          5 : Cfg.ExtProt[test2].SendCmd:=Rest;
          6 : Cfg.ExtProt[test2].RecvCmd:=Rest;
        END;
      END;

      PROCEDURE ImportAreaMan;
      var
        test : Integer;
      BEGIN
        Rest:=TrimRest;
        CASE TokenNr of
           1 : Cfg.areaMan.DlCntStart:=rest[1];
           2 : Cfg.areaMan.DlCntStop:=rest[1];
           3 : Cfg.AreaMan.AdoptDefault:=rest='YES';
           4 : Cfg.AreaMan.InsDlCnt:=rest='YES';
           5 : Cfg.AreaMan.AddInbound:=rest='YES';
           6 : Val(rest, Cfg.AreaMan.FirstArea, test);
           7 : Val(rest, Cfg.AreaMan.LastArea, test);
           8 : Val(rest, Cfg.AreaMan.DlCDigits, test);
           9 : Cfg.AreaMan.DlCZeroFill:=rest='YES';
          10 : Cfg.AreaMan.ViewCmd:=rest;
        END;
      END;

      PROCEDURE ImportPackers;
      Var
        test2,
        Test : Integer;
      BEGIN
        rest:=TrimRest;
        Val(NextWord(' ',rest),test2,test);
        CASE TokenNr of
          1 : Cfg.Packer[test2].AddCmd:=Rest;
          2 : Cfg.Packer[test2].UnPackCmd:=Rest;
          3 : Cfg.Packer[test2].EraseCmd:=Rest;
          4 : Cfg.Packer[test2].TestCmd:=Rest;
        END;
      END;

      PROCEDURE ImportEventfile;
      Var
        DelStr    : String;
        w         : LongInt;
        Test      : Integer;
      BEGIN
        CASE TokenNr of
           1 : BEGIN
                 FillChar(CurrentEvent,Sizeof(TEvent),#0);
                 Rest:=Rest+' ';
                 WHILE Rest<>'' DO
                 BEGIN
                   rest:=TrimLead(rest);
                   DelStr:=NextWord(' ',rest);
                   IF MainStrDict^.Member(DelStr,w) THEN
                   BEGIN
                     CASE w OF
                       110 : CurrentEvent.Active:=CurrentEvent.active OR 128;
                  120..126 : CurrentEvent.Active:=CurrentEvent.Active OR (1 SHL (w-120));
                     END;
                   END;
                 END;
               END;
           2 : CurrentEvent.Start:=TimeStringToTime('HH:MM',TrimRest);
           3 : Val(TrimRest,CurrentEvent.Month,Test);
           4 : Val(TrimRest,CurrentEvent.Day,Test);
           5 : Val(TrimRest,CurrentEvent.InitExit,Test);
           6 : Val(TrimRest,CurrentEvent.MailExit,Test);
           7 : Val(TrimRest,CurrentEvent.PollExit,Test);
           8 : Val(TrimRest,CurrentEvent.FilesExit,Test);
           9 : BEGIN
                 Rest:=Rest+' ';
                 WHILE Rest<>'' DO
                 BEGIN
                   Rest:=TrimLead(Rest);
                   DelStr:=NextWord(' ',Rest);
                   IF LocalStrDict^.Member(DelStr,w) THEN
                   BEGIN
                     CurrentEvent.Typ:=CurrentEvent.Typ OR (1 SHL (w-101));
                   END;
                 END;
               END;
          10 : Val(TrimRest,CurrentEvent.Tries.Bad,Test);
          11 : Val(TrimRest,CurrentEvent.Tries.Busy,Test);
          12 : CurrentEvent.CallTime:=TimeStringToTime('HH:MM:SS',TrimRest);
          13 : CurrentEvent.CallWidth:=TimeStringToTime('HH:MM:SS',TrimRest);
          14 : CurrentEvent.Description:=TrimRest;
          15 : GetAdressFromStr(TrimRest,CurrentEvent.ConnectTo);
          16 : Val(TrimRest,CurrentEvent.SchedNumber,Test);
          17 : Val(TrimRest,CurrentEvent.MaxCost,Test);
          18 : Val(TrimRest,CurrentEvent.MinMail,Test);
          19 : Val(TrimRest,CurrentEvent.SpecDial,Test);
          20 : Val(TrimRest,CurrentEvent.TaskNumber,Test);
        END;
      END;

      PROCEDURE ImportNodesfile;
      Var
        DelStr    : String;
        w         : LongInt;
        Test      : Integer;
      BEGIN
        rest:=TrimRest;
        CASE TokenNr of
           1 : GetAdressFromStr(Rest,NodesRec.Address);
           2 : NodesRec.PktPassword:=rest;
           3 : NodesRec.AreaFixPwd:=Rest;
           4 : NodesRec.SessionPwd:=Rest;
           5 : Val(Rest,NodesRec.PackerType,Test);
           6 : Val(Rest,NodesRec.Level,Test);
           7 : Val(Rest,NodesRec.keys,Test);
           8 : NodesRec.OpenFrom:=TimeStringToTime('HH:MM:SS',Rest);
           9 : NodesRec.OpenTo:=TimeStringToTime('HH:MM:SS',Rest);
          10 : NodesRec.UseEmsi:=rest[1];
          11 : NodesRec.SendFwdLetter:=rest='YES';
          12 : Val(Rest,NodesRec.PointNet,Test);
          13 : NodesRec.CheckConnect:=rest[1];
          14 : NodesRec.UseFake:=rest[1];
          15 : NodesRec.DisallowReq:=Rest='YES';
          16 : NodesRec.UseFullDuplex:=rest[1];
          17 : NodesRec.Phone:=Rest;
          18 : NodesRec.TickPassword:=Rest;
          19 : NodesRec.PackTick:=rest='YES';
          20 : NodesRec.Flavor:=rest[1];
          21 : BEGIN
                 NodesRec.SpecialDials[1]:=copy(rest,1,Pos('',rest)-1);
                 NodesRec.SpecialDials[2]:=Copy(rest,Pos('',rest)+1,255);
               END;
          22 : NodesRec.EmsiSetTime:=Rest='YES';
          23 : Val(Rest,NodesRec.MinConnectBaud,Test);
        END;
      END;

      PROCEDURE ImportTickfile;
      Var
        DelStr    : String;
        w         : LongInt;
        Test      : Integer;

      BEGIN
        rest:=TrimRest;
        CASE TokenNr of
           1 : TickRec.AreaName:=Rest;
           2 : TickRec.GroupName:=Rest;
           3 : TickRec.HumanName:=Rest;
           4 : TickRec.Areapath:=Rest;
           5 : TickRec.WriteLetter:=Rest='YES';
           6 : TickRec.AnnouncePath:=Rest;
           7 : TickRec.CanBeRepacked:=Rest='YES';
           8 : BEGIN
                 rest:=Rest+' ';
                 TickRec.GetFrom[1]:=copy(rest,1,Pos('@',rest)-1);
                 TickRec.GetFrom[2]:=copy(rest,Pos('@',rest)+1,255);
               END;
           9 : BEGIN
                 rest:=Rest+' ';
                 TickRec.SendTo[1]:=copy(rest,1,Pos('@',rest)-1);
                 TickRec.SendTo[2]:=copy(rest,Pos('@',rest)+1,255);
               END;
          10 : Val(Rest,TickRec.Level,Test);
          11 : Val(Rest,TickRec.keys,Test);
          12 : TickRec.CheckCRC:=Rest='YES';
          13 : TickRec.FilesBBs:=Rest;
          14 : Val(Rest,TickRec.AkaToUse,Test);
          15 : TickRec.CheckDupe:=rest='YES';
        END;
      END;

      PROCEDURE ImportfileForward;
      Var
        DelStr    : String;
        w         : LongInt;
        Test      : Integer;
        dt        : DateTime;

      BEGIN
        rest:=TrimRest;
        CASE TokenNr of
           1 : FileFwdRec.FileName:=Rest;
           2 : FileFwdRec.WhereToPut:=Rest;
           3 : FileFwdRec.AddToFiles:=Rest='YES';
           4 : Val(Rest,FileFwdRec.AddBeforeLine,Test);
           5 : FileFwdRec.Description:=Rest;
           6 : BEGIN
                 rest:=Rest+' ';
                 FileFwdRec.SendTo[1]:=copy(rest,1,Pos('@',rest)-1);
                 FileFwdRec.SendTo[2]:=copy(rest,Pos('@',rest)+1,255);
               END;
           7 : FileFwdRec.BeforeCmd:=Rest;
           8 : FileFwdRec.AfterCmd:=Rest;
           9 : FileFwdRec.TouchFile:=Rest='YES';
          10 : GetAdressFromStr(Rest,FileFwdRec.GetFrom);
          11 : BEGIN
                 VAL(COPY(rest,1,2),dt.Day,Test);
                 VAL(COPY(rest,4,2),dt.Month,Test);
                 VAL(COPY(rest,7,2),dt.Year,Test);
                 VAL(COPY(rest,10,2),dt.Hour,Test);
                 VAL(COPY(rest,13,2),dt.Min,Test);
                 VAL(COPY(rest,16,2),dt.Sec,Test);
                 PackTime(dt,w);
                 FileFwdRec.LastForward:=w;
               END;
          12 : FileFwdRec.KillDupe:=Rest='YES';
          13 : FileFwdRec.CheckDate:=Rest='YES';
          14 : Val(Rest,FileFwdRec.Level,Test);
          15 : Val(Rest,FileFwdRec.keys,Test);
          16 : FileFwdRec.PortalFixName:=Rest;
          17 : Val(Rest,FileFwdRec.KeepMax,Test);
        END;
      END;

      PROCEDURE ImportNlt;
      BEGIN
        rest:=TrimRest;
        CASE TokenNr of
           1 : NltRec.NumFrom:=Rest;
           2 : NltRec.NumTo:=Rest;
        END;
      END;

      PROCEDURE ImportScd;
      Var
        Test      : Integer;

      BEGIN
        rest:=TrimRest;
        CASE TokenNr of
           1 : Val(Rest,ScdRec.Number,Test);
           2 : Val(Rest,ScdRec.Action,Test);
           3 : BEGIN
                 rest:=Rest+' ';
                 ScdRec.Adr[1]:=copy(rest,1,Pos('@',rest)-1);
                 ScdRec.Adr[2]:=copy(rest,Pos('@',rest)+1,255);
               END;
           4 : ScdRec.stat:=Rest[1];
           5 : Val(Rest,ScdRec.Subline,Test);
        END;
      END;

      PROCEDURE Importokf;
      Var
        w         : Longint;
        Test      : Integer;

      BEGIN
        rest:=TrimRest;
        CASE TokenNr of
           1 : BEGIN
                 mainstrdict^.member(rest,w);
                 OkfRec.nodestat:=Tnodestat(w-570);
               END;
           2 : OkfRec.MagicName:=rest;
           3 : Okfrec.FilePath:=rest;
           4 : OkfRec.Password:=Rest;
           5 : Val(Rest,okfRec.Level,Test);
           6 : Val(Rest,okfRec.Keys,Test);
           7 : BEGIN
                 mainstrdict^.member(rest,w);
                 OkfRec.FreeArea:=TFreeArea(w-550);
               END;
           8 : Val(Rest,okfRec.Tasknumber,Test);
        END;
      END;

      PROCEDURE ImportAreas;
      Var
        w         : Longint;
        Test      : Integer;

      BEGIN
        rest:=TrimRest;
        CASE TokenNr of
           1 : AreaRec.Directory:=rest;
           2 : BEGIN
                 AreaRec.EchoNames[1]:=NextWord('@',rest);
                 AreaRec.EchoNames[2]:=NextWord('@',rest);
                 AreaRec.Echonames[3]:=rest;
               END;
           3 : AreaRec.Origin:=rest;
           4 : BEGIN
                 AreaRec.SendTo[1]:=NextWord('@',rest);
                 AreaRec.SendTo[2]:=rest;
               END;
           5 : BEGIN
                 AreaRec.Sendonly[1]:=NextWord('@',rest);
                 AreaRec.Sendonly[2]:=rest;
               END;
           6 : AreaRec.ScramblePwd:=rest;
           7 : AreaRec.StripSeenBy:=rest='YES';
           8 : AreaRec.Pvt2Email:=Rest='YES';
           9 : Val(Rest,AreaRec.Level,Test);
          10 : Val(Rest,AreaRec.Keys,Test);
          11 : Val(Rest,AreaRec.MaxScan,Test);
          12 : AreaRec.ScanDate:=DateStringToDate('dd.mm.yy',rest);
          13 : Val(Rest,AreaRec.Scanned,Test);
          14 : AreaRec.Description:=rest;
          15 : Val(Rest,AreaRec.AreaType,Test);
          16 : AreaRec.ImportSB:=Rest='YES';
          17 : Val(Rest,AreaRec.UsedAka,Test);
          18 : Val(Rest,AreaRec.MsgCount,Test);
          19 : Val(Rest,AreaRec.DateCount,Test);
          20 : Val(Rest,AreaRec.MsgKeep,Test);
        END;
      END;

      PROCEDURE ImportNls;
      Var
        w         : Longint;
        Test      : Integer;
      BEGIN
        rest:=TrimRest;
        CASE TokenNr of
           1 : NlsRec.NodeListName:=rest;
           2 : NlsRec.DiffFileName:=rest;
           3 : Nlsrec.CheckCRC:=rest='YES';
           4 : NlsRec.NewNlPath:=Rest;
           5 : BEGIN
                 NlsRec.Include[1]:=NextWord('@',rest);
                 NlsRec.Include[2]:=rest;
               END;
           6 : BEGIN
                 NlsRec.Exclude[1]:=NextWord('@',rest);
                 NlsRec.Exclude[2]:=rest;
               END;
           7 : NlsRec.NewNlDesc:=Rest;
        END;
      END;

      PROCEDURE ImportMFS;
      Var
        w         : Longint;
        Test      : Integer;
      BEGIN
        rest:=TrimRest;
        CASE TokenNr of
           1 : MFSRec.Name:=rest;
           2 : MFSRec.FileName:=rest;
           3 : MFSrec.HeaderFile:=rest;
           4 : BEGIN
                 MFSRec.IncludeAreas[1]:=NextWord('@',rest);
                 MFSRec.IncludeAreas[2]:=NextWord('@',rest);
                 MFSRec.IncludeAreas[3]:=NextWord('@',rest);
                 MFSRec.IncludeAreas[4]:=rest;
               END;
           6 : MFSRec.Doafter:=rest;
        END;
      END;

      PROCEDURE SkrivAst;
      Var
        Ch : Char;
      BEGIN
        inc(AstCount);
        if Astcount>4 then astcount:=1;
        CASE AstCount of
          1 : ch:='-';
          2 : ch:='\';
          3 : ch:='|';
          4 : ch:='/';
        END;
        win^.WFasttext(ch,2,12);
      END;

    BEGIN
      Assign(f, FName); Reset(f);
      IF IOResult=0 THEN
      BEGIN
        TmpFile.FName := '';
        New(LocalStrDict,init);
        Section:=0; OldSection:=-1;
        WHILE NOT EoF(f) DO
        BEGIN
          ReadLn(f, s);
          IF (Length(s)>0) AND (Copy(s, 1, 1)<>';') THEN
          BEGIN
            Split(s, Token, Rest);
            IF Section<>0 THEN
            BEGIN
              IF NOT LocalStrDict^.Member(Token, TokenNr) THEN
                IF (MainStrDict^.Member(Token, TokenNr)) AND (TokenNr=3) THEN
                  Section:=0
                ELSE
                  TokenNr:=0;
            END;
            CASE Section OF
               0: BEGIN
                    IF NOT MainStrDict^.Member(Token, TokenNr) THEN TokenNr:=0;
                    CASE TokenNr OF
                       1 : ImportFile(Rest);   { Include }
                       3 : BEGIN               { End }
                             SkrivAst;
{                            if Filerec(tmpfile).mode<>FmClosed then Seek(TmpFile,FileSize(TmpFile));}
                             IF TmpFile.FName <> '' THEN TmpFile.Seek(TmpFile.FileSize);
                             CASE OldSection OF
                               50 : BEGIN
                                      TmpFile.Write(CurrentEvent);
                                      FillChar(CurrentEvent,Sizeof(TEvent),#0);
                                    END;
                               51 : BEGIN
                                      TmpFile.Write(NodesRec);
                                      FillChar(NodesRec,Sizeof(TNodeInfo),#0);
                                    END;
                               52 : BEGIN
                                      TmpFile.Write(TickRec);
                                      FillChar(TickRec,Sizeof(TTickArea),#0);
                                    END;
                               53 : BEGIN
                                      TmpFile.Write(FileFwdRec);
                                      FillChar(FileFwdRec,SizeOf(TFileFwd),#0);
                                    END;
                               54 : BEGIN
                                      TmpFile.Write(NltRec);
                                      FillChar(NltRec,SizeOf(TNLTranslat),#0);
                                    END;
                               55 : BEGIN
                                      TmpFile.Write(ScdRec);
                                      FillChar(ScdRec,SizeOf(TSchedule),#0);
                                    END;
                               56 : BEGIN
                                      TmpFile.Write(OkfRec);
                                      FillChar(OkfRec,SizeOf(TOkfile),#0);
                                    END;
                               57 : BEGIN
                                      TmpFile.Write(AreaRec);
                                      FillChar(AreaRec,SizeOf(TMsgArea),#0);
                                    END;
                               58 : BEGIN
                                      TmpFile.Write(NlsRec);
                                      FillChar(NlsRec,SizeOf(TNodelistSeg),#0);
                                    END;
                             END;
                           END;
                  10..24 : IF MainStrDict^.Member(Token, TokenNr) {AND (TokenNr=2)} THEN
                           BEGIN
                             Section:=TokenNr;
                             ResLib.GetEntry('TOK'+To3(Section), LocalStrDict^);
                           END;
                  50..59 : BEGIN
                             Section:=TokenNr;
                             IF (Section<>OldSection) THEN
                             BEGIN
{                              IF (FileRec(TmpFile).Mode<>fmClosed) THEN NetCloseFile(TmpFile);}
                               IF TmpFile.FName <> '' THEN TmpFile.Close;
                               LocalStrDict^.Done;
                               LocalStrDict^.Init;
                               ResLib.GetEntry('TOK'+To3(Section), LocalStrDict^);
                               CASE Section OF
                                 50 : BEGIN
                                        TmpFile.Open(PoPEventFileName,SizeOf(TEvent),TRUE);
                                        IF Overwrite THEN TmpFile.Truncate;
                                        FillChar(CurrentEvent,Sizeof(TEvent),#0);
                                      END;
                                 51 : BEGIN
                                        TmpFile.Open(PoPNodesFileName,SizeOf(TNodeInfo),TRUE);
                                        IF Overwrite THEN TmpFile.Truncate;
                                        FillChar(NodesRec,Sizeof(TNodeInfo),#0);
                                      END;
                                 52 : BEGIN
                                        TmpFile.Open(PopTickFileName,SizeOf(TTickArea),TRUE);
                                        IF Overwrite THEN TmpFile.Truncate;
                                        FillChar(TickRec,Sizeof(TTickArea),#0);
                                      END;
                                 53 : BEGIN
                                        TmpFile.Open(PoPFileFwdFileName,SizeOf(TFileFwd),TRUE);
                                        IF Overwrite THEN TmpFile.Truncate;
                                        FillChar(FileFwdRec,SizeOf(TFileFwd),#0);
                                      END;
                                 54 : BEGIN
                                        TmpFile.Open(PoPNLTranslateFileName,SizeOf(TNLTranslat),TRUE);
                                        IF Overwrite THEN TmpFile.Truncate;
                                        FillChar(NltRec,SizeOf(TNlTranslat),#0);
                                      END;
                                 55 : BEGIN
                                        TmpFile.Open(PoPScheduleFileName,SizeOf(TSchedule),TRUE);
                                        IF Overwrite THEN TmpFile.Truncate;
                                        FillChar(ScdRec,SizeOf(TSchedule),#0);
                                      END;
                                 56 : BEGIN
                                        TmpFile.Open(PoPOkFileName,SizeOf(TOkfile),TRUE);
                                        IF Overwrite THEN TmpFile.Truncate;
                                        FillChar(OkfRec,SizeOf(TOkfile),#0);
                                      END;
                                 57 : BEGIN
                                        TmpFile.Open(PoPMsgAreaFileName,SizeOf(TMsgArea),TRUE);
                                        IF Overwrite THEN TmpFile.Truncate;
                                        FillChar(areaRec,SizeOf(TmsgArea),#0);
                                      END;
                                 58 : BEGIN
                                        TmpFile.Open(PoPNLSegmentFileName,SizeOf(TNodelistseg),TRUE);
                                        IF Overwrite THEN TmpFile.Truncate;
                                        FillChar(NlsRec,SizeOf(TnodelistSeg),#0);
                                      END;
                                 59 : BEGIN
                                        TmpFile.Open(PoPListSegmentsName,SizeOf(TFilelistsegment),TRUE);
                                        IF Overwrite THEN TmpFile.Truncate;
                                        FillChar(MFSRec,SizeOf(TFileListSegment),#0);
                                      END;
                               END;
                               OldSection:=Section;
                             END;
                           END;
                    END;
                  END;
              10: ImportSystem;
              11: ImportBBs;
              12: ImportModem;
              13: ImportScreen;
              14: ImportListFile;
              15: ImportRequest;
              16: ImportMailScanner;
              17: ImportFileFwd;
              18: ImportTick;
              19: ImportBiMail;
              20: ImportNodeListComp;
              21: ImportDumbTerm;
              22: ImportExtProt;
              23: ImportAreaMan;
              24: ImportPackers;
              50: ImportEventfile;
              51: ImportNodesFile;
              52: ImportTickFile;
              53: ImportFileForward;
              54: ImportNLT;
              55: ImportScd;
              56: ImportOkf;
              57: ImportAreas;
              58: ImportNls;
              59: ImportMFS;
            END;
          END;
        END;
        Dispose(LocalStrDict, Done);
        Close(f);
      END;
    END;

  BEGIN
    AdrNum:=0;
    FName:=StartPath+PoPCfgExportFileName;
    IF SelectFile(Fname) THEN
    BEGIN
      Overwrite:=Confirm('Overwrite existing datafiles', 'N', 14);
{     FileRec(TmpFile).Mode:=fmClosed;}
      New(MainStrDict,init);
      ResLib.GetEntry('TOK000', MainStrDict^);
      Astcount:=0;
      MyWin(win,10,10,24,13,2,'Importing',true);
      Win^.Wfasttext('Reading.',2,2);
      ImportFile(FName);
      Dispose(MainStrDict, Done);
{      IF FileRec(TmpFile).Mode<>fmClosed THEN NetCloseFile(TmpFile);}
      IF TmpFile.FName <> '' THEN TmpFile.Close;
      IF Confirm('Save new configuration','Y',11) THEN BEGIN
        SaveConfiguration;
        Addlog('+','Configuration imported');
      END ELSE LoadConfiguration;
      KillWindow(win);
    END;
  END;

END.
