UNIT NewExp;
{ͻ}
{ Export                                        Last changed: 20.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-95 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}
{ͻ}
{ Changes made by the German Portal Team                                   }
{                                                                          }
{ By                : Marcus Roeckrath                                     }
{ First Modification: 08 February 1999                                     }
{ Last Modification : 13 October 1999                                      }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}

INTERFACE

USES Use32;

PROCEDURE ExportConfig;

IMPLEMENTATION

USES Dos, OpRoot, OpDate, OpString, NetFile, Util, OproUtil, logfile,
     StrUtil, Resource, Globals, poptypes, OpWindow;

  PROCEDURE ExportConfig;
  VAR
    MainStrDict, LocalStrDict : StringDictPtr;
    OutFile                   : TBufTextFile;
    W                         : WindowPtr;

    PROCEDURE WriteExport(tekst: s30);
    BEGIN
      W^.WFastText('Exporting '+cpad(Tekst,35),2,2);
    END;

    FUNCTION ResStr(SD: StringDict; Nr: LongInt; PadSize: Byte): String;
    VAR
      S: String;
    BEGIN
      IF NOT SD.GetString(Nr, S) THEN S:='('+Long2Str(Nr)+')?';
      ResStr:=Pad(S+' ', PadSize);
    END;

    PROCEDURE ExpItem(i:WORD; CONST s:STRING);
    BEGIN
      OutFile.Writeln('  '+ResStr(LocalStrDict^, i, 25)+s);
    END;

    PROCEDURE OpenExportFile;
    VAR
      FName : PathStr;
    BEGIN
      FName:=StartPath+PoPCfgExportFileName;
      OutFile.Init(FName,SCreate,Max64K(MaxAvail));
      WITH OutFile DO
      BEGIN
        WriteLn(';');
        WriteLn('; Configuration exported on '+DateToDateString('dd.mm.yy', Today)+
          TimeToTimeString(' hh:mm',CurrentTime));
        WriteLn(';');
      END;
    END;

    Procedure ExportBBSSection;
    VAR
      i : Byte;
    Begin
      WriteExport('BBs Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK011', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 11, 0)+ResStr(MainStrDict^, 2, 0));
        With Cfg.BBs do
        Begin
          ExpItem(1,ResStr(MainStrDict^, 500+Byte(BBsType),15));
          ExpItem(2,path);
          ExpItem(3,Userfile);
          ExpItem(4,Long2Str(Minbaud));
          ExpItem(5,MinBaudFile);
          ExpItem(6,Long2Str(UserErrorLevel));
          for I:=1 to 5 do
            ExpItem(7,Long2Str(i)+' '+multi[i].key + '@' + cfg.bbs.multi[i].batname);
        end;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 11, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportModem;
    VAR
      i : Byte;
    Begin
      WriteExport('Modem Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK012', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 12, 0)+ResStr(MainStrDict^, 2, 0));
        With Cfg.Modem do
        Begin
          ExpItem(1,Long2Str(commPort));
          ExpItem(2,Long2Str(BaudRate));
          ExpItem(3,PreInit);
          ExpItem(4,Init);
          ExpItem(5,NoAnswer);
          ExpItem(6,Dial);
          ExpItem(7,Busy);
          ExpItem(8,HangUp);
          ExpItem(9,Answer);
          ExpItem(10,TimeToTimeString('hh:mm.ss',ReInit));
          ExpItem(11,LockedBaud);
          for i:=1 to 5 do
            ExpItem(12,Long2Str(i)+' '+ExitStr[i].ConStr+'@'+
                    Long2Str(Cfg.Modem.ExitStr[i].ErrLvl));
          For i:=0 to 7 do
            ExpItem(13,Long2Str(i)+' '+Long2Str(ModemType[i].Bit)+'@'+ModemType[i].Dial+
              '@'+ResStr(MainStrDict^, 111-byte(ModemType[i].DialOut),3)+'@'+Long2Str(ModemType[i].Baud));
          ExpItem(14,TimeToTimeString('hh:mm.ss',WaitTime));
          ExpItem(15,ResStr(MainStrDict^, 111-Byte(InternalFax),3));
          ExpItem(16,LinkStat);
          ExpItem(17,Long2Str(LogLines));
          ExpItem(18,Long2Str(ConnectTime));
          ExpItem(19,ResStr(MainStrDict^, 111-Byte(UseLCR),3));
          ExpItem(20,ResStr(MainStrDict^, 111-Byte(UseRingAnaly),3));
          for i:=1 to 5 do
            ExpItem(21,Long2Str(i)+' '+Cfg.Statistics.MdmProtocol[i]);
        end;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 12, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportScreen;
    Begin
      WriteExport('Screen Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK013', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 13, 0)+ResStr(MainStrDict^, 2, 0));
        With cfg.screen do
        Begin
          ExpItem(1,TimeToTimeString('hh:mm.ss',BlankTime));
          ExpItem(2,ResStr(MainStrDict^, 111-Byte(chkSnow),3));
          ExpItem(3,ResStr(MainStrDict^, 111-Byte(KeepOffScrMode),3));
          ExpItem(4,ResStr(MainStrDict^, 111-Byte(ScrMode),3));
          ExpItem(5,ResStr(MainStrDict^, 111-Byte(HardWareBlank),3));
          ExpItem(6,ResStr(MainStrDict^, 111-Byte(ExplodingWin),3));
          ExpItem(7,ResStr(MainStrDict^, 111-Byte(FourDigitsYear),3));
        end;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 13, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    Procedure ExportListFile;
    VAR
      i : Byte;
    Begin
      WriteExport('ListFile Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK014', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 14, 0)+ResStr(MainStrDict^, 2, 0));
        With Cfg.ListFiles do
        Begin
          ExpItem(1,FileList);
          ExpItem(2,NewsList);
          ExpItem(3,Header);
          ExpItem(4,Footer);
          ExpItem(5,TopFile);
          ExpItem(6,StatFile);
          ExpItem(7,ResStr(MainStrDict^, 111-Byte(Adopt),3));
          ExpItem(8,AdoptComment);
          ExpItem(9,ResStr(MainStrDict^, 111-Byte(DupeCheck),3));
          ExpItem(10,ResStr(MainStrDict^, 111-Byte(Stat),3));
          ExpItem(11,ResStr(MainStrDict^, 111-Byte(IncludeTop),3));
          ExpItem(12,Long2Str(Top));
          ExpItem(13,ResStr(MainStrDict^, 111-Byte(Dkdate),3));
          ExpItem(14,Long2Str(NewsDays));
          ExpItem(15,Long2Str(Threshold));
          ExpItem(16,ResStr(MainStrDict^, 111-Byte(RemMissing),3));
          ExpItem(17,ResStr(MainStrDict^, 111-Byte(Okportal),3));
          ExpItem(18,ResStr(MainStrDict^, 111-Byte(ZapZero),3));
          ExpItem(19,ResStr(MainStrDict^, 111-Byte(Touch),3));
          for I:=1 to 10 do
            ExpItem(20,longintform('## ',i)+CrapFiles[i]);
          for I:=1 to 10 do
            ExpItem(21,longintform('## ',i)+ExcludeFiles[i]);
          for I:=1 to 10 do
            ExpItem(22,longintform('## ',i)+NoDupeCheck[i]);
          for I:=1 to 10 do
            ExpItem(23,longintform('## ',i)+NonAdoptFiles[i]);
          for I:=1 to 10 do
            ExpItem(24,longintform('## ',i)+NonAdoptAreas[i]);
          for I:=1 to 11 do
            ExpItem(25,longintform('## ',i)+PrivateAreas[i]);
          ExpItem(26,DoBefore);
          ExpItem(27,Doafter);
          ExpItem(28,DoPack);
          ExpItem(29,DupeReport);
          for I:=0 to 3 do
            ExpItem(30,Long2Str(i)+' '+TxtFreq[i]);
          ExpItem(31,OkBiModemPath);
        end;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 14, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportTick;
    Begin
      WriteExport('Tick Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK018', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 18, 0)+ResStr(MainStrDict^, 2, 0));
        With Cfg.Tick do
        Begin
          ExpItem(1,DupeDir);
          ExpItem(2,HoldDir);
          ExpItem(3,BeforeMoving);
          ExpItem(4,ResStr(MainStrDict^, 111-Byte(RequestMissing),3));
        end;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 18, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportBimail;
    VAR
      I : Byte;
    Begin
      WriteExport('Bimodem Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK019', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 19, 0)+ResStr(MainStrDict^, 2, 0));
        With cfg.Bimail do
        Begin
          For I:=1 to 5 do
            ExpItem(1,Long2Str(i)+' '+BiOverRide[i]);
          ExpItem(2,ResStr(MainStrDict^, 111-Byte(NoSendOverRide),3));
          ExpItem(3,Long2Str(MaxBaud));
          ExpItem(4,BiModemPath);
        End;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 19, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportRequest;
    Begin
      WriteExport('Request Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK015', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 15, 0)+ResStr(MainStrDict^, 2, 0));
        With Cfg.Request do
        Begin
          ExpItem(1,Long2Str(Limit[NsUnKnown,RlPrDay].MaxFiles));
          ExpItem(2,Long2Str(Limit[NsUnKnown,RlPrCall].MaxFiles));
          ExpItem(3,TimetoTimeString('hh:mm:ss',Limit[NsUnKnown,RlPrDay].MaxTime));
          ExpItem(4,TimeToTimeString('hh:mm:ss',Limit[NsUnKnown,RlPrCall].MaxTime));
          ExpItem(5,Long2Str(Limit[NsUnKnown,RlPrDay].MaxBytes));
          ExpItem(6,Long2Str(Limit[NsUnKnown,RlPrCall].Maxbytes));
          ExpItem(7,Long2Str(Limit[NsKnown,RlPrDay].MaxFiles));
          ExpItem(8,Long2Str(Limit[NsKnown,RlPrCall].MaxFiles));
          ExpItem(9,TimetoTimeString('hh:mm:ss',Limit[NsKnown,RlPrDay].MaxTime));
          ExpItem(10,TimeToTimeString('hh:mm:ss',Limit[NsKnown,RlPrCall].MaxTime));
          ExpItem(11,Long2Str(Limit[NsKnown,RlPrDay].MaxBytes));
          ExpItem(12,Long2Str(Limit[NsKnown,RlPrCall].Maxbytes));
          ExpItem(13,Long2Str(Limit[NsPassword,RlPrDay].MaxFiles));
          ExpItem(14,Long2Str(Limit[NsPassword,RlPrCall].MaxFiles));
          ExpItem(15,TimetoTimeString('hh:mm:ss',Limit[NsPassword,RlPrDay].MaxTime));
          ExpItem(16,TimeToTimeString('hh:mm:ss',Limit[NsPassword,RlPrCall].MaxTime));
          ExpItem(17,Long2Str(Limit[NsPassword,RlPrDay].MaxBytes));
          ExpItem(18,Long2Str(Limit[NsPassword,RlPrCall].Maxbytes));
          ExpItem(19,ResStr(MainStrDict^, 111-Byte(RspAsPkt),3));
          ExpItem(20,ResStr(MainStrDict^, 111-Byte(skipAfterFirst),3));
          ExpItem(21,Long2Str(MinBaud));
          ExpItem(22,Long2Str(Byte(ReqOnUs)));
          ExpItem(23,Long2Str(ReqOnUsCost));
        end;
        WriteLn(ResStr(MainStrDict^,3,0)+ResStr(MainStrDict^,15,0)+ResStr(MainStrDict^,2,0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportFwdFile;
    Begin
      WriteExport('File Forward Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK017', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 17, 0)+ResStr(MainStrDict^, 2, 0));
        With Cfg.FwdFile do
        Begin
          ExpItem(1,PreCmd);
          ExpItem(2,SecureDir);
          ExpItem(3,Long2Str(MsgAttribute));
          ExpItem(4,ResStr(MainStrDict^, 111-Byte(KillSent),3));
          ExpItem(5,ResStr(MainStrDict^, 111-Byte(MsgPrivate),3));
          ExpItem(6,Subject);
        End;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 17, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportMailScanner;
    Begin
      WriteExport('MailScanner Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK016', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 16, 0)+ResStr(MainStrDict^, 2, 0));
        With cfg.MailScanner do
        Begin
          ExpItem(1,NetMailDir);
          ExpItem(2,ResStr(MainStrDict^, 111-Byte(secure),3));
          ExpItem(3,BadMsgs);
          ExpItem(4,SaveDupesDir);
          ExpItem(5,Long2Str(MaxDupes));
          ExpItem(6,EchoTossLog);
          ExpItem(7,ResStr(MainStrDict^, 111-Byte(StripCrash),3));
          ExpItem(8,ResStr(MainStrDict^, 111-Byte(SetAkaSent),3));
          ExpItem(9,ResStr(MainStrDict^, 111-Byte(PvtEchoMail),3));
          ExpItem(10,ResStr(MainStrDict^, 111-Byte(SaveFwdMail),3));
          ExpItem(11,RouteFile);
          ExpItem(12,ResStr(MainStrDict^, 111-Byte(ForwardMail),3));
          ExpItem(13,ResStr(MainStrDict^, 111-Byte(KillFwdFiles),3));
          ExpItem(14,ResStr(MainStrDict^, 111-Byte(OldExt),3));
          ExpItem(15,Long2Str(DefaultPacker));
          ExpItem(16,Long2Str(NetMailBoard));
        End;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 16, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportNLCompiler;
    VAR
      I : Byte;
    Begin
      WriteExport('NodeList Compiler Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK020', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 20, 0)+ResStr(MainStrDict^, 2, 0));
        With cfg.NlCompiler do
        Begin
          ExpItem(1,CostFileName);
          ExpItem(2,IntPreFix);
          ExpItem(3,OurPreFix);
          ExpItem(4,ResStr(MainStrDict^, 111-Byte(UseFidoUserLst),3));
          For I:=0 to 7 do
            ExpItem(5,Long2Str(i)+' '+MTypeStr[i]);
        end;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 20, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportDumbTerm;
    Begin
      WriteExport('Dumb Terminal Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK021', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 21, 0)+ResStr(MainStrDict^, 2, 0));
        With cfg.DumbTerm do
        Begin
          ExpItem(1,ResStr(MainStrDict^, 111-Byte(CrSendsLf),3));
          ExpItem(2,ResStr(MainStrDict^, 111-Byte(DestructiveBS),3));
          ExpItem(3,ModemInit);
          ExpItem(4,Long2Str(TimeOutNoCarrier));
          ExpItem(5,Long2Str(TimeOutCarrier));
          ExpItem(6,Long2Str(ExtTermErrorlevel));
        end;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 21, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportExternal;
    VAR
      i : Byte;
    Begin
      WriteExport('External protocol Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK022', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 22, 0)+ResStr(MainStrDict^, 2, 0));
        for i:=1 to 5 do
        Begin
          With Cfg.ExtProt[i] do
          Begin
            ExpItem(1,Long2Str(i)+' '+Key);
            ExpItem(2,Long2Str(i)+' '+Name);
            ExpItem(3,Long2Str(i)+' '+ResStr(MainStrDict^, 111-Byte(AskDlName),3));
            ExpItem(4,Long2Str(i)+' '+AutoStart);
            ExpItem(5,Long2Str(i)+' '+SendCmd);
            ExpItem(6,Long2Str(i)+' '+RecvCmd);
          end;
          Writeln('');
        end;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 22, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportAreaMan;
    Begin
      WriteExport('Area Manager Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK023', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 23, 0)+ResStr(MainStrDict^, 2, 0));
        With cfg.Areaman do
        Begin
          ExpItem(1,DlCntStart);
          ExpItem(2,DlCntStop);
          ExpItem(3,ResStr(MainStrDict^, 111-Byte(AdoptDefault),3));
          ExpItem(4,ResStr(MainStrDict^, 111-Byte(InsDlCnt),3));
          ExpItem(5,ResStr(MainStrDict^, 111-Byte(AddInbound),3));
          ExpItem(6,Long2Str(FirstArea));
          ExpItem(7,Long2Str(LastArea));
          ExpItem(8,Long2Str(DlCDigits));
          ExpItem(9,ResStr(MainStrDict^, 111-Byte(DlCZeroFill),3));
          ExpItem(10,ViewCmd);
        end;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 23, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportPackers;
    VAR
      I : Byte;
    Begin
      WriteExport('Packer Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK024', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 24, 0)+ResStr(MainStrDict^, 2, 0));
        for I:=1 to 7 do
        Begin
          With cfg.packer[i] do
          Begin
            ExpItem(1,Long2Str(i)+' '+AddCmd);
            ExpItem(2,Long2Str(i)+' '+UnpackCmd);
            ExpItem(3,Long2Str(i)+' '+EraseCmd);
            ExpItem(4,Long2Str(i)+' '+TestCmd);
          end;
          Writeln('');
        end;
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 24, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE ExportSystemSection;
    VAR
      i,j : Byte;
      c   : char;

    BEGIN
      WriteExport('System Section');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK010', LocalStrDict^);
      WITH OutFile DO
      BEGIN
        WriteLn(ResStr(MainStrDict^, 10, 0)+ResStr(MainStrDict^, 2, 0));
        ExpItem(1,Long2Str(Cfg.version));
        ExpItem(2,Long2Str(Cfg.tasknumber));
        ExpItem(3,Cfg.swapdir);
        ExpItem(4,Cfg.outbound);
        ExpItem(5,Cfg.banner);
        ExpItem(6,Cfg.defaultmacro);
        ExpItem(7,Cfg.Editor);
        ExpItem(8,Cfg.logfilename);
        ExpItem(9,Long2Str(Cfg.loglevel));
        ExpItem(10,ResStr(MainStrDict^, 111-Byte(Cfg.UseYearInLog),3));
        ExpItem(11,cfg.Nodelist);
        ExpItem(12,ResStr(MainStrDict^, 520+Byte(Cfg.Nodelisttyp),15));
        ExpItem(13,Long2Str(Cfg.MainAdrNum));
        FOR i:=1 TO MaxAddresses DO
          IF Cfg.Addresses[i].Zone<>0 THEN
            ExpItem(14,Address2Str(Cfg.Addresses[i]));
        ExpItem(15,Long2Str(Cfg.PointNet));
        ExpItem(16,ResStr(MainStrDict^, 111-Byte(cfg.UseFakeAddress),3));
        ExpItem(17,Cfg.Sysop);
        ExpItem(18,Cfg.System);
        ExpItem(19,ResStr(MainStrDict^, 111-Byte(Cfg.SwapOnExec),3));
        ExpItem(20,Cfg.EnterBBSText);
        ExpItem(21,Cfg.DoingMailText);
        ExpItem(22,Cfg.PressESCText);
        ExpItem(23,Long2Str(Cfg.maxringing));
        ExpItem(24,TimeToTimeString('hh:mm',Cfg.ZMHStart)+'-'+
          TimeToTimeString('hh:mm',cfg.ZMHEnd));
        ExpItem(25,TimeToTimeString('hh:mm:ss',cfg.CallTime));
        ExpItem(26,TimeToTimeString('hh:mm:ss',cfg.CallWidth));
        ExpItem(27,ResStr(MainStrDict^, 111-Byte(Cfg.ConnectFastest),3));
        ExpItem(28,TimeToTimeString('hh:mm:ss',cfg.OutReReadDelay));
        ExpItem(29,Cfg.FuncReqPwd);
        ExpItem(30,ResStr(MainStrDict^, 111-Byte(Cfg.UseJanus),3));
        ExpItem(31,ResStr(MainStrDict^, 111-Byte(Cfg.UseEmsi),3));
        ExpItem(32,ResStr(MainStrDict^, 111-Byte(Cfg.FastCalls),3));
        ExpItem(33,ResStr(MainStrDict^, 111-Byte(Cfg.KeepEmptyDirs),3));
        ExpItem(34,ResStr(MainStrDict^, 111-Byte(Cfg.Curmudgeon),3));
        ExpItem(35,ResStr(MainStrDict^, 111-Byte(Cfg.ReReadOnCall),3));
        ExpItem(36,cfg.Inbound[NsUnknown]);
        ExpItem(37,cfg.Inbound[NsKnown]);
        ExpItem(38,cfg.Inbound[NsPassword]);
        WriteNoLn('  '+ResStr(LocalStrDict^, 39, 25));
        if cfg.InBoundToDo[NsUnKnown] and 1 = 1 then WriteNoLn(' '+ResStr(MainStrDict^, 531,8));
        if cfg.InBoundToDo[NsUnKnown] and 2 = 2 then WriteNoLn(' '+ResStr(MainStrDict^, 532,8));
        if cfg.InBoundToDo[NsUnKnown] and 4 = 4 then WriteNoLn(' '+ResStr(MainStrDict^, 533,8));
        Writeln('');
        WriteNoLn('  '+ResStr(LocalStrDict^, 40, 25));
        if cfg.InBoundToDo[NsKnown] and 1 = 1 then WriteNoLn(' '+ResStr(MainStrDict^, 531,8));
        if cfg.InBoundToDo[NsKnown] and 2 = 2 then WriteNoLn(' '+ResStr(MainStrDict^, 532,8));
        if cfg.InBoundToDo[NsKnown] and 4 = 4 then WriteNoLn(' '+ResStr(MainStrDict^, 533,8));
        Writeln('');
        WriteNoLn('  '+ResStr(LocalStrDict^, 41, 25));
        if cfg.InBoundToDo[Nspassword] and 1 = 1 then WriteNoLn(' '+ResStr(MainStrDict^, 531,8));
        if cfg.InBoundToDo[Nspassword] and 2 = 2 then WriteNoLn(' '+ResStr(MainStrDict^, 532,8));
        if cfg.InBoundToDo[Nspassword] and 4 = 4 then WriteNoLn(' '+ResStr(MainStrDict^, 533,8));
        Writeln('');
        c:='C';
        For I:=1 to 2 do
        Begin
          for j:=1 to 10 do
          Begin
            ExpItem(42,c+longintform('## ',j)+Long2Str(cfg.fkey[i,j].ErrorLevel)+'@'+
              cfg.fkey[i,j].Description);
          end;
          c:='A';
        end;
        ExpItem(43,ResStr(MainStrDict^, 111-Byte(Cfg.ZModemDummyPkt),3));
        WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 10, 0)+ResStr(MainStrDict^, 2, 0));
        WriteLn(';');
      END;
      Dispose(LocalStrDict, Done);
    END;

    Procedure ExportCfg;
    Begin
      ExportSystemSection;
      ExportBBSSection;
      ExportModem;
      ExportScreen;
      ExportListFile;
      ExportRequest;
      ExportMailScanner;
      ExportFwdFile;
      ExportTick;
      ExportBimail;
      ExportNlCompiler;
      ExportDumbTerm;
      ExportExternal;
      ExportAreaMan;
      ExportPackers;
    end;

    Procedure ExportEvent;
    Var
      Event    : Tevent;
      Datafile : TNetFile;
      i:BYTE;
    Begin
      WriteExport('EventFile');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK050', LocalStrDict^);
      IF DataFile.Open(StartPath+PoPEventFileName,SizeOf(tEvent),false) THEN
      BEGIN
        WITH OutFile DO
        BEGIN
          WITH EVENT DO
          BEGIN
            WHILE NOT DataFile.EoF DO
            BEGIN
              DataFile.Read(event,nokeep,wait);
              WriteLn(ResStr(MainStrDict^, 50, 0)+ResStr(MainStrDict^, 2, 0));
              WriteNoLn('  '+ResStr(LocalStrDict^, 1, 25));
              if active and 128<>0 then WriteNoLn(' '+ResStr(MainStrDict^, 110,3))
                else WriteNoLn(' '+ResStr(MainStrDict^, 111,3));
              FOR i:=0 TO 6 DO
                if active and (1  SHL i)<>0 then WriteNoLn(' '+ResStr(MainStrDict^, 120+i,3));
              writeln('');
              ExpItem(2,TimeToTimeString('hh:mm',Start));
              ExpItem(3,Long2Str(month));
              ExpItem(4,Long2Str(Day));
              ExpItem(5,Long2Str(InitExit));
              ExpItem(6,Long2Str(MailExit));
              ExpItem(7,Long2Str(PollExit));
              ExpItem(8,Long2Str(FilesExit));

              WriteNoLn('  '+ResStr(LocalStrDict^, 9, 25));
              FOR i:=0 TO 14 DO
                if Typ and (1 SHL i)<>0 then WriteNoLn(' '+ResStr(LocalStrDict^, 101+i,15));
              writeln('');
              ExpItem(10,Long2Str(Tries.Bad));
              ExpItem(11,Long2Str(Tries.Busy));
              ExpItem(12,TimeToTimeString('hh:mm:ss',Calltime));
              ExpItem(13,TimeToTimeString('hh:mm:ss',Callwidth));
              ExpItem(14,Description);
              ExpItem(15,Address2Str(connectTo));
              ExpItem(16,Long2Str(SchedNumber));
              ExpItem(17,Long2Str(MaxCost));
              ExpItem(18,Long2Str(MinMail));
              ExpItem(19,Long2Str(SpecDial));
              ExpItem(20,Long2Str(TaskNumber));
              WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 50, 0)+ResStr(MainStrDict^, 2, 0));
              Writeln('');
            END;
          END;
        END;
        OutFile.WriteLn(';');
        DataFile.Close;
      END;
      Dispose(LocalStrDict, Done);
    end;

    PROCEDURE Exportnodes;
    VAR
      i          : Byte;
      DataFile   : TNetFile;
      NodePost   : TNodeInfo;
    BEGIN
      WriteExport('NodeFile');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK051', LocalStrDict^);
      IF DataFile.Open(PoPNodesFileName,SizeOf(TNodeInfo),False) THEN
      BEGIN
        WITH NodePost,OutFile DO
        BEGIN
          WHILE NOT DataFile.EoF DO
          BEGIN
            DataFile.Read(Nodepost,nokeep,wait);
            WriteLn(ResStr(MainStrDict^, 51, 0)+ResStr(MainStrDict^, 2, 0));
            ExpItem(1,Address2Str(Address));
            ExpItem(2,PktPassWord);
            ExpItem(3,AreaFixPwd);
            ExpItem(4,SessionPwd);
            ExpItem(5,Long2Str(PackerType));
            ExpItem(6,Long2Str(Level));
            ExpItem(7,Long2Str(Keys));
            ExpItem(8,TimeToTimeString('hh:mm:ss',OpenFrom));
            ExpItem(9,TimeToTimeString('hh:mm:ss',OpenTo));
            ExpItem(10,UseEmsi);
            ExpItem(11,ResStr(MainStrDict^, 111-Byte(SendFwdLetter),3));
            ExpItem(12,Long2Str(PointNet));
            ExpItem(13,CheckConnect);
            ExpItem(14,UseFake);
            ExpItem(15,ResStr(MainStrDict^, 111-Byte(DisallowReq),3));
            ExpItem(16,UseFullDuplex);
            ExpItem(17,Phone);
            ExpItem(18,TickPassWord);
            ExpItem(19,ResStr(MainStrDict^, 111-Byte(PackTick),3));
            ExpItem(20,Flavor);
            ExpItem(21,SpecialDials[1]+''+SpecialDials[2]);
            ExpItem(22,ResStr(MainStrDict^, 111-Byte(EmsiSetTime),3));
            ExpItem(23,Long2Str(MinConnectBaud));
            WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 51, 0)+ResStr(MainStrDict^, 2, 0));
            Writeln('');
          END;
        END;
        DataFile.Close;
      END;
      OutFile.WriteLn(';');
      Dispose(LocalStrDict, Done);
    END;

    PROCEDURE ExportTickFile;
    VAR
      DataFile   : TNetFile;
      TickPost   : TTickArea;
    BEGIN
      WriteExport('TickFile');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK052', LocalStrDict^);
      IF DataFile.Open(PoPTickFileName,SizeOf(TTickArea),False) THEN
      BEGIN
        WITH OutFile DO
        BEGIN
          WHILE NOT DataFile.EoF DO
          BEGIN
            DataFile.Read(Tickpost,nokeep,wait);
            WriteLn(ResStr(MainStrDict^, 52, 0)+ResStr(MainStrDict^, 2, 0));
            WITH TickPost DO
            BEGIN
              ExpItem(1,AreaName);
              ExpItem(2,GroupName);
              ExpItem(3,HumanName);
              ExpItem(4,AreaPath);
              ExpItem(5,ResStr(MainStrDict^, 111-Byte(WriteLetter),3));
              ExpItem(6,AnnouncePath);
              ExpItem(7,ResStr(MainStrDict^, 111-Byte(CanBeRepacked),3));
              ExpItem(8,GetFrom[1]+'@'+GetFrom[2]);
              ExpItem(9,SendTo[1]+'@'+SendTo[2]);
              ExpItem(10,Long2Str(Level));
              ExpItem(11,Long2Str(Keys));
              ExpItem(12,ResStr(MainStrDict^, 111-Byte(CheckCRC),3));
              ExpItem(13,FilesBBs);
              ExpItem(14,Long2Str(AkaToUse));
              ExpItem(15,ResStr(MainStrDict^, 111-Byte(CheckDupe),3));
            END;
            WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 52, 0)+ResStr(MainStrDict^, 2, 0));
            Writeln('');
          END;
        END;
        DataFile.Close;
      END;
      OutFile.WriteLn(';');
      Dispose(LocalStrDict, Done);
    END;

    PROCEDURE ExportFileForward;
    VAR
      DataFile   : TNetFile;
      FwdPost    : TFileFwd;
      dt         : DateTime;
    BEGIN
      WriteExport('File Forward File');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK053', LocalStrDict^);
      IF DataFile.Open(PoPFileFwdFileName,SizeOf(TFileFwd),False) THEN
      BEGIN
        WITH OutFile DO
        BEGIN
          WHILE NOT DataFile.EoF DO
          BEGIN
            DataFile.Read(Fwdpost,nokeep,wait);
            WriteLn(ResStr(MainStrDict^, 53, 0)+ResStr(MainStrDict^, 2, 0));
            WITH FwdPost DO
            BEGIN
              ExpItem(1,FileName);
              ExpItem(2,WhereToPut);
              ExpItem(3,ResStr(MainStrDict^, 111-Byte(AddTofiles),3));
              ExpItem(4,Long2Str(AddBeforeLine));
              ExpItem(5,Description);
              ExpItem(6,SendTo[1]+'@'+SendTo[2]);
              ExpItem(7,BeforeCmd);
              ExpItem(8,AfterCmd);
              ExpItem(9,ResStr(MainStrDict^, 111-Byte(TouchFile),3));
              ExpItem(10,Address2str(GetFrom));
              UnpackTime(LastForward,dt);
              ExpItem(11,ToChar(dt.Day)+'.'+ToChar(dt.Month)+'.'+ToChar(dt.Year)+' '+
                         ToChar(dt.Hour)+':'+ToChar(dt.Min)+':'+ToChar(dt.Sec));
              ExpItem(12,ResStr(MainStrDict^, 111-Byte(KillDupe),3));
              ExpItem(13,ResStr(MainStrDict^, 111-Byte(CheckDate),3));
              ExpItem(14,Long2Str(Level));
              ExpItem(15,Long2Str(keys));
              ExpItem(16,PortalFixName);
              ExpItem(17,Long2Str(KeepMax));
            END;
            WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 53, 0)+ResStr(MainStrDict^, 2, 0));
            Writeln('');
          END;
        END;
        DataFile.Close;
      END;
      OutFile.WriteLn(';');
      Dispose(LocalStrDict, Done);
    END;

    PROCEDURE ExportNodeListtrans;
    VAR
      DataFile   : TNetFile;
      NltPost    : TNltranslat;
    BEGIN
      WriteExport('NodeList Translation File');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK054', LocalStrDict^);
      IF DataFile.Open(PoPNLTranslateFileName,SizeOf(TNltranslat),False) THEN
      BEGIN
        WITH NltPost,OutFile DO
        BEGIN
          WHILE NOT DataFile.EoF DO
          BEGIN
            DataFile.Read(Nltpost,nokeep,wait);
            WriteLn(ResStr(MainStrDict^, 54, 0)+ResStr(MainStrDict^, 2, 0));

            ExpItem(1,NumFrom);
            ExpItem(2,NumTo);
            WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 54, 0)+ResStr(MainStrDict^, 2, 0));
            Writeln('');
          END;
        END;
        DataFile.Close;
      END;
      OutFile.WriteLn(';');
      Dispose(LocalStrDict, Done);
    END;

    PROCEDURE ExportScheduleFile;
    VAR
      DataFile   : TNetFile;
      ScdPost    : Tschedule;
    BEGIN
      WriteExport('Schedule File');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK055', LocalStrDict^);
      IF DataFile.Open(PoPScheduleFileName,SizeOf(Tschedule),False) THEN
      BEGIN
        WITH ScdPost,OutFile DO
        BEGIN
          WHILE NOT DataFile.EoF DO
          BEGIN
            DataFile.Read(Scdpost,nokeep,wait);
            WriteLn(ResStr(MainStrDict^, 55, 0)+ResStr(MainStrDict^, 2, 0));

            ExpItem(1,Long2Str(Number));
            ExpItem(2,Long2Str(Action));
            ExpItem(3,Adr[1]+'@'+Adr[2]);
            ExpItem(4,Stat);
            ExpItem(5,Long2Str(SubLine));
            WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 55, 0)+ResStr(MainStrDict^, 2, 0));
            Writeln('');
          END;
        END;
        DataFile.Close;
      END;
      OutFile.WriteLn(';');
      Dispose(LocalStrDict, Done);
    END;

    PROCEDURE ExportOkFileFile;
    VAR
      DataFile   : TNetFile;
      fejl       : Word;
      OkPost     : Tokfile;
    BEGIN
      WriteExport('Okfile File');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK056', LocalStrDict^);
      fejl:=LocalStrDict^.getStatus;
      IF DataFile.Open(PoPOkFileName,SizeOf(TOkfile),False) THEN
      BEGIN
        WITH OKPost,OutFile DO
        BEGIN
          WHILE NOT DataFile.EoF DO
          BEGIN
            DataFile.Read(Okpost,nokeep,wait);
            WriteLn(ResStr(MainStrDict^, 56, 0)+ResStr(MainStrDict^, 2, 0));

            ExpItem(1,ResStr(MainStrDict^, 570+Byte(NodeStat),10));
            ExpItem(2,MagicName);
            ExpItem(3,FilePath);
            ExpItem(4,Password);
            ExpItem(5,Long2Str(Level));
            ExpItem(6,Long2Str(keys));
            ExpItem(7,ResStr(MainStrDict^, 550+Byte(FreeArea),10));
            ExpItem(8,Long2Str(Tasknumber));

            WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 56, 0)+ResStr(MainStrDict^, 2, 0));
            Writeln('');
          END;
        END;
        DataFile.Close;
      END;
      OutFile.WriteLn(';');
      Dispose(LocalStrDict,done);
    END;


    PROCEDURE ExportareaFile;
    VAR
      DataFile   : TNetFile;
      AreaPost   : TMsgArea;
    BEGIN
      WriteExport('Msgarea File');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK057', LocalStrDict^);
      IF DataFile.Open(PoPMsgAreaFileName,SizeOf(TMsgArea),False) THEN
      BEGIN
        WITH AreaPost,OutFile DO
        BEGIN
          WHILE NOT DataFile.EoF DO
          BEGIN
            DataFile.Read(Areapost,nokeep,wait);
            WriteLn(ResStr(MainStrDict^, 57, 0)+ResStr(MainStrDict^, 2, 0));

            ExpItem(1,Directory);
            ExpItem(2,EchoNames[1]+'@'+EchoNames[2]+'@'+EchoNames[3]);
            ExpItem(3,Origin);
            ExpItem(4,SendTo[1]+'@'+Sendto[2]);
            ExpItem(5,SendOnly[1]+'@'+SendOnly[2]);
            ExpItem(6,ScramblePwd);
            ExpItem(7,ResStr(MainStrDict^, 111-Byte(StripSeenBy),3));
            ExpItem(8,ResStr(MainStrDict^, 111-Byte(Pvt2EMail),3));
            ExpItem(9,Long2Str(Level));
            ExpItem(10,Long2Str(keys));
            ExpItem(11,Long2Str(MaxScan));
            ExpItem(12,DateToDateString('dd.mm.yy', ScanDate));
            ExpItem(13,Long2Str(Scanned));
            ExpItem(14,Description);
            ExpItem(15,Long2Str(AreaType));
            ExpItem(16,ResStr(MainStrDict^, 111-Byte(ImportSB),3));
            ExpItem(17,Long2Str(UsedAka));
            ExpItem(18,Long2Str(MsgCount));
            ExpItem(19,Long2Str(DateCount));
            ExpItem(20,Long2Str(MsgKeep));

            WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 57, 0)+ResStr(MainStrDict^, 2, 0));
            Writeln('');
          END;
        END;
        DataFile.Close;
      END;
      OutFile.WriteLn(';');
      Dispose(LocalStrDict, Done);
    END;

    PROCEDURE ExportNodeListSegmentFile;
    VAR
      DataFile   : TNetFile;
      NlsPost   : TNodeListSeg;
    BEGIN
      WriteExport('NodeList Segment File');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK058', LocalStrDict^);
      IF DataFile.Open(PoPNlSegmentFileName,SizeOf(TNodeListSeg),False) THEN
      BEGIN
        WITH NlsPost,OutFile DO
        BEGIN
          WHILE NOT DataFile.EoF DO
          BEGIN
            DataFile.Read(Nlspost,nokeep,wait);
            WriteLn(ResStr(MainStrDict^, 58, 0)+ResStr(MainStrDict^, 2, 0));

            ExpItem(1,NodeListName);
            ExpItem(2,DiffFileName);
            ExpItem(3,ResStr(MainStrDict^, 111-Byte(CheckCrc),3));
            ExpItem(4,NewNlPath);
            ExpItem(5,Include[1]+'@'+Include[2]);
            ExpItem(6,Exclude[1]+'@'+exclude[2]);
            ExpItem(7,NewNlDesc);

            WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 58, 0)+ResStr(MainStrDict^, 2, 0));
            Writeln('');
          END;
        END;
        DataFile.Close;
      END;
      OutFile.WriteLn(';');
      Dispose(LocalStrDict, Done);
    END;
    PROCEDURE ExportMultiListSegments;
    VAR
      DataFile   : TNetFile;
      MFSPost    : TFileListSegment;
    BEGIN
      WriteExport('Multi List Segments');
      New(LocalStrDict,init);
      ResLib.GetEntry('TOK059', LocalStrDict^);
      IF DataFile.Open(PoPListSegmentsName,SizeOf(TFileListSegment),False) THEN
      BEGIN
        WITH MFSPost,OutFile DO
        BEGIN
          WHILE NOT DataFile.EoF DO
          BEGIN
            DataFile.Read(MFSpost,nokeep,wait);
            WriteLn(ResStr(MainStrDict^, 59, 0)+ResStr(MainStrDict^, 2, 0));

            ExpItem(1,Name);
            ExpItem(2,FileName);
            ExpItem(3,HeaderFile);
            ExpItem(4,IncludeAreas[1]+'@'+IncludeAreas[2]+'@'+IncludeAreas[3]+'@'+IncludeAreas[4]);
            ExpItem(5,DoAfter);

            WriteLn(ResStr(MainStrDict^, 3, 0)+ResStr(MainStrDict^, 59, 0)+ResStr(MainStrDict^, 2, 0));
            Writeln('');
          END;
        END;
        DataFile.Close;
      END;
      OutFile.WriteLn(';');
      Dispose(LocalStrDict, Done);
    END;

  BEGIN
    MyWin(W,20,10,60,14,2,'Exporting',true);
    New(MainStrDict,init);
    ResLib.GetEntry('TOK000', MainStrDict^);
    OpenExportFile;
    ExportCfg;
    if cfg.Tasknumber < 2 then
    Begin
      ExportEvent;
      ExportNodes;
      ExportTickFile;
      ExportFileForward;
      ExportNodelistTrans;
      ExportScheduleFile;
      ExportOkFileFile;
      ExportAreaFile;
      ExportNodeListSegmentFile;
      ExportMultiListSegments;
    end;
    Addlog('+','Configuration exported');
    OutFile.Done;
    Dispose(MainStrDict, Done);
    KillWindow(W);
  END;

END.
