UNIT MTask;
{ͻ}
{ Multitask detection                           Last changed: 29.01.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, PoPTypes;

VAR
  MultiTasker         : Byte;  { 0=None
                                 1=OS/2
                                 2=Windows
                                 3=DesqView
                                 4=TaskView
                                 5=TopView
                                 6=DoubleDos
                                 7=Virtual   }
  TaskVersion: Word;

PROCEDURE DV_Begin_Critical;           { Disallow giving away time }
PROCEDURE DV_End_Critical;             { Allow giving away timeslices }
PROCEDURE DV_Sound(freq,dur:integer);  { Sound a tone }

PROCEDURE GiveUpTime;
FUNCTION  MultiName(i:BYTE):S9;

IMPLEMENTATION

USES Dos
{$IFDEF OS2}
     , Os2Base
{$ENDIF}
     ;


  FUNCTION MultiName(i: Byte):S9;
  BEGIN
    CASE i OF
      0 : MultiName:='None';
      1 : MultiName:='OS/2';
      2 : MultiName:='Windows';
      3 : MultiName:='DesqView';
      4 : MultiName:='TaskView';
      5 : MultiName:='TopView';
      6 : MultiName:='DoubleDos';
      7 : MultiName:='Virtual';
    END;
  END;

  PROCEDURE DV_Begin_Critical; assembler;
  ASM
    MOV AX,$101B       { DV critical function }
    INT 15h
  END; { DV_Begin_Critical }

  PROCEDURE DV_End_Critical; assembler;
  ASM
    MOV AX,$101C       { DV END critical }
    INT 15h
  END; { DV_End_Critical }

  PROCEDURE DV_Sound(freq,dur:integer); assembler; { sound a tone }
  ASM
{$IFNDEF OS2}
    MOV   AX,1019H
    MOV   BX,freq  { frequency above 20 Hz }
    MOV   CX,dur   { duration in clock ticks }
    INT   15H
{$ENDIF}
  END;

  PROCEDURE GiveUpTime;
  BEGIN
{$IFDEF OS2}
    DosSleep(1);
{$ELSE}
    CASE MultiTasker OF
      0 : ASM
            sti
            int 28h
          END;
      1 : ASM
            int 28h
{
            sti
            xor dx,dx
            mov ax,1
            hlt
            db $35,$ca
            mov ax,1680h
            int 2fh
}
          END;
    2,7 : ASM
            mov ax,1680h
            int 2fh
          END;
    3,5 : ASM
            mov ax,1000h
            int 15h
          END;
      4 : ;
      6 : ASM
            mov ax, 0fe01h
            int 21h
          END;
    END;
{$ENDIF}
  END;

{$IFNDEF OS2}
  PROCEDURE InitTasker;
  VAR
    R : Registers;
  BEGIN
    With R Do
    BEGIN

      {-- OS/2 --------------}

      IF Lo(DosVersion)>=20 THEN
      BEGIN
        MultiTasker:=1;
        TaskVersion:=((Lo(DosVersion) Div 10)*256)+Hi(DosVersion);
        Exit;
      END;

      {-- Windows -----------}

      AX:=$4680; Intr($2F,R);
      IF AX=0 THEN MultiTasker:=2
      Else BEGIN
        AX:=$160A; BX:=0; Intr($2F,R);
        IF BX<>0 THEN
        BEGIN
          MultiTasker:=2;
          TaskVersion:=BX;
          Exit;
        END;
      END;

      {-- DesqView ----------}

      CH:=68; CL:=69; DH:=83; DL:=81; AX:=$2B01; Intr($21,R);
      IF AL<>255 THEN
      BEGIN
        MultiTasker:=3;
  {      DirectVideo:=False;
        ES:=VideoSeg;
        AH:=$FE;
        Intr($10,R);
        AlternateScreenAddr:=ES;
        IF AlternateScreenAddr<>0 THEN VideoSeg:=AlternateScreenAddr;
        TaskVersion:=BX;}
        Exit;
      END;

      {-- TaskView ----------} {-- TopView -----------}

      AX:=$1022; BX:=0; Intr($15,R);
      IF BX=1 THEN  { TaskView }
      BEGIN
        MultiTasker:=4;
  {      DirectVideo:=False;}
        Exit;
      END ELSE
        IF BX<>0 THEN
        BEGIN
          TaskVersion:=Swap(BX);
          MultiTasker:=5;
  {       DirectVideo:=False;
          AH:=$FE; ES:=VideoSeg; DI:=0; Intr($10,R);
          ES:=VideoSeg;}
          Exit;
        END;

      {-- DoubleDos ---------}

      AX:=$F400;  Intr($21,R);
      IF AL<>0 THEN
      BEGIN
        MultiTasker:=6;
  {      DirectVideo:=False;
        AH:=$FC; ES:=0; Intr($21,R);
        IF ES<>0 THEN VideoSeg:=ES;}
        Exit;
      END;

      {-- Virtual -----------}

      ASM
        MOV AX, 1680h
        INT 2Fh          { Gives up time slice in most 386+ virtual machines }
        CMP AL,0
        JNE @NoVir
        MOV MultiTasker,7
@NoVir:
      END;
  {    IF MultiTasker=7 THEN Exit;}

    END;
  END;
{$ENDIF}

BEGIN
{$IFNDEF OS2}
  TaskVersion:=0;
  MultiTasker:=0;
  InitTasker;
{$ELSE}
  MultiTasker:=1;
{$ENDIF}
END.

