UNIT MoreHeap;
{ͻ}
{ Expands heap with available UMB               Last changed: 04.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

IMPLEMENTATION

USES OpInline;

TYPE
  PFreeRec = ^TFreeRec;
  TFreeRec = RECORD
    Next : PFreeRec;
    Size : Pointer;
  END;

  PROCEDURE AddHeapBlock(P: Pointer; BlockSize: LongInt);
  VAR
    FreeRec : PFreeRec;

    function Linear(P: pointer): longint;
    begin
      Linear := (longint(seg(P^)) shl 4) + ofs(P^)
    end;

    FUNCTION CalcSize(StartPtr,EndPtr: Pointer): Pointer;
    BEGIN
      IF Ofs(EndPtr^) >= Ofs(StartPtr^) THEN
        CalcSize := Ptr(Seg(EndPtr^)-Seg(StartPtr^), Ofs(EndPtr^)-Ofs(StartPtr^))
      ELSE
        CalcSize := Ptr(Seg(EndPtr^)-Seg(StartPtr^)-1, Ofs(EndPtr^)-Ofs(StartPtr^)+16);
    END;

  BEGIN
    IF Linear(P)<Linear(HeapPtr) THEN
    BEGIN
      FreeRec:=FreeList;
      WHILE Linear(FreeRec)<Linear(P) DO
        FreeRec:=FreeRec^.Next;
      PFreeRec(P)^.Size:=CalcSize(P, AddLongToPtr(P,BlockSize));
      PFreeRec(P)^.Next:=FreeRec^.Next;
      FreeRec^.Next:=P;
    END ELSE
    BEGIN
      FreeRec := HeapPtr;
      WITH FreeRec^ DO
      BEGIN
         Next:=P;
         Size:=CalcSize(P, AddLongToPtr(P,BlockSize));
       END;
       HeapPtr:=Normalized(P);
{      SaveHeapEnd:=HeapEnd;}
       HeapEnd:=AddLongToPtr(P,BlockSize);
{      Ptr(seg(HeapPtr^)+Size,ofs(HeapPtr^));}
    END;
  END;

END.
