UNIT Modem;
{ͻ}
{ Misc. modem functions                         Last changed: 10.12.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{ͻ}
{ Changes made by the German Portal Team                                   }
{                                                                          }
{ By                : Marcus Roeckrath                                     }
{ First Modification: 11 May 1999                                          }
{ Last Modification : 03 November 1999                                     }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

CONST ReportModemInit : BOOLEAN = FALSE;

PROCEDURE MakeModemBusy;
FUNCTION  CheckConnectExit(CONST s: String): Byte;
PROCEDURE InitModemForEvent;
PROCEDURE MNPFilter;
FUNCTION  CheckBiOverride(CONST InStr: String): Boolean;
FUNCTION  ModemReadStr: String;
PROCEDURE ModemHangUp;
PROCEDURE InitModem(BaudRate: Word; CONST Preinit, Init: String);
PROCEDURE TranslateModemString(CONST St: String);
FUNCTION  TimedRead(Time: LongInt): Integer;
PROCEDURE WaitForSlowModem;
FUNCTION  GetRealBaudRate(s: String): Word;
FUNCTION  GetExtraInfo(CONST s: String): String;
FUNCTION  IsLockedBaud(CONST s: String): Boolean;
PROCEDURE DropCarrier;
PROCEDURE LogLinkStat;

IMPLEMENTATION

USES OpCrt, OpWindow, OpString, ApTimer,
     MTask, PoPTypes, Com, Util, Display, LogFile, Globals,
     OProUtil, Keyboard;

  PROCEDURE MakeModemBusy;
  BEGIN
    IF Cfg.Modem.Busy<>'' THEN
    BEGIN
      TranslateModemString('^'+Cfg.Modem.Busy);
      Pause(50);
      WHILE ComPort^.KeyPressed DO
        ComPort^.PurgeIn;
      NewTimer(ModemReInit, 0);
    END;
  END;

  FUNCTION CheckConnectExit(CONST s: String): Byte;
  VAR
    el,i : Byte;
  BEGIN
    el:=0;
    FOR i:=1 TO 5 DO
      IF (Cfg.Modem.ExitStr[i].ConStr<>'') And (Pos(Cfg.Modem.ExitStr[i].ConStr,s)>0)THEN
        el:=Cfg.Modem.ExitStr[i].ErrLvl;
    CheckConnectExit:=el;
  END;

  PROCEDURE InitModemForEvent;
  BEGIN
    IF (CurrentEvent.Typ AND etNoAnswer=etNoAnswer) AND (Cfg.Modem.NoAnswer<>'') THEN
      InitModem(Cfg.Modem.BaudRate,Cfg.Modem.PreInit,Cfg.Modem.NoAnswer)
    ELSE
      InitModem(Cfg.Modem.BaudRate,Cfg.Modem.PreInit,Cfg.Modem.Init);
    NewTimerSecs(ModemReInit, Cfg.Modem.ReInit);
  END;

  PROCEDURE MNPFilter;
  CONST
    BadChars = #17#22+'b'+#252#253#254#255;
  VAR
    t,t1 : EventTimer;
    c : Byte;
  BEGIN
    NewTimerSecs(t1, 10);
    NewTimerSecs(t, 1);
    WHILE Not TimerExpired(t) DO
    BEGIN
      IF TimerExpired(t1) THEN Exit;
      IF ComPort^.Peek(c) THEN
      BEGIN
        IF ((c<>0) And (Pos(Char(c),BadChars)>0)) Or (Pos(Char(c And $7f),BadChars)>0) THEN
        BEGIN
          c:=ComPort^.ReadByte;
          AddLog('#','MNP Filter');
          NewTimer(t, 9);
          WHILE Not TimerExpired(t) DO
          BEGIN
            IF ComPort^.KeyPressed THEN
            BEGIN
              c:=ComPort^.ReadByte;
              NewTimer(t, 9);
            END;
            IF TimerExpired(t1) THEN Exit;
          END;
        END;
      END;
    END;
  END;

  FUNCTION GetRealBaudRate(s: String): Word;
  VAR
    Error: Integer;
    R    : Word;
  BEGIN
    s:=Copy(s,9,255);
    IF pos('/', s)>0 THEN s:=Copy(s, 1, pos('/',s) - 1);
    IF pos(' ', s)>0 THEN s:=Copy(s, 1, pos(' ',s) - 1);
    WHILE (s<>'') AND (Pos(s[Length(s)],'0123456789')=0) DO
      Dec(s[0]) ;
    IF s<>'' THEN Val(s,r,Error) ELSE r:=300;
    IF r<300 THEN r:=300;
    GetRealBaudRate:=r;
  END;

  FUNCTION GetExtraInfo(CONST s: String): String;
  VAR
    i : Byte;
  BEGIN
    i:=9;
    WHILE (i<Length(s)) AND (Pos(s[i],'0123456789')>0) DO
      Inc(i);
    GetExtraInfo:=Copy(s,i+1,255);
  END;

  PROCEDURE WaitForSlowModem;
  VAR
    x : EventTimer;
  BEGIN
    NewTimerSecs(x, 2);
    WHILE NOT ComPort^.Carrier AND NOT TimerExpired(x) DO
      GiveUpTime;
  END;

  FUNCTION CheckBiOverride(CONST InStr: String): Boolean;
  VAR
    i : Byte;
    c : Boolean;
  BEGIN
    IF ComPort^.GetBaudRate<=Cfg.BiMail.MaxBaud THEN
      c:=True
    ELSE
    BEGIN
      C:=False;
      FOR i:=1 TO 5 DO
        IF (Cfg.Bimail.BiOverride[i]<>'') And (Pos(StUpCase(Cfg.BiMail.BiOverride[i]),StUpCase(InStr))>0) THEN C:=True;
    END;
    CheckBiOverride:=c;
  END;

  FUNCTION IsLockedBaud(CONST s: String): Boolean;
  BEGIN
    IsLockedBaud:=(Cfg.Modem.LockedBaud<>'') And (Pos(Cfg.Modem.LockedBaud,s)>0);
  END;

  FUNCTION TimedRead(Time: LongInt): Integer;
  VAR
    t       : EventTimer;
    OutByte : Integer;
  BEGIN
    OutByte:=-1;
    NewTimer(t, Secs2Tics(Time) DIV 100);
    WHILE (NOT ComPort^.KeyPressed) AND (NOT TimerExpired(t)) AND (ComPort^.Carrier) DO
{     GiveUpTime};
    IF (ComPort^.KeyPressed) AND (ComPort^.Carrier) THEN OutByte:=ComPort^.ReadByte;
    TimedRead:=OutByte;
  END;

  PROCEDURE EmptyDelay;
  VAR
    t : EventTimer;
  BEGIN
    NewTimerSecs(t, 5);
    WHILE (NOT TimerExpired(t)) AND (NOT ComPort^.OutEmpty) DO
      IF MultiTasker=1 THEN GiveUpTime;
  END;

  FUNCTION ModemReadStr : String;
  VAR
    InStr   : String;
    Count   : Byte;
    t       : EventTimer;
    Ch      : Char;
    Escaped : Boolean;
  BEGIN
    InStr:=''; Count:=0; Ch:=#0;
    NewTimerSecs(t, 2);
    Escaped:=GotESC;
    WHILE (Count<81) AND (NOT TimerExpired(t)) AND (NOT Escaped) DO
    BEGIN
      IF ComPort^.KeyPressed THEN
      BEGIN
        IF Com.RxKeyPressedDelay THEN LogWin('M', 'Testausgabe');
        Ch:=Char(ComPort^.ReadByte);
        IF (Ch=Char(Cr)) OR (Ch=Char(Lf)) THEN
        BEGIN
          IF Count>0 THEN Count:=81;
        END ELSE
        BEGIN
          InStr:=InStr+Ch;
          Inc(Count);
        END;
        NewTimerSecs(t, 2);
      END;{ ELSE
        GiveUpTime;}
      Escaped:=GotESC;
    END;
    IF NOT Escaped THEN ModemReadStr:=InStr ELSE ModemReadStr:='';
    IF Com.RxKeyPressedDelay THEN ReWriteLogWindow;
  END;

  PROCEDURE TranslateModemString(CONST St : String);
  VAR
    a : Byte;
    Escaped : Boolean;
  BEGIN
    Escaped:=False;
    FOR a:=1 TO Length(St) DO
    BEGIN
      IF Escaped THEN
      BEGIN
        ComPort^.WriteByte(Byte(St[a]), False);
        Escaped:=False;
      END ELSE
      BEGIN
        CASE St[a] OF
          '\' : Escaped:=True;
          '-' : ;
          '^' : BEGIN
                  EmptyDelay;
                  ComPort^.SetDtr(High);
                END;
          'v' : BEGIN
                  EmptyDelay;
                  ComPort^.SetDtr(Low);
                END;
          '|' : BEGIN
                  ComPort^.WriteByte(Byte(Cr), True);
                  EmptyDelay;
                  Pause(20);
                END;
          '`' : BEGIN
                  Pause(10);
                END;
          '~' : BEGIN
                  EmptyDelay;
                  Pause(100);
                END;
          ELSE  BEGIN
                  ComPort^.WriteByte(Byte(St[a]), False);
    {             Pause(1);}
                END;
        END;
      END;
    END;
  END;

  PROCEDURE InitModem(BaudRate : Word; CONST preinit, Init : String);
  VAR
    i  : Byte;
    s  : String;
    t  : EventTimer;
  BEGIN
    IF ((CmdLineFlags AND clNoModem)=0) AND NOT PoPKeyPressed THEN
    BEGIN
      IF (CmdLineFlags AND clReportMInit) = clReportMInit THEN AddLog(':','Initializing modem');
      ComPort^.SetXOn(Off);
      i:=0;
      REPEAT
        Inc(i);
        ComPort^.PurgeOut; ComPort^.PurgeIn;
        ComPort^.SetDtr(High);
        ComPort^.SetBaudRate(BaudRate);
        IF PreInit<>'' THEN
        BEGIN
          ComPort^.WriteStr(' '+CHAR(Cr));
          TranslateModemString(PreInit);
          ComPort^.PurgeIn;
          Pause(10);
        END ELSE
        BEGIN
          ComPort^.WriteByte(Byte(Cr), True);
          ComPort^.SetDtr(Low);
          Pause(100);
          ComPort^.SetDtr(High);
          Pause(50);
          ComPort^.WriteStr(' '+Char(Cr));
          Pause(50);
          ComPort^.PurgeIn;
        END;
        IF ComPort^.Carrier THEN
        BEGIN
          ComPort^.SetFlowControl(0);
          ComPort^.SetDtr(On);
          ComPort^.WriteByte(17, True);
          ComPort^.SendBreak;
          DropCarrier;
          ComPort^.SetFlowControl(2);
          ComPort^.PurgeIn;
        END;
        TranslateModemString(Init);
        s:=''; NewTimerSecs(t, 5);
        WHILE (Not TimerExpired(t)) And (s<>'OK') DO
        BEGIN
          IF (GotESC) And (i>1) THEN Halt(1);
          s:=ModemReadStr;
{
          IF FKeyPressed THEN s:=s+Char(FReadByte);
          IF (Length(s)=1) AND (s[1]<>'O') THEN s:='';
          IF (Length(s)=2) AND (s[2]<>'K') THEN s:='';
}
        END;
        IF s<>'OK' THEN AddLog('!','Modem does not respond OK');
      UNTIL (s='OK') OR (i=4);
      IF i=4 THEN
      BEGIN
        AddLog('!','Error initializing modem - aborting');
        SpawnWithErrorlevel(253, 'Exiting', False, TRUE);
      END;
      Pause(50);
      ComPort^.PurgeIn; ComPort^.PurgeOut;
      UpdateStatusWindow;
    END;
  END;

  PROCEDURE ModemHangUp;
  BEGIN
    IF Cfg.Modem.Hangup<>'' THEN TranslateModemString(Cfg.Modem.Hangup);
    IF ComPort^.Carrier THEN DropCarrier;
    ComPort^.PurgeOut;
    ComPort^.PurgeIn;
  END;

  PROCEDURE DropCarrier;
  VAR
    t : EventTimer;
    Wait : PWait;
  BEGIN
    New(Wait, Init((ScreenHeight DIV 2)-3, 2, 'Waiting for modem to drop carrier'));
    ComPort^.SetDtr(Low);
    NewTimerSecs(t, 10);
    WHILE ComPort^.Carrier AND Not TimerExpired(t) DO
    BEGIN
      GiveUpTime;
      Wait^.Animate;
    END;
    IF ComPort^.Carrier THEN TranslateModemString('^~~~+++~~~ATH0|');
    Dispose(Wait, Done);
  END;

  PROCEDURE LogLinkStat;
  VAR
    t : EventTimer;
    Ch : Char;
    InStr : S200;
    Lines : Byte;
  BEGIN
    IF (Cfg.Modem.LinkStat<>'') AND (Cfg.Modem.LogLines>0) THEN
    BEGIN
      IF ComPort^.Carrier THEN
      BEGIN
        DropCarrier;
        NewTimerSecs(t, 10);
        WHILE ComPort^.Carrier AND Not TimerExpired(t) DO
          GiveUpTime;
      END;
      ComPort^.SetDtr(High);
      NewTimerSecs(t,1);
      WHILE Not TimerExpired(t) OR ComPort^.KeyPressed DO
      BEGIN
        ComPort^.PurgeIn;
        GiveUpTime;
      END;
      ComPort^.PurgeOut;
      TranslateModemString(Cfg.Modem.LinkStat);
      AddLog('!', 'Getting link statistics...');
      NewTimerSecs(t, 30);
      Lines:=0; InStr:='';
      REPEAT
        IF ComPort^.Keypressed THEN
        BEGIN
          Ch:=Char(ComPort^.ReadByte);
          IF Ch=#13 THEN
          BEGIN
            IF (Copy(InStr,1,2)<>'AT') AND ((InStr<>'') OR (Lines>0)) THEN
            BEGIN
              AddLog('!',InStr);
              Inc(Lines);
            END;
            InStr:='';
          END ELSE
            IF Ch<>#10 THEN InStr:=InStr+Ch;
        END;
      UNTIL (Lines=Cfg.Modem.LogLines) OR TimerExpired(t);
      ComPort^.PurgeIn;
    END;
  END;

END.

